/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttCategoryPlot;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.project.components.ui.AbstractView;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.Workbench;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class GanttView
extends AbstractView {
    private AppGanttChart chart;

    public GanttView(AppGanttChart appGanttChart) {
        super(Workbench.getNLSString("gantt_view_title", new Object[0]));
        this.chart = appGanttChart;
        JScrollPane jScrollPane = new JScrollPane(appGanttChart.getView());
        jScrollPane.setColumnHeaderView(appGanttChart.getHeader());
        JComponent jComponent = ((AppGanttTreeTable)appGanttChart.getTreeTable()).getRowHeaderComponent();
        jScrollPane.setRowHeaderView(jComponent);
        jScrollPane.setCorner("UPPER_LEADING_CORNER", new AppGanttTreeTable.RowHeaderRenderer());
        jScrollPane.setBackground(UIConstants.BACKGROUND_HEADER_COLOR);
        this.body = jScrollPane;
        this.mainComponent.add((Component)this.body, "Center");
        appGanttChart.getTreeTable().setView(this);
    }

    public void activeStateChanged(boolean bl) {
        super.activeStateChanged(bl);
        GanttCategoryPlot ganttCategoryPlot = (GanttCategoryPlot)this.chart.getChart().getPlot();
        ganttCategoryPlot.setFocused(bl);
        this.chart.chartPanel.forceRepaint(1);
    }

    public JComponent getMainFocusableComponent() {
        return this.chart.getTreeTable();
    }

    public JComponent[] getToolBarItems() {
        return this.chart.actions.getItems();
    }

    public Action getAction(int n) {
        if (n == 1) {
            return this.chart.actions.deleteAction;
        }
        if (n == 2) {
            return this.chart.actions.newAction;
        }
        return null;
    }

    public AppGanttChart getChart() {
        return this.chart;
    }
}

