/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class FullScreenAction
extends AbstractAction {
    private JDialog fullScreenDialog;
    private Component mainComponent;
    private Container contentPane0;
    protected AppGanttChart ganttCtrl;
    protected static final Icon MAXIMIZE_ICON = WDUtil.getIcon("maximize.png");
    protected static final Icon RESTORE_ICON = WDUtil.getIcon("restore.png");

    public FullScreenAction(AppGanttChart appGanttChart) {
        this.putValue("SmallIcon", MAXIMIZE_ICON);
        this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("enter_fullscreen_button"));
        this.ganttCtrl = appGanttChart;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        if (this.fullScreenDialog != null) {
            this.undoFullScreenMode();
            return;
        }
        if (this.contentPane0 == null) {
            serializable = SwingUtilities.getRootPane(this.ganttCtrl.getView());
            this.contentPane0 = ((JRootPane)serializable).getContentPane();
            this.mainComponent = this.contentPane0.getComponent(0);
        }
        serializable = this.mainComponent.getSize();
        BufferedImage bufferedImage = new BufferedImage(((Dimension)serializable).width, ((Dimension)serializable).height, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.mainComponent.printAll(graphics2D);
        graphics2D.setColor(new Color(0, 0, 0, 20));
        graphics2D.fillRect(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
        JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
        Window window = SwingUtilities.getWindowAncestor(this.mainComponent);
        this.contentPane0.remove(this.mainComponent);
        this.contentPane0.add(jLabel);
        window.validate();
        String string = this.ganttCtrl.getModel().getMainProjectModel().getProjectContext().getProjectName();
        if (string == null) {
            string = this.ganttCtrl.getModel().getRootNode().getName();
        }
        String string2 = "ProjExec Gantt - " + string;
        JDialog jDialog = window instanceof Dialog ? new JDialog((Dialog)window, string2, true) : new JDialog((Frame)window, string2, true);
        ImageIcon imageIcon = WDUtil.getIcon("pe16x16.jpg");
        if (imageIcon != null) {
            WDUtil.setDialogIcon(jDialog, imageIcon.getImage());
        }
        jDialog.getContentPane().add(this.mainComponent);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FullScreenAction.this.undoFullScreenMode();
            }
        });
        jDialog.pack();
        Rectangle rectangle = WDUtil.getDisplayBounds(this.contentPane0);
        jDialog.setBounds(rectangle);
        this.fullScreenDialog = jDialog;
        this.putValue("SmallIcon", RESTORE_ICON);
        this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("exit_fullscreen_button"));
        jDialog.setVisible(true);
        this.putValue("SmallIcon", MAXIMIZE_ICON);
        this.putValue("ShortDescription", AppGanttChart.NLS_BUNDLE.getString("enter_fullscreen_button"));
        this.fullScreenDialog.getContentPane().remove(this.mainComponent);
        this.contentPane0.removeAll();
        this.contentPane0.add(this.mainComponent);
        this.contentPane0.validate();
        this.fullScreenDialog = null;
    }

    protected void undoFullScreenMode() {
        this.fullScreenDialog.dispose();
    }

    public void hideFullScreen() {
        if (this.fullScreenDialog != null) {
            this.fullScreenDialog.dispose();
        }
    }
}

