/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ICategoryPlotModel;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.NodeSetModel;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.event.GanttModelEvent;
import com.triloggroup.gantt.event.GanttModelListener;
import com.triloggroup.gantt.event.GanttModelSelectionEvent;
import com.triloggroup.gantt.event.GanttModelSelectionListener;
import com.triloggroup.gantt.util.Intervals;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class TGChartModel
implements ICategoryPlotModel {
    private static final GanttModelListener[] EMPTY_MODEL_LSNR_ARRAY = new GanttModelListener[0];
    private static final GanttModelSelectionListener[] EMPTY_MODEL_SELECTION_LSNR_ARRAY = new GanttModelSelectionListener[0];
    private int nbEntriesAcceptedByFilter;
    protected GlobalContext globalContext;
    protected NodeSetModel nodeSetModel;
    private GanttDataset ganttDataset;
    protected boolean updatingselection = false;
    protected TGNode[] selectedNodes;
    private Vector<GanttModelSelectionListener> selectionListeners;
    private Vector<GanttModelListener> modelListeners;

    public TGChartModel(String string) {
        this.globalContext = this.createGlobalContext(string);
        this.nodeSetModel = new NodeSetModel(this.globalContext);
        this.selectionListeners = new Vector();
        this.modelListeners = new Vector();
    }

    protected GlobalContext createGlobalContext(String string) {
        return new GlobalContext(string);
    }

    public GlobalContext getGlobalContext() {
        return this.globalContext;
    }

    public Intervals getOffPeriods(long l, long l2) {
        return null;
    }

    public String getSiteId() {
        return this.globalContext.getSiteId();
    }

    public NodeSetModel getNodeSetModel() {
        return this.nodeSetModel;
    }

    public TGNode getRootNode() {
        return this.nodeSetModel.getRootNode();
    }

    protected GanttDataset getGanttDataset() {
        return this.ganttDataset;
    }

    public void setGanttDataset(GanttDataset ganttDataset) {
        this.ganttDataset = ganttDataset;
    }

    protected void resetTaskSeriesForInit() {
        this.nodeSetModel.resetTaskSeriesForInit();
        this.nbEntriesAcceptedByFilter = -1;
    }

    public Date getDataStartDate() {
        return this.nodeSetModel.getDataStartDate();
    }

    public Date getDataEndDate() {
        return this.nodeSetModel.getDataEndDate();
    }

    public void setFilter(INodeFilter iNodeFilter) {
        this.globalContext.setFilter(iNodeFilter);
        this.nbEntriesAcceptedByFilter = 0;
        this.applyFilter(this.getRootNode());
        this.fireStructureChanged();
    }

    public void reapplyCurrentFilter() {
        this.setFilter(this.globalContext.getFilter());
    }

    public INodeFilter getFilter() {
        return this.globalContext.getFilter();
    }

    public int getNbEntriesAcceptedByFilter() {
        if (this.globalContext.getFilter() == null) {
            TGNode tGNode = this.getRootNode();
            int n = this.countReadableNodes(tGNode);
            if (tGNode.isFakeRoot()) {
                --n;
            }
            return n;
        }
        return this.nbEntriesAcceptedByFilter;
    }

    private int countReadableNodes(TGNode tGNode) {
        int n = 0;
        if (tGNode.isReadeable()) {
            ++n;
            for (int i = 0; i < tGNode.getAllSubTaskCount(); ++i) {
                n += this.countReadableNodes(tGNode.getSubtaskInAll(i));
            }
        }
        return n;
    }

    private boolean applyFilter(TGNode tGNode) {
        INodeFilter iNodeFilter = this.globalContext.getFilter();
        boolean bl = iNodeFilter == null || iNodeFilter.acceptAll() || iNodeFilter.accept(tGNode);
        tGNode.setHiddenByFilter(!bl);
        if (bl) {
            ++this.nbEntriesAcceptedByFilter;
            if (tGNode.isLeaf()) {
                return true;
            }
            boolean bl2 = false;
            for (int i = 0; i < tGNode.getAllSubTaskCount(); ++i) {
                TGNode tGNode2 = tGNode.getSubtaskInAll(i);
                bl2 |= this.applyFilter(tGNode2);
            }
            if (iNodeFilter != null && iNodeFilter.isHideEmptyWBS() && !bl2 && tGNode.getParent() != null) {
                tGNode.setHiddenByFilter(true);
                --this.nbEntriesAcceptedByFilter;
            }
            return bl2;
        }
        return false;
    }

    public TGNode getNodeByDocId(String string) {
        return this.getNodeSetModel().getNodeByDocId(string);
    }

    public int getRowCount() {
        return this.getGanttDataset().getSeries(0).getItemCount();
    }

    public int getRowIndex(TGNode tGNode) {
        if (tGNode != null) {
            GanttDataset ganttDataset = this.getGanttDataset();
            return ganttDataset.getColumnIndex((Comparable)((Object)tGNode.getDescription()));
        }
        return -1;
    }

    public TGNode getNodeByRowIndex(int n) {
        if (n >= 0) {
            return (TGNode)this.getGanttDataset().getSeries(0).get(n);
        }
        return null;
    }

    public TGNode[] getSelectedNodes() {
        return this.selectedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSelectedNodes(TGNode ... tGNodeArray) {
        if (this.updatingselection) {
            return;
        }
        try {
            this.updatingselection = true;
            GanttModelSelectionEvent ganttModelSelectionEvent = this.createModelSelectionEvent(1, tGNodeArray);
            this.selectedNodes = tGNodeArray;
            this.fireSelectionChanged(ganttModelSelectionEvent);
        }
        finally {
            this.updatingselection = false;
        }
    }

    public boolean isSelectedNode(TGNode tGNode) {
        if (this.selectedNodes == null) {
            return false;
        }
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            if (this.selectedNodes[i] != tGNode) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean collapseNode(TGNode tGNode) {
        if (!tGNode.isLeaf() && tGNode.isExpanded() && tGNode.setExpanded(false)) {
            this.fireNodeCollapsed(tGNode);
            return true;
        }
        return false;
    }

    public boolean expandNode(TGNode tGNode) {
        if (!tGNode.isLeaf() && !tGNode.isExpanded() && tGNode.setExpanded(true)) {
            this.fireNodeExpanded(tGNode);
            return true;
        }
        return false;
    }

    public synchronized void addSelectionListener(GanttModelSelectionListener ganttModelSelectionListener) {
        this.selectionListeners.addElement(ganttModelSelectionListener);
    }

    public synchronized void removeSelectionListener(GanttModelSelectionListener ganttModelSelectionListener) {
        this.selectionListeners.removeElement(ganttModelSelectionListener);
    }

    protected synchronized void fireSelectionChanged(GanttModelSelectionEvent ganttModelSelectionEvent) {
        GanttModelSelectionListener[] ganttModelSelectionListenerArray;
        if (ganttModelSelectionEvent == null) {
            return;
        }
        for (GanttModelSelectionListener ganttModelSelectionListener : ganttModelSelectionListenerArray = this.selectionListeners.toArray(EMPTY_MODEL_SELECTION_LSNR_ARRAY)) {
            ganttModelSelectionListener.selectionChanged(ganttModelSelectionEvent);
        }
    }

    protected GanttModelSelectionEvent createModelSelectionEvent(int n, Object[] objectArray) {
        boolean bl;
        int n2 = 0;
        Object[] objectArray2 = this.getSelectedNodes();
        boolean bl2 = objectArray2 == null || objectArray2.length == 0;
        boolean bl3 = bl = objectArray == null || objectArray.length == 0;
        if (bl2 && bl) {
            return null;
        }
        if (Arrays.equals(objectArray2, objectArray)) {
            return null;
        }
        return new GanttModelSelectionEvent(this, n2, objectArray2, n, objectArray);
    }

    public synchronized void addGanttModelListener(GanttModelListener ganttModelListener) {
        this.modelListeners.addElement(ganttModelListener);
    }

    public synchronized void removeGanttModelListener(GanttModelListener ganttModelListener) {
        this.modelListeners.removeElement(ganttModelListener);
    }

    public synchronized void fireNodeChanged(TGNode tGNode) {
        this.fireNodesChanged(new TGNode[]{tGNode});
    }

    protected synchronized void fireNodesChanged(final TGNode[] tGNodeArray) {
        GanttModelListener[] ganttModelListenerArray;
        if (!TGChart.isServerMode && !SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TGChartModel.this.fireNodesChanged(tGNodeArray);
                }
            });
            return;
        }
        GanttModelEvent ganttModelEvent = new GanttModelEvent((Object)this, tGNodeArray);
        for (GanttModelListener ganttModelListener : ganttModelListenerArray = this.modelListeners.toArray(EMPTY_MODEL_LSNR_ARRAY)) {
            ganttModelListener.nodesChanged(ganttModelEvent);
        }
    }

    protected synchronized void fireStructureChanged() {
        GanttModelListener[] ganttModelListenerArray;
        if (!TGChart.isServerMode && !SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TGChartModel.this.fireStructureChanged();
                }
            });
            return;
        }
        GanttModelEvent ganttModelEvent = new GanttModelEvent((Object)this, (TGNode[])null);
        for (GanttModelListener ganttModelListener : ganttModelListenerArray = this.modelListeners.toArray(EMPTY_MODEL_LSNR_ARRAY)) {
            ganttModelListener.structureChanged(ganttModelEvent);
        }
    }

    public synchronized void fireNodeCollapsed(TGNode tGNode) {
        GanttModelListener[] ganttModelListenerArray;
        GanttModelEvent ganttModelEvent = new GanttModelEvent((Object)this, tGNode);
        for (GanttModelListener ganttModelListener : ganttModelListenerArray = this.modelListeners.toArray(EMPTY_MODEL_LSNR_ARRAY)) {
            ganttModelListener.nodeCollapsed(ganttModelEvent);
        }
    }

    public synchronized void fireNodeExpanded(TGNode tGNode) {
        GanttModelListener[] ganttModelListenerArray;
        GanttModelEvent ganttModelEvent = new GanttModelEvent((Object)this, tGNode);
        for (GanttModelListener ganttModelListener : ganttModelListenerArray = this.modelListeners.toArray(EMPTY_MODEL_LSNR_ARRAY)) {
            ganttModelListener.nodeExpanded(ganttModelEvent);
        }
    }
}

