/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.ICategoryPlotModel;
import com.triloggroup.gantt.TGChart;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.util.Interval;
import com.triloggroup.gantt.util.Intervals;
import com.triloggroup.project.components.IGlobalContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.DateRange;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class TGCategoryPlot
extends CategoryPlot {
    public static final Color OFF_DAY_COLOR = TGChart.OFF_DAY_COLOR;
    public static final int MIN_OFF_PERIOD_WIDTH = 6;
    protected ICategoryPlotModel model;
    private boolean focused = true;
    private boolean printing = false;
    private boolean drawOffPeriods = true;

    public TGCategoryPlot(ICategoryPlotModel iCategoryPlotModel, CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        super(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer);
        this.model = iCategoryPlotModel;
        this.setInsets(new RectangleInsets(3.0, 0.0, 1.0, 1.0));
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public void setPrinting(boolean bl) {
        this.printing = bl;
    }

    public boolean isPrinting() {
        return this.printing;
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isRangeGridlinesVisible()) {
            Date date;
            ValueAxis valueAxis = this.getRangeAxis();
            if (valueAxis == null) {
                return;
            }
            int n = (int)graphics2D.getClipBounds().getMinY();
            int n2 = (int)graphics2D.getClipBounds().getMaxY();
            if (list != null) {
                graphics2D.setPaint(this.getRangeGridlinePaint());
                graphics2D.setStroke(this.getRangeGridlineStroke());
                for (int i = 0; i < list.size(); ++i) {
                    date = (DateTick)list.get(i);
                    int n3 = (int)valueAxis.valueToJava2D((double)date.getDate().getTime(), rectangle2D, this.getRangeAxisEdge());
                    graphics2D.drawLine(n3, n, n3, n2);
                }
            }
            IGlobalContext iGlobalContext = this.model.getGlobalContext();
            date = iGlobalContext.convertToServerTimeZone(iGlobalContext.getCurrentDate());
            long l = date.getTime();
            if (valueAxis.getRange().contains((double)l)) {
                int n4 = (int)valueAxis.valueToJava2D((double)l, rectangle2D, this.getRangeAxisEdge());
                Color color = graphics2D.getColor();
                graphics2D.setColor(Color.red);
                graphics2D.drawLine(n4, n, n4, n2);
                graphics2D.setColor(color);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        super.drawRangeMarkers(graphics2D, rectangle2D, n, layer);
        if (layer == Layer.BACKGROUND && this.isDrawOffPeriods()) {
            DateAxis dateAxis = (DateAxis)this.getRangeAxis();
            Intervals intervals = this.getOffPeriods((DateRange)dateAxis.getRange());
            if (intervals == null || intervals.isEmpty()) {
                return;
            }
            int n2 = (int)rectangle2D.getMinY();
            int n3 = (int)rectangle2D.getHeight();
            RectangleEdge rectangleEdge = this.getRangeAxisEdge();
            Color color = graphics2D.getColor();
            graphics2D.setColor(OFF_DAY_COLOR);
            for (int i = 0; i < intervals.size(); ++i) {
                Object t = intervals.get(i);
                int n4 = (int)dateAxis.lengthToJava2D((double)(((Interval)t).end - ((Interval)t).start), rectangle2D, rectangleEdge);
                if (n4 < 6) continue;
                int n5 = (int)dateAxis.valueToJava2D((double)((Interval)t).start, rectangle2D, rectangleEdge);
                graphics2D.fillRect(n5, n2, n4 + 1, n3);
            }
            graphics2D.setColor(color);
        }
    }

    protected Intervals getOffPeriods(DateRange dateRange) {
        return this.model.getOffPeriods(dateRange.getLowerDate().getTime(), dateRange.getUpperDate().getTime());
    }

    public void setDrawOffPeriods(boolean bl) {
        this.drawOffPeriods = bl;
    }

    public boolean isDrawOffPeriods() {
        return this.drawOffPeriods;
    }

    public boolean isSelectedNode(TGNode tGNode) {
        return this.model.isSelectedNode(tGNode);
    }
}

