/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.pe.timesheet.ItemTimeSheetData;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.financial.FinancialComputation;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.ITaskResource;
import com.triloggroup.project.schedule.ITaskSchedule;
import com.triloggroup.project.schedule.ITaskSummary;
import com.triloggroup.project.schedule.Predecessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.time.TimePeriod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttTask
extends GanttNode
implements ITaskSummary,
ITaskSchedule,
FinancialComputation.IFinancialTask,
Serializable {
    public static final ObjectType TYPE = new ObjectType("task");
    public static final int PE_SCHEDULING_MODE_EFFORT_DRIVEN = 0;
    public static final int PE_SCHEDULING_MODE_DURATION_DRIVEN = 1;
    public static final int PE_SCHEDULING_MODE_FORCE_DATES = 2;
    public static final int PE_SCHEDULING_MODE_DEADLINE_DRIVEN = 3;
    private static final double UNDEFINED_WORK = -1.0;
    private static final IPredecessor[] EMPTY_PREDECESSORS_ARRAY = new IPredecessor[0];
    private ArrayList<Predecessor> predecessors;
    private TaskResource[] resources = TaskResource.EMPTY_ARRAY;
    private Date actualStartDate;
    private Date actualFinishDate;
    private boolean skipAutoReschedule;
    private Date deadlineDate;
    private int priority = 500;
    private double remainingWork = -1.0;
    private double actualWork = -1.0;
    private double timeSheetHours;
    private ItemTimeSheetData timeSheetData;
    private int schedulingMode;
    protected int durationFormat;
    private double durationInHours;
    protected int workFormat;
    private double workInHours;
    private String calendarId;
    private boolean ignoreResourcesCalendar;
    private Date lateStart;
    private Date lateFinish;
    private double totalSlack = 0.0;

    public GanttTask(String string, String string2, String string3, String string4, Date date, Date date2) {
        super(string, string2, string3, string4, date, date2);
    }

    public boolean hasPredecessors() {
        return this.predecessors != null && !this.predecessors.isEmpty();
    }

    public ArrayList<Predecessor> getPredecessorsCopy() {
        return this.predecessors == null ? null : (ArrayList)this.predecessors.clone();
    }

    public ArrayList<Predecessor> getPredecessorsList() {
        return this.predecessors;
    }

    public int getPredecessorsCount() {
        if (this.predecessors != null) {
            return this.predecessors.size();
        }
        return 0;
    }

    public void setPredecessors(ArrayList<Predecessor> arrayList) {
        this.predecessors = arrayList;
    }

    public Predecessor getPredecessor(int n) {
        if (this.predecessors != null && n < this.predecessors.size()) {
            return this.predecessors.get(n);
        }
        return null;
    }

    public Predecessor addPredecessor(Predecessor predecessor) {
        if (predecessor == null) {
            throw new NullPointerException();
        }
        if (this.predecessors != null) {
            for (int i = 0; i < this.predecessors.size(); ++i) {
                if (!predecessor.getId().equals(this.predecessors.get(i).getId())) continue;
                throw new IllegalStateException("Predecessor " + predecessor.getId() + " already exist on task " + this.getUid());
            }
        }
        if (this.predecessors == null) {
            this.predecessors = new ArrayList();
        }
        this.predecessors.add(predecessor);
        return predecessor;
    }

    public Predecessor addPredecessor(String string, int n) {
        return this.addPredecessor(new Predecessor(string, n));
    }

    public Predecessor removePredecessor(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.predecessors == null) {
            return null;
        }
        for (int i = 0; i < this.predecessors.size(); ++i) {
            if (!string.equals(this.predecessors.get(i).getId())) continue;
            return this.predecessors.remove(i);
        }
        return null;
    }

    public Predecessor removePredecessor(int n) {
        if (this.predecessors != null && n < this.predecessors.size()) {
            return this.predecessors.remove(n);
        }
        return null;
    }

    public void addPredecessorAt(int n, Predecessor predecessor) {
        if (this.predecessors != null && n <= this.predecessors.size()) {
            this.predecessors.add(n, predecessor);
        }
    }

    public void setResources(TaskResource[] taskResourceArray) {
        if (taskResourceArray == null) {
            taskResourceArray = TaskResource.EMPTY_ARRAY;
        }
        this.resources = taskResourceArray;
    }

    public TaskResource[] getResources() {
        return this.resources;
    }

    public TaskResource[] getResourcesCopy() {
        if (this.resources == null || this.resources == TaskResource.EMPTY_ARRAY) {
            return this.resources;
        }
        TaskResource[] taskResourceArray = new TaskResource[this.resources.length];
        for (int i = 0; i < this.resources.length; ++i) {
            taskResourceArray[i] = this.resources[i].clone();
        }
        return taskResourceArray;
    }

    @Override
    public double getPlannedProgress() {
        long l;
        TimePeriod timePeriod = this.getDuration();
        long l2 = timePeriod.getStart().getTime();
        if (l2 >= (l = this.getGlobalContext().getCurrentDate().getTime())) {
            return 0.0;
        }
        long l3 = this.getFinishDate().getTime();
        if (l3 <= l) {
            return 1.0;
        }
        return (double)(l - l2) / (double)(l3 - l2);
    }

    public boolean isMilestone() {
        if (this.getDurationInHours() == 0.0) {
            TimePeriod timePeriod = this.getDuration();
            return timePeriod.getEnd().getTime() == timePeriod.getStart().getTime();
        }
        return false;
    }

    @Override
    public boolean setExpanded(boolean bl) {
        return !bl;
    }

    @Override
    public Date getActualStartDate() {
        return this.actualStartDate;
    }

    @Override
    public void setActualStartDate(Date date) {
        this.actualStartDate = date;
    }

    @Override
    public Date getActualFinishDate() {
        return this.actualFinishDate;
    }

    @Override
    public void setActualFinishDate(Date date) {
        this.actualFinishDate = date;
    }

    @Override
    public boolean isSkipAutoReschedule() {
        return this.skipAutoReschedule;
    }

    public void setSkipAutoReschedule(boolean bl) {
        this.skipAutoReschedule = bl;
    }

    public Date getDeadlineDate() {
        return this.deadlineDate;
    }

    public void setDeadlineDate(Date date) {
        this.deadlineDate = date;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public double getSpecifiedRemainingWork() {
        return this.remainingWork;
    }

    public void setSpecifiedRemainingWork(double d) {
        if (d < 0.0) {
            d = -1.0;
        }
        this.remainingWork = d;
    }

    public void resetSpecifiedRemainingWork() {
        this.setSpecifiedRemainingWork(-1.0);
    }

    @Override
    public double getEstimatedRemainingWork() {
        return this.getWorkInHours() * (1.0 - this.getProgress());
    }

    @Override
    public double getSpecifiedActualWork() {
        return this.actualWork;
    }

    public void setSpecifiedActualWork(double d) {
        if (d < 0.0) {
            d = -1.0;
        }
        this.actualWork = d;
    }

    public void resetSpecifiedActualWork() {
        this.setSpecifiedActualWork(-1.0);
    }

    public double getEstimatedActualWork() {
        if (this.getProjectContext().isActualWorkComputationModeTimesheet()) {
            return this.timeSheetHours;
        }
        return this.getWorkInHours() * this.getProgress();
    }

    @Override
    public double getComputedWorkedHours() {
        return this.getWorkInHours() * this.getProgress();
    }

    @Override
    public double getPlannedWorkedHours() {
        return this.getWorkInHours() * this.getPlannedProgress();
    }

    public double getTimeSheetHours() {
        return this.timeSheetHours;
    }

    public void setTimeSheetHours(double d) {
        this.timeSheetHours = d;
    }

    public ItemTimeSheetData getTimeSheetData() {
        return this.timeSheetData;
    }

    public void setTimeSheetData(ItemTimeSheetData itemTimeSheetData) {
        this.timeSheetData = itemTimeSheetData;
    }

    @Override
    public int getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(int n) {
        this.schedulingMode = n;
    }

    @Override
    public int getDurationFormat() {
        return this.durationFormat;
    }

    @Override
    public void setDurationFormat(int n) {
        this.durationFormat = n;
    }

    @Override
    public double getDurationInHours() {
        return this.durationInHours;
    }

    @Override
    public void setDurationInHours(double d) {
        this.durationInHours = d;
    }

    @Override
    public int getWorkFormat() {
        return this.workFormat;
    }

    @Override
    public void setWorkFormat(int n) {
        if (n == 0) {
            n = 5;
        }
        this.workFormat = n;
    }

    @Override
    public double getWorkInHours() {
        return this.workInHours;
    }

    @Override
    public void setWorkInHours(double d) {
        this.workInHours = d;
    }

    @Override
    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String string) {
        this.calendarId = string;
    }

    @Override
    public boolean isIgnoreResourcesCalendar() {
        return this.ignoreResourcesCalendar;
    }

    public void setIgnoreResourcesCalendar(boolean bl) {
        this.ignoreResourcesCalendar = bl;
    }

    @Override
    public double getTotalSlack() {
        return this.totalSlack;
    }

    @Override
    public void setTotalSlack(double d) {
        this.totalSlack = d;
    }

    @Override
    public GanttTask clone() {
        GanttTask ganttTask = (GanttTask)super.clone();
        if (this.predecessors != null) {
            ganttTask.predecessors = this.getPredecessorsCopy();
        }
        if (this.resources != null) {
            ganttTask.resources = this.getResourcesCopy();
        }
        return ganttTask;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Date getLateStart() {
        return this.lateStart;
    }

    @Override
    public void setLateStart(Date date) {
        this.lateStart = date;
    }

    @Override
    public Date getLateFinish() {
        return this.lateFinish;
    }

    @Override
    public void setLateFinish(Date date) {
        this.lateFinish = date;
    }

    @Override
    public ITaskResource[] getTaskResources() {
        return this.getResources();
    }

    @Override
    public IPredecessor[] getPredecessors() {
        if (this.predecessors == null) {
            return EMPTY_PREDECESSORS_ARRAY;
        }
        return this.predecessors.toArray(EMPTY_PREDECESSORS_ARRAY);
    }

    @Override
    public IPredecessor getPredecessor(String string) {
        if (this.predecessors == null) {
            return null;
        }
        for (int i = 0; i < this.predecessors.size(); ++i) {
            Predecessor predecessor = this.predecessors.get(i);
            if (!string.equals(predecessor.getId())) continue;
            return predecessor;
        }
        return null;
    }

    @Override
    public boolean isForceStartDate() {
        return false;
    }

    @Override
    public void setForceStartDate(boolean bl) {
    }

    @Override
    public boolean isTemplate() {
        return false;
    }

    @Override
    public boolean isSkipDocumentInitialization() {
        return false;
    }

    @Override
    public void setPercentage(int n) {
        this.setPercentComplete((double)n / 100.0);
    }

    @Override
    public ObjectType getType() {
        return TYPE;
    }

    @Override
    public double getProjectedAdditionalCost() {
        return FinancialComputation.getNodeProjectedAdditionalCost(this);
    }

    @Override
    public double getInitiallyPlannedAdditionalCost() {
        return this.getAdditionalCost();
    }
}

