/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt;

import com.triloggroup.gantt.TGNode;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;

public class GanttDataset
extends TaskSeriesCollection {
    protected HashMap<String, Integer> keysIndexMap = new HashMap();

    public TGNode getNode(int n, int n2) {
        TaskSeries taskSeries = this.getSeries(n);
        return (TGNode)taskSeries.get(n2);
    }

    public TGNode getNode(int n, String string, String string2) {
        TaskSeries taskSeries = this.getSeries(n);
        return (TGNode)taskSeries.get(string + '_' + string2);
    }

    public int getColumnIndex(Comparable comparable) {
        Integer n = this.keysIndexMap.get(comparable);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void add(TaskSeries taskSeries) {
        if (taskSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.getRowKeys().add(taskSeries);
        taskSeries.addChangeListener((SeriesChangeListener)this);
        List list = this.getColumnKeys();
        for (Task task : taskSeries.getTasks()) {
            String string = task.getDescription();
            Integer n = this.keysIndexMap.get(string);
            if (n != null) continue;
            list.add(string);
            this.keysIndexMap.put(string, new Integer(list.size() - 1));
        }
        this.fireDatasetChanged();
    }

    public void removeAll() {
        super.removeAll();
        this.getColumnKeys().clear();
        this.keysIndexMap.clear();
    }

    public void setSeries(TaskSeries taskSeries, int n) {
        if (n < 0 || n >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        TaskSeries taskSeries2 = this.getRowKeys().set(n, taskSeries);
        if (taskSeries2 != null) {
            taskSeries2.removeChangeListener((SeriesChangeListener)this);
        }
        taskSeries.addChangeListener((SeriesChangeListener)this);
        this.seriesChanged(null);
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        List list = this.getColumnKeys();
        list.clear();
        this.keysIndexMap.clear();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            List list2 = this.getRowKeys();
            TaskSeries taskSeries = (TaskSeries)list2.get(i);
            for (Task task : taskSeries.getTasks()) {
                String string = task.getDescription();
                Integer n = this.keysIndexMap.get(string);
                if (n != null) continue;
                list.add(string);
                this.keysIndexMap.put(string, new Integer(list.size() - 1));
            }
        }
    }
}

