/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.util;

import com.triloggroup.util.UString;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLSFileLoader {
    private static final char keyValueSeparator = '=';
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final String LINKED_BUNDLE_KEY = "!!LinkedToNLSBundle=";

    public static String load(InputStream inputStream, Map<String, String> map) throws Exception {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            if (bufferedReader.markSupported()) {
                bufferedReader.mark(1);
                if (bufferedReader.read() != 65279) {
                    bufferedReader.reset();
                }
            }
            String string = null;
            while (true) {
                int n;
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    String string3 = string;
                    return string3;
                }
                if (string2.length() <= 0) continue;
                int n2 = string2.length();
                for (n = 0; n < n2 && whiteSpaceChars.indexOf(string2.charAt(n)) != -1; ++n) {
                }
                if (n == n2) continue;
                char c = string2.charAt(n);
                if (c != '#' && c != '!') {
                    int n3;
                    while (NLSFileLoader.continueLine(string2)) {
                        int n4;
                        String string4 = bufferedReader.readLine();
                        if (string4 == null) {
                            string4 = "";
                        }
                        String string5 = string2.substring(0, n2 - 1);
                        for (n4 = 0; n4 < string4.length() && whiteSpaceChars.indexOf(string4.charAt(n4)) != -1; ++n4) {
                        }
                        string4 = string4.substring(n4, string4.length());
                        string2 = new String(string5 + string4);
                        n2 = string2.length();
                    }
                    for (n3 = n; n3 < n2; ++n3) {
                        char c2 = string2.charAt(n3);
                        if (c2 == '\\') {
                            ++n3;
                            continue;
                        }
                        if ('=' == c2) break;
                    }
                    int n5 = n3 + 1;
                    String string6 = string2.substring(n, n3);
                    String string7 = n3 < n2 ? string2.substring(n5, n2) : "";
                    map.put(string6, NLSFileLoader.convert(string7));
                    continue;
                }
                if (string != null || !string2.startsWith(LINKED_BUNDLE_KEY) || string2.length() <= LINKED_BUNDLE_KEY.length()) continue;
                String string8 = string2.substring(LINKED_BUNDLE_KEY.length());
                if (UString.isEmpty(string8 = UString.trim(string8))) continue;
                string = string8;
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private static String convert(String string) {
        int n = string.length();
        StringBuilder stringBuilder = null;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n);
                    if (n2 > 2) {
                        stringBuilder.append(string.substring(0, n2 - 2));
                    }
                }
                stringBuilder.append((char)n3);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append((char)n3);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }
}

