/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.ScheduleCalendar;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBSComputation {
    public static final int COMPUTE_DATES = 1;
    public static final int COMPUTE_PROGRESS = 2;
    protected Date refDate;

    public void setReferenceDate(Date date) {
        this.refDate = date;
    }

    public Date getReferenceDate() {
        return this.refDate;
    }

    public void rescheduleAllWBSDates(ScheduleCalendar scheduleCalendar, IWBS iWBS, double d) {
        this.rescheduleAllWBS(scheduleCalendar, iWBS, 1, d);
    }

    public void rescheduleAllWBSProgress(IWBS iWBS) {
        this.rescheduleWBS(null, iWBS, null, true, 2, 0.0);
    }

    public void rescheduleAllWBS(ScheduleCalendar scheduleCalendar, IWBS iWBS, int n, double d) {
        ArrayList<IWBS> arrayList = (n & 1) != 0 ? new ArrayList<IWBS>() : null;
        this.rescheduleWBS(scheduleCalendar, iWBS, arrayList, true, n, d);
        this.computeDatesForWbsWithoutSubTasks(arrayList);
    }

    public void rescheduleWBS(ScheduleCalendar scheduleCalendar, IWBS[] iWBSArray, int n, double d) {
        ArrayList<IWBS> arrayList = (n & 1) != 0 ? new ArrayList<IWBS>() : null;
        for (int i = iWBSArray.length - 1; i >= 0; --i) {
            this.rescheduleWBS(scheduleCalendar, iWBSArray[i], arrayList, false, n, d);
        }
        this.computeDatesForWbsWithoutSubTasks(arrayList);
    }

    protected void rescheduleWBS(ScheduleCalendar scheduleCalendar, IWBS iWBS, ArrayList<IWBS> arrayList, boolean bl, int n, double d) {
        boolean bl2;
        Iterator<? extends INode> iterator = iWBS.allChildrenIterator();
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = bl2 = (n & 1) != 0;
        if (iWBS.isSubProject() && !iterator.hasNext()) {
            if (bl2) {
                double d2 = CalendarUtil.msToHours(CalendarUtil.getDurationInMs(iWBS.getStartDate(), iWBS.getFinishDate(), scheduleCalendar));
                iWBS.setDurationInDays(d2 / d);
            }
            return;
        }
        if (iterator.hasNext()) {
            iWBS.setHasChildren(true);
            boolean bl5 = false;
            double d3 = 0.0;
            Date date = null;
            Date date2 = null;
            double d4 = 0.0;
            double d5 = 0.0;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            while (iterator.hasNext()) {
                INode iNode = iterator.next();
                double d6 = 0.0;
                if (iNode instanceof IWBS) {
                    IWBS iWBS2 = (IWBS)iNode;
                    if (bl) {
                        this.rescheduleWBS(scheduleCalendar, iWBS2, arrayList, bl, n, d);
                    }
                    if ((d6 = iWBS2.getWorkInHours()) == 0.0 && !this.hasSubTaskRecursive(iWBS2, bl ? null : arrayList)) {
                        continue;
                    }
                } else {
                    d6 = iNode.getWorkInHours();
                }
                bl5 = true;
                if (d6 > 0.0) {
                    d3 += d6;
                    if (bl3) {
                        d4 += iNode.getComputedWorkedHours();
                        d5 += iNode.getPlannedWorkedHours();
                    }
                }
                if (bl3) {
                    if ("Done".equals(iNode.getStatus())) {
                        bl6 = true;
                    } else if ("In Progress".equals(iNode.getStatus())) {
                        bl7 = true;
                    } else if ("Pending".equals(iNode.getStatus())) {
                        bl8 = true;
                    }
                }
                if (!bl2) continue;
                if (date == null || iNode.getStartDate().getTime() < date.getTime()) {
                    date = iNode.getStartDate();
                }
                if (date2 != null && iNode.getFinishDate().getTime() <= date2.getTime()) continue;
                date2 = iNode.getFinishDate();
            }
            if (bl5) {
                if (bl2) {
                    iWBS.setDates(date, date2);
                    double d7 = CalendarUtil.msToHours(CalendarUtil.getDurationInMs(date, date2, scheduleCalendar));
                    iWBS.setDurationInDays(d7 / d);
                }
                iWBS.setWorkInHours(d3);
                if (bl3) {
                    if (bl7 || bl6 && bl8) {
                        iWBS.setStatus("In Progress");
                    } else if (bl6) {
                        iWBS.setStatus("Done");
                    } else {
                        iWBS.setStatus("Pending");
                    }
                    iWBS.setComputedWorkedHours(d4);
                    iWBS.setPlannedWorkedHours(d5);
                    if (d3 == 0.0) {
                        this.computeCompletionForWbsWithMilestonesOnly(iWBS);
                    } else {
                        double d8 = d4 / d3;
                        if (d8 > 0.99 && (bl7 || bl8)) {
                            d8 = 0.99;
                        } else if (d8 > 0.0 && d8 < 0.01) {
                            d8 = 0.01;
                        }
                        iWBS.setProgress(d8);
                        iWBS.setPlannedProgress(d5 / d3);
                    }
                }
                iWBS.setHasSubTask(true);
                return;
            }
        } else {
            iWBS.setHasChildren(false);
        }
        if (arrayList != null) {
            arrayList.add(iWBS);
        }
        iWBS.setHasSubTask(false);
        iWBS.setWorkInHours(0.0);
        if (bl3) {
            iWBS.setProgress(0.0);
            iWBS.setPlannedProgress(0.0);
            iWBS.setStatus("Pending");
            iWBS.setComputedWorkedHours(0.0);
            iWBS.setPlannedWorkedHours(0.0);
        }
        iWBS.setDurationInDays(0.0);
    }

    protected void computeDatesForWbsWithoutSubTasks(ArrayList<IWBS> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        HashSet<IWBS> hashSet = new HashSet<IWBS>();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            IWBS iWBS = arrayList.get(i);
            if (!hashSet.add(iWBS)) continue;
            IWBS iWBS2 = iWBS.getParentWBS();
            Date date = iWBS2 == null ? iWBS.getStartDate() : iWBS2.getStartDate();
            iWBS.setDates(date, date);
        }
    }

    protected void computeCompletionForWbsWithMilestonesOnly(IWBS iWBS) {
        double[] dArray = new double[3];
        long l = this.refDate != null ? this.refDate.getTime() : System.currentTimeMillis();
        this.getDataForWbsWithMilestonesOnly(iWBS, dArray, l);
        double d = dArray[0];
        if (d == 0.0) {
            iWBS.setProgress(0.0);
            iWBS.setPlannedProgress(0.0);
        } else {
            iWBS.setProgress(dArray[2] / d);
            iWBS.setPlannedProgress(dArray[1] / d);
        }
    }

    private void getDataForWbsWithMilestonesOnly(IWBS iWBS, double[] dArray, long l) {
        Iterator<? extends INode> iterator = iWBS.allChildrenIterator();
        if (iWBS.isSubProject()) {
            return;
        }
        while (iterator.hasNext()) {
            INode iNode = iterator.next();
            if (iNode instanceof IWBS) {
                this.getDataForWbsWithMilestonesOnly((IWBS)iNode, dArray, l);
                continue;
            }
            if (!iNode.getStartDate().equals(iNode.getFinishDate())) {
                if (iNode.getFinishDate().getTime() < l) {
                    dArray[1] = dArray[1] + 1.0;
                }
            } else if (iNode.getStartDate().getTime() < l) {
                dArray[1] = dArray[1] + 1.0;
            }
            dArray[0] = dArray[0] + 1.0;
            dArray[2] = dArray[2] + iNode.getProgress();
        }
    }

    private boolean hasSubTaskRecursive(IWBS iWBS, ArrayList<IWBS> arrayList) {
        if (iWBS.isSubProject()) {
            return true;
        }
        if (arrayList == null) {
            return iWBS.hasSubTask();
        }
        Iterator<? extends INode> iterator = iWBS.allChildrenIterator();
        while (iterator.hasNext()) {
            INode iNode = iterator.next();
            if (iNode instanceof IWBS) {
                if (!this.hasSubTaskRecursive((IWBS)iNode, arrayList)) continue;
                return true;
            }
            return true;
        }
        if (arrayList != null) {
            arrayList.add(iWBS);
        }
        return false;
    }

    public static interface INode {
        public double getWorkInHours();

        public Date getStartDate();

        public Date getFinishDate();

        public String getStatus();

        public double getProgress();

        public double getPlannedProgress();

        public double getComputedWorkedHours();

        public double getPlannedWorkedHours();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IWBS
    extends INode {
        public Iterator<? extends INode> allChildrenIterator();

        public void setDates(Date var1, Date var2);

        public void setDurationInDays(double var1);

        public void setWorkInHours(double var1);

        public boolean isSubProject();

        public void setStatus(String var1);

        public void setProgress(double var1);

        public void setPlannedProgress(double var1);

        public IWBS getParentWBS();

        public void setHasChildren(boolean var1);

        public boolean hasSubTask();

        public void setHasSubTask(boolean var1);

        public void setComputedWorkedHours(double var1);

        public void setPlannedWorkedHours(double var1);
    }
}

