/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.date.TGTime;
import java.util.ArrayList;
import java.util.Date;

public class CalendarUtil {
    public static final long MAX_DATE = System.currentTimeMillis() + 9460800000000L;
    public static final long MIN_DATE = System.currentTimeMillis() - 9460800000000L;

    static double getWorkingHoursForDay(ScheduleCalendar scheduleCalendar, int n) {
        return CalendarUtil.msToHours(CalendarUtil.getWorkingMsForDay(scheduleCalendar, n));
    }

    static double getWorkingHoursByWeek(ScheduleCalendar scheduleCalendar) {
        return CalendarUtil.msToHours(CalendarUtil.getWorkingMsByWeek(scheduleCalendar));
    }

    static long getWorkingMsForDay(ScheduleCalendar scheduleCalendar, int n) {
        ScheduleCalendar.Weekday weekday = scheduleCalendar.getWeekdayByDayType(n);
        if (weekday == null || !weekday.isDayWorking) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < weekday.workingTimes.length; ++i) {
            long l2 = weekday.workingTimes[i].fromTime.toSeconds();
            long l3 = weekday.workingTimes[i].toTime.toSeconds();
            l += l3 - l2;
        }
        return l * 1000L;
    }

    static long getWorkingMsByWeek(ScheduleCalendar scheduleCalendar) {
        long l = 0L;
        for (int i = 1; i < 8; ++i) {
            l += CalendarUtil.getWorkingMsForDay(scheduleCalendar, i);
        }
        return l;
    }

    static long getWorkingMsForException(ScheduleCalendar.ExceptionWeekday exceptionWeekday) {
        if (exceptionWeekday == null || !exceptionWeekday.isDayWorking) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < exceptionWeekday.workingTimes.length; ++i) {
            long l2 = exceptionWeekday.workingTimes[i].fromTime.toSeconds();
            long l3 = exceptionWeekday.workingTimes[i].toTime.toSeconds();
            l += l3 - l2;
        }
        return l * 1000L;
    }

    static double getWorkingHoursForException(ScheduleCalendar.ExceptionWeekday exceptionWeekday) {
        return CalendarUtil.msToHours(CalendarUtil.getWorkingMsForException(exceptionWeekday));
    }

    public static Date getNextWorkingDay(Date date, ScheduleCalendar scheduleCalendar) {
        TGTime tGTime = null;
        while (tGTime == null) {
            CalendarUtil.addDays(date, 1);
            tGTime = scheduleCalendar.getFirstWorkingTime(date);
            if (date.getTime() <= MAX_DATE) continue;
            throw new IllegalStateException("No working day found for calendar " + scheduleCalendar.getCalendarId());
        }
        tGTime.setTimeToDate(date);
        return date;
    }

    public static Date getPreviousWorkingDay(Date date, ScheduleCalendar scheduleCalendar) {
        TGTime tGTime = null;
        while (tGTime == null) {
            CalendarUtil.addDays(date, -1);
            tGTime = scheduleCalendar.getLastWorkingTime(date);
            if (date.getTime() >= MIN_DATE) continue;
            throw new IllegalStateException("No working day found for calendar " + scheduleCalendar.getCalendarId());
        }
        tGTime.setTimeToDate(date);
        return date;
    }

    public static ScheduleCalendar.WorkingTime[] moveToPreviousWorkingDay(Date date, ScheduleCalendar scheduleCalendar) {
        TGTime tGTime = null;
        ScheduleCalendar.WorkingTime[] workingTimeArray = null;
        do {
            CalendarUtil.addDays(date, -1);
        } while ((workingTimeArray = scheduleCalendar.getWorkingHours(date)) == null || workingTimeArray.length <= 0);
        tGTime = workingTimeArray[workingTimeArray.length - 1].toTime;
        tGTime.setTimeToDate(date);
        return workingTimeArray;
    }

    public static long getNextWorkingMs(Date date, ScheduleCalendar scheduleCalendar) {
        ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
        if (workingTimeArray == null || workingTimeArray.length == 0) {
            return 0L;
        }
        int n = 0;
        long l = CalendarUtil.getTimeInSeconds(date);
        for (int i = 0; i < workingTimeArray.length; ++i) {
            long l2 = workingTimeArray[i].fromTime.toSeconds();
            long l3 = workingTimeArray[i].toTime.toSeconds();
            if (l < l2) {
                n = (int)((long)n + (l3 - l2) * 1000L);
                continue;
            }
            if (l >= l3) continue;
            n = (int)((long)n + (l3 - l) * 1000L);
        }
        return n;
    }

    public static long getPreviousWorkingMs(Date date, ScheduleCalendar scheduleCalendar) {
        ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
        if (workingTimeArray == null || workingTimeArray.length == 0) {
            return 0L;
        }
        long l = 0L;
        long l2 = CalendarUtil.getTimeInSeconds(date);
        for (int i = 0; i < workingTimeArray.length; ++i) {
            long l3 = workingTimeArray[i].fromTime.toSeconds();
            long l4 = workingTimeArray[i].toTime.toSeconds();
            if (l2 > l4) {
                l += (l4 - l3) * 1000L;
                continue;
            }
            if (l2 <= l3) continue;
            l += (l2 - l3) * 1000L;
        }
        return l;
    }

    public static long getDurationInMs(Date date, Date date2, ScheduleCalendar scheduleCalendar) {
        int n;
        int n2;
        long l = 0L;
        if (date.compareTo(date2) == 0) {
            return 0L;
        }
        if (CalendarUtil.isSameDay(date, date2)) {
            ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
            if (workingTimeArray != null && workingTimeArray.length > 0) {
                long l2 = CalendarUtil.getTimeInSeconds(date);
                long l3 = CalendarUtil.getTimeInSeconds(date2);
                for (int i = 0; i < workingTimeArray.length; ++i) {
                    long l4 = workingTimeArray[i].fromTime.toSeconds();
                    long l5 = workingTimeArray[i].toTime.toSeconds();
                    if (l2 >= l4) {
                        if (l3 <= l5) {
                            return (l3 - l2) * 1000L;
                        }
                        if (l2 >= l5) continue;
                        l += (l5 - l2) * 1000L;
                        continue;
                    }
                    if (l3 <= l4) break;
                    if (l3 <= l5) {
                        l += (l3 - l4) * 1000L;
                        break;
                    }
                    l += (l5 - l4) * 1000L;
                }
            }
            return l;
        }
        long l6 = CalendarUtil.getWorkingMsByWeek(scheduleCalendar);
        Date date3 = (Date)date.clone();
        date3.setDate(date.getDate() - date.getDay());
        TGTime tGTime = new TGTime(0, 0, 0);
        date3 = tGTime.applyTime(date3);
        Date date4 = new Date();
        date4 = (Date)date2.clone();
        date4.setDate(date2.getDate() - date2.getDay() + 7);
        date4 = tGTime.applyTime(date4);
        double d = (double)(date4.getTime() - date3.getTime()) / 1000.0 / 60.0 / 60.0 / 24.0 / 7.0;
        long l7 = Math.round(d) * l6;
        long l8 = 0L;
        long[] lArray = new long[7];
        for (n2 = 0; n2 < 7; ++n2) {
            lArray[n2] = CalendarUtil.getWorkingMsForDay(scheduleCalendar, n2 + 1);
        }
        for (n2 = 0; n2 < CalendarUtil.getDay(date) + 1; ++n2) {
            l8 += lArray[n2];
        }
        for (n2 = CalendarUtil.getDay(date2); n2 < 7; ++n2) {
            l8 += lArray[n2];
        }
        l = l7 - l8;
        ArrayList<ScheduleCalendar.ExceptionWeekday> arrayList = scheduleCalendar.getExceptionWeekDays();
        Date date5 = new Date();
        long l9 = 0L;
        for (n = 0; n < arrayList.size(); ++n) {
            ScheduleCalendar.ExceptionWeekday exceptionWeekday = arrayList.get(n);
            l9 = CalendarUtil.getWorkingMsForException(exceptionWeekday);
            Date date6 = exceptionWeekday.period.fromDate;
            Date date7 = exceptionWeekday.period.toDate;
            if (date.after(date6) && date.before(date7)) {
                date5 = (Date)date.clone();
                CalendarUtil.addDays(date5, 1);
            } else if (date.before(date6)) {
                date5 = (Date)date6.clone();
            } else {
                date5 = (Date)date2.clone();
                CalendarUtil.addDays(date5, 1);
            }
            while (date5.before(date7) && date5.before(date2) && !CalendarUtil.isSameDay(date5, date2)) {
                l -= lArray[CalendarUtil.getDay(date5)];
                l += l9;
                CalendarUtil.addDays(date5, 1);
            }
        }
        ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
        if (workingTimeArray != null && workingTimeArray.length > 0) {
            n = 0;
            for (int i = 0; i < workingTimeArray.length; ++i) {
                long l10 = workingTimeArray[i].fromTime.toSeconds();
                long l11 = workingTimeArray[i].toTime.toSeconds();
                long l12 = CalendarUtil.getTimeInSeconds(date);
                if (l12 <= l11 && l12 >= l10 && n == 0) {
                    l += (l11 - l12) * 1000L;
                    n = 1;
                    continue;
                }
                if (l12 > l11) continue;
                l += (l11 - l10) * 1000L;
            }
        }
        if ((workingTimeArray = scheduleCalendar.getWorkingHours(date2)) != null) {
            for (n = 0; n < workingTimeArray.length; ++n) {
                long l13 = workingTimeArray[n].fromTime.toSeconds();
                long l14 = workingTimeArray[n].toTime.toSeconds();
                double d2 = CalendarUtil.getTimeInSeconds(date2);
                if (d2 >= (double)l13 && d2 <= (double)l14) {
                    l = (long)((double)l + (d2 - (double)l13) * 1000.0);
                    break;
                }
                if (d2 < (double)l13) break;
                l += (l14 - l13) * 1000L;
            }
        }
        return l;
    }

    private static int getDay(Date date) {
        return date.getDay();
    }

    public static Date getFirstStartDate(Date date, ScheduleCalendar[] scheduleCalendarArray) {
        return CalendarUtil.getFirstStartDate(date, scheduleCalendarArray, false);
    }

    static Date getFirstStartDate(Date date, ScheduleCalendar[] scheduleCalendarArray, boolean bl) {
        Date date2 = null;
        for (int i = 0; i < scheduleCalendarArray.length; ++i) {
            Date date3 = (Date)date.clone();
            ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendarArray[i].getWorkingHours(date3);
            if (workingTimeArray == null) {
                date3 = CalendarUtil.getNextWorkingDay(date3, scheduleCalendarArray[i]);
            } else {
                long l = CalendarUtil.getTimeInMinutes(date3);
                TGTime tGTime = workingTimeArray[workingTimeArray.length - 1].toTime;
                long l2 = tGTime.hours * 60 + tGTime.minutes;
                if (l > l2 || !bl && l == l2) {
                    date3 = CalendarUtil.getNextWorkingDay(date3, scheduleCalendarArray[i]);
                } else {
                    for (int j = 0; j < workingTimeArray.length; ++j) {
                        long l3 = workingTimeArray[j].fromTime.toMinutes();
                        long l4 = workingTimeArray[j].toTime.toMinutes();
                        if (l < l3) {
                            workingTimeArray[j].fromTime.setTimeToDate(date3);
                            break;
                        }
                        if (l < l4 || bl && l == l4) break;
                    }
                }
            }
            if (date2 != null && !date3.before(date2)) continue;
            date2 = date3;
        }
        return date2;
    }

    public static Date getFirstStartDate(Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        if (scheduleCalendarArray != null && scheduleCalendarArray.length > 0) {
            return CalendarUtil.getFirstStartDate(date, scheduleCalendarArray);
        }
        if (scheduleCalendar2 != null) {
            return CalendarUtil.getFirstStartDate(date, new ScheduleCalendar[]{scheduleCalendar2});
        }
        return CalendarUtil.getFirstStartDate(date, new ScheduleCalendar[]{scheduleCalendar});
    }

    public static Date getLastEndDate(Date date, ScheduleCalendar[] scheduleCalendarArray) {
        return CalendarUtil.getLastEndDate(date, scheduleCalendarArray, false);
    }

    static Date getLastEndDate(Date date, ScheduleCalendar[] scheduleCalendarArray, boolean bl) {
        Date date2 = null;
        for (int i = 0; i < scheduleCalendarArray.length; ++i) {
            Date date3 = (Date)date.clone();
            ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendarArray[i].getWorkingHours(date3);
            if (workingTimeArray == null || workingTimeArray.length == 0) {
                date3 = CalendarUtil.getPreviousWorkingDay(date3, scheduleCalendarArray[i]);
            } else {
                long l;
                long l2 = CalendarUtil.getTimeInMinutes(date3);
                if (l2 < (l = workingTimeArray[0].fromTime.toMinutes()) || !bl && l2 == l) {
                    date3 = CalendarUtil.getPreviousWorkingDay(date3, scheduleCalendarArray[i]);
                } else {
                    for (int j = workingTimeArray.length - 1; j >= 0; --j) {
                        long l3 = workingTimeArray[j].fromTime.toMinutes();
                        long l4 = workingTimeArray[j].toTime.toMinutes();
                        if (l2 > l4) {
                            workingTimeArray[j].toTime.setTimeToDate(date3);
                            break;
                        }
                        if (l2 > l3 || bl && l2 == l3) break;
                    }
                }
            }
            if (date2 != null && !date3.after(date2)) continue;
            date2 = date3;
        }
        return date2;
    }

    private static void addDays(Date date, int n) {
        date.setDate(date.getDate() + n);
    }

    private static long getTimeInMinutes(Date date) {
        return date.getHours() * 60 + date.getMinutes();
    }

    static long getTimeInSeconds(Date date) {
        return date.getHours() * 3600 + date.getMinutes() * 60 + date.getSeconds();
    }

    static boolean isSameDay(Date date, Date date2) {
        long l;
        if (date == null || date2 == null) {
            return false;
        }
        long l2 = date.getTime();
        if (l2 == (l = date2.getTime())) {
            return true;
        }
        if (Math.abs(l - l2) > 90000000L) {
            return false;
        }
        return date.getDate() == date2.getDate();
    }

    public static double msToHours(long l) {
        return (double)l / 3600000.0;
    }

    public static long hoursToMs(double d) {
        return Math.round(d * 3600.0) * 1000L;
    }
}

