/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.schedule;

import com.triloggroup.gantt.util.Interval;
import com.triloggroup.gantt.util.ValueInterval;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.IPredecessor;
import com.triloggroup.project.schedule.ITaskResource;
import com.triloggroup.project.schedule.ITaskSchedule;
import com.triloggroup.project.schedule.ITaskSummary;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.project.schedule.ScheduleCst;
import com.triloggroup.util.date.TGTime;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractScheduleComputation {
    protected static boolean ENABLE_ASSERT = false;
    private static final ScheduleCalendar.WorkingTime[] WORKING_TIMES_EMPTY_ARRAY = new ScheduleCalendar.WorkingTime[0];
    private static int cptID = 0;

    public static String newObjectId(String string) {
        long l = System.currentTimeMillis();
        long l2 = l * 1000L + (long)(cptID++ % 1000);
        return string + Long.toHexString(l2);
    }

    public int validateTask(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray, boolean bl) {
        int n = 0;
        try {
            String string = iTaskSchedule.getStatus();
            int n2 = iTaskSchedule.getPercentage();
            Date date = iTaskSchedule.getStartDate();
            Date date2 = iTaskSchedule.getActualFinishDate();
            if (!(iTaskSchedule.getPredecessors() != null && iTaskSchedule.getPredecessors().length != 0 || string.equals("Done") || date != null)) {
                date = this.getProjectStartDate();
                iTaskSchedule.setStartDate(date);
            }
            if (bl) {
                if (!(n2 != 100 && date2 == null || string.equals("Done"))) {
                    this.calculateTaskComputedValues(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                }
                if (n2 == 100 || date2 != null || string.equals("Done")) {
                    int n3 = this.checkActualDates(iTaskSchedule);
                    if (n3 != 0) {
                        return n3;
                    }
                    int n4 = this.checkPredecessorsForAutomaticReschedule(iTaskSchedule);
                    if (n4 < 0) {
                        return 9;
                    }
                }
                iTaskSchedule.setStatus("Done");
                iTaskSchedule.setPercentage(100);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    protected int checkActualDates(ITaskSchedule iTaskSchedule) {
        Date date = null;
        Date date2 = null;
        Date date3 = null;
        Date date4 = null;
        Date date5 = iTaskSchedule.getStartDate();
        Date date6 = iTaskSchedule.getActualStartDate();
        Date date7 = iTaskSchedule.getFinishDate();
        Date date8 = iTaskSchedule.getActualFinishDate();
        if (date5 != null) {
            date = this.setTime(date5, 0, 0, 0);
        }
        if (date6 != null) {
            date2 = this.setTime(date6, 0, 0, 0);
        }
        if (date7 != null) {
            date3 = this.setTime(date7, 0, 0, 0);
        }
        if (date8 != null) {
            date4 = this.setTime(date8, 0, 0, 0);
        }
        if (date8 != null) {
            if (date6 != null) {
                if (date4.getTime() < date2.getTime()) {
                    return 10;
                }
            } else if (date4.getTime() < date.getTime()) {
                return 11;
            }
        } else if (date7 != null && date6 != null && date2.getTime() > date3.getTime()) {
            return 12;
        }
        return 0;
    }

    public int checkPredecessorsForAutomaticReschedule(ITaskSchedule iTaskSchedule) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        Date date = null;
        Date date2 = null;
        Date date3 = null;
        Date date4 = null;
        IPredecessor[] iPredecessorArray = iTaskSchedule.getPredecessors();
        Date date5 = iTaskSchedule.getStartDate();
        Date date6 = iTaskSchedule.getFinishDate();
        Date date7 = iTaskSchedule.getActualFinishDate();
        Date date8 = iTaskSchedule.getActualStartDate();
        if (date6 != null) {
            date = this.setTime(date6, 0, 0, 0);
        }
        if (date7 != null) {
            date3 = this.setTime(date7, 0, 0, 0);
        }
        if (date8 != null) {
            date4 = this.setTime(date8, 0, 0, 0);
        }
        if (date5 != null) {
            date2 = this.setTime(date5, 0, 0, 0);
        }
        if (iPredecessorArray != null && iPredecessorArray.length > 0) {
            for (int i = 0; i < iPredecessorArray.length; ++i) {
                int n2 = iPredecessorArray[i].getType();
                if (n2 == 0 || n2 == 2) {
                    bl = true;
                }
                if (n2 != 3 && n2 != 1) continue;
                bl2 = true;
            }
        }
        if (bl && date6 != null && date3.getTime() < date.getTime()) {
            n = -1;
        }
        if (bl2 && date8 != null && date4.getTime() < date2.getTime()) {
            n = -1;
        }
        return n;
    }

    public void onQuerySaveTaskDocument(ITaskSchedule iTaskSchedule, boolean bl, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray, boolean bl2) throws Exception {
        Object object;
        String string = iTaskSchedule.getStatus();
        if (bl && !iTaskSchedule.isSkipDocumentInitialization()) {
            object = AbstractScheduleComputation.newObjectId("Task_");
            iTaskSchedule.setUid((String)object);
        }
        if (!string.equals("Done") || !bl2) {
            this.calculateTaskComputedValues(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        } else {
            object = null;
            Date date = null;
            Date date2 = iTaskSchedule.getActualStartDate();
            Date date3 = iTaskSchedule.getStartDate();
            Date date4 = iTaskSchedule.getActualFinishDate();
            if (date2 != null && date2.getTime() != date3.getTime() && (object = this.setFirstTimeInDate(date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray)) != null) {
                iTaskSchedule.setStartDate((Date)object);
                iTaskSchedule.setActualStartDate((Date)object);
            }
            if (date4 != null && (date = this.setLastTimeInDate(date4, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray)) != null) {
                iTaskSchedule.setFinishDate(date);
                iTaskSchedule.setActualFinishDate(date);
            }
            this.calculateDurationAndWorkFromDates(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        }
    }

    public Date setFirstTimeInDate(Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        if (scheduleCalendarArray == null || scheduleCalendarArray.length == 0) {
            scheduleCalendarArray = new ScheduleCalendar[]{scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar};
        }
        return this.setFirstTimeInDate(date, scheduleCalendarArray);
    }

    public Date setLastTimeInDate(Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        if (scheduleCalendarArray == null || scheduleCalendarArray.length == 0) {
            scheduleCalendarArray = new ScheduleCalendar[]{scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar};
        }
        return this.setLastTimeInDate(date, scheduleCalendarArray);
    }

    public static boolean isWorkingDay(Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        if (scheduleCalendarArray != null && scheduleCalendarArray.length > 0) {
            for (int i = 0; i < scheduleCalendarArray.length; ++i) {
                if (!scheduleCalendarArray[i].isWorkingDay(date)) continue;
                return true;
            }
        } else {
            if (scheduleCalendar2 != null) {
                return scheduleCalendar2.isWorkingDay(date);
            }
            return scheduleCalendar.isWorkingDay(date);
        }
        return false;
    }

    protected void calculateDurationAndWorkFromDates(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        ITaskResource[] iTaskResourceArray;
        Date date = iTaskSchedule.getStartDate();
        Date date2 = iTaskSchedule.getFinishDate();
        int n = iTaskSchedule.getDurationFormat();
        if (n <= 0) {
            n = 7;
            iTaskSchedule.setDurationFormat(n);
        }
        if ((iTaskResourceArray = iTaskSchedule.getTaskResources()) == null || iTaskResourceArray.length == 0) {
            ScheduleCalendar scheduleCalendar3 = scheduleCalendar2;
            if (scheduleCalendar3 == null) {
                scheduleCalendar3 = scheduleCalendar;
            }
            double d = this.getDurationBetweenDates(date, date2, scheduleCalendar3);
            long l = (long)(d * 3600000.0);
            double d2 = this.getDurationInDurationFormat(l, n);
            iTaskSchedule.setDurationDisplay(d2);
            iTaskSchedule.setDurationInHours((double)l / 3600000.0);
            iTaskSchedule.setWorkInHours(d);
            int n2 = iTaskSchedule.getWorkFormat();
            double d3 = this.getDurationInDurationFormat(l, n2);
            iTaskSchedule.setWorkDisplay(d3);
        } else {
            Date date3 = (Date)date.clone();
            long l = 0L;
            double d = 0.0;
            double[] dArray = new double[scheduleCalendarArray.length];
            while (date3.before(date2)) {
                long[] lArray = new long[iTaskResourceArray.length];
                double d4 = 0.0;
                int n3 = 0;
                while (n3 < scheduleCalendarArray.length) {
                    long l2;
                    double d5;
                    if (this.isSameDay(date3, date2)) {
                        d5 = this.getDurationBetweenDates(date3, date2, scheduleCalendarArray[n3]);
                        l2 = CalendarUtil.hoursToMs(d5);
                    } else {
                        l2 = CalendarUtil.getNextWorkingMs(date3, scheduleCalendarArray[n3]);
                    }
                    lArray[n3] = l2;
                    if ((double)lArray[n3] > d4) {
                        d4 = lArray[n3];
                    }
                    d5 = (double)(lArray[n3] * (long)iTaskResourceArray[n3].getUnit()) / 100.0 / 3600000.0;
                    int n4 = n3++;
                    dArray[n4] = dArray[n4] + d5;
                    d += d5;
                }
                l = (long)((double)l + d4);
                this.setTime(date3, 0, 0, 0);
                this.addDays(date3, 1);
            }
            double d6 = this.getDurationInDurationFormat(l, n);
            iTaskSchedule.setDurationDisplay(d6);
            iTaskSchedule.setDurationInHours((double)l / 3600000.0);
            iTaskSchedule.setWorkInHours(d);
            int n5 = iTaskSchedule.getWorkFormat();
            long l3 = (long)(d * 3600000.0);
            double d7 = this.getDurationInDurationFormat(l3, n5);
            iTaskSchedule.setWorkDisplay(d7);
            for (int i = 0; i < dArray.length; ++i) {
                iTaskResourceArray[i].setWork(dArray[i] / 1000.0 / 3600.0);
            }
        }
    }

    public Date addDurationToGetEndDate(Date date, long l, ScheduleCalendar scheduleCalendar) {
        return this.addDuration(date, l, scheduleCalendar, false);
    }

    public Date addDurationToGetStartDate(Date date, long l, ScheduleCalendar scheduleCalendar) {
        return this.addDuration(date, l, scheduleCalendar, true);
    }

    private Date addDuration(Date date, long l, ScheduleCalendar scheduleCalendar, boolean bl) {
        if (l < 0L) {
            return this.removeDuration(date, -l, scheduleCalendar, bl);
        }
        date = (Date)date.clone();
        if (l == 0L) {
            return date;
        }
        ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
        if (workingTimeArray == null || workingTimeArray.length == 0) {
            date = CalendarUtil.getNextWorkingDay(date, scheduleCalendar);
            workingTimeArray = scheduleCalendar.getWorkingHours(date);
        }
        while (l > 0L) {
            for (int i = 0; i < workingTimeArray.length; ++i) {
                long l2;
                Date date2 = workingTimeArray[i].toTime.applyTime(date);
                if (date.after(date2)) continue;
                Date date3 = workingTimeArray[i].fromTime.applyTime(date);
                if (date.before(date3)) {
                    date = date3;
                }
                if ((l2 = date2.getTime() - date.getTime()) > l || !bl && l2 == l) {
                    return new Date(date.getTime() + l);
                }
                if ((l -= l2) != 0L) continue;
                if (i < workingTimeArray.length - 1) {
                    return workingTimeArray[i + 1].fromTime.applyTime(date);
                }
                return CalendarUtil.getNextWorkingDay(date, scheduleCalendar);
            }
            date = CalendarUtil.getNextWorkingDay(date, scheduleCalendar);
            workingTimeArray = scheduleCalendar.getWorkingHours(date);
        }
        return date;
    }

    public Date addDayDurationToDate(Date date, double d, double d2, ScheduleCalendar scheduleCalendar) {
        Date date2 = (Date)date.clone();
        while (d > 0.0) {
            if (d == 1.0) {
                TGTime tGTime = scheduleCalendar.getLastWorkingTime(date2);
                tGTime.setTimeToDate(date2);
                d -= 1.0;
                continue;
            }
            if (d > 1.0) {
                date2 = CalendarUtil.getNextWorkingDay(date2, scheduleCalendar);
                d -= 1.0;
                continue;
            }
            double d3 = d2 * d;
            double d4 = CalendarUtil.getWorkingHoursForDay(scheduleCalendar, date2.getDay() + 1);
            if (d3 < d4) {
                date2.setHours(date2.getHours() + (int)d3);
                d = 0.0;
                continue;
            }
            date2 = CalendarUtil.getNextWorkingDay(date2, scheduleCalendar);
            d = (d3 - d4) / d4;
        }
        return date2;
    }

    public Date removeDurationToGetStartDate(Date date, long l, ScheduleCalendar scheduleCalendar) {
        return this.removeDuration(date, l, scheduleCalendar, true);
    }

    public Date removeDurationToGetEndDate(Date date, long l, ScheduleCalendar scheduleCalendar) {
        return this.removeDuration(date, l, scheduleCalendar, false);
    }

    private Date removeDuration(Date date, long l, ScheduleCalendar scheduleCalendar, boolean bl) {
        date = (Date)date.clone();
        if (l == 0L) {
            return date;
        }
        ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendar.getWorkingHours(date);
        if (workingTimeArray == null || workingTimeArray.length == 0) {
            workingTimeArray = CalendarUtil.moveToPreviousWorkingDay(date, scheduleCalendar);
        } else {
            Date date2 = workingTimeArray[0].fromTime.applyTime(date);
            if (!date.after(date2)) {
                workingTimeArray = CalendarUtil.moveToPreviousWorkingDay(date, scheduleCalendar);
            }
        }
        block0: while (l > 0L) {
            for (int i = workingTimeArray.length - 1; i >= 0; --i) {
                long l2;
                Date date3;
                Date date4;
                if (workingTimeArray[i].toTime.hours == 24) {
                    date4 = (Date)date.clone();
                    date3 = (Date)date.clone();
                    date3.setDate(date3.getDate() - 1);
                    date3 = workingTimeArray[i].fromTime.applyTime(date3);
                } else {
                    date3 = workingTimeArray[i].fromTime.applyTime(date);
                    date4 = workingTimeArray[i].toTime.applyTime(date);
                }
                if (!date.after(date3)) continue;
                if (date.after(date4)) {
                    date = date4;
                }
                if ((l2 = date.getTime() - date3.getTime()) > l || bl && l2 == l) {
                    date = new Date(date.getTime() - l);
                    return date;
                }
                l -= l2;
                if (i > 0) {
                    date = workingTimeArray[i - 1].toTime.applyTime(date);
                    if (l != 0L) continue;
                    continue block0;
                }
                date = date3;
                workingTimeArray = CalendarUtil.moveToPreviousWorkingDay(date, scheduleCalendar);
            }
        }
        return date;
    }

    protected CalculateResult calculateEndDateAndOtherFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        CalculateResult calculateResult = this._calculateEndDateAndOtherFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        if (ENABLE_ASSERT) {
            Date date2 = calculateResult.date;
            CalculateResult calculateResult2 = this._calculateStartDateAndOtherFromWork(iTaskSummary, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            Date date3 = calculateResult2.date;
            if (!date3.equals(date)) {
                System.out.println("calculateEndDateFromWork warning:");
                System.out.println(date);
                System.out.println(date3);
                System.out.println();
            }
        }
        return calculateResult;
    }

    public Date calculateEndDateFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        CalculateResult calculateResult = this._calculateEndDateAndOtherFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        return calculateResult.date;
    }

    protected CalculateResult _calculateEndDateAndOtherFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        long l = (long)(iTaskSummary.getWorkInHours() * 3600.0 * 1000.0);
        ITaskResource[] iTaskResourceArray = iTaskSummary.getTaskResources();
        long[] lArray = new long[iTaskResourceArray.length];
        for (int i = iTaskResourceArray.length - 1; i >= 0 && iTaskResourceArray[i].getUnit() <= 0; --i) {
            if (i != 0) continue;
            iTaskResourceArray = new ITaskResource[]{};
        }
        Date date2 = (Date)date.clone();
        if (iTaskResourceArray.length > 0) {
            long[] lArray2 = new long[iTaskResourceArray.length];
            long[] lArray3 = new long[iTaskResourceArray.length];
            for (int i = 0; i < iTaskResourceArray.length; ++i) {
                lArray3[i] = iTaskResourceArray[i].getUnit();
            }
            long l2 = 0L;
            if (l == 0L) {
                Date date3 = date;
                return new CalculateResult(date3, l2, lArray);
            }
            while (l >= 0L) {
                int n;
                int n2;
                long l3;
                Object object;
                int n3;
                long l4 = 0L;
                long l5 = 0L;
                for (n3 = 0; n3 < scheduleCalendarArray.length; ++n3) {
                    lArray2[n3] = CalendarUtil.getNextWorkingMs(date2, scheduleCalendarArray[n3]);
                    if (lArray2[n3] > l5) {
                        l5 = lArray2[n3];
                    }
                    lArray2[n3] = lArray2[n3] * lArray3[n3] / 100L;
                    l4 += lArray2[n3];
                }
                if (l4 < l) {
                    for (n3 = 0; n3 < lArray2.length; ++n3) {
                        int n4 = n3;
                        lArray[n4] = lArray[n4] + lArray2[n3];
                    }
                    this.addDays(date2, 1);
                    if (date2.getTime() > CalendarUtil.MAX_DATE) {
                        throw new IllegalStateException("Unable to compute task end date");
                    }
                    this.setTime(date2, 0, 0, 0);
                    l -= l4;
                    l2 += l5;
                    continue;
                }
                if (l4 == l) {
                    Date date4 = null;
                    for (int i = 0; i < lArray2.length; ++i) {
                        int n5 = i;
                        lArray[n5] = lArray[n5] + lArray2[i];
                        Date date5 = this.addDurationToGetEndDate(date2, lArray2[i] * 100L / lArray3[i], scheduleCalendarArray[i]);
                        if (date4 != null && !date4.before(date5)) continue;
                        date4 = date5;
                    }
                    return new CalculateResult(date4, l2 += l5, lArray);
                }
                if (lArray2.length == 1 || !this.isWorkDistributionModeShortest()) {
                    Date date6 = null;
                    long l6 = 0L;
                    for (int i = 0; i < lArray2.length; ++i) {
                        if (lArray2[i] == 0L && i < lArray2.length - 1) continue;
                        long l7 = 0L;
                        if (l <= 0L) continue;
                        if (lArray2[i] >= l) {
                            l7 = l;
                            if (l * 100L / lArray3[i] > l6) {
                                l6 = l * 100L / lArray3[i];
                            }
                            l = 0L;
                        } else {
                            l7 = lArray2[i];
                            l -= lArray2[i];
                            if (lArray2[i] * 100L / lArray3[i] > l6) {
                                l6 = lArray2[i] * 100L / lArray3[i];
                            }
                        }
                        int n6 = i;
                        lArray[n6] = lArray[n6] + l7;
                        Date date7 = this.addDurationToGetEndDate(date2, l7 * 100L / lArray3[i], scheduleCalendarArray[i]);
                        if (date6 != null && !date6.before(date7)) continue;
                        date6 = date7;
                    }
                    return new CalculateResult(date6, l2 += l6, lArray);
                }
                ValueIntervals valueIntervals = new ValueIntervals();
                ScheduleCalendar.WorkingTime[][] workingTimeArrayArray = new ScheduleCalendar.WorkingTime[scheduleCalendarArray.length][];
                for (int i = 0; i < scheduleCalendarArray.length; ++i) {
                    ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendarArray[i].getWorkingHours(date2);
                    if (workingTimeArray == null) {
                        workingTimeArray = WORKING_TIMES_EMPTY_ARRAY;
                    }
                    workingTimeArrayArray[i] = workingTimeArray;
                    for (ScheduleCalendar.WorkingTime workingTime : workingTimeArray) {
                        object = new ValueInterval(workingTime.fromTime.toSeconds(), workingTime.toTime.toSeconds(), (int)lArray3[i]);
                        valueIntervals.addInterval((ValueInterval)object);
                    }
                }
                long l8 = CalendarUtil.getTimeInSeconds(date2);
                if (l8 > 0L) {
                    valueIntervals.resetInterval(new Interval(0L, l8));
                }
                long l9 = l;
                long l10 = 0L;
                object = valueIntervals.getIntervals().iterator();
                while (object.hasNext()) {
                    ValueInterval valueInterval;
                    ValueInterval valueInterval2 = valueInterval = (ValueInterval)object.next();
                    l3 = valueInterval2.end - valueInterval2.start;
                    if (l9 > (l3 = l3 * (long)valueInterval2.value * 10L)) {
                        l9 -= l3;
                        continue;
                    }
                    if (l9 == l3) {
                        l10 = valueInterval2.end;
                        break;
                    }
                    double d = (double)l9 / (double)l3;
                    l10 = (long)Math.ceil((double)valueInterval2.start + (double)(valueInterval2.end - valueInterval2.start) * d);
                    break;
                }
                if (l10 == 0L) {
                    l10 = valueIntervals.getLastIntervalEnd();
                    System.out.println("Illegal state during schedule of task " + iTaskSummary.getUid());
                }
                long l11 = 0L;
                for (n2 = 0; n2 < scheduleCalendarArray.length; ++n2) {
                    l3 = 0L;
                    ScheduleCalendar.WorkingTime[] workingTimeArray = workingTimeArrayArray[n2];
                    n = workingTimeArray.length;
                    for (int i = 0; i < n; ++i) {
                        ScheduleCalendar.WorkingTime workingTime = workingTimeArray[i];
                        long l12 = workingTime.fromTime.toSeconds();
                        long l13 = workingTime.toTime.toSeconds();
                        if (l13 <= l8) continue;
                        if (l12 >= l10) break;
                        if (l12 < l8) {
                            l12 = l8;
                        }
                        if (l13 > l10) {
                            l13 = l10;
                        }
                        l3 += l13 - l12;
                    }
                    long l14 = l3 * lArray3[n2] * 10L;
                    int n7 = n2;
                    lArray[n7] = lArray[n7] + l14;
                    l -= l14;
                    if (l3 <= l11) continue;
                    l11 = l3;
                }
                l2 += l11 * 1000L;
                if (l != 0L) {
                    n2 = l > 0L ? 1 : -1;
                    l = Math.abs(l);
                    int n8 = (int)(l / 1000L);
                    for (int i = 0; i < n8; ++i) {
                        int n9 = i % lArray.length;
                        lArray[n9] = lArray[n9] + (long)(n2 * 1000);
                    }
                }
                l = (long)(iTaskSummary.getWorkInHours() * 3600.0 * 1000.0);
                long l15 = 0L;
                for (long l16 : lArray) {
                    l15 += l16;
                }
                if (l15 != l && Math.abs(l15 - l) > 999L) {
                    System.out.println("Work not accurate: " + l15 + "/" + l);
                }
                int n10 = (int)l10 / 3600;
                int n11 = (int)l10 % 60;
                n = (int)(l10 / 60L) % 60;
                this.setTime(date2, n10, n, n11);
                return new CalculateResult(date2, l2, lArray);
            }
        } else {
            ScheduleCalendar scheduleCalendar3 = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
            Date date8 = this.addDurationToGetEndDate(date2, l, scheduleCalendar3);
            return new CalculateResult(date8, l, lArray);
        }
        return null;
    }

    protected CalculateResult calculateStartDateAndOtherFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        CalculateResult calculateResult = this._calculateStartDateAndOtherFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        if (ENABLE_ASSERT) {
            Date date2 = calculateResult.date;
            CalculateResult calculateResult2 = this._calculateEndDateAndOtherFromWork(iTaskSummary, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            Date date3 = calculateResult2.date;
            if (!date3.equals(date)) {
                System.out.println("calculateStartDateFromWork warning:");
                System.out.println(date);
                System.out.println(date3);
                System.out.println();
            }
        }
        return calculateResult;
    }

    public Date calculateStartDateFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        CalculateResult calculateResult = this._calculateStartDateAndOtherFromWork(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        return calculateResult.date;
    }

    protected CalculateResult _calculateStartDateAndOtherFromWork(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) {
        long l = (long)(iTaskSummary.getWorkInHours() * 3600.0 * 1000.0);
        ITaskResource[] iTaskResourceArray = iTaskSummary.getTaskResources();
        long[] lArray = new long[iTaskResourceArray.length];
        for (int i = iTaskResourceArray.length - 1; i >= 0 && iTaskResourceArray[i].getUnit() <= 0; --i) {
            if (i != 0) continue;
            iTaskResourceArray = new ITaskResource[]{};
        }
        Date date2 = (Date)date.clone();
        if (iTaskResourceArray.length > 0) {
            long[] lArray2 = new long[iTaskResourceArray.length];
            ITaskResource[] iTaskResourceArray2 = iTaskSummary.getTaskResources();
            long[] lArray3 = new long[iTaskResourceArray2.length];
            for (int i = 0; i < iTaskResourceArray2.length; ++i) {
                lArray3[i] = iTaskResourceArray2[i].getUnit();
            }
            long l2 = 0L;
            if (l == 0L) {
                Date date3 = date;
                return new CalculateResult(date3, l2, lArray);
            }
            while (l >= 0L) {
                int n;
                Object object;
                int n2;
                long l3 = 0L;
                long l4 = 0L;
                for (n2 = 0; n2 < scheduleCalendarArray.length; ++n2) {
                    lArray2[n2] = CalendarUtil.getPreviousWorkingMs(date2, scheduleCalendarArray[n2]);
                    if (lArray2[n2] > l4) {
                        l4 = lArray2[n2];
                    }
                    lArray2[n2] = lArray2[n2] * lArray3[n2] / 100L;
                    l3 += lArray2[n2];
                }
                if (l3 < l) {
                    for (n2 = 0; n2 < lArray2.length; ++n2) {
                        int n3 = n2;
                        lArray[n3] = lArray[n3] + lArray2[n2];
                    }
                    this.addDays(date2, -1);
                    if (date2.getTime() < CalendarUtil.MIN_DATE) {
                        throw new IllegalStateException("Unable to compute task start date");
                    }
                    this.setTime(date2, 23, 59, 59);
                    l -= l3;
                    l2 += l4;
                    continue;
                }
                if (l3 == l) {
                    Date date4 = null;
                    for (int i = 0; i < lArray2.length; ++i) {
                        int n4 = i;
                        lArray[n4] = lArray[n4] + lArray2[i];
                        Date date5 = this.removeDurationToGetStartDate(date2, lArray2[i], scheduleCalendarArray[i]);
                        if (date4 != null && !date4.after(date5)) continue;
                        date4 = date5;
                    }
                    return new CalculateResult(date4, l2 += l4, lArray);
                }
                if (lArray2.length == 1 || !this.isWorkDistributionModeShortest()) {
                    Date date6 = null;
                    long l5 = 0L;
                    for (int i = 0; i < lArray2.length; ++i) {
                        long l6 = 0L;
                        if (l <= 0L) continue;
                        if (lArray2[i] >= l) {
                            l6 = l;
                            if (l * 100L / lArray3[i] > l5) {
                                l5 = l * 100L / lArray3[i];
                            }
                            l = 0L;
                        } else {
                            l6 = lArray2[i];
                            l -= lArray2[i];
                            if (lArray2[i] * 100L / lArray3[i] > l5) {
                                l5 = lArray2[i] * 100L / lArray3[i];
                            }
                        }
                        int n5 = i;
                        lArray[n5] = lArray[n5] + l6;
                        Date date7 = this.removeDurationToGetStartDate(date2, l6 * 100L / lArray3[i], scheduleCalendarArray[i]);
                        if (date6 != null && !date6.after(date7)) continue;
                        date6 = date7;
                    }
                    return new CalculateResult(date6, l2 += l5, lArray);
                }
                ValueIntervals valueIntervals = new ValueIntervals();
                ScheduleCalendar.WorkingTime[][] workingTimeArrayArray = new ScheduleCalendar.WorkingTime[scheduleCalendarArray.length][];
                for (int i = 0; i < scheduleCalendarArray.length; ++i) {
                    ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendarArray[i].getWorkingHours(date2);
                    if (workingTimeArray == null) {
                        workingTimeArray = WORKING_TIMES_EMPTY_ARRAY;
                    }
                    workingTimeArrayArray[i] = workingTimeArray;
                    for (ScheduleCalendar.WorkingTime workingTime : workingTimeArray) {
                        object = new ValueInterval(workingTime.fromTime.toSeconds(), workingTime.toTime.toSeconds(), (int)lArray3[i]);
                        valueIntervals.addInterval((ValueInterval)object);
                    }
                }
                long l7 = CalendarUtil.getTimeInSeconds(date2);
                valueIntervals.resetInterval(new Interval(l7, 100000L));
                long l8 = l;
                long l9 = -1L;
                object = valueIntervals.getIntervals();
                for (int i = object.size() - 1; i >= 0; --i) {
                    ValueInterval valueInterval = (ValueInterval)object.get(i);
                    long l10 = valueInterval.end - valueInterval.start;
                    if (l8 > (l10 = l10 * (long)valueInterval.value * 10L)) {
                        l8 -= l10;
                        continue;
                    }
                    if (l8 == l10) {
                        l9 = valueInterval.start;
                        break;
                    }
                    double d = (double)l8 / (double)l10;
                    l9 = (long)Math.floor((double)valueInterval.end - (double)(valueInterval.end - valueInterval.start) * d);
                    break;
                }
                if (l9 < 0L) {
                    l9 = valueIntervals.getFirstIntervalStart();
                    System.out.println("Illegal state during schedule of task " + iTaskSummary.getUid());
                }
                long l11 = 0L;
                for (n = 0; n < scheduleCalendarArray.length; ++n) {
                    long l12 = 0L;
                    for (int i = workingTimeArrayArray[n].length - 1; i >= 0; --i) {
                        ScheduleCalendar.WorkingTime workingTime = workingTimeArrayArray[n][i];
                        long l13 = workingTime.fromTime.toSeconds();
                        long l14 = workingTime.toTime.toSeconds();
                        if (l14 <= l9) continue;
                        if (l13 >= l7) break;
                        if (l13 < l9) {
                            l13 = l9;
                        }
                        if (l14 > l7) {
                            l14 = l7;
                        }
                        l12 += l14 - l13;
                    }
                    long l15 = l12 * lArray3[n] * 10L;
                    int n6 = n;
                    lArray[n6] = lArray[n6] + l15;
                    l -= l15;
                    if (l12 <= l11) continue;
                    l11 = l12;
                }
                l2 += l11 * 1000L;
                if (l != 0L) {
                    n = l > 0L ? 1 : -1;
                    l = Math.abs(l);
                    int n7 = (int)(l / 1000L);
                    for (int i = 0; i < n7; ++i) {
                        int n8 = i % lArray.length;
                        lArray[n8] = lArray[n8] + (long)(n * 1000);
                    }
                }
                l = (long)(iTaskSummary.getWorkInHours() * 3600.0 * 1000.0);
                long l16 = 0L;
                for (long l13 : lArray) {
                    l16 += l13;
                }
                if (l16 != l && Math.abs(l16 - l) > 999L) {
                    System.out.println("Work not accurate: " + l16 + "/" + l);
                }
                int n9 = (int)l9 / 3600;
                int n10 = (int)l9 % 60;
                int n11 = (int)(l9 / 60L) % 60;
                this.setTime(date2, n9, n11, n10);
                return new CalculateResult(date2, l2, lArray);
            }
        } else {
            ScheduleCalendar scheduleCalendar3 = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
            Date date8 = l == 0L ? (Date)date2.clone() : this.removeDurationToGetStartDate(date2, l, scheduleCalendar3);
            return new CalculateResult(date8, l, lArray);
        }
        return null;
    }

    protected CalculateResult calculateEndDateAndOtherFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        CalculateResult calculateResult = this._calculateEndDateAndOtherFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        if (ENABLE_ASSERT) {
            Date date2 = calculateResult.date;
            CalculateResult calculateResult2 = this._calculateStartDateAndOtherFromDuration(iTaskSummary, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            Date date3 = calculateResult2.date;
            if (!date3.equals(date)) {
                System.out.println("calculateEndDateFromDuration warning:");
                System.out.println(date);
                System.out.println(date3);
                System.out.println();
            }
        }
        return calculateResult;
    }

    public Date calculateEndDateFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        CalculateResult calculateResult = this._calculateEndDateAndOtherFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        return calculateResult.date;
    }

    protected CalculateResult _calculateEndDateAndOtherFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        Object object;
        int n;
        long l = CalendarUtil.hoursToMs(iTaskSummary.getDurationInHours());
        if (iTaskSummary instanceof ITaskSchedule) {
            double d = ((ITaskSchedule)iTaskSummary).getDurationDisplay();
            n = ((ITaskSchedule)iTaskSummary).getDurationFormat();
            l = this.getDurationInMilliseconds(d, n);
        }
        ITaskResource[] iTaskResourceArray = iTaskSummary.getTaskResources();
        long[] lArray = new long[iTaskResourceArray.length];
        if (l == 0L) {
            return new CalculateResult(date, 0L, lArray);
        }
        for (n = iTaskResourceArray.length - 1; !(n < 0 || (object = iTaskResourceArray[n]).getUnit() > 0 || object.isWorkSpecified() && object.getWork() > 0.0); --n) {
            if (n != 0) continue;
            iTaskResourceArray = new ITaskResource[]{};
        }
        Date date2 = (Date)date.clone();
        if (iTaskResourceArray.length > 0) {
            int n2;
            object = new long[iTaskResourceArray.length];
            long[] lArray2 = new long[iTaskResourceArray.length];
            for (int i = 0; i < iTaskResourceArray.length; ++i) {
                lArray2[i] = iTaskResourceArray[i].isWorkSpecified() ? 100L : (long)iTaskResourceArray[i].getUnit();
            }
            Date date3 = null;
            while (true) {
                Object object2 = 0L;
                for (n2 = 0; n2 < scheduleCalendarArray.length; ++n2) {
                    object[n2] = CalendarUtil.getNextWorkingMs(date2, scheduleCalendarArray[n2]);
                    if (object[n2] > object2) {
                        object2 = object[n2];
                    }
                    object[n2] = object[n2] * lArray2[n2] / 100L;
                }
                if (l <= object2) break;
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    int n3 = n2;
                    lArray[n3] = lArray[n3] + object[n2];
                }
                l -= object2;
                this.addDays(date2, 1);
                if (date2.getTime() > CalendarUtil.MAX_DATE) {
                    throw new IllegalStateException("Unable to compute task end date");
                }
                this.setTime(date2, 0, 0, 0);
            }
            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                Object object3;
                Object object4;
                reference var21_22 = object[n2] * 100L / lArray2[n2];
                if (l < var21_22) {
                    object4 = l * lArray2[n2] / 100L;
                    object3 = l;
                } else {
                    object4 = object[n2];
                    object3 = var21_22;
                }
                int n4 = n2;
                lArray[n4] = lArray[n4] + object4;
                Date date4 = this.addDurationToGetEndDate(date2, (long)object3, scheduleCalendarArray[n2]);
                if (date3 != null && date3.getTime() >= date4.getTime()) continue;
                date3 = date4;
            }
            long l2 = 0L;
            for (int i = 0; i < lArray.length; ++i) {
                if (iTaskResourceArray[i].isWorkSpecified()) {
                    l2 += CalendarUtil.hoursToMs(iTaskResourceArray[i].getWork());
                    continue;
                }
                l2 += lArray[i];
            }
            return new CalculateResult(date3, l2, lArray);
        }
        object = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
        Date date5 = this.addDurationToGetEndDate(date2, l, (ScheduleCalendar)object);
        return new CalculateResult(date5, l, lArray);
    }

    protected CalculateResult calculateStartDateAndOtherFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        CalculateResult calculateResult = this._calculateStartDateAndOtherFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        if (ENABLE_ASSERT) {
            Date date2 = calculateResult.date;
            CalculateResult calculateResult2 = this._calculateEndDateAndOtherFromDuration(iTaskSummary, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            Date date3 = calculateResult2.date;
            if (!date3.equals(date)) {
                System.out.println("calculateStartDateFromDuration warning:");
                System.out.println(date);
                System.out.println(date3);
                System.out.println();
            }
        }
        return calculateResult;
    }

    public Date calculateStartDateFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        CalculateResult calculateResult = this._calculateStartDateAndOtherFromDuration(iTaskSummary, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        return calculateResult.date;
    }

    protected CalculateResult _calculateStartDateAndOtherFromDuration(ITaskSummary iTaskSummary, Date date, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        Object object;
        int n;
        Object object2 = CalendarUtil.hoursToMs(iTaskSummary.getDurationInHours());
        if (iTaskSummary instanceof ITaskSchedule) {
            double d = ((ITaskSchedule)iTaskSummary).getDurationDisplay();
            n = ((ITaskSchedule)iTaskSummary).getDurationFormat();
            object2 = this.getDurationInMilliseconds(d, n);
        }
        ITaskResource[] iTaskResourceArray = iTaskSummary.getTaskResources();
        long[] lArray = new long[iTaskResourceArray.length];
        for (n = iTaskResourceArray.length - 1; !(n < 0 || (object = iTaskResourceArray[n]).getUnit() > 0 || object.isWorkSpecified() && object.getWork() > 0.0); --n) {
            if (n != 0) continue;
            iTaskResourceArray = new ITaskResource[]{};
        }
        Date date2 = (Date)date.clone();
        if (iTaskResourceArray.length > 0) {
            object = new long[iTaskResourceArray.length];
            long[] lArray2 = new long[iTaskResourceArray.length];
            for (int i = 0; i < iTaskResourceArray.length; ++i) {
                lArray2[i] = iTaskResourceArray[i].isWorkSpecified() ? 100L : (long)iTaskResourceArray[i].getUnit();
            }
            Date date3 = null;
            long l = 0L;
            if (object2 == 0L) {
                date3 = date;
                return new CalculateResult(date3, l, lArray);
            }
            while (object2 > 0L) {
                int n2;
                Object object3 = 0L;
                for (n2 = 0; n2 < scheduleCalendarArray.length; ++n2) {
                    object[n2] = CalendarUtil.getPreviousWorkingMs(date2, scheduleCalendarArray[n2]);
                    if (object[n2] > object3) {
                        object3 = object[n2];
                    }
                    object[n2] = object[n2] * lArray2[n2] / 100L;
                }
                if (object2 > object3) {
                    for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                        int n3 = n2;
                        lArray[n3] = lArray[n3] + object[n2];
                    }
                    object2 -= object3;
                    this.addDays(date2, -1);
                    if (date2.getTime() < CalendarUtil.MIN_DATE) {
                        throw new IllegalStateException("Unable to compute task start date");
                    }
                    this.setTime(date2, 23, 59, 59);
                    continue;
                }
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    Object object4 = 0L;
                    object4 = object2 < object[n2] ? object2 : (Object)object[n2];
                    int n4 = n2;
                    lArray[n4] = lArray[n4] + object4;
                    Date date4 = this.removeDurationToGetStartDate(date2, (long)object4, scheduleCalendarArray[n2]);
                    if (date3 != null && !date3.after(date4)) continue;
                    date3 = date4;
                }
                object2 = 0L;
            }
            for (int i = 0; i < lArray.length; ++i) {
                if (iTaskResourceArray[i].isWorkSpecified()) {
                    l += CalendarUtil.hoursToMs(iTaskResourceArray[i].getWork());
                    continue;
                }
                l += lArray[i];
            }
            return new CalculateResult(date3, l, lArray);
        }
        object = null;
        object = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
        Date date5 = this.removeDurationToGetStartDate(date2, (long)object2, (ScheduleCalendar)object);
        return new CalculateResult(date5, (long)object2, lArray);
    }

    protected void calculateDurationAndUnits(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        Date date = iTaskSchedule.getStartDate();
        Date date2 = iTaskSchedule.getFinishDate();
        if (scheduleCalendarArray == null || scheduleCalendarArray.length == 0) {
            scheduleCalendarArray = new ScheduleCalendar[]{scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar};
        }
        date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray);
        iTaskSchedule.setStartDate(date);
        TGTime tGTime = new TGTime(date2);
        if (tGTime.hours == 0 && tGTime.minutes == 0) {
            date2 = new TGTime(23, 59, 59).applyTime(date2);
        }
        date2 = CalendarUtil.getLastEndDate(date2, scheduleCalendarArray);
        iTaskSchedule.setFinishDate(date2);
        double d = iTaskSchedule.getWorkInHours() * 3600.0 * 1000.0;
        ITaskResource[] iTaskResourceArray = iTaskSchedule.getTaskResources();
        int n = iTaskSchedule.getDurationFormat();
        if (n <= 0) {
            n = 7;
            iTaskSchedule.setDurationFormat(n);
        }
        if (iTaskResourceArray == null || iTaskResourceArray.length == 0) {
            ScheduleCalendar scheduleCalendar3 = scheduleCalendar2;
            if (scheduleCalendar3 == null) {
                scheduleCalendar3 = scheduleCalendar;
            }
            long l = CalendarUtil.getDurationInMs(date, date2, scheduleCalendar3);
            double d2 = this.getDurationInDurationFormat(l, n);
            iTaskSchedule.setDurationDisplay(d2);
            iTaskSchedule.setDurationInHours((double)l / 3600000.0);
        } else {
            Date date3 = (Date)date.clone();
            long l = 0L;
            ArrayList<long[]> arrayList = new ArrayList<long[]>();
            long l2 = 0L;
            long[] lArray = new long[iTaskResourceArray.length];
            while (date3.before(date2)) {
                long[] lArray2 = new long[iTaskResourceArray.length];
                long l3 = 0L;
                for (int i = 0; i < scheduleCalendarArray.length; ++i) {
                    lArray2[i] = CalendarUtil.getNextWorkingMs(date3, scheduleCalendarArray[i]);
                    if (lArray2[i] > l3) {
                        l3 = lArray2[i];
                    }
                    l += lArray2[i];
                }
                l2 += l3;
                arrayList.add(lArray2);
                this.addDays(date3, 1);
            }
            double d3 = this.getDurationInDurationFormat(l2, n);
            iTaskSchedule.setDurationDisplay(d3);
            iTaskSchedule.setDurationInHours((double)l2 / 3600000.0);
            double d4 = d / (double)l;
            date3 = (Date)date.clone();
            int n2 = 0;
            while (date3.before(date2)) {
                long[] lArray3 = (long[])arrayList.get(n2);
                int n3 = 0;
                while (n3 < iTaskResourceArray.length) {
                    double d5 = (double)lArray3[n3] * d4;
                    int n4 = n3++;
                    lArray[n4] = (long)((double)lArray[n4] + d5);
                }
                ++n2;
                this.addDays(date3, 1);
            }
            double d6 = 2.7777777777777776E-7;
            for (int i = 0; i < iTaskResourceArray.length; ++i) {
                int n5 = (int)Math.round(d4 * 100.0);
                iTaskResourceArray[i].setUnit(n5);
                double d7 = d6 * (double)lArray[i];
                iTaskResourceArray[i].setWork(d7);
            }
        }
    }

    protected void calculateStartDateAndDuration(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        int n;
        Date date = iTaskSchedule.getFinishDate();
        TGTime tGTime = new TGTime(date);
        if (tGTime.hours == 0 && tGTime.minutes == 0) {
            date = new TGTime(23, 59, 59).applyTime(date);
        }
        date = scheduleCalendarArray != null && scheduleCalendarArray.length > 0 ? CalendarUtil.getLastEndDate(date, scheduleCalendarArray) : CalendarUtil.getLastEndDate(date, new ScheduleCalendar[]{scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar});
        iTaskSchedule.setFinishDate(date);
        CalculateResult calculateResult = this.calculateStartDateAndOtherFromWork(iTaskSchedule, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
        Date date2 = calculateResult.date;
        long l = calculateResult.workOrDurationMs;
        ITaskResource[] iTaskResourceArray = iTaskSchedule.getTaskResources();
        for (n = 0; n < iTaskResourceArray.length; ++n) {
            iTaskResourceArray[n].setWork((double)calculateResult.usersWorkMs[n] / 1000.0 / 3600.0);
        }
        iTaskSchedule.setStartDate(date2);
        n = iTaskSchedule.getDurationFormat();
        if (n <= 0) {
            n = 7;
            iTaskSchedule.setDurationFormat(n);
        }
        double d = this.getDurationInDurationFormat(l, n);
        iTaskSchedule.setDurationDisplay(d);
        iTaskSchedule.setDurationInHours((double)l / 3600000.0);
    }

    public double getDurationInDurationFormat(long l, int n) throws Exception {
        if (l == 0L) {
            return 0.0;
        }
        switch (n) {
            case 3: 
            case 4: {
                return (double)l / 60.0 / 1000.0;
            }
            case 5: 
            case 6: {
                return (double)l / 60.0 / 60.0 / 1000.0;
            }
            case 7: {
                double d = this.getHoursPerDay();
                return (double)l / d / 60.0 / 60.0 / 1000.0;
            }
            case 8: {
                return (double)l / 24.0 / 60.0 / 60.0 / 1000.0;
            }
            case 9: {
                double d = this.getHoursPerWeek();
                return (double)l / d / 60.0 / 60.0 / 1000.0;
            }
            case 10: {
                return (double)l / 7.0 / 24.0 / 60.0 / 60.0 / 1000.0;
            }
            case 11: {
                double d = this.getHoursPerMonth();
                return (double)l / d / 60.0 / 60.0 / 1000.0;
            }
            case 12: {
                return (double)l / 30.0 / 24.0 / 60.0 / 60.0 / 1000.0;
            }
        }
        return (double)l / 60.0 / 60.0 / 1000.0;
    }

    public double getDurationInHours(double d, int n) throws Exception {
        if (d == 0.0) {
            return 0.0;
        }
        switch (n) {
            case 3: 
            case 4: {
                return d / 60.0;
            }
            case 5: 
            case 6: {
                return d;
            }
            case 7: {
                double d2 = this.getHoursPerDay();
                return d * d2;
            }
            case 8: {
                return d * 24.0;
            }
            case 9: {
                double d3 = this.getHoursPerWeek();
                return d * d3;
            }
            case 10: {
                return d * 7.0 * 24.0;
            }
            case 11: {
                double d4 = this.getHoursPerMonth();
                return d * d4;
            }
            case 12: {
                return (long)(d * 30.0 * 24.0);
            }
        }
        return d;
    }

    public long getDurationInMilliseconds(double d, int n) throws Exception {
        if (d == 0.0) {
            return 0L;
        }
        switch (n) {
            case 3: 
            case 4: {
                return Math.round(d * 60.0) * 1000L;
            }
            case 5: 
            case 6: {
                return Math.round(d * 3600.0) * 1000L;
            }
            case 7: {
                double d2 = this.getHoursPerDay();
                return Math.round(d * d2 * 3600.0) * 1000L;
            }
            case 8: {
                return Math.round(d * 24.0 * 3600.0) * 1000L;
            }
            case 9: {
                double d3 = this.getHoursPerWeek();
                return Math.round(d * d3 * 3600.0) * 1000L;
            }
            case 10: {
                return Math.round(d * 7.0 * 24.0 * 3600.0) * 1000L;
            }
            case 11: {
                double d4 = this.getHoursPerMonth();
                return Math.round(d * d4 * 3600.0) * 1000L;
            }
            case 12: {
                return Math.round(d * 30.0 * 24.0 * 3600.0) * 1000L;
            }
        }
        return Math.round(d * 3600.0) * 1000L;
    }

    private Date setLastTimeInDate(Date date, ScheduleCalendar[] scheduleCalendarArray) {
        Date date2 = null;
        for (int i = 0; i < scheduleCalendarArray.length; ++i) {
            Date date3 = (Date)date.clone();
            TGTime tGTime = scheduleCalendarArray[i].getLastWorkingTime(date3);
            if (tGTime == null) {
                date3 = CalendarUtil.getNextWorkingDay(date3, scheduleCalendarArray[i]);
                tGTime = scheduleCalendarArray[i].getLastWorkingTime(date3);
            }
            tGTime.setTimeToDate(date3);
            if (date2 != null && !date3.before(date2)) continue;
            date2 = date3;
        }
        return date2;
    }

    private Date setFirstTimeInDate(Date date, ScheduleCalendar[] scheduleCalendarArray) {
        Date date2 = null;
        for (int i = 0; i < scheduleCalendarArray.length; ++i) {
            Date date3 = (Date)date.clone();
            TGTime tGTime = scheduleCalendarArray[i].getFirstWorkingTime(date3);
            if (tGTime == null) {
                date3 = CalendarUtil.getNextWorkingDay(date3, scheduleCalendarArray[i]);
                tGTime = scheduleCalendarArray[i].getFirstWorkingTime(date3);
            }
            tGTime.setTimeToDate(date3);
            if (date2 != null && !date3.before(date2)) continue;
            date2 = date3;
        }
        return date2;
    }

    protected void setTaskDatesFromWork(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        this.setTaskDates(true, iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
    }

    protected void setTaskDatesFromDuration(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        this.setTaskDates(false, iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
    }

    protected void setTaskDates(boolean bl, ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        double d;
        CalculateResult calculateResult;
        Object object;
        ScheduleCalendar[] scheduleCalendarArray2 = scheduleCalendarArray != null && scheduleCalendarArray.length > 0 ? scheduleCalendarArray : (scheduleCalendar2 != null ? new ScheduleCalendar[]{scheduleCalendar2} : new ScheduleCalendar[]{scheduleCalendar});
        boolean bl2 = bl && iTaskSchedule.getWorkInHours() == 0.0 || !bl && iTaskSchedule.getDurationInHours() == 0.0;
        Date date = null;
        Date date2 = null;
        IPredecessor[] iPredecessorArray = iTaskSchedule.getPredecessors();
        boolean bl3 = iPredecessorArray.length == 0 ? true : iTaskSchedule.isForceStartDate();
        if (!bl3) {
            for (int i = 0; i < iPredecessorArray.length; ++i) {
                Date date3;
                object = iPredecessorArray[i].getId();
                String string = Predecessor.predecessorTypeAsString(iPredecessorArray[i].getType());
                if (string.length() < 2) {
                    string = "FS";
                }
                if ((date3 = string.charAt(0) == 'S' ? this.getTaskStartDateTime((String)object) : this.getTaskEndDateTime((String)object)) == null) {
                    System.out.println("WARNING: predecessor not found for task " + iTaskSchedule.getName() + ": " + (String)object);
                    continue;
                }
                double d2 = iPredecessorArray[i].getLag();
                long l = 0L;
                if (d2 != 0.0) {
                    int n = iPredecessorArray[i].getLagFormat();
                    if (n != 19) {
                        l = this.getDurationInMilliseconds(d2, n);
                    } else {
                        double d3 = this.getTaskDuration((String)object);
                        l = (long)(d3 * d2 * 3600.0 * 10.0);
                    }
                    if (ScheduleCst.isElapsedDurationFormat(n)) {
                        date3 = new Date(date3.getTime() + l);
                    } else {
                        ScheduleCalendar scheduleCalendar3 = scheduleCalendar2 != null ? scheduleCalendar2 : scheduleCalendar;
                        date3 = l < 0L ? this.removeDuration(date3, -l, scheduleCalendar3, true) : this.addDuration(date3, l, scheduleCalendar3, false);
                    }
                }
                if (string.charAt(1) == 'F') {
                    if (date2 != null && !date3.after(date2)) continue;
                    date2 = date3;
                    continue;
                }
                if (date != null && !date3.after(date)) continue;
                date = date3;
            }
        }
        if (bl3 || date == null && date2 == null) {
            date = iTaskSchedule.getStartDate();
            if (date == null) {
                date = this.getProjectStartDate();
            }
            iTaskSchedule.setForceStartDate(false);
        }
        Date date4 = null;
        object = null;
        long l = 0L;
        long[] lArray = null;
        if (date2 != null) {
            date2 = CalendarUtil.getLastEndDate(date2, scheduleCalendarArray2, bl2);
            calculateResult = bl ? this.calculateStartDateAndOtherFromWork(iTaskSchedule, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray) : this.calculateStartDateAndOtherFromDuration(iTaskSchedule, date2, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            object = date2;
            date4 = calculateResult.date;
            l = calculateResult.workOrDurationMs;
            lArray = calculateResult.usersWorkMs;
        }
        if (date != null && (date4 == null || date.after(date4))) {
            date = CalendarUtil.getFirstStartDate(date, scheduleCalendarArray2, bl2);
            calculateResult = bl ? this.calculateEndDateAndOtherFromWork(iTaskSchedule, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray) : this.calculateEndDateAndOtherFromDuration(iTaskSchedule, date, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            date4 = date;
            object = calculateResult.date;
            l = calculateResult.workOrDurationMs;
            lArray = calculateResult.usersWorkMs;
        }
        iTaskSchedule.setStartDate(date4);
        iTaskSchedule.setFinishDate((Date)object);
        int n = iTaskSchedule.getDurationFormat();
        if (n <= 0) {
            n = 7;
            iTaskSchedule.setDurationFormat(n);
        }
        if (bl) {
            d = this.getDurationInDurationFormat(l, n);
            iTaskSchedule.setDurationDisplay(d);
            iTaskSchedule.setDurationInHours((double)l / 3600000.0);
        } else {
            d = iTaskSchedule.getDurationDisplay();
            double d4 = this.getDurationInHours(d, n);
            iTaskSchedule.setDurationInHours(d4);
            double d5 = (double)l / 1000.0 / 3600.0;
            iTaskSchedule.setWorkInHours(d5);
            int n2 = iTaskSchedule.getWorkFormat();
            double d6 = this.getDurationInDurationFormat(l, n2);
            iTaskSchedule.setWorkDisplay(d6);
        }
        ITaskResource[] iTaskResourceArray = iTaskSchedule.getTaskResources();
        for (int i = 0; i < iTaskResourceArray.length; ++i) {
            double d7 = (double)lArray[i] / 1000.0 / 3600.0;
            if (iTaskResourceArray[i].isWorkSpecified()) {
                if (d7 == 0.0) {
                    iTaskResourceArray[i].setUnit(100);
                    iTaskResourceArray[i].setWork(0.0);
                    iTaskResourceArray[i].setWorkSpecified(false);
                    continue;
                }
                int n3 = (int)(iTaskResourceArray[i].getWork() / d7 * 100.0);
                iTaskResourceArray[i].setUnit(n3);
                continue;
            }
            iTaskResourceArray[i].setWork(d7);
        }
    }

    public double getDurationBetweenDates(Date date, Date date2, ScheduleCalendar scheduleCalendar) {
        return CalendarUtil.msToHours(CalendarUtil.getDurationInMs(date, date2, scheduleCalendar));
    }

    public double getWorkValue(ITaskSchedule iTaskSchedule) throws Exception {
        double d = iTaskSchedule.getDurationDisplay();
        long l = iTaskSchedule.getDurationFormat();
        double d2 = this.getDurationInHours(d, (int)l);
        double d3 = 0.0;
        ITaskResource[] iTaskResourceArray = iTaskSchedule.getTaskResources();
        if (iTaskResourceArray == null || iTaskResourceArray.length == 0) {
            return d2;
        }
        for (int i = 0; i < iTaskResourceArray.length; ++i) {
            d3 += (double)iTaskResourceArray[i].getUnit();
        }
        return d2 * (d3 /= 100.0);
    }

    public void calculateTaskComputedValues(ITaskSchedule iTaskSchedule, ScheduleCalendar scheduleCalendar, ScheduleCalendar scheduleCalendar2, ScheduleCalendar[] scheduleCalendarArray) throws Exception {
        int n;
        try {
            n = iTaskSchedule.getSchedulingMode();
        }
        catch (Exception exception) {
            System.out.println("Unable to read scheduling mode - " + exception.getMessage());
            exception.printStackTrace();
            n = 0;
        }
        if (!this.canSpecifyUsersWork(iTaskSchedule)) {
            for (ITaskResource iTaskResource : iTaskSchedule.getTaskResources()) {
                if (!iTaskResource.isWorkSpecified()) continue;
                iTaskResource.setWorkSpecified(false);
            }
        }
        switch (n) {
            case 0: {
                this.setTaskDatesFromWork(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                break;
            }
            case 1: {
                this.setTaskDatesFromDuration(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                break;
            }
            case 2: {
                this.calculateDurationAndUnits(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
                break;
            }
            case 3: {
                this.calculateStartDateAndDuration(iTaskSchedule, scheduleCalendar, scheduleCalendar2, scheduleCalendarArray);
            }
        }
    }

    public boolean mustApplyAutomaticRescheduleOnTask(ITaskSchedule iTaskSchedule) {
        if (iTaskSchedule.isSkipAutoReschedule()) {
            return false;
        }
        Date date = iTaskSchedule.getActualFinishDate();
        if (date == null) {
            return false;
        }
        if (!this.isAutomaticRescheduleProject()) {
            return false;
        }
        Date date2 = iTaskSchedule.getFinishDate();
        if (date2 == null) {
            return true;
        }
        if (this.isSameDay(date, date2)) {
            date = date2;
            iTaskSchedule.setActualFinishDate(date2);
            return false;
        }
        int n = iTaskSchedule.getSchedulingMode();
        return n == 0 || n == 1;
    }

    public boolean canSpecifyUsersWork(ITaskSchedule iTaskSchedule) {
        return iTaskSchedule.getSchedulingMode() == 1 && iTaskSchedule.getDurationInHours() > 0.0;
    }

    public long[] computeUsersWorkMs(Date date, Date date2, int[] nArray, ScheduleCalendar[] scheduleCalendarArray, long l) {
        if (nArray == null || nArray.length == 0) {
            return new long[0];
        }
        if (nArray.length != scheduleCalendarArray.length) {
            throw new IllegalArgumentException("units and calendars do not have the same size: " + nArray.length + "/" + scheduleCalendarArray.length);
        }
        if (!date2.after(date) || l == 0L) {
            return new long[nArray.length];
        }
        long l2 = 0L;
        long[] lArray = new long[nArray.length];
        Date date3 = (Date)date.clone();
        while (date3.before(date2)) {
            long l3 = this.isSameDay(date3, date2) ? AbstractScheduleComputation.getTimeInSeconds(date2) : Long.MAX_VALUE;
            int n = 0;
            while (n < scheduleCalendarArray.length) {
                long l4;
                long l5 = 0L;
                ScheduleCalendar.WorkingTime[] workingTimeArray = scheduleCalendarArray[n].getWorkingHours(date3);
                if (workingTimeArray != null && workingTimeArray.length > 0) {
                    l4 = AbstractScheduleComputation.getTimeInSeconds(date3);
                    for (int i = 0; i < workingTimeArray.length; ++i) {
                        long l6 = workingTimeArray[i].fromTime.toSeconds();
                        long l7 = workingTimeArray[i].toTime.toSeconds();
                        l6 = Math.max(l4, l6);
                        if ((l7 = Math.min(l3, l7)) - l6 <= 0L) continue;
                        l5 += (l7 - l6) * 1000L;
                    }
                }
                l4 = l5 * (long)nArray[n] / 100L;
                if (l >= 0L && (l2 += l4) >= l) {
                    l4 = l4 + l2 - l;
                    int n2 = n;
                    lArray[n2] = lArray[n2] + l4;
                    return lArray;
                }
                int n3 = n++;
                lArray[n3] = lArray[n3] + l4;
            }
            this.addDays(date3, 1);
            if (date3.getTime() > CalendarUtil.MAX_DATE) {
                throw new IllegalStateException("Unable to compute task end date");
            }
            this.setTime(date3, 0, 0, 0);
        }
        return lArray;
    }

    protected long resetMillis(long l) {
        long l2 = l % 1000L;
        return l - l2;
    }

    public boolean isSameDay(Date date, Date date2) {
        return CalendarUtil.isSameDay(date, date2);
    }

    private Date setTime(Date date, int n, int n2, int n3) {
        date.setHours(n);
        date.setMinutes(n2);
        date.setSeconds(n3);
        return date;
    }

    private static long getTimeInSeconds(Date date) {
        return CalendarUtil.getTimeInSeconds(date);
    }

    private void addDays(Date date, int n) {
        date.setDate(date.getDate() + n);
    }

    private int getDay(Date date) {
        return date.getDay();
    }

    protected abstract boolean isWorkDistributionModeShortest();

    public abstract Date getProjectStartDate() throws Exception;

    public abstract double getHoursPerDay() throws Exception;

    public abstract double getHoursPerWeek() throws Exception;

    public abstract double getHoursPerMonth() throws Exception;

    protected abstract double getTaskDuration(String var1) throws Exception;

    protected abstract Date getTaskEndDateTime(String var1) throws Exception;

    protected abstract Date getTaskStartDateTime(String var1) throws Exception;

    public abstract boolean isAutomaticRescheduleProject();

    protected static class CalculateResult {
        public Date date;
        public long workOrDurationMs;
        public long[] usersWorkMs;

        CalculateResult(Date date, long l, long[] lArray) {
            this.date = date;
            this.workOrDurationMs = l;
            this.usersWorkMs = lArray;
        }
    }
}

