/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.financial;

import com.flowbuilder.util.TString;
import com.triloggroup.pe.timesheet.ItemResourceData;
import com.triloggroup.pe.timesheet.ItemTimeSheetData;
import com.triloggroup.pe.timesheet.TimeSheetEntry;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.ITaskResource;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.project.schedule.SubprojectOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class FinancialComputation {
    private double fixedResourceCost;
    private double actualFixedResourceCost;
    private HashSet<String> fixedCostDns = new HashSet();
    private HashSet<String> actualFixedCostDns = new HashSet();
    private boolean hasSubproject = false;
    private boolean hasFinancialRollupSubproject = false;

    public void process() {
        this.fixedResourceCost = 0.0;
        this.actualFixedResourceCost = 0.0;
        this.fixedCostDns.clear();
        this.actualFixedCostDns.clear();
        IFinancialWBS iFinancialWBS = this.getRoot();
        if (iFinancialWBS != null) {
            this.processWBS(iFinancialWBS);
            iFinancialWBS.setProjectedResourceCost(iFinancialWBS.getProjectedResourceCost() + this.fixedResourceCost);
            iFinancialWBS.setInitiallyPlannedResourceCost(iFinancialWBS.getInitiallyPlannedResourceCost() + this.fixedResourceCost);
            iFinancialWBS.setActualResourceCost(iFinancialWBS.getActualResourceCost() + this.actualFixedResourceCost);
        }
    }

    private boolean processWBS(IFinancialWBS iFinancialWBS) {
        if (iFinancialWBS.isSubProject()) {
            this.hasSubproject = true;
            if (this.isRollupWBSCost(iFinancialWBS)) {
                this.hasFinancialRollupSubproject = true;
                return this.processSubproject(iFinancialWBS);
            }
            this.processSubprojectNoRollup(iFinancialWBS);
            return false;
        }
        return this.processWBSIgnoreSubproject(iFinancialWBS);
    }

    protected boolean processWBSIgnoreSubproject(IFinancialWBS iFinancialWBS) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl = false;
        Iterator<? extends IFinancialNode> iterator = iFinancialWBS.allChildrenIterator();
        while (iterator.hasNext()) {
            boolean bl2;
            IFinancialNode iFinancialNode = iterator.next();
            if (iFinancialNode instanceof IFinancialWBS) {
                IFinancialWBS iFinancialWBS2 = (IFinancialWBS)iFinancialNode;
                bl2 = this.isRollupWBSCost(iFinancialWBS2);
                bl |= this.processWBS(iFinancialWBS2);
                if (bl2) {
                    d3 += iFinancialWBS2.getProjectedAdditionalCost();
                    d4 += iFinancialWBS2.getInitiallyPlannedAdditionalCost();
                }
            } else {
                bl2 = true;
                bl |= this.processTask((IFinancialTask)iFinancialNode);
                d3 += Math.max(iFinancialNode.getAdditionalCost(), iFinancialNode.getActualAdditionalCost());
                d4 += iFinancialNode.getAdditionalCost();
            }
            if (!bl2) continue;
            d2 += iFinancialNode.getActualAdditionalCost();
            d6 += iFinancialNode.getProjectedResourceCost();
            d5 += iFinancialNode.getActualResourceCost();
            d7 += iFinancialNode.getInitiallyPlannedResourceCost();
        }
        if (iFinancialWBS.getSpecifiedActualAdditionalCost() != null) {
            d = iFinancialWBS.getSpecifiedActualAdditionalCost();
        } else if (bl) {
            d = iFinancialWBS.getAdditionalCost();
        }
        iFinancialWBS.setNodeActualAdditionalCost(d);
        iFinancialWBS.setActualAdditionalCost(d2 += d);
        d3 = iFinancialWBS.getSpecifiedActualAdditionalCost() != null && iFinancialWBS.getSpecifiedActualAdditionalCost() > iFinancialWBS.getAdditionalCost() ? (d3 += iFinancialWBS.getSpecifiedActualAdditionalCost().doubleValue()) : (d3 += iFinancialWBS.getAdditionalCost());
        iFinancialWBS.setProjectedAdditionalCost(d3);
        iFinancialWBS.setInitiallyPlannedAdditionalCost(d4);
        iFinancialWBS.setActualResourceCost(d5);
        iFinancialWBS.setProjectedResourceCost(d6);
        iFinancialWBS.setInitiallyPlannedResourceCost(d7);
        return bl;
    }

    protected abstract boolean processSubproject(IFinancialWBS var1);

    protected void processSubprojectNoRollup(IFinancialWBS iFinancialWBS) {
    }

    private boolean processTask(IFinancialTask iFinancialTask) {
        double d = iFinancialTask.getSpecifiedActualAdditionalCost() != null ? iFinancialTask.getSpecifiedActualAdditionalCost() : (iFinancialTask.isPending() ? 0.0 : iFinancialTask.getAdditionalCost());
        iFinancialTask.setActualAdditionalCost(d);
        double d2 = this.computeResourceCostBasedOnAssignments(iFinancialTask);
        double d3 = this.computePerUseResourceCost(iFinancialTask);
        boolean bl = this.isActualWorkComputationModeTimesheet();
        double d4 = bl ? this.computeResourceCostBasedOnTimesheets(iFinancialTask) : 0.0;
        double d5 = this.computeActualResourceCost(iFinancialTask, d2, d3, bl, d4);
        double d6 = this.computeProjectedResourceCost(iFinancialTask, d2, d3, bl, d4);
        iFinancialTask.setActualResourceCost(d5);
        iFinancialTask.setProjectedResourceCost(d6);
        iFinancialTask.setInitiallyPlannedResourceCost(d2 + d3);
        return !iFinancialTask.isPending();
    }

    private double computeProjectedResourceCost(IFinancialTask iFinancialTask, double d, double d2, boolean bl, double d3) {
        double d4;
        double d5 = iFinancialTask.getWorkInHours();
        if (iFinancialTask.isDone()) {
            if (bl) {
                d4 = d3;
            } else {
                double d6;
                d4 = d;
                if (d4 != 0.0 && (d6 = iFinancialTask.getSpecifiedActualWork()) >= 0.0) {
                    d4 = d4 * d6 / d5;
                }
            }
        } else if (bl) {
            d4 = d;
            if (d4 != 0.0) {
                double d7 = iFinancialTask.getSpecifiedRemainingWork();
                if (d7 < 0.0) {
                    d7 = iFinancialTask.getEstimatedRemainingWork();
                }
                d4 *= d7 / d5;
            }
            d4 += d3;
        } else {
            d4 = d;
            if (d4 != 0.0) {
                double d8 = iFinancialTask.getSpecifiedActualWork();
                double d9 = iFinancialTask.getSpecifiedRemainingWork();
                if (d8 >= 0.0 || d9 >= 0.0) {
                    if (d8 < 0.0) {
                        d8 = this.getEstimatedActualWork(iFinancialTask);
                    }
                    if (d9 < 0.0) {
                        d9 = iFinancialTask.getEstimatedRemainingWork();
                    }
                    d4 *= (d8 + d9) / d5;
                }
            }
        }
        return d4 += d2;
    }

    private double computeActualResourceCost(IFinancialTask iFinancialTask, double d, double d2, boolean bl, double d3) {
        double d4;
        if (bl) {
            d4 = d3;
        } else {
            if (iFinancialTask.getTaskResources().length == 0) {
                return 0.0;
            }
            d4 = d;
            if (d4 != 0.0) {
                double d5 = iFinancialTask.getSpecifiedActualWork();
                if (d5 < 0.0) {
                    d5 = this.getEstimatedActualWork(iFinancialTask);
                }
                double d6 = iFinancialTask.getWorkInHours();
                d4 = d4 * d5 / d6;
            }
        }
        if (!iFinancialTask.isPending()) {
            d4 += d2;
        }
        return d4;
    }

    private double computeResourceCostBasedOnTimesheets(IFinancialTask iFinancialTask) {
        return this.computeResourceCostBasedOnTimesheets(iFinancialTask, null);
    }

    protected double computeResourceCostBasedOnTimesheets(IFinancialTask iFinancialTask, String string) {
        ItemTimeSheetData itemTimeSheetData = this.getTimeSheetData(iFinancialTask);
        if (itemTimeSheetData == null) {
            return 0.0;
        }
        if (string != null) {
            ItemResourceData itemResourceData = itemTimeSheetData.getResourceData(string);
            return this.getTimesheetCost(string, itemResourceData);
        }
        double d = 0.0;
        HashMap<String, ItemResourceData> hashMap = itemTimeSheetData.getResourceData();
        if (hashMap != null) {
            for (Map.Entry<String, ItemResourceData> entry : hashMap.entrySet()) {
                d += this.getTimesheetCost(entry.getKey(), entry.getValue());
            }
        }
        return d;
    }

    private double getTimesheetCost(String string, ItemResourceData itemResourceData) {
        if (itemResourceData == null || itemResourceData.getResourceHours() == 0.0) {
            return 0.0;
        }
        CostRates costRates = this.getCostRates(string);
        if (costRates == null) {
            return 0.0;
        }
        double d = 0.0;
        for (TimeSheetEntry timeSheetEntry : itemResourceData.getEntries()) {
            ICostRate iCostRate = costRates.getCostRate(timeSheetEntry.getDate());
            d += this.getCost(iCostRate, timeSheetEntry.getEntryHours());
        }
        return d;
    }

    protected double computeResourceCostBasedOnAssignments(IFinancialTask iFinancialTask) {
        if (iFinancialTask.getWorkInHours() == 0.0) {
            return 0.0;
        }
        ITaskResource[] iTaskResourceArray = iFinancialTask.getTaskResources();
        if (iTaskResourceArray.length == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < iTaskResourceArray.length; ++i) {
            d += this.getCost(iTaskResourceArray[i], iFinancialTask);
        }
        return d;
    }

    private double computePerUseResourceCost(IFinancialTask iFinancialTask) {
        ITaskResource[] iTaskResourceArray = iFinancialTask.getTaskResources();
        double d = 0.0;
        for (int i = 0; i < iTaskResourceArray.length; ++i) {
            CostRates costRates = this.getCostRates(iTaskResourceArray[i]);
            if (costRates == null) continue;
            ICostRate iCostRate = costRates.getCostRate(iFinancialTask.getStartDate());
            if (iCostRate != null && this.isPerUse(iCostRate)) {
                d += iCostRate.getCost();
            }
            if ((iCostRate = costRates.getCostRate(this.getProjectStartDate())) == null || !this.isFixed(iCostRate)) continue;
            String string = iTaskResourceArray[i].getDn();
            if (this.fixedCostDns.add(string)) {
                this.fixedResourceCost += iCostRate.getCost();
            }
            if (iFinancialTask.isPending() || !this.actualFixedCostDns.add(string)) continue;
            this.actualFixedResourceCost += iCostRate.getCost();
        }
        return d;
    }

    protected CostRates getCostRates(ITaskResource iTaskResource) {
        return this.getCostRates(iTaskResource.getDn());
    }

    protected abstract CostRates getCostRates(String var1);

    protected double getCost(ITaskResource iTaskResource, IFinancialTask iFinancialTask) {
        int n;
        CostRates costRates = this.getCostRates(iTaskResource);
        if (costRates == null) {
            return 0.0;
        }
        VariableCost[] variableCostArray = costRates.variableCosts;
        if (variableCostArray == null || variableCostArray.length == 0) {
            return this.getCost(costRates.defaultCost, iTaskResource.getWork());
        }
        Date date = iFinancialTask.getStartDate();
        Date date2 = iFinancialTask.getFinishDate();
        VariableCost variableCost = variableCostArray[0];
        if (date2.before(variableCost.from)) {
            return this.getCost(costRates.defaultCost, iTaskResource.getWork());
        }
        VariableCost variableCost2 = variableCostArray[variableCostArray.length - 1];
        if (date.after(variableCost2.from)) {
            return this.getCost(variableCost2.costRate, iTaskResource.getWork());
        }
        for (n = -1; n < variableCostArray.length - 1; ++n) {
            if (!date.before(variableCostArray[n + 1].from)) continue;
            if (!date2.before(variableCostArray[n + 1].from)) break;
            return this.getCost(variableCostArray[n].costRate, iTaskResource.getWork());
        }
        String string = null;
        if (!iFinancialTask.isIgnoreResourcesCalendar()) {
            string = this.getResourceCalendarId(iTaskResource);
        }
        if (TString.isEmpty(string) && TString.isEmpty(string = iFinancialTask.getCalendarId())) {
            string = this.getProjectCalendarId();
        }
        ScheduleCalendar scheduleCalendar = this.getCalendar(string);
        double d = iTaskResource.getWork();
        double d2 = 0.0;
        int n2 = iTaskResource.getUnit();
        if (iFinancialTask.getSchedulingMode() == 3) {
            Date date3 = iFinancialTask.getFinishDate();
            for (n = variableCostArray.length - 1; n > 0 && !date3.after(variableCostArray[n].from); --n) {
            }
            while (n >= 0 && d > 0.0) {
                long l = CalendarUtil.getDurationInMs(variableCostArray[n].from, date3, scheduleCalendar);
                if (l > 0L) {
                    if (n2 != 100) {
                        l = l * (long)n2 / 100L;
                    }
                    double d3 = CalendarUtil.msToHours(l);
                    d3 = Math.min(d3, d);
                    ICostRate iCostRate = n < 0 ? costRates.defaultCost : variableCostArray[n].costRate;
                    d2 += this.getCost(iCostRate, d3);
                    d -= d3;
                }
                date3 = variableCostArray[n].from;
                --n;
            }
            if (d > 0.0) {
                if (n != -1) {
                    System.out.println("FinancialComputation: assertion 01 failed");
                }
                d2 += this.getCost(costRates.defaultCost, d);
            }
        } else {
            Date date4 = iFinancialTask.getStartDate();
            while (n < variableCostArray.length - 1 && d > 0.0) {
                long l = CalendarUtil.getDurationInMs(date4, variableCostArray[n + 1].from, scheduleCalendar);
                if (l > 0L) {
                    if (n2 != 100) {
                        l = l * (long)n2 / 100L;
                    }
                    double d4 = CalendarUtil.msToHours(l);
                    d4 = Math.min(d4, d);
                    ICostRate iCostRate = n < 0 ? costRates.defaultCost : variableCostArray[n].costRate;
                    d2 += this.getCost(iCostRate, d4);
                    d -= d4;
                }
                date4 = variableCostArray[n + 1].from;
                ++n;
            }
            if (d > 0.0) {
                if (n != variableCostArray.length - 1) {
                    System.out.println("FinancialComputation: assertion 02 failed");
                }
                d2 += this.getCost(variableCostArray[variableCostArray.length - 1].costRate, d);
            }
        }
        return d2;
    }

    public double getCost(ICostRate iCostRate, double d) {
        if (iCostRate == null || d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("worked hours is invalid: " + d);
        }
        if (this.isFixed(iCostRate)) {
            return 0.0;
        }
        if (this.isPerUse(iCostRate)) {
            return 0.0;
        }
        if (this.isByHour(iCostRate)) {
            return iCostRate.getCost() * d;
        }
        if (this.isByDay(iCostRate)) {
            return iCostRate.getCost() * d / this.getProjectHoursPerDay();
        }
        if (this.isByWeek(iCostRate)) {
            return iCostRate.getCost() * d / this.getProjectHoursPerWeek();
        }
        if (this.isByMonth(iCostRate)) {
            return iCostRate.getCost() * d / this.getProjectHoursPerMonth();
        }
        throw new IllegalStateException("Unknown unit: " + iCostRate.getRateUnitCode());
    }

    protected abstract IFinancialWBS getRoot();

    protected abstract boolean isActualWorkComputationModeTimesheet();

    protected abstract double getProjectHoursPerDay();

    protected abstract double getProjectHoursPerWeek();

    protected abstract double getProjectHoursPerMonth();

    protected abstract Date getProjectStartDate();

    private boolean isRollupWBSCost(IFinancialWBS iFinancialWBS) {
        return iFinancialWBS.getSubprojectOptions() == null || iFinancialWBS.getSubprojectOptions().isFinancialRollup();
    }

    protected abstract ItemTimeSheetData getTimeSheetData(IFinancialTask var1);

    protected double getEstimatedActualWork(IFinancialTask iFinancialTask) {
        if (this.isActualWorkComputationModeTimesheet()) {
            ItemTimeSheetData itemTimeSheetData = this.getTimeSheetData(iFinancialTask);
            return itemTimeSheetData.getItemHours();
        }
        return iFinancialTask.getWorkInHours() * iFinancialTask.getProgress();
    }

    protected boolean isByHour(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "byhour";
    }

    protected boolean isByDay(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "byday";
    }

    protected boolean isByWeek(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "byweek";
    }

    protected boolean isByMonth(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "bymonth";
    }

    protected boolean isPerUse(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "peruse";
    }

    protected boolean isFixed(ICostRate iCostRate) {
        return iCostRate.getRateUnitCode() == "fixed";
    }

    public static double getNodeProjectedAdditionalCost(IFinancialNode iFinancialNode) {
        Double d = iFinancialNode.getSpecifiedActualAdditionalCost();
        double d2 = iFinancialNode.getAdditionalCost();
        if (d == null) {
            return d2;
        }
        return Math.max(d, d2);
    }

    public boolean hasSubproject() {
        return this.hasSubproject;
    }

    public boolean hasFinancialRollupSubproject() {
        return this.hasFinancialRollupSubproject;
    }

    public abstract double getComputedBudget();

    public double getInitiallyPlannedCost() {
        IFinancialWBS iFinancialWBS = this.getRoot();
        return iFinancialWBS.getInitiallyPlannedResourceCost() + iFinancialWBS.getInitiallyPlannedAdditionalCost();
    }

    public double getDeclaredBudget() {
        return this.getFinancialSettings().getBudget();
    }

    protected abstract FinancialSettings getFinancialSettings();

    protected abstract ScheduleCalendar getCalendar(String var1);

    protected abstract String getResourceCalendarId(ITaskResource var1);

    protected abstract String getProjectCalendarId();

    public static interface IFinancialNode {
        public String getUid();

        public double getAdditionalCost();

        public Double getSpecifiedActualAdditionalCost();

        public void setActualAdditionalCost(double var1);

        public double getActualAdditionalCost();

        public void setActualResourceCost(double var1);

        public double getActualResourceCost();

        public void setProjectedResourceCost(double var1);

        public double getProjectedResourceCost();

        public void setInitiallyPlannedResourceCost(double var1);

        public double getInitiallyPlannedResourceCost();
    }

    public static interface IFinancialTask
    extends IFinancialNode {
        public boolean isDone();

        public boolean isPending();

        public double getWorkInHours();

        public double getSpecifiedActualWork();

        public double getSpecifiedRemainingWork();

        public double getEstimatedRemainingWork();

        public ITaskResource[] getTaskResources();

        public Date getStartDate();

        public Date getFinishDate();

        public boolean isIgnoreResourcesCalendar();

        public String getCalendarId();

        public int getSchedulingMode();

        public double getProgress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFinancialWBS
    extends IFinancialNode {
        public void setProjectedAdditionalCost(double var1);

        public double getProjectedAdditionalCost();

        public void setInitiallyPlannedAdditionalCost(double var1);

        public double getInitiallyPlannedAdditionalCost();

        public void setNodeActualAdditionalCost(double var1);

        public double getNodeActualAdditionalCost();

        public boolean isSubProject();

        public SubprojectOptions getSubprojectOptions();

        public Iterator<? extends IFinancialNode> allChildrenIterator();
    }
}

