/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.util.format;

import com.triloggroup.util.UString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class TGDecimalFormat
extends DecimalFormat {
    private NumberFormat format2;

    public static DecimalFormat getTGInstance(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        return new TGDecimalFormat(decimalFormat.toPattern(), decimalFormat.getDecimalFormatSymbols());
    }

    private TGDecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        super(string, decimalFormatSymbols);
        if (decimalFormatSymbols.getDecimalSeparator() != '.' && decimalFormatSymbols.getGroupingSeparator() != '.') {
            DecimalFormatSymbols decimalFormatSymbols2 = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            decimalFormatSymbols2.setDecimalSeparator('.');
            this.format2 = new DecimalFormat(string, decimalFormatSymbols2);
        }
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Number number = super.parse(string, parsePosition);
        if (parsePosition.getIndex() != string.length() && this.format2 != null && string.charAt(parsePosition.getIndex()) == '.' && parsePosition.getErrorIndex() <= 0 && (number == null || number.doubleValue() == (double)number.longValue())) {
            int n2 = parsePosition.getIndex();
            parsePosition.setIndex(n);
            parsePosition.setErrorIndex(-1);
            Number number2 = this.format2.parse(string, parsePosition);
            if (parsePosition.getIndex() > n2) {
                number = number2;
            } else {
                parsePosition.setIndex(n2);
                parsePosition.setErrorIndex(-1);
            }
        }
        return number;
    }

    public static Number parseFullString(String string, NumberFormat numberFormat) throws ParseException {
        if (UString.isEmpty(string)) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string, parsePosition);
        int n = parsePosition.getIndex();
        if (n == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", parsePosition.getErrorIndex());
        }
        if (n != string.length()) {
            throw new ParseException("Unparseable number (contains invalid characters at the end): \"" + string + "\"", n);
        }
        return number;
    }
}

