/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.project.components.ui.table.ListItemsEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class ListItemEditorDialog
extends WDDialog
implements ActionListener {
    protected ListItemsEditor editor;
    private WDButton okButton;
    protected boolean[] tableSelection;
    private Object[] extra;
    private boolean[] extraSelection;
    protected Object[] result;
    protected JTable table;
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border FOCUS_BORDER = new LineBorder(TGTreeTable.EDITABLE_CELL_BORDER_COLOR, 1);

    static ListItemEditorDialog create(ListItemsEditor listItemsEditor) {
        Window window = SwingUtilities.getWindowAncestor(listItemsEditor.lb);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(listItemsEditor.lb);
        return new ListItemEditorDialog(window, listItemsEditor, graphicsConfiguration);
    }

    protected ListItemEditorDialog(Window window, ListItemsEditor listItemsEditor, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.editor = listItemsEditor;
    }

    protected void updateTableUI() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new ItemRenderer());
        ItemEditor itemEditor = new ItemEditor();
        tableColumn.setCellEditor(itemEditor);
        int n = this.table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Component component = itemEditor.getTableCellEditorComponent(this.table, null, true, i, 0);
            n = Math.max(n, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n + 5);
        this.table.setSelectionMode(0);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setShowGrid(false);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    /*
     * WARNING - void declaration
     */
    protected void init() {
        Serializable serializable;
        this.tableSelection = new boolean[this.editor.allValues.length];
        this.extra = null;
        this.extraSelection = null;
        if (this.editor.currentValue != null) {
            serializable = new HashSet();
            for (Object object : this.editor.currentValue) {
                ((HashSet)serializable).add(object);
            }
            for (int i = 0; i < this.tableSelection.length; ++i) {
                if (!((HashSet)serializable).contains(this.editor.allValues[i])) continue;
                this.tableSelection[i] = true;
            }
            if (this.editor.isAllowSelectValueNotInAllValues()) {
                void var3_9;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (Object object : this.editor.allValues) {
                    hashSet.add(object);
                }
                Object jScrollPane = null;
                for (Object object : this.editor.currentValue) {
                    if (hashSet.contains(object)) continue;
                    if (var3_9 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var3_9.add(object);
                }
                if (var3_9 != null) {
                    this.extra = var3_9.toArray();
                    this.extraSelection = new boolean[this.extra.length];
                    Arrays.fill(this.extraSelection, true);
                }
            }
        }
        serializable = new AbstractTableModel(){

            public String getColumnName(int n) {
                return ListItemEditorDialog.this.editor.title;
            }

            public int getRowCount() {
                int n = ListItemEditorDialog.this.editor.allValues.length;
                if (ListItemEditorDialog.this.extra != null) {
                    n += ListItemEditorDialog.this.extra.length;
                }
                return n;
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int n, int n2) {
                boolean bl = n < ListItemEditorDialog.this.tableSelection.length ? ListItemEditorDialog.this.tableSelection[n] : ListItemEditorDialog.this.extraSelection[n - ListItemEditorDialog.this.tableSelection.length];
                return bl;
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            public void setValueAt(Object object, int n, int n2) {
                boolean bl = (Boolean)object;
                if (n < ListItemEditorDialog.this.tableSelection.length) {
                    ListItemEditorDialog.this.tableSelection[n] = bl;
                } else {
                    ((ListItemEditorDialog)ListItemEditorDialog.this).extraSelection[n - ListItemEditorDialog.this.tableSelection.length] = bl;
                }
            }
        };
        this.table = new JTable((TableModel)((Object)serializable));
        this.updateTableUI();
        Dimension dimension = new Dimension(this.table.getPreferredSize());
        this.table.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel.add(wDButton);
        wDButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setDragHeader(false);
        this.setDialogDecoration(false);
        this.setMaximizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            int n;
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n = 0; n < this.tableSelection.length; ++n) {
                if (!this.tableSelection[n]) continue;
                arrayList.add(this.editor.allValues[n]);
            }
            if (this.extraSelection != null) {
                for (n = 0; n < this.extraSelection.length; ++n) {
                    if (!this.extraSelection[n]) continue;
                    arrayList.add(this.extra[n]);
                }
            }
            this.result = arrayList.toArray();
        }
        this.dispose();
    }

    protected Object[] getSelectedValue() {
        return this.result;
    }

    private void prepareCheckBoxForRow(JCheckBox jCheckBox, int n) {
        Object object;
        if (n < this.tableSelection.length) {
            object = this.editor.allValues[n];
            jCheckBox.setSelected(this.tableSelection[n]);
            jCheckBox.setForeground(Color.BLACK);
        } else {
            object = this.extra[n -= this.tableSelection.length];
            jCheckBox.setSelected(this.extraSelection[n]);
            jCheckBox.setForeground(Color.RED);
        }
        if (object == null) {
            jCheckBox.setText("");
        } else {
            jCheckBox.setText(object.toString());
        }
    }

    class ItemEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JCheckBox cb = new JCheckBox();

        ItemEditor() {
            this.cb.setFont(this.cb.getFont().deriveFont(0));
            this.cb.setOpaque(true);
            this.cb.setBackground(ListItemEditorDialog.this.table.getSelectionBackground());
            this.cb.setBorderPaintedFlat(true);
            this.cb.addActionListener(this);
        }

        public Object getCellEditorValue() {
            return this.cb.isSelected();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ListItemEditorDialog.this.prepareCheckBoxForRow(this.cb, n);
            return this.cb;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
        }
    }

    class ItemRenderer
    implements TableCellRenderer {
        JCheckBox cb = new JCheckBox();

        ItemRenderer() {
            this.cb.setFont(this.cb.getFont().deriveFont(0));
            this.cb.setBorderPainted(true);
            this.cb.setBorderPaintedFlat(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ListItemEditorDialog.this.prepareCheckBoxForRow(this.cb, n);
            this.cb.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.cb.setBorder(bl2 ? FOCUS_BORDER : NO_FOCUS_BORDER);
            return this.cb;
        }
    }
}

