/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.CellEditorWithLabel;
import java.awt.event.FocusListener;
import java.util.Locale;

public class IntegerCellEditorWithLabel
extends CellEditorWithLabel
implements FocusListener {
    protected Integer value;
    protected int minValue;
    protected int maxValue;
    protected boolean acceptNull;

    public IntegerCellEditorWithLabel(Locale locale, String string) {
        this(locale, Integer.MIN_VALUE, Integer.MAX_VALUE, string);
    }

    public IntegerCellEditorWithLabel(Locale locale, int n, int n2, String string) {
        super(string);
        this.getTextComponent().setHorizontalAlignment(4);
        this.minValue = n;
        this.maxValue = n2;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        if (this.acceptNull && "".equals(string)) {
            this.value = null;
        } else {
            try {
                Integer n = Integer.valueOf(string);
                int n2 = n;
                if (n2 < this.minValue || n2 > this.maxValue) {
                    this.value = null;
                    this.panel.setBorder(ERROR_BORDER);
                    return false;
                }
                this.value = n;
            }
            catch (Exception exception) {
                this.panel.setBorder(ERROR_BORDER);
                return false;
            }
        }
        return super.stopCellEditing();
    }
}

