/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui.table;

import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.util.Locale;

public class IntegerCellEditor
extends TextCellEditor {
    protected Integer value;
    protected int minValue;
    protected int maxValue;

    public IntegerCellEditor(Locale locale) {
        this(locale, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerCellEditor(Locale locale, boolean bl) {
        this(locale, bl ? 0 : Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerCellEditor(Locale locale, int n, int n2) {
        this.getTextComponent().setHorizontalAlignment(4);
        this.minValue = n;
        this.maxValue = n2;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean stopCellEditing() {
        String string = this.getTextComponent().getText();
        try {
            Integer n = Integer.valueOf(string);
            int n2 = n;
            if (n2 < this.minValue || n2 > this.maxValue) {
                this.value = null;
                this.getTextComponent().setBorder(ERROR_BORDER);
                return false;
            }
            this.value = n;
        }
        catch (Exception exception) {
            this.getTextComponent().setBorder(ERROR_BORDER);
            return false;
        }
        return super.stopCellEditing();
    }
}

