/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import com.triloggroup.project.components.ui.WDSplitPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class WDSplitPaneDivider
extends BasicSplitPaneDivider {
    private Color controlColor = MetalLookAndFeel.getControl();
    private Color primaryControlColor = UIManager.getColor("SplitPane.dividerFocusColor");

    public WDSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(true));
                this.add(this.leftButton);
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(false));
                this.add(this.rightButton);
            }
        }
        this.revalidate();
    }

    public void revalidate() {
        this.invalidate();
        if (this.splitPane != null) {
            this.splitPane.revalidate();
        }
    }

    public void paint(Graphics graphics) {
        if (this.splitPane.hasFocus()) {
            graphics.setColor(this.primaryControlColor);
        } else {
            graphics.setColor(this.controlColor);
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paint(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){
            int[][] buffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                block8: {
                    JSplitPane jSplitPane = WDSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (jSplitPane == null) break block8;
                    int n = WDSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n2 = WDSplitPaneDivider.this.getOrientationFromSuper();
                    int n3 = Math.min(WDSplitPaneDivider.this.getDividerSize(), n);
                    Color[] colorArray = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    graphics.setColor(this.getBackground());
                    if (this.isOpaque()) {
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (this.getModel().isPressed()) {
                        colorArray[1] = colorArray[2];
                    }
                    if (n2 == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < n3; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                                graphics.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < n3; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                                graphics.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        this.maybeMakeButtonOpaque(jButton);
        return jButton;
    }

    private void maybeMakeButtonOpaque(JComponent jComponent) {
        Object object = UIManager.get("SplitPane.oneTouchButtonsOpaque");
        if (object != null) {
            jComponent.setOpaque((Boolean)object);
        }
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){
            int[][] buffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                block8: {
                    JSplitPane jSplitPane = WDSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (jSplitPane == null) break block8;
                    int n = WDSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n2 = WDSplitPaneDivider.this.getOrientationFromSuper();
                    int n3 = Math.min(WDSplitPaneDivider.this.getDividerSize(), n);
                    Color[] colorArray = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    graphics.setColor(this.getBackground());
                    if (this.isOpaque()) {
                        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    if (this.getModel().isPressed()) {
                        colorArray[1] = colorArray[2];
                    }
                    if (n2 == 0) {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < n3; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                                graphics.drawLine(i, j, i, j);
                            }
                        }
                    } else {
                        for (int i = 1; i <= this.buffer[0].length; ++i) {
                            for (int j = 1; j < n3; ++j) {
                                if (this.buffer[j - 1][i - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[j - 1][i - 1]]);
                                graphics.drawLine(j, i, j, i);
                            }
                        }
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        this.maybeMakeButtonOpaque(jButton);
        return jButton;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;

        OneTouchActionHandler(boolean bl) {
            this.toMinimum = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            double d = ((WDSplitPane)WDSplitPaneDivider.this.splitPane).getDefaultDividerProportional();
            if (d <= 0.0 || d >= 1.0) {
                this.defaultOneTouchactionPerformed(actionEvent);
                return;
            }
            Insets insets = WDSplitPaneDivider.this.splitPane.getInsets();
            int n2 = WDSplitPaneDivider.this.splitPaneUI.getDividerLocation(WDSplitPaneDivider.this.splitPane);
            int n3 = WDSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int n4 = WDSplitPaneDivider.this.splitPane.getHeight();
            int n5 = WDSplitPaneDivider.this.splitPane.getWidth();
            if (this.toMinimum) {
                Dimension dimension = WDSplitPaneDivider.this.splitPane.getRightComponent().getPreferredSize();
                Dimension dimension2 = WDSplitPaneDivider.this.splitPane.getRightComponent().getMinimumSize();
                Dimension dimension3 = WDSplitPaneDivider.this.splitPane.getLeftComponent().getMinimumSize();
                if (WDSplitPaneDivider.this.orientation == 0) {
                    int n6 = n4 - insets.bottom - WDSplitPaneDivider.this.getHeight() - dimension2.height;
                    if (n2 >= n6) {
                        if (this.isInAllowedDividerArea(n3)) {
                            n = n3;
                        } else {
                            n = (int)((double)n4 * d);
                            if (n4 - dimension.height > 0) {
                                n = Math.min(n, n4 - (n4 - dimension.height));
                            }
                        }
                    } else {
                        n = insets.top + dimension3.height;
                    }
                } else {
                    int n7 = n5 - insets.right - WDSplitPaneDivider.this.getWidth() - dimension2.width;
                    if (n2 >= n7) {
                        if (this.isInAllowedDividerArea(n3)) {
                            n = n3;
                        } else {
                            n = (int)((double)n5 * d);
                            if (n5 - dimension.width > 0) {
                                n = Math.min(n, n5 - (n5 - dimension.width));
                            }
                        }
                    } else {
                        n = insets.left + dimension3.width;
                    }
                }
            } else {
                int n8;
                int n9;
                Dimension dimension = WDSplitPaneDivider.this.splitPane.getLeftComponent().getMinimumSize();
                Dimension dimension4 = WDSplitPaneDivider.this.splitPane.getRightComponent().getMinimumSize();
                n = WDSplitPaneDivider.this.orientation == 0 ? (n2 <= (n9 = insets.top + dimension.height) ? (this.isInAllowedDividerArea(n3) ? n3 : Math.min(n4 - (insets.bottom + dimension4.height + WDSplitPaneDivider.this.getHeight()), (int)((double)n4 * d))) : n4 - (insets.bottom + dimension4.height + WDSplitPaneDivider.this.getHeight())) : (n2 <= (n8 = insets.left + dimension.width) ? (this.isInAllowedDividerArea(n3) ? n3 : Math.min(n5 - (insets.right + dimension4.width + WDSplitPaneDivider.this.getWidth()), (int)((double)n5 * d))) : n5 - (insets.right + dimension4.width + WDSplitPaneDivider.this.getWidth()));
            }
            if (n2 != n) {
                WDSplitPaneDivider.this.splitPane.setDividerLocation(n);
                WDSplitPaneDivider.this.splitPane.setLastDividerLocation(n2);
            }
        }

        protected boolean isInAllowedDividerArea(int n) {
            Dimension dimension = WDSplitPaneDivider.this.splitPane.getLeftComponent().getMinimumSize();
            Dimension dimension2 = WDSplitPaneDivider.this.splitPane.getLeftComponent().getMinimumSize();
            Insets insets = WDSplitPaneDivider.this.splitPane.getInsets();
            int n2 = WDSplitPaneDivider.this.splitPane.getHeight();
            int n3 = WDSplitPaneDivider.this.splitPane.getWidth();
            if (WDSplitPaneDivider.this.orientation == 0) {
                return n < n2 - insets.bottom - WDSplitPaneDivider.this.getHeight() - dimension2.height && n > insets.top + dimension.height;
            }
            return n > n3 - insets.right - WDSplitPaneDivider.this.getWidth() - dimension2.width && n < insets.left + dimension.width;
        }

        protected void defaultOneTouchactionPerformed(ActionEvent actionEvent) {
            int n;
            Insets insets = WDSplitPaneDivider.this.splitPane.getInsets();
            int n2 = WDSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int n3 = WDSplitPaneDivider.this.splitPaneUI.getDividerLocation(WDSplitPaneDivider.this.splitPane);
            if (this.toMinimum) {
                if (WDSplitPaneDivider.this.orientation == 0) {
                    if (n3 >= WDSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - WDSplitPaneDivider.this.getHeight()) {
                        int n4 = WDSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                        n = Math.min(n2, n4);
                    } else {
                        n = insets.top;
                    }
                } else if (n3 >= WDSplitPaneDivider.this.splitPane.getWidth() - insets.right - WDSplitPaneDivider.this.getWidth()) {
                    int n5 = WDSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    n = Math.min(n2, n5);
                } else {
                    n = insets.left;
                }
            } else if (WDSplitPaneDivider.this.orientation == 0) {
                if (n3 == insets.top) {
                    int n6 = WDSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                    n = Math.min(n2, n6);
                } else {
                    n = WDSplitPaneDivider.this.splitPane.getHeight() - WDSplitPaneDivider.this.getHeight() - insets.top;
                }
            } else if (n3 == insets.left) {
                int n7 = WDSplitPaneDivider.this.splitPane.getMaximumDividerLocation();
                n = Math.min(n2, n7);
            } else {
                n = WDSplitPaneDivider.this.splitPane.getWidth() - WDSplitPaneDivider.this.getWidth() - insets.left;
            }
            if (n3 != n) {
                WDSplitPaneDivider.this.splitPane.setDividerLocation(n);
                WDSplitPaneDivider.this.splitPane.setLastDividerLocation(n3);
            }
        }
    }
}

