/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.AbstractBorder;

public class ToolBarPanel
extends JPanel {
    private JComponent[] leftItems1;
    private JComponent[] leftItems2;
    private JComponent[] rightItems;
    private GridBagConstraints constraint;

    public static JSeparator createSeparator() {
        JSeparator jSeparator = new JSeparator(1);
        return jSeparator;
    }

    public ToolBarPanel() {
        super(new GridBagLayout());
        this.setBorder(new BottomBorder());
        this.constraint = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 3, new Insets(0, 5, 0, 0), 0, 0);
    }

    public void setLeftItems1(JComponent[] jComponentArray) {
        this.leftItems1 = jComponentArray;
        this.updateItems();
    }

    public void setLeftItems2(JComponent[] jComponentArray) {
        this.leftItems2 = jComponentArray;
        this.updateItems();
    }

    public void setRightItems(JComponent[] jComponentArray) {
        this.rightItems = jComponentArray;
        this.updateItems();
    }

    private void updateItems() {
        this.removeAll();
        this.addItems(this.leftItems1);
        this.addItems(this.leftItems2);
        this.add((Component)new JLabel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addItems(this.rightItems);
        this.revalidate();
        this.repaint();
    }

    private void addItems(JComponent[] jComponentArray) {
        if (jComponentArray == null) {
            return;
        }
        for (int i = 0; i < jComponentArray.length; ++i) {
            this.add((Component)jComponentArray[i], this.constraint);
        }
    }

    private static class BottomBorder
    extends AbstractBorder {
        Insets insets = new Insets(5, 5, 5, 5);
        Color lineColor = Color.BLACK;

        BottomBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.lineColor);
            graphics.drawLine(n, n2 + n4 - 1, n3, n2 + n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }
    }
}

