/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.ui;

import com.triloggroup.project.components.ui.IView;
import com.triloggroup.project.components.ui.WorkbenchPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public abstract class AbstractView
implements IView {
    protected static Color FOCUS_BORDER_COLOR = new Color(221, 231, 245);
    protected static Color DEFAULT_BORDER_COLOR = Color.LIGHT_GRAY;
    private static final int BORDER_WIDTH = 3;
    protected WorkbenchPage workbenchPage;
    protected JPanel mainComponent = new JPanel(new BorderLayout()){

        public Dimension getMinimumSize() {
            Dimension dimension = AbstractView.this.header.getPreferredSize();
            dimension.height += 3;
            return dimension;
        }
    };
    protected LineBorder defaultBorder;
    protected LineBorder focusBorder;
    protected JLabel header;
    protected JComponent body;
    private boolean hasFocus;

    protected AbstractView(String string) {
        Icon icon = null;
        this.header = new JLabel(string, icon, 2);
        this.header.setOpaque(true);
        this.header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!AbstractView.this.hasFocus) {
                    JComponent jComponent = AbstractView.this.getMainFocusableComponent();
                    if (jComponent != null) {
                        jComponent.requestFocus();
                    } else {
                        AbstractView.this.workbenchPage.setActiveView(AbstractView.this);
                    }
                }
            }
        });
        this.mainComponent.add((Component)this.header, "North");
        this.defaultBorder = new LineBorder(DEFAULT_BORDER_COLOR, 3);
        this.focusBorder = new LineBorder(FOCUS_BORDER_COLOR, 3);
    }

    public String getTitle() {
        return this.header.getText();
    }

    public void setTitle(String string) {
        this.header.setText(string);
    }

    public JComponent getComponent() {
        return this.mainComponent;
    }

    public Action getAction(int n) {
        return null;
    }

    public void setWorkbenchPage(WorkbenchPage workbenchPage) {
        this.workbenchPage = workbenchPage;
    }

    public WorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    public void activeStateChanged(boolean bl) {
        this.hasFocus = bl;
        this.header.setBackground(bl ? FOCUS_BORDER_COLOR : DEFAULT_BORDER_COLOR);
        this.mainComponent.setBorder(bl ? this.focusBorder : this.defaultBorder);
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }
}

