/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.schedulecalendar;

import com.triloggroup.project.components.schedulecalendar.CalendarTableModel;
import com.triloggroup.project.components.schedulecalendar.DayData;
import com.triloggroup.project.components.schedulecalendar.DayRenderer;
import com.triloggroup.project.components.schedulecalendar.WeekDayRenderer;
import com.triloggroup.project.components.schedulecalendar.WeekSelectorRenderer;
import com.triloggroup.util.date.TGTime;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class CalendarTable
extends JTable {
    private TableCellRenderer dayRenderer;
    private TableCellRenderer weekDayRenderer;
    private TableCellRenderer weekSelectorRenderer;
    private DateFormat timeFormat;

    public CalendarTable(CalendarTableModel calendarTableModel, Locale locale) {
        super(calendarTableModel);
        this.timeFormat = DateFormat.getTimeInstance(3, locale);
        this.dayRenderer = new DayRenderer();
        this.weekDayRenderer = new WeekDayRenderer();
        this.weekSelectorRenderer = new WeekSelectorRenderer();
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(30);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.getCalendarTableModel().isEditable() && n2 == 0) {
            return this.weekSelectorRenderer;
        }
        if (n == 0) {
            return this.weekDayRenderer;
        }
        return this.dayRenderer;
    }

    protected CalendarTableModel getCalendarTableModel() {
        return (CalendarTableModel)this.getModel();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (object = this.getValueAt(n2, n)) instanceof DayData) {
            DayData dayData = (DayData)object;
            if (!dayData.isWorkingDay()) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer("<html>");
            for (int i = 0; i < dayData.workingTimes.length; ++i) {
                if (i > 0) {
                    stringBuffer.append("<br>");
                }
                stringBuffer.append(this.formatTime(dayData.workingTimes[i].fromTime));
                stringBuffer.append(" - ");
                stringBuffer.append(this.formatTime(dayData.workingTimes[i].toTime));
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return null;
    }

    protected String formatTime(TGTime tGTime) {
        Calendar calendar = this.timeFormat.getCalendar();
        calendar.set(11, tGTime.hours);
        calendar.set(12, tGTime.minutes);
        return this.timeFormat.format(calendar.getTime());
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.x += 20;
        return point;
    }
}

