/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table.costrate;

import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.components.ui.table.CellEditorWithLabel;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.components.util.format.TGDecimalFormat;
import com.triloggroup.project.financial.FinancialSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class SimpleCostRateEditor
extends CellEditorWithLabel {
    private NumberFormat fmt;
    private JComboBox cbRateUnit;
    private CostRate newValue;

    public SimpleCostRateEditor(Locale locale, FinancialSettings financialSettings) {
        super(new JComboBox<CostRateUnit>(CostRateUnit.getAll()), true);
        this.cbRateUnit = (JComboBox)this.label;
        this.cbRateUnit.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.cbRateUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleCostRateEditor.this.stopCellEditing();
            }
        });
        this.fmt = FormatUtil.getCostFormat(locale, financialSettings);
        this.getTextComponent().setHorizontalAlignment(4);
    }

    protected String getTextValue(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            return "";
        }
        CostRate costRate = (CostRate)object;
        this.cbRateUnit.setSelectedItem(costRate.getRateUnit());
        return this.fmt.format(costRate.getCost());
    }

    public boolean stopCellEditing() {
        try {
            CostRateUnit costRateUnit = (CostRateUnit)this.cbRateUnit.getSelectedItem();
            String string = this.getTextComponent().getText();
            Number number = TGDecimalFormat.parseFullString(string, this.fmt);
            if (number.doubleValue() >= 0.0) {
                this.newValue = new CostRate(number.doubleValue(), costRateUnit);
                return super.stopCellEditing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel.setBorder(ERROR_BORDER);
        return false;
    }

    public Object getCellEditorValue() {
        return this.newValue;
    }
}

