/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table.costrate;

import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.table.ResourceTable;
import com.triloggroup.project.components.resourceeditor.table.costrate.CostRatesEditorDialog;
import com.triloggroup.project.components.resourceeditor.table.costrate.CostRatesRenderer;
import com.triloggroup.project.components.resourceeditor.table.costrate.SimpleCostRateEditor;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.CellEditorWithDialog;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CostRatesEditor
extends CellEditorWithDialog<CostRates> {
    private boolean editable;
    private ResourceTable resourceTable;
    private boolean potentiallyInlineEditor;
    private TableCellEditor redirectEditor;

    public CostRatesEditor(ResourceTable resourceTable) {
        this.resourceTable = resourceTable;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (!super.isCellEditable(eventObject)) {
            return false;
        }
        this.potentiallyInlineEditor = false;
        if (eventObject == null) {
            return true;
        }
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            Point point = mouseEvent.getPoint();
            int n = this.resourceTable.rowAtPoint(point);
            int n2 = this.resourceTable.columnAtPoint(point);
            Rectangle rectangle = this.resourceTable.getCellRect(n, n2, true);
            this.potentiallyInlineEditor = !CostRatesRenderer.isLocationInEditHint(mouseEvent.getX(), mouseEvent.getY(), rectangle);
        } else if (eventObject instanceof KeyEvent) {
            char c = ((KeyEvent)eventObject).getKeyChar();
            this.potentiallyInlineEditor = Character.isDigit(c);
        }
        return true;
    }

    @Override
    protected void showDialog() {
        CostRatesEditorDialog costRatesEditorDialog = CostRatesEditorDialog.create(this.lb);
        costRatesEditorDialog.init((CostRates)this.currentValue, this.editable, this.resourceTable.getView());
        costRatesEditorDialog.ensureMinMaxSize(this.lb.getWidth(), -1, -1, 500);
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.lb);
        costRatesEditorDialog.setLocation(point);
        costRatesEditorDialog.setVisibleDisableMouseEvents(500L);
        this.currentValue = costRatesEditorDialog.getSelectedValue();
        if (!this.editable || this.currentValue == null) {
            this.cancelCellEditing();
        } else {
            this.stopCellEditing();
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.editable && this.potentiallyInlineEditor) {
            Locale locale = Workbench.get().getFormatLocale();
            FinancialSettings financialSettings = this.resourceTable.getView().getProjectModel().getFinancialSettings();
            this.currentValue = (CostRates)object;
            this.redirectEditor = new InlineEditor(locale, financialSettings);
            return this.redirectEditor.getTableCellEditorComponent(jTable, ((CostRates)this.currentValue).getCostRate(new Date()), bl, n, n2);
        }
        this.redirectEditor = null;
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.redirectEditor != null) {
            return this.redirectEditor.stopCellEditing();
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.redirectEditor != null) {
            this.redirectEditor.cancelCellEditing();
        } else {
            super.cancelCellEditing();
        }
    }

    private class InlineEditor
    extends SimpleCostRateEditor
    implements CellEditorListener {
        private ICostRate editedRate;

        public InlineEditor(Locale locale, FinancialSettings financialSettings) {
            super(locale, financialSettings);
            this.addCellEditorListener(this);
            this.selectAll = true;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editedRate = (ICostRate)object;
            return super.getTableCellEditorComponent(jTable, this.editedRate, bl, n, n2);
        }

        public void editingStopped(ChangeEvent changeEvent) {
            CostRate costRate = (CostRate)this.getCellEditorValue();
            CostRatesEditor.this.redirectEditor = null;
            if (this.editedRate == ((CostRates)((CostRatesEditor)CostRatesEditor.this).currentValue).defaultCost) {
                CostRatesEditor.this.currentValue = new CostRates(costRate, ((CostRates)((CostRatesEditor)CostRatesEditor.this).currentValue).variableCosts);
            } else {
                VariableCost[] variableCostArray = (VariableCost[])((CostRates)((CostRatesEditor)CostRatesEditor.this).currentValue).variableCosts.clone();
                for (int i = 0; i < variableCostArray.length; ++i) {
                    if (this.editedRate != variableCostArray[i].costRate) continue;
                    variableCostArray[i] = new VariableCost(variableCostArray[i].from, costRate);
                    CostRatesEditor.this.currentValue = new CostRates(((CostRates)((CostRatesEditor)CostRatesEditor.this).currentValue).defaultCost, variableCostArray);
                    break;
                }
            }
            CostRatesEditor.this.stopCellEditing();
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            CostRatesEditor.this.redirectEditor = null;
            CostRatesEditor.this.currentValue = null;
            CostRatesEditor.this.cancelCellEditing();
        }
    }
}

