/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.resourceeditor.NewTeamDialog;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.ui.table.ComboEditorWithEditLink;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TeamEditor
extends ComboEditorWithEditLink {
    private ResourceView resourceView;
    private JPanel editPanel;
    private JTextField textfield;
    private Border defaultTextBorder;
    private Border errorTextBorder = new LineBorder(Color.red);

    private static ProjectTeam[] computeTeamList(ResourceView resourceView) {
        Object[] objectArray = resourceView.getProjectModel().getProjectTeams();
        Arrays.sort(objectArray);
        ProjectTeam[] projectTeamArray = new ProjectTeam[objectArray.length + 1];
        System.arraycopy(objectArray, 0, projectTeamArray, 0, objectArray.length);
        return projectTeamArray;
    }

    public TeamEditor(ResourceView resourceView) {
        super(TeamEditor.computeTeamList(resourceView), Workbench.getNLSString("newTeam", new Object[0]));
        this.resourceView = resourceView;
    }

    protected JComponent getEditionPanel() {
        if (this.editPanel == null) {
            this.editPanel = new JPanel();
            JLabel jLabel = new JLabel(Workbench.getNLSString("teamName", new Object[0]));
            this.editPanel.add((Component)jLabel, "West");
            this.textfield = new JTextField(30);
            this.editPanel.add((Component)this.textfield, "Center");
            this.defaultTextBorder = this.textfield.getBorder();
            this.textfield.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.resetTextFieldError();
                }

                protected void resetTextFieldError() {
                    if (!UString.isEmpty(TeamEditor.this.textfield.getToolTipText())) {
                        TeamEditor.this.textfield.setBorder(TeamEditor.this.defaultTextBorder);
                        TeamEditor.this.textfield.setToolTipText(null);
                    }
                }
            });
            ImageIcon imageIcon = WDUtil.getIcon("saveSmall.gif");
            WDButton wDButton = new WDButton(imageIcon);
            this.editPanel.add((Component)wDButton, "East");
            wDButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TeamEditor.this.setNewCreatedValue(TeamEditor.this.createNewTeamObject());
                }
            });
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 10: {
                            keyEvent.consume();
                            TeamEditor.this.setNewCreatedValue(TeamEditor.this.createNewTeamObject());
                            break;
                        }
                        case 27: {
                            keyEvent.consume();
                            TeamEditor.this.cancelEditionPanel();
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.textfield.addKeyListener(keyListener);
            wDButton.addKeyListener(keyListener);
        } else {
            this.textfield.setText("");
            this.textfield.setToolTipText(null);
            this.textfield.setBorder(this.defaultTextBorder);
        }
        return this.editPanel;
    }

    protected void setNewCreatedValue(Object object) {
        if (object != null && object instanceof ProjectTeam) {
            this.creationDialog.setVisible(false);
            this.resourceView.addProjectTeam((ProjectTeam)object);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)((JComboBox)this.editorComponent).getModel();
            defaultComboBoxModel.insertElementAt(object, 0);
            defaultComboBoxModel.setSelectedItem(object);
            ((ComboEditorWithEditLink.InternalComboBox)this.editorComponent).hidePopup();
            this.stopCellEditing();
        }
    }

    protected ProjectTeam createNewTeamObject() {
        ProjectTeam projectTeam = null;
        String string = UString.trim(this.textfield.getText());
        String string2 = NewTeamDialog.isValidTeamName(string, this.resourceView.getProjectModel());
        if (string2 != null) {
            this.textfield.setBorder(this.errorTextBorder);
            this.textfield.requestFocus();
            this.textfield.setToolTipText(string2);
        } else {
            projectTeam = new ProjectTeam(NewTeamDialog.generateTeamId(), string, this.resourceView.getProjectModel().getProjectContext());
        }
        return projectTeam;
    }
}

