/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.project.Role;
import com.triloggroup.project.Team;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.table.ITableItem;
import com.triloggroup.project.components.resourceeditor.table.SearchedResource;
import com.triloggroup.project.components.resourceeditor.table.TableLeaf;
import com.triloggroup.project.components.resourceeditor.table.TableNode;
import com.triloggroup.project.components.ui.table.ITGTableModel;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;

public class ResourceTableModel
extends AbstractTableModel
implements ITGTableModel {
    private static final ITableItem[] EMPTY_ARRAY = new ITableItem[0];
    private static final int EMPTY_ROWS_COUNT = 53;
    private static final ITableItem EMPTY_NODE = new ITableItem(){

        public ITableItem getParent() {
            return null;
        }

        public Object getValue() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    };
    protected Object emptyCategory;
    protected String[] columnLabels;
    protected String[] columnKeyNames;
    protected String[] availableColumns;
    protected NLSBundle nlsBundle;
    protected ResourceView view;
    protected boolean resourcesEditable;
    protected boolean financialEditable;
    private ITableItem[] values;
    protected String categorizeBy;

    public ResourceTableModel(ResourceView resourceView, NLSBundle nLSBundle) {
        this.view = resourceView;
        this.nlsBundle = nLSBundle;
        this.emptyCategory = nLSBundle.getString("unassigned");
        this.projectChanged();
    }

    public void projectChanged() {
        IProjectResourceModel iProjectResourceModel = this.view.getProjectModel();
        this.resourcesEditable = iProjectResourceModel.isResourceEditable();
        this.financialEditable = iProjectResourceModel.isFinancialEditable();
        this.availableColumns = iProjectResourceModel.isFinancialModuleAvailable() ? new String[]{"Name", "Email", "Role", "Team", "CostRate", "InvitationDate", "InvitedBy"} : new String[]{"Name", "Email", "Role", "Team", "InvitationDate", "InvitedBy"};
        this.setVisibleColumns(this.availableColumns, null, true);
        this.fireTableStructureChanged();
    }

    public boolean isEditable() {
        return this.resourcesEditable || this.financialEditable;
    }

    public boolean isLeaf(int n) {
        return this.getItemAtRow(n).isLeaf();
    }

    public boolean isValidElement(int n) {
        return true;
    }

    public void setVisibleColumns(String[] stringArray, String string, boolean bl) {
        if (this.categorizeBy != string) {
            bl = true;
        }
        this.categorizeBy = string;
        int n = stringArray.length;
        this.columnLabels = new String[n];
        this.columnKeyNames = new String[n];
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            FinancialSettings financialSettings;
            String string3;
            this.columnKeyNames[i] = string3 = stringArray[i].intern();
            this.columnLabels[i] = this.nlsBundle.getString(string3);
            if (string3 != "CostRate") continue;
            if (string2 == null && (financialSettings = this.view.getProjectModel().getFinancialSettings()) != null) {
                string2 = " (" + financialSettings.getCurrencySymbol() + ')';
            }
            if (string2 == null) continue;
            int n2 = i;
            this.columnLabels[n2] = this.columnLabels[n2] + string2;
        }
        if (bl) {
            this.rebuild();
        } else {
            this.lightRebuildKeepOrder();
        }
    }

    public void rebuild() {
        IProjectResourceModel iProjectResourceModel = this.view.getProjectModel();
        ProjectResource[] projectResourceArray = iProjectResourceModel.getProjectResources();
        if (projectResourceArray == null) {
            this.values = EMPTY_ARRAY;
        } else if (this.categorizeBy == null) {
            ProjectResource[] projectResourceArray2 = (ProjectResource[])projectResourceArray.clone();
            Arrays.sort(projectResourceArray2, ProjectResource.COMPARATOR_REGISTERED_FIRST);
            int n = this.isEditable() ? 53 : 0;
            this.values = new ITableItem[projectResourceArray2.length + n];
            for (int i = 0; i < projectResourceArray2.length; ++i) {
                this.values[i] = new TableLeaf(null, projectResourceArray2[i]);
            }
        } else {
            boolean bl;
            if (this.categorizeBy == "Team") {
                bl = true;
            } else if (this.categorizeBy == "Role") {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid categorization: " + this.categorizeBy);
            }
            HashMap<ProjectTeam, ArrayList<ProjectResource>> hashMap = new HashMap<ProjectTeam, ArrayList<ProjectResource>>();
            ArrayList<ProjectResource> arrayList = new ArrayList<ProjectResource>();
            for (int i = 0; i < projectResourceArray.length; ++i) {
                Comparable comparable;
                ProjectResource projectResource = projectResourceArray[i];
                Comparable comparable2 = comparable = bl ? this.view.getProjectModel().getProjectTeamById(projectResource.getTeamId()) : this.view.getProjectModel().getProjectRoleById(projectResource.getRoleId());
                if (comparable == null) {
                    arrayList.add(projectResource);
                    continue;
                }
                ArrayList<ProjectResource> arrayList2 = (ArrayList<ProjectResource>)hashMap.get(comparable);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<ProjectResource>();
                    hashMap.put((ProjectTeam)comparable, arrayList2);
                }
                arrayList2.add(projectResource);
            }
            Object[] objectArray = hashMap.keySet().toArray();
            Arrays.sort(objectArray);
            int n = objectArray.length + projectResourceArray.length;
            if (!arrayList.isEmpty()) {
                ++n;
            }
            this.values = new ITableItem[n];
            int n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                TableNode tableNode = new TableNode(null, object);
                this.values[n2++] = tableNode;
                ArrayList arrayList3 = (ArrayList)hashMap.get(object);
                Collections.sort(arrayList3);
                for (int j = 0; j < arrayList3.size(); ++j) {
                    this.values[n2++] = new TableLeaf(tableNode, arrayList3.get(j));
                }
            }
            if (!arrayList.isEmpty()) {
                TableNode tableNode = new TableNode(null, null);
                this.values[n2++] = tableNode;
                Collections.sort(arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.values[n2++] = new TableLeaf(tableNode, arrayList.get(i));
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void lightRebuildKeepOrder() {
        IProjectResourceModel iProjectResourceModel = this.view.getProjectModel();
        ProjectResource[] projectResourceArray = iProjectResourceModel.getProjectResources();
        if (projectResourceArray == null) {
            this.values = EMPTY_ARRAY;
        } else {
            int n;
            HashSet<ProjectResource> hashSet = new HashSet<ProjectResource>();
            for (n = 0; n < projectResourceArray.length; ++n) {
                hashSet.add(projectResourceArray[n]);
            }
            if (this.categorizeBy == null) {
                ITableItem iTableItem;
                int n2;
                ArrayList<ITableItem> arrayList = new ArrayList<ITableItem>();
                for (n2 = 0; n2 < this.values.length && (iTableItem = this.values[n2]) != null; ++n2) {
                    ProjectResource projectResource;
                    if (!iTableItem.isLeaf() || !hashSet.remove(projectResource = (ProjectResource)iTableItem.getValue())) continue;
                    arrayList.add(iTableItem);
                }
                if (!hashSet.isEmpty()) {
                    ProjectResource[] projectResourceArray2 = hashSet.toArray(new ProjectResource[0]);
                    Arrays.sort(projectResourceArray2, ProjectResource.COMPARATOR_REGISTERED_FIRST);
                    for (int i = 0; i < projectResourceArray2.length; ++i) {
                        arrayList.add(new TableLeaf(null, projectResourceArray2[i]));
                    }
                }
                n2 = this.isEditable() ? 53 : 0;
                this.values = new ITableItem[arrayList.size() + n2];
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.values[i] = (ITableItem)arrayList.get(i);
                }
            } else {
                ArrayList arrayList;
                Comparable comparable;
                ProjectResource projectResource;
                ITableItem iTableItem;
                if (this.categorizeBy == "Team") {
                    n = 1;
                } else if (this.categorizeBy == "Role") {
                    n = 0;
                } else {
                    throw new IllegalArgumentException("Invalid categorization: " + this.categorizeBy);
                }
                HashMap hashMap = new HashMap();
                ArrayList<ProjectResource> arrayList2 = new ArrayList<ProjectResource>();
                Object object = null;
                ArrayList<ProjectResource> arrayList3 = null;
                for (int i = 0; i < this.values.length && (iTableItem = this.values[i]) != null; ++i) {
                    if (!iTableItem.isLeaf()) {
                        object = iTableItem.getValue();
                        if (object == null) {
                            arrayList3 = arrayList2;
                            continue;
                        }
                        arrayList3 = (ArrayList<ProjectResource>)hashMap.get(object);
                        if (arrayList3 != null) continue;
                        arrayList3 = new ArrayList<ProjectResource>();
                        hashMap.put(object, arrayList3);
                        continue;
                    }
                    projectResource = (ProjectResource)iTableItem.getValue();
                    Comparable comparable2 = comparable = n != 0 ? this.view.getProjectModel().getProjectTeamById(projectResource.getTeamId()) : this.view.getProjectModel().getProjectRoleById(projectResource.getRoleId());
                    if (comparable != object || !hashSet.remove(projectResource)) continue;
                    arrayList3.add((ProjectResource)iTableItem.getValue());
                }
                if (!hashSet.isEmpty()) {
                    ProjectResource[] projectResourceArray3 = hashSet.toArray(new ProjectResource[0]);
                    Arrays.sort(projectResourceArray3, ProjectResource.COMPARATOR_REGISTERED_FIRST);
                    for (int i = 0; i < projectResourceArray3.length; ++i) {
                        projectResource = projectResourceArray3[i];
                        Comparable comparable3 = comparable = n != 0 ? this.view.getProjectModel().getProjectTeamById(projectResource.getTeamId()) : this.view.getProjectModel().getProjectRoleById(projectResource.getRoleId());
                        if (comparable == null) {
                            arrayList2.add(projectResource);
                            continue;
                        }
                        arrayList = (ArrayList)hashMap.get(comparable);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            hashMap.put(comparable, arrayList);
                        }
                        arrayList.add(projectResource);
                    }
                }
                Object[] objectArray = hashMap.keySet().toArray();
                Arrays.sort(objectArray);
                int n3 = objectArray.length + projectResourceArray.length;
                if (!arrayList2.isEmpty()) {
                    ++n3;
                }
                this.values = new ITableItem[n3];
                int n4 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayList = objectArray[i];
                    TableNode tableNode = new TableNode(null, arrayList);
                    this.values[n4++] = tableNode;
                    ArrayList arrayList4 = (ArrayList)hashMap.get(arrayList);
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        this.values[n4++] = new TableLeaf(tableNode, arrayList4.get(j));
                    }
                }
                if (!arrayList2.isEmpty()) {
                    TableNode tableNode = new TableNode(null, null);
                    this.values[n4++] = tableNode;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        this.values[n4++] = new TableLeaf(tableNode, arrayList2.get(i));
                    }
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void replaceResource(ProjectResource projectResource, ProjectResource projectResource2) {
        int n = this.getIndexForResourceDn(projectResource.getDn());
        if (n < 0) {
            this.lightRebuildKeepOrder();
            return;
        }
        boolean bl = false;
        if (this.categorizeBy == null) {
            bl = true;
        } else if (this.categorizeBy == "Team") {
            bl = UString.equals(projectResource.getTeamId(), projectResource2.getTeamId());
        } else if (this.categorizeBy == "Role") {
            bl = UString.equals(projectResource.getRoleId(), projectResource2.getRoleId());
        }
        if (bl) {
            this.values[n] = new TableLeaf(this.values[n].getParent(), projectResource2);
            this.fireTableRowsUpdated(n, n);
        } else {
            this.lightRebuildKeepOrder();
        }
    }

    public Object getValueAt(int n, int n2) {
        return this.getValueAt(this.getItemAtRow(n), n2);
    }

    protected Object getValueAt(ITableItem iTableItem, int n) {
        if (iTableItem == null || iTableItem == EMPTY_NODE) {
            return null;
        }
        if (iTableItem.isLeaf()) {
            ProjectResource projectResource = (ProjectResource)iTableItem.getValue();
            String string = this.columnKeyNames[n];
            if (string == "Name") {
                return projectResource.getCn();
            }
            if (string == "Email") {
                return projectResource.getEmail();
            }
            if (string == "Team") {
                return this.view.getProjectModel().getProjectTeamById(projectResource.getTeamId());
            }
            if (string == "Role") {
                return this.view.getProjectModel().getProjectRoleById(projectResource.getRoleId());
            }
            if (string == "CostRate") {
                return projectResource.getCostRates();
            }
            if (string == "InvitationDate") {
                return projectResource.getInvitationDate();
            }
            if (string == "InvitedBy") {
                return projectResource.getInvitedBy();
            }
            return null;
        }
        if (n == 0) {
            Object object = iTableItem.getValue();
            if (object != null) {
                return object;
            }
            return this.emptyCategory;
        }
        return null;
    }

    public ITableItem getItemAtRow(int n) {
        ITableItem iTableItem = this.values[n];
        return iTableItem == null ? EMPTY_NODE : iTableItem;
    }

    public ProjectResource getResourceAtRow(int n) {
        ITableItem iTableItem = this.values[n];
        if (iTableItem != null && iTableItem.isLeaf()) {
            return (ProjectResource)iTableItem.getValue();
        }
        return null;
    }

    public String getColumnKeyName(int n) {
        return this.columnKeyNames[n];
    }

    public String getColumnName(int n) {
        return this.columnLabels[n];
    }

    public int getColumnCount() {
        return this.columnLabels.length;
    }

    public int getRowCount() {
        return this.values.length;
    }

    public boolean isCellEditable(int n, int n2) {
        ITableItem iTableItem = this.getItemAtRow(n);
        if (!iTableItem.isLeaf()) {
            return false;
        }
        String string = this.columnKeyNames[n2];
        if (iTableItem == EMPTY_NODE) {
            return this.resourcesEditable && (string == "Name" || string == "Email");
        }
        if (string == "CostRate") {
            if (this.financialEditable) {
                return true;
            }
            return iTableItem.isLeaf() && ((ProjectResource)iTableItem.getValue()).hasVariableCosts();
        }
        if (!this.resourcesEditable) {
            return false;
        }
        if (string == "Team") {
            return true;
        }
        if (string == "Role") {
            return true;
        }
        return string == "Name" || string == "Email";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValueAt(Object object, int n, int n2) {
        ITableItem iTableItem = this.getItemAtRow(n);
        if (!iTableItem.isLeaf()) {
            throw new IllegalStateException("This cell is not editable: " + n + ',' + n2);
        }
        ProjectResource projectResource = (ProjectResource)iTableItem.getValue();
        if (projectResource == null) {
            SearchedResource searchedResource = (SearchedResource)object;
            String string = null;
            String string2 = null;
            if (n > 0) {
                Object object2 = this.getItemAtRow(n - 1).getValue();
                if (object2 instanceof ProjectResource) {
                    string = ((ProjectResource)object2).getTeamId();
                } else if (this.categorizeBy == "Team" && object2 instanceof Team) {
                    string = ((Team)object2).getId();
                }
                if (this.categorizeBy == "Role") {
                    if (object2 instanceof ProjectResource) {
                        string2 = ((ProjectResource)object2).getRoleId();
                    } else if (this.categorizeBy == "Role" && object2 instanceof Role) {
                        string2 = ((Role)object2).getId();
                    }
                }
            }
            this.view.addResource(searchedResource, string, string2);
            return;
        }
        try {
            Object object3;
            Object object4;
            String string;
            block35: {
                string = this.columnKeyNames[n2];
                if (string == "CostRate") {
                    object4 = projectResource.getCostRates();
                    if (ProjectResource.costRatesEquals((CostRates)object4, (CostRates)object)) {
                        return;
                    }
                    projectResource.setCostRates((CostRates)object);
                    this.view.getProjectModel().updateResourcesCost();
                } else if (string == "Team") {
                    object4 = projectResource.getTeamId();
                    object3 = (Team)object;
                    if (object3 != null) {
                        object = ((Team)object3).getId();
                    }
                    if (this.equals(object4, object)) {
                        return;
                    }
                    projectResource.setTeamId((String)object);
                    if (this.categorizeBy == "Team") {
                        this.rebuild();
                    }
                } else if (string == "Role") {
                    object4 = projectResource.getRoleId();
                    object3 = (Role)object;
                    if (object3 != null) {
                        object = ((Role)object3).getId();
                    }
                    if (this.equals(object4, object)) {
                        return;
                    }
                    projectResource.setRoleId((String)object);
                    if (this.categorizeBy == "Role") {
                        this.rebuild();
                    }
                } else {
                    if (string == "Email") {
                        object3 = (SearchedResource)object;
                        if (((SearchedResource)object3).dn == null && projectResource.getDn().endsWith(",dc=new,dc=resourceseditor")) {
                            object4 = projectResource.getEmail();
                            if (this.equals(object4, object)) {
                                return;
                            }
                            projectResource.setEmail(((SearchedResource)object3).email);
                            object = ((SearchedResource)object3).email;
                            break block35;
                        } else {
                            if (projectResource.getDn().equals(((SearchedResource)object3).dn)) {
                                return;
                            }
                            this.view.replaceResource(projectResource, (SearchedResource)object3);
                            return;
                        }
                    }
                    if (string != "Name") {
                        System.out.println("unknown Resource field edited: " + string + ";value=" + object);
                        return;
                    }
                    object3 = (SearchedResource)object;
                    if (((SearchedResource)object3).dn == null && projectResource.getDn().endsWith(",dc=new,dc=resourceseditor")) {
                        object4 = projectResource.getCn();
                        if (this.equals(object4, object)) {
                            return;
                        }
                        projectResource.setCn(((SearchedResource)object3).cn);
                        object = ((SearchedResource)object3).cn;
                    } else {
                        if (projectResource.getDn().equals(((SearchedResource)object3).dn)) {
                            return;
                        }
                        this.view.replaceResource(projectResource, (SearchedResource)object3);
                        return;
                    }
                }
            }
            object3 = Change.newUpdateChange(projectResource);
            ((Change)object3).addModification(string, object4, object);
            this.view.getChangeManager().addChange((Change)object3);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public int getIndexForResourceDn(String string) {
        for (int i = 0; i < this.values.length; ++i) {
            ProjectResource projectResource = this.getResourceAtRow(i);
            if (projectResource == null || !string.equals(projectResource.getDn())) continue;
            return i;
        }
        return -1;
    }

    protected void addResourceInline(int n) {
        if (n < 0 || n > this.values.length) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        ITableItem[] iTableItemArray = new ITableItem[this.values.length + 1];
        System.arraycopy(this.values, 0, iTableItemArray, 0, n + 1);
        if (n < this.values.length) {
            System.arraycopy(this.values, n + 1, iTableItemArray, n + 2, this.values.length - n - 1);
        }
        this.values = iTableItemArray;
        this.fireTableDataChanged();
    }
}

