/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor.table;

import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ResourceView;
import com.triloggroup.project.components.resourceeditor.table.NameEditor;
import com.triloggroup.project.components.resourceeditor.table.SearchedResource;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import javax.swing.ListCellRenderer;

public class EmailEditor
extends NameEditor {
    public EmailEditor(ResourceView resourceView, ProjectResource projectResource) {
        super(resourceView, projectResource);
        this.ignoreNameRendererIcons = true;
    }

    protected void selectValueForText(String string) {
        if (UString.isEmpty(string)) {
            return;
        }
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            WDDialog.showMsgDialog(this.view.getMainTable(), string2);
            return;
        }
        ProjectResource projectResource = this.getResourceByEmail(string);
        if (projectResource == null && (projectResource = this.getResourceByCn(EmailEditor.createCnFromEmail(string))) == this.currentResource) {
            projectResource = null;
        }
        if (projectResource != null) {
            if (this.acceptProjectResources()) {
                SearchedResource searchedResource = new SearchedResource(projectResource.getCn(), projectResource.getDn(), projectResource.getEmail());
                this.selectValue(searchedResource);
            } else {
                WDDialog.showMsgDialog(this.view.getMainTable(), Workbench.getNLSString("resourceExists_email", new Object[0]));
            }
            return;
        }
        if (this.acceptResourceNotExisting()) {
            SearchedResource searchedResource = new SearchedResource(EmailEditor.createCnFromEmail(string), null, string);
            this.selectValue(searchedResource);
        }
    }

    protected boolean acceptUniqueValue(Object object, String string) {
        if (object == null) {
            return false;
        }
        String string2 = ((SearchedResource)object).email;
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase();
        if ((string = string.toLowerCase()).equals(string2)) {
            return true;
        }
        return string.startsWith(string2 + '@');
    }

    protected boolean acceptProjectResources() {
        return this.currentResource != null;
    }

    protected boolean equivalent(Object object, String string) {
        if (string == null) {
            return object == null;
        }
        if (object instanceof String) {
            return string.equals(object);
        }
        return object instanceof SearchedResource && string.equalsIgnoreCase(((SearchedResource)object).email);
    }

    protected String getStringValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof SearchedResource) {
            return ((SearchedResource)object).email;
        }
        return object.toString();
    }

    protected ListCellRenderer createRenderer() {
        return this.createRenderer(true);
    }

    static String createCnFromEmail(String string) {
        if (UString.isEmpty(string)) {
            return "";
        }
        int n = string.indexOf(64);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }
}

