/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.flowbuilder.util.xml.JDOMUtil;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.ws.WebServiceHelper;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.SecurityProfile;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import java.util.Date;
import java.util.List;
import org.jdom.Element;

public class ResourcesWSHelper
extends WebServiceHelper {
    public ResourcesWSHelper(PEAppProjectContext pEAppProjectContext) {
        super(pEAppProjectContext, "ResourcesWS");
    }

    public String[] searchResources(String string) throws Exception {
        Element element = this.createSOAPDoc("searchResources");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projectId", this.getProjectId()));
        element.addContent(this.createStringSOAPParamElt("text", string));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            String[] stringArray = JDOMUtil.getStrings(element2, "searchResourcesReturn");
            return stringArray;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public String getResourceInfo(String string) throws Exception {
        Element element = this.createSOAPDoc("getResourceInfo");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("dn", string));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            String string2 = element2.getText();
            return string2;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public SecurityProfile[] getSecurityProfiles() throws Exception {
        Element element = this.createSOAPDoc("getSecurityProfiles");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        Element element2 = this.callWebService(element);
        if (element2 != null) {
            List list = element2.getChildren("getSecurityProfilesReturn");
            SecurityProfile[] securityProfileArray = new SecurityProfile[list.size()];
            for (int i = 0; i < securityProfileArray.length; ++i) {
                Element element3 = (Element)list.get(i);
                securityProfileArray[i] = new SecurityProfile(element3.getChildText("id"), element3.getChildText("label"));
            }
            return securityProfileArray;
        }
        throw new GanttChartException("No valid data in web service response");
    }

    public Element sendInvitations(ProjectResource[] projectResourceArray, String string, boolean bl) throws Exception {
        Element element = this.createSOAPDoc("inviteResources");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projetId", this.getProjectId()));
        String[] stringArray = new String[projectResourceArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = projectResourceArray[i].getDn();
        }
        element.addContent(this.createStringArraySOAPParamElt("dns", stringArray));
        element.addContent(this.createStringSOAPParamElt("invitationText", string));
        element.addContent(this.createBooleanSOAPParamElt("ignoreWarnings", bl));
        Element element2 = this.callWebService(element);
        return element2;
    }

    public ValueIntervals getUserAllocationsForOtherProjects(String string, Date date, Date date2) throws Exception {
        Element element = this.createSOAPDoc("getUserAllocationsForOtherProjects");
        element.addContent(this.createStringSOAPParamElt("sessionId", this.getSessionId()));
        element.addContent(this.createStringSOAPParamElt("siteId", this.getSiteId()));
        element.addContent(this.createStringSOAPParamElt("projetId", this.getProjectId()));
        element.addContent(this.createStringSOAPParamElt("dn", string));
        element.addContent(this.createDateTimeSOAPParamElt("from", date));
        element.addContent(this.createDateTimeSOAPParamElt("to", date2));
        Element element2 = this.callWebService(element);
        if (element2 != null && "getUserAllocationsForOtherProjectsReturn".equals(element2.getName())) {
            String string2 = element2.getText();
            ValueIntervals valueIntervals = ValueIntervals.loadFromString(string2);
            return valueIntervals;
        }
        throw new GanttChartException("No valid data in web service response");
    }
}

