/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.resourceeditor;

import com.triloggroup.gantt.Resource;
import com.triloggroup.project.ObjectRef;
import com.triloggroup.project.components.IProjectContext;
import com.triloggroup.project.components.IdentifiableObject;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.ICostRate;
import com.triloggroup.project.financial.VariableCost;
import com.triloggroup.project.schedule.datamodel.IPEProjectResource;
import java.util.Comparator;
import java.util.Date;

public class ProjectResource
extends Resource
implements IdentifiableObject,
IPEProjectResource {
    public static final ObjectType TYPE = new ObjectType("resource");
    private boolean registered;
    private boolean enabled;
    private String teamId;
    private String roleId;
    private CostRates costRates;
    private Date invitationDate;
    private String invitedBy;
    protected IProjectContext projectContext;
    public static final Comparator<ProjectResource> COMPARATOR_REGISTERED_FIRST = new Comparator<ProjectResource>(){

        @Override
        public int compare(ProjectResource projectResource, ProjectResource projectResource2) {
            if (projectResource == null) {
                return projectResource2 == null ? 0 : -1;
            }
            if (projectResource2 == null) {
                return 1;
            }
            if (projectResource.isRegistered() ^ projectResource2.isRegistered()) {
                return projectResource.isRegistered() ? -1 : 1;
            }
            return projectResource.getCn().compareToIgnoreCase(projectResource2.getCn());
        }
    };

    public ProjectResource(String string, String string2, String string3, IProjectContext iProjectContext) {
        super(string, string2, string3);
        this.projectContext = iProjectContext;
    }

    public void setCn(String string) {
        if (!this.dn.endsWith(",dc=new,dc=resourceseditor")) {
            throw new IllegalStateException("Can not rename an existing resource");
        }
        this.cn = string;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean bl) {
        this.registered = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String string) {
        this.teamId = string;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String string) {
        this.roleId = string;
    }

    public CostRates getCostRates() {
        return this.costRates;
    }

    public void setCostRates(CostRates costRates) {
        this.costRates = costRates;
    }

    public CostRate getDefaultCost() {
        return this.costRates == null ? null : (CostRate)this.costRates.defaultCost;
    }

    public VariableCost[] getVariableCosts() {
        return this.costRates == null ? null : this.costRates.variableCosts;
    }

    public boolean hasVariableCosts() {
        return this.costRates != null && this.costRates.variableCosts != null && this.costRates.variableCosts.length > 0;
    }

    public Date getInvitationDate() {
        return this.invitationDate;
    }

    public void setInvitationDate(Date date) {
        this.invitationDate = date;
    }

    public String getInvitedBy() {
        return this.invitedBy;
    }

    public void setInvitedBy(String string) {
        this.invitedBy = string;
    }

    public ObjectType getType() {
        return TYPE;
    }

    public String getUid() {
        return this.getDn();
    }

    public String getProjectId() {
        return this.projectContext.getProjectId();
    }

    public ObjectRef toObjectRef() {
        return new ObjectRef(null, this.getProjectId(), this.getUid());
    }

    public static boolean costRatesEquals(CostRates costRates, CostRates costRates2) {
        if (costRates == null) {
            return costRates2 == null;
        }
        if (costRates2 == null) {
            return false;
        }
        ICostRate iCostRate = costRates.defaultCost;
        ICostRate iCostRate2 = costRates2.defaultCost;
        if (iCostRate == null && iCostRate2 != null || iCostRate != null && !iCostRate.equals(iCostRate2)) {
            return false;
        }
        VariableCost[] variableCostArray = costRates.variableCosts;
        VariableCost[] variableCostArray2 = costRates2.variableCosts;
        if (variableCostArray == null) {
            return variableCostArray2 == null || variableCostArray2.length == 0;
        }
        if (variableCostArray2 == null) {
            return variableCostArray.length == 0;
        }
        if (variableCostArray.length != variableCostArray2.length) {
            return false;
        }
        for (int i = 0; i < variableCostArray.length; ++i) {
            if (!variableCostArray[i].from.equals(variableCostArray2[i].from)) {
                return false;
            }
            if (variableCostArray[i].costRate.equals(variableCostArray2[i].costRate)) continue;
            return false;
        }
        return true;
    }

    public static CostRates createDefaultCostRates() {
        return new CostRates(new CostRate(0.0, CostRateUnit.BY_HOUR), VariableCost.NO_VARIABLE_COSTS);
    }
}

