/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project.components.allocations;

import com.triloggroup.gantt.GanttCategoryAxis;
import com.triloggroup.gantt.GanttDataset;
import com.triloggroup.gantt.GanttDateAxis;
import com.triloggroup.gantt.ProjectModel;
import com.triloggroup.gantt.TGCategoryPlot;
import com.triloggroup.gantt.allocation.renderer.AllocationNodeRenderer;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.components.allocations.SimpleAllocationChartModel;
import com.triloggroup.project.components.allocations.SimpleAllocationsContext;
import com.triloggroup.project.components.allocations.SimpleAllocationsNode;
import com.triloggroup.project.components.ui.Workbench;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.time.DateRange;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class SimpleAllocationsChart
extends JComponent {
    private boolean crossProject = true;
    private SimpleAllocationsNode node;
    private ProjectModel model;
    private JFreeChart chart;
    private String message;

    public SimpleAllocationsChart(ProjectModel projectModel) {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setGanttModel(projectModel);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected void setGanttModel(ProjectModel projectModel) {
        this.model = projectModel;
        Date date = new Date();
        this.node = new SimpleAllocationsNode(date, date);
        TaskSeries taskSeries = new TaskSeries("SimpleAllocations");
        taskSeries.add((Task)this.node);
        GanttDataset ganttDataset = new GanttDataset();
        ganttDataset.add(taskSeries);
        GanttCategoryAxis ganttCategoryAxis = new GanttCategoryAxis();
        ganttCategoryAxis.setVisible(false);
        Locale locale = Workbench.get().getFormatLocale();
        TimeZone timeZone = Workbench.get().getTimeZone();
        GanttDateAxis ganttDateAxis = new GanttDateAxis(locale, timeZone);
        ganttDateAxis.setFixedDimension(14.0);
        ganttDateAxis.setTickMarksVisible(true);
        AllocationNodeRenderer allocationNodeRenderer = new AllocationNodeRenderer(false);
        allocationNodeRenderer.setBaseItemLabelsVisible(true);
        boolean bl = Workbench.get().getBooleanProperty("projexec.gantt.allocations.waveui");
        if (bl) {
            allocationNodeRenderer.setWaveui(true);
        }
        TGCategoryPlot tGCategoryPlot = new TGCategoryPlot(new SimpleAllocationChartModel(projectModel), (CategoryDataset)ganttDataset, ganttCategoryAxis, (ValueAxis)ganttDateAxis, (CategoryItemRenderer)allocationNodeRenderer);
        tGCategoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        AxisSpace axisSpace = new AxisSpace();
        axisSpace.setTop(ganttDateAxis.getFixedDimension());
        tGCategoryPlot.setFixedRangeAxisSpace(axisSpace);
        tGCategoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        this.chart = new JFreeChart((Plot)tGCategoryPlot);
        this.chart.setBackgroundPaint((Paint)UIManager.getColor("TableHeader.background"));
        this.chart.removeLegend();
        this.node.setNodeContext(new SimpleAllocationsContext(projectModel.getGlobalContext()));
    }

    public void setAllocations(ValueIntervals valueIntervals) {
        this.node.setIntervals(valueIntervals);
        if (this.message != null) {
            this.awtRepaint();
        }
    }

    public void setMessage(String string) {
        this.message = string;
        this.awtRepaint();
    }

    public String getMessage() {
        return this.message;
    }

    public void setPeriod(Date date, Date date2) {
        if (this.isCrossProject()) {
            this.node.setDuration(date, date2);
        }
        DateAxis dateAxis = (DateAxis)((CategoryPlot)this.chart.getPlot()).getRangeAxis();
        dateAxis.setRange((Range)new DateRange(date, date2));
        if (this.message != null) {
            this.awtRepaint();
        }
    }

    public void setCrossProject(boolean bl) {
        this.crossProject = bl;
        TGCategoryPlot tGCategoryPlot = (TGCategoryPlot)this.chart.getPlot();
        tGCategoryPlot.setDrawOffPeriods(!bl);
        if (!bl) {
            this.node.setDuration(this.model.getProjectStartDate(), this.model.getProjectEndDate());
        }
    }

    public boolean isCrossProject() {
        return this.crossProject;
    }

    private void awtRepaint() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SimpleAllocationsChart.this.repaint();
                }
            });
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.message != null) {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            graphics.drawString(this.message, 10, 15);
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        this.chart.draw((Graphics2D)graphics, (Rectangle2D)double_);
    }

    public Dimension getPreferredSize() {
        AxisSpace axisSpace = ((CategoryPlot)this.chart.getPlot()).getFixedRangeAxisSpace();
        RectangleInsets rectangleInsets = this.chart.getPlot().getInsets();
        Insets insets = this.getInsets();
        int n = 100;
        return new Dimension(n, (int)(18.0 + axisSpace.getBottom() + axisSpace.getTop() + rectangleInsets.getTop() + rectangleInsets.getBottom()) + insets.top + insets.bottom);
    }

    public int getValueAt(int n) {
        TGCategoryPlot tGCategoryPlot = (TGCategoryPlot)this.chart.getPlot();
        ValueAxis valueAxis = tGCategoryPlot.getRangeAxis();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        RectangleEdge rectangleEdge = tGCategoryPlot.getRangeAxisEdge();
        long l = (long)valueAxis.java2DToValue((double)n, (Rectangle2D)double_, rectangleEdge);
        int n2 = this.node.getIntervals().getValueAt(l);
        return n2;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getValueAt(mouseEvent.getX()) + "%";
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.x += 20;
        return point;
    }
}

