/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.project;

import com.triloggroup.util.UString;
import java.io.Serializable;

public class ProjectRef
implements Serializable {
    public final String siteId;
    public final String projectId;

    public ProjectRef(String string, String string2) {
        this.siteId = string;
        this.projectId = string2;
    }

    public String toString() {
        return "ProjectRef(" + this.siteId + ',' + this.projectId + ')';
    }

    public boolean equals(Object object) {
        return object instanceof ProjectRef && UString.equals(this.siteId, ((ProjectRef)object).siteId) && UString.equals(this.projectId, ((ProjectRef)object).projectId);
    }

    public int hashCode() {
        return (this.siteId + this.projectId).hashCode();
    }

    public static String[] toProjectIds(ProjectRef[] projectRefArray) {
        if (projectRefArray != null) {
            String[] stringArray = new String[projectRefArray.length];
            for (int i = 0; i < projectRefArray.length; ++i) {
                stringArray[i] = projectRefArray[i].projectId;
            }
            return stringArray;
        }
        return null;
    }

    public static String[] toSiteIdsPipeProjectIds(ProjectRef[] projectRefArray) {
        if (projectRefArray != null) {
            String[] stringArray = new String[projectRefArray.length];
            for (int i = 0; i < projectRefArray.length; ++i) {
                stringArray[i] = projectRefArray[i].siteId + "|" + projectRefArray[i].projectId;
            }
            return stringArray;
        }
        return null;
    }

    public static ProjectRef[] fromSiteIdsPipeProjectIds(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ProjectRef[] projectRefArray = new ProjectRef[stringArray.length];
        for (int i = 0; i < projectRefArray.length; ++i) {
            String[] stringArray2 = UString.splitString(stringArray[i], '|');
            projectRefArray[i] = new ProjectRef(stringArray2[0], stringArray2[1]);
        }
        return projectRefArray;
    }

    public static ProjectRef[] fromSiteIdAndProjectIds(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ProjectRef[] projectRefArray = new ProjectRef[stringArray.length];
        for (int i = 0; i < projectRefArray.length; ++i) {
            projectRefArray[i] = new ProjectRef(string, stringArray[i]);
        }
        return projectRefArray;
    }
}

