/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.util;

import com.triloggroup.gantt.util.Interval;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntervals<T extends Interval>
implements Cloneable {
    protected static final String TOSTRING_PREFIX = "Intervals(";
    protected static final Comparator<Interval> intervalStartComparator = new Comparator<Interval>(){

        @Override
        public int compare(Interval interval, Interval interval2) {
            if (interval.start != interval2.start) {
                return interval.start > interval2.start ? 1 : -1;
            }
            return 0;
        }
    };
    protected ArrayList<T> list = new ArrayList();

    protected AbstractIntervals() {
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
    }

    public long getFirstIntervalStart() {
        Interval interval = (Interval)this.list.get(0);
        return interval.start;
    }

    public long getLastIntervalEnd() {
        Interval interval = (Interval)this.list.get(this.list.size() - 1);
        return interval.end;
    }

    public List<T> getIntervals() {
        return Collections.unmodifiableList(this.list);
    }

    public int size() {
        return this.list.size();
    }

    public T get(int n) {
        return (T)((Interval)this.list.get(n));
    }

    public T getIntervalAt(long l) {
        if (this.isEmpty()) {
            return null;
        }
        if (l < this.getFirstIntervalStart()) {
            return null;
        }
        if (l >= this.getLastIntervalEnd()) {
            return null;
        }
        int n = Collections.binarySearch(this.list, new Interval(l, l + 1L), intervalStartComparator);
        if (n >= 0) {
            return (T)((Interval)this.list.get(n));
        }
        if ((n = -n - 2) < 0) {
            return null;
        }
        Interval interval = (Interval)this.list.get(n);
        if (interval.end > l) {
            return (T)interval;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TOSTRING_PREFIX);
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.list.get(i));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toStringAsDate() {
        return this.toStringAsDate(null);
    }

    public String toStringAsDate(DateFormat dateFormat) {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(3, 2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TOSTRING_PREFIX);
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",  ");
            }
            stringBuilder.append(((Interval)this.list.get(i)).toStringAsDate(dateFormat));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String toStringAsDate(AbstractIntervals<?> abstractIntervals) {
        return abstractIntervals == null ? null : abstractIntervals.toStringAsDate();
    }

    public Object clone() {
        try {
            AbstractIntervals abstractIntervals = (AbstractIntervals)super.clone();
            abstractIntervals.list = (ArrayList)this.list.clone();
            return abstractIntervals;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }
}

