/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.renderer;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.data.category.CategoryDataset;

public class TGEntity
extends CategoryItemEntity {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_TASK = 1;
    public static final int TYPE_WBS = 2;
    public static final int TYPE_PREDECESSOR = 3;
    public static final int ZONE_DEFAULT = 0;
    public static final int ZONE_COMPLETION = 16;
    public static final int ZONE_START = 32;
    public static final int ZONE_END = 48;
    public static final int ZONE_PREDECESSOR_START = 33;
    public static final int ZONE_PREDECESSOR_FINISH = 49;
    public static final int ZONE_PREDECESSOR_MASK = 1;
    private static final int PRED_AREA_WIDTH = 8;
    private static final int AREA_HALF_WIDTH = 8;
    private static final int ZONE_HIGHLIGHT_WIDTH = 10;
    private final Shape highlightShape;
    private final int entityType;
    private final TGNode node;
    private final TaskPredecessor predecessor;

    protected TGEntity(CategoryDataset categoryDataset, int n, int n2, TGNode tGNode, TaskPredecessor taskPredecessor, Shape shape, Shape shape2, int n3) {
        super(shape, null, null, categoryDataset, categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2));
        this.highlightShape = shape2;
        this.entityType = n3;
        this.node = tGNode;
        this.predecessor = taskPredecessor;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public TGNode getNode() {
        return this.node;
    }

    public TaskPredecessor getPredecessor() {
        return this.predecessor;
    }

    public int getZone(int n, int n2) {
        if (this.entityType != 1) {
            return 0;
        }
        GanttTask ganttTask = (GanttTask)this.node;
        Rectangle rectangle = this.getArea().getBounds();
        int n3 = n - rectangle.x;
        int n4 = n2 - rectangle.y;
        if (n3 < 8) {
            return 33;
        }
        if (rectangle.width - n3 < 8) {
            return 49;
        }
        if (ganttTask.isMilestone()) {
            return 0;
        }
        double d = 0.3;
        if ((double)n4 >= (double)rectangle.height * d && (double)n4 <= (double)rectangle.height * (1.0 - d)) {
            double d2;
            double d3 = 0.0;
            Double d4 = ganttTask.getPercentComplete();
            if (d4 != null && d4 >= 0.0) {
                d3 = d4;
            }
            if ((double)n3 > (d2 = (1.0 * (double)rectangle.width - 16.0) * d3 + 8.0) - 8.0 && (double)n3 < d2 + 8.0) {
                return 16;
            }
        }
        if (rectangle.width < 32) {
            return 0;
        }
        if (n3 < 16) {
            return 32;
        }
        if (n3 > rectangle.width - 8 - 8) {
            return 48;
        }
        return 0;
    }

    public void paintHighlight(Graphics2D graphics2D) {
        if (this.entityType == 3) {
            return;
        }
        graphics2D.setColor(Color.WHITE);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(this.highlightShape);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(stroke);
        graphics2D.draw(this.highlightShape);
    }

    public void paintZoneHighlight(Graphics2D graphics2D, int n) {
        int n2;
        if (this.entityType == 3) {
            return;
        }
        int n3 = 5;
        Rectangle rectangle = this.highlightShape.getBounds();
        int n4 = rectangle.y + (rectangle.height - 10) / 2;
        switch (n) {
            case 32: 
            case 33: {
                n2 = rectangle.x - n3;
                break;
            }
            case 48: 
            case 49: {
                n2 = rectangle.x + rectangle.width - n3;
                break;
            }
            default: {
                n2 = rectangle.x + (rectangle.width - 10) / 2;
            }
        }
        graphics2D.setColor(new Color(190, 190, 250));
        graphics2D.drawOval(n2, n4, 10, 10);
        graphics2D.drawLine(n2 - 2, n4 + n3, n2 + 2, n4 + n3);
        graphics2D.drawLine(n2 + 10 - 2, n4 + n3, n2 + 10 + 2, n4 + n3);
        graphics2D.drawLine(n2 + n3, n4 - 2, n2 + n3, n4 + 2);
        graphics2D.drawLine(n2 + n3, n4 + 10 - 2, n2 + n3, n4 + 10 + 2);
    }

    public static TGEntity create(CategoryDataset categoryDataset, int n, int n2, GanttTask ganttTask, Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - 8.0, rectangle2D.getY(), rectangle2D.getWidth() + 16.0, rectangle2D.getHeight());
        Rectangle rectangle = rectangle2D.getBounds();
        return new TGEntity(categoryDataset, n, n2, ganttTask, null, double_, rectangle, 1);
    }

    public static TGEntity createMilestone(CategoryDataset categoryDataset, int n, int n2, GanttTask ganttTask, Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() - 8.0, rectangle2D.getY(), rectangle2D.getWidth() + 16.0, rectangle2D.getHeight());
        return new TGEntity(categoryDataset, n, n2, ganttTask, null, double_, shape, 1);
    }

    public static TGEntity create(CategoryDataset categoryDataset, int n, int n2, GanttWBS ganttWBS, Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        return new TGEntity(categoryDataset, n, n2, ganttWBS, null, rectangle2D, shape, 2);
    }

    public static TGEntity createPredecessor(CategoryDataset categoryDataset, int n, int n2, TaskPredecessor taskPredecessor, Shape shape) {
        return new TGEntity(categoryDataset, n, n2, null, taskPredecessor, shape, shape, 3);
    }
}

