/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app.dialog;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.ui.LineWrapTextArea;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDExpandableSection;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppGanttChart;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.ui.DoubleTextField;
import com.triloggroup.util.NLSBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class GanttNodeCostSection
extends WDExpandableSection
implements ActionListener {
    private GanttNode node;
    DoubleTextField tfAdditionalCost;
    DoubleTextField tfActualAdditionalCost;
    private boolean actualAdditionalCostSpecified;
    private WDButton btActualAdditionalCost;
    JTextArea additionCostDescriptionTA;

    GanttNodeCostSection(PEAppGanttChart pEAppGanttChart, GanttNode ganttNode, NLSBundle nLSBundle) {
        super(nLSBundle.getString("costs"), new JPanel(new GridBagLayout()));
        this.node = ganttNode;
        FinancialSettings financialSettings = pEAppGanttChart.getModel().getProjectModel(ganttNode.getProjectId()).getProjectContext().getFinancialSettings();
        DecimalFormat decimalFormat = FormatUtil.getCostFormat(pEAppGanttChart.getLocale(), financialSettings);
        this.tfAdditionalCost = new DoubleTextField(decimalFormat);
        this.tfAdditionalCost.setValue(9.999999999E9);
        Dimension dimension = this.tfAdditionalCost.getPreferredSize();
        this.tfAdditionalCost.setPreferredSize(dimension);
        this.tfAdditionalCost.setValue(null);
        Insets insets = new Insets(5, 0, 0, 0);
        Insets insets2 = new Insets(5, 0, 0, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, insets2, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, -1, 1, 1, 0.25, 0.0, 17, 2, insets2, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        String string = nLSBundle.getString("AdditionalCost");
        if (financialSettings != null) {
            string = string + " (" + financialSettings.getCurrencySymbol() + ')';
        }
        JLabel jLabel = new JLabel(string);
        this.content.add((Component)jLabel, gridBagConstraints);
        this.content.add((Component)this.tfAdditionalCost, gridBagConstraints2);
        JLabel jLabel2 = new JLabel(nLSBundle.getString("ActualAdditionalCost"));
        this.content.add((Component)jLabel2, gridBagConstraints);
        this.tfActualAdditionalCost = new DoubleTextField(decimalFormat);
        this.btActualAdditionalCost = new WDButton();
        this.btActualAdditionalCost.addActionListener(this);
        this.content.add((Component)this.tfActualAdditionalCost, gridBagConstraints2);
        this.content.add((Component)this.btActualAdditionalCost, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        JLabel jLabel3 = new JLabel(nLSBundle.getString("AdditionalCostDescription"));
        this.content.add((Component)jLabel3, gridBagConstraints3);
        this.additionCostDescriptionTA = new LineWrapTextArea();
        WDUtil.setDocumentWithMaxLength(this.additionCostDescriptionTA, 512);
        this.content.add((Component)this.additionCostDescriptionTA, gridBagConstraints3);
    }

    protected void updateNodefromFields() throws ChangeException {
        if (!this.tfAdditionalCost.isEditValid()) {
            throw new ChangeException(null, "additionalcost");
        }
        double d = this.tfAdditionalCost.getDoubleValue();
        this.node.setAdditionalCost(d);
        if (this.actualAdditionalCostSpecified) {
            if (!this.tfActualAdditionalCost.isEditValid()) {
                throw new ChangeException(null, "actualadditionalcost");
            }
            this.node.setSpecifiedActualAdditionalCost(this.tfActualAdditionalCost.getValue());
        } else {
            this.node.setSpecifiedActualAdditionalCost(null);
        }
        String string = this.additionCostDescriptionTA.getText();
        String string2 = Workbench.checkInvalidCharacters(string);
        if (string2 != null) {
            throw new ChangeException(string2, "additionalcostdescription");
        }
        this.node.setAdditionalCostDescription(string);
    }

    protected void updateFieldsFromNode() {
        this.tfAdditionalCost.setValue(this.node.getAdditionalCost());
        if (this.node.getSpecifiedActualAdditionalCost() == null) {
            this.setActualCostComputed();
        } else {
            this.tfActualAdditionalCost.setValue(this.node.getSpecifiedActualAdditionalCost());
            this.setActualCostSpecified();
        }
        this.additionCostDescriptionTA.setText(this.node.getAdditionalCostDescription());
    }

    protected void setEditable(boolean bl) {
        this.tfAdditionalCost.setEditable(bl);
        this.tfActualAdditionalCost.setEditable(bl && this.actualAdditionalCostSpecified);
        this.btActualAdditionalCost.setVisible(bl);
        this.additionCostDescriptionTA.setEditable(bl);
    }

    private boolean isEditable() {
        return this.tfAdditionalCost.isEditable();
    }

    private void setActualCostComputed() {
        this.actualAdditionalCostSpecified = false;
        this.tfActualAdditionalCost.setValue(this.getComputedActualCost(this.node));
        Font font = this.tfActualAdditionalCost.getFont().deriveFont(2);
        this.tfActualAdditionalCost.setFont(font);
        this.tfActualAdditionalCost.setEditable(false);
        this.btActualAdditionalCost.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkSpecify") + ' ');
    }

    private void setActualCostSpecified() {
        this.actualAdditionalCostSpecified = true;
        Font font = this.tfActualAdditionalCost.getFont().deriveFont(0);
        this.tfActualAdditionalCost.setFont(font);
        if (this.isEditable()) {
            this.tfActualAdditionalCost.setEditable(true);
        }
        this.btActualAdditionalCost.setText(' ' + AppGanttChart.NLS_BUNDLE.getString("remainWorkAuto") + ' ');
    }

    private double getComputedActualCost(GanttNode ganttNode) {
        if (ganttNode.isPending()) {
            return 0.0;
        }
        return this.tfAdditionalCost.getDoubleValue();
    }

    protected void registerListeners() {
        this.tfAdditionalCost.addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!GanttNodeCostSection.this.actualAdditionalCostSpecified) {
                    GanttNodeCostSection.this.tfActualAdditionalCost.setValue(GanttNodeCostSection.this.tfAdditionalCost.getValue());
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btActualAdditionalCost) {
            if (this.actualAdditionalCostSpecified) {
                this.setActualCostComputed();
            } else {
                this.setActualCostSpecified();
                this.tfActualAdditionalCost.selectAll();
                this.tfActualAdditionalCost.requestFocusInWindow();
            }
        }
    }
}

