/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.applet.IJSCallBack;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppGanttChart;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PEScriptGanttApplet
extends GanttAppletBase {
    private static final String WINDOW_TITLE = "ProjExec Gantt";
    private URL touchSessionURL = null;
    private int touchSessionInterval = -1;
    private boolean ganttInitializied = false;
    private String siteId;
    private String projectId;
    private JDialog window;

    public void init() {
        System.out.println(this.getClass().getName());
        try {
            super.init();
            String string = this.getParameter("touchSessionURL");
            if (!UString.isEmpty(string)) {
                try {
                    this.touchSessionURL = new URL(string);
                    String string2 = this.getParameter("touchSessionInterval");
                    this.touchSessionInterval = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    this.touchSessionInterval = 10;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            System.out.println("ProjExec Script Gantt Applet loaded");
        }
        catch (Exception exception) {
            System.out.println("Unable to load ProjExec Script Gantt Applet");
            exception.printStackTrace();
        }
    }

    protected void createLoadingGUI() {
        this.setBackground(Color.WHITE);
    }

    public void showGantt(final String string, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!string.equals(PEScriptGanttApplet.this.siteId) || !string2.equals(PEScriptGanttApplet.this.projectId)) {
                            PEScriptGanttApplet.this.hideGantt(true);
                        }
                        PEScriptGanttApplet.this.callBack = null;
                        PEScriptGanttApplet.this.doShowGantt(string, string2, null);
                    }
                });
                return null;
            }
        });
    }

    public void callJS(String string, IJSCallBack iJSCallBack) {
        if (iJSCallBack != null) {
            iJSCallBack = new ScriptAppletCallBack(this.siteId, this.projectId, iJSCallBack);
        }
        super.callJS(string, iJSCallBack);
    }

    public void callBack(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (PEScriptGanttApplet.this.callBack != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ScriptAppletCallBack scriptAppletCallBack = (ScriptAppletCallBack)PEScriptGanttApplet.this.callBack;
                            PEScriptGanttApplet.this.doShowGantt(scriptAppletCallBack.siteId, scriptAppletCallBack.projectId, string);
                        }
                    });
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowGantt(String string, String string2, final String string3) {
        if (UString.isEmpty(string) || UString.isEmpty(string2)) {
            throw new IllegalArgumentException("Invalid siteId/projectId: " + string + '/' + string2);
        }
        Accessible accessible = this;
        synchronized (accessible) {
            if (this.ganttInitializied) {
                if (!string.equals(this.siteId) || !string2.equals(this.projectId)) {
                    throw new IllegalStateException("It it not possible to have multiple Gantt Chart simultaneously");
                }
                if (this.window != null) {
                    if (this.callBack != null) {
                        this.callBack.actionPerformed(string3);
                    }
                    if (!this.window.isVisible()) {
                        this.window.setVisible(true);
                    }
                }
                return;
            }
            this.ganttInitializied = true;
            this.siteId = string;
            this.projectId = string2;
        }
        this.window = new JDialog((Frame)null, WINDOW_TITLE, true);
        accessible = WDUtil.getIcon("pe16x16.jpg");
        if (accessible != null) {
            WDUtil.setDialogIcon(this.window, ((ImageIcon)accessible).getImage());
        }
        this.window.setSize(900, 600);
        this.window.setLocationRelativeTo(null);
        this.window.setDefaultCloseOperation(0);
        this.window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PEScriptGanttApplet.this.hideGantt();
            }
        });
        ImageIcon imageIcon = WDUtil.getIcon("loading.gif");
        JLabel jLabel = new JLabel(imageIcon);
        this.window.getContentPane().add((Component)jLabel, "Center");
        new Thread(){

            public void run() {
                PEScriptGanttApplet.this.showGantt2(string3);
            }
        }.start();
        this.window.setVisible(true);
    }

    private void showGantt2(final String string) {
        try {
            PEAppGanttChart pEAppGanttChart = new PEAppGanttChart();
            PEAppGanttChartModel pEAppGanttChartModel = new PEAppGanttChartModel(this.projectId, this.siteId);
            pEAppGanttChartModel.init(this, this.getServerBaseUrl(), this.getParameter("wsSessionId"), new Date());
            pEAppGanttChart.setModel(pEAppGanttChartModel);
            this.setGanttChart(pEAppGanttChart);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEScriptGanttApplet.this.showGantt3(string);
                }
            });
            pEAppGanttChart.initTouchSessionThread(this.touchSessionInterval, this.touchSessionURL);
        }
        catch (Exception exception) {
            System.out.println("Error during ProjExec Script Gantt Initialization");
            exception.printStackTrace();
            this.showErrorDialog();
        }
    }

    private void showGantt3(final String string) {
        try {
            String string2 = this.getGanttChart().getModel().getMainProjectModel().getProjectContext().getProjectName();
            String string3 = "ProjExec Gantt - " + string2;
            this.window.setTitle(string3);
            GanttWorkbenchPage ganttWorkbenchPage = this.createGanttWorkbenchPage(GanttWorkbenchPage.Mode.EMBEDDED_APPLET);
            this.window.getContentPane().removeAll();
            this.window.getContentPane().add(ganttWorkbenchPage.getComponent());
            this.window.getContentPane().validate();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEScriptGanttApplet.this.getGanttChart().chartMadeVisible();
                    if (PEScriptGanttApplet.this.callBack != null) {
                        System.out.println("Call callback");
                        PEScriptGanttApplet.this.callBack.actionPerformed(string);
                    }
                }
            });
        }
        catch (Exception exception) {
            System.out.println("Error during ProjExec Script Gantt Initialization");
            exception.printStackTrace();
            this.showErrorDialog();
        }
    }

    public void hideFullScreen(boolean bl) {
        this.hideGantt(bl);
    }

    public synchronized void hideGantt() {
        this.hideGantt(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void hideGantt(boolean bl) {
        block10: {
            PEScriptGanttApplet pEScriptGanttApplet = this;
            synchronized (pEScriptGanttApplet) {
                block9: {
                    AppGanttChart appGanttChart = this.getGanttChart();
                    if (!this.ganttInitializied || appGanttChart == null) {
                        return;
                    }
                    try {
                        boolean bl2;
                        if (appGanttChart.getModel().getChangeManager().canUndo() && (bl2 = WDDialog.showYesNoDialog(appGanttChart.getView(), AppGanttChart.NLS_BUNDLE.getString("saveBeforeQuitQuestion")))) {
                            AsyncActionRunner asyncActionRunner = appGanttChart.saveChanges();
                            asyncActionRunner.waitUntilDone();
                        }
                        appGanttChart.unload();
                        if (!bl) break block9;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    PEScriptGanttApplet.this.window.dispose();
                                }
                            });
                            this.setGanttChart(null);
                            this.ganttInitializied = false;
                            this.siteId = null;
                            this.projectId = null;
                        } else {
                            this.window.setVisible(false);
                        }
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    this.setGanttChart(null);
                    this.ganttInitializied = false;
                    this.siteId = null;
                    this.projectId = null;
                    break block10;
                }
                this.window.setVisible(false);
            }
        }
    }

    protected void showErrorDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEScriptGanttApplet.this.showErrorDialog();
                }
            });
            return;
        }
        String string = AppGanttChart.NLS_BUNDLE != null ? AppGanttChart.NLS_BUNDLE.getString("gantt_error") : "<html>An unexpected error occured.<br>Please try again later or contact ProjExec support.</html>";
        JOptionPane.showMessageDialog(this.getContentPane(), string, "Gantt", 0);
    }

    protected void internalBeforeUnload() {
        try {
            this.hideGantt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class ScriptAppletCallBack
    implements IJSCallBack {
        private final String siteId;
        private final String projectId;
        private final IJSCallBack source;

        private ScriptAppletCallBack(String string, String string2, IJSCallBack iJSCallBack) {
            this.siteId = string;
            this.projectId = string2;
            this.source = iJSCallBack;
        }

        public void actionPerformed(String string) {
            this.source.actionPerformed(string);
        }

        public void actionCancelled() {
            this.source.actionCancelled();
        }
    }
}

