/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.pe.app.PEAppGanttChart;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PEMobileGanttApplet
extends GanttAppletBase {
    private String siteId;
    private String projectId;
    private URL touchSessionURL = null;
    private int touchSessionInterval = -1;
    private boolean ganttShowing = false;
    private JFrame frame;

    public void init() {
        try {
            super.init();
            this.siteId = this.getParameter("siteId");
            this.projectId = this.getParameter("projectId");
            String string = this.getParameter("touchSessionURL");
            if (!UString.isEmpty(string)) {
                try {
                    this.touchSessionURL = new URL(string);
                    String string2 = this.getParameter("touchSessionInterval");
                    this.touchSessionInterval = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    this.touchSessionInterval = 10;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEMobileGanttApplet.this.createDefaultUI();
                }
            });
            System.out.println("ProjExec Mobile Gantt Applet loaded");
        }
        catch (Exception exception) {
            System.out.println("Unable to load ProjExec Mobile Gantt Applet");
            exception.printStackTrace();
            this.getContentPane().removeAll();
            this.setBackground(Color.WHITE);
        }
    }

    private void createDefaultUI() {
        ImageIcon imageIcon = WDUtil.getIcon("gantt.jpg");
        JButton jButton = new JButton(imageIcon);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PEMobileGanttApplet.this.showGantt();
            }
        });
        this.getContentPane().removeAll();
        this.getContentPane().add(jButton);
    }

    private synchronized void showGantt() {
        if (this.ganttShowing) {
            if (this.frame != null) {
                this.frame.toFront();
            }
            return;
        }
        this.ganttShowing = true;
        ImageIcon imageIcon = WDUtil.getIcon("loading.gif");
        ((JButton)this.getContentPane().getComponent(0)).setIcon(imageIcon);
        new Thread(){

            public void run() {
                PEMobileGanttApplet.this.showGantt2();
            }
        }.start();
    }

    private void showGantt2() {
        try {
            PEAppGanttChart pEAppGanttChart = new PEAppGanttChart();
            PEAppGanttChartModel pEAppGanttChartModel = new PEAppGanttChartModel(this.projectId, this.siteId);
            pEAppGanttChartModel.init(this, this.getServerBaseUrl(), this.getParameter("wsSessionId"), new Date());
            pEAppGanttChart.setModel(pEAppGanttChartModel);
            this.setGanttChart(pEAppGanttChart);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEMobileGanttApplet.this.showGantt3();
                }
            });
            pEAppGanttChart.initTouchSessionThread(this.touchSessionInterval, this.touchSessionURL);
        }
        catch (Exception exception) {
            System.out.println("Error during ProjExec Mobile Gantt Initialization");
            exception.printStackTrace();
            this.showErrorDialog();
        }
    }

    private void showGantt3() {
        try {
            String string = this.getGanttChart().getModel().getMainProjectModel().getProjectContext().getProjectName();
            String string2 = "ProjExec Gantt - " + string;
            this.frame = new JFrame(string2);
            ImageIcon imageIcon = WDUtil.getIcon("pe16x16.jpg");
            if (imageIcon != null) {
                this.frame.setIconImage(imageIcon.getImage());
            }
            GanttWorkbenchPage ganttWorkbenchPage = this.createGanttWorkbenchPage(GanttWorkbenchPage.Mode.EMBEDDED_APPLET);
            this.frame.getContentPane().add(ganttWorkbenchPage.getComponent());
            this.frame.setSize(900, 600);
            this.frame.setLocationRelativeTo(null);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PEMobileGanttApplet.this.hideGantt();
                }
            });
            this.frame.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEMobileGanttApplet.this.getGanttChart().chartMadeVisible();
                }
            });
            ImageIcon imageIcon2 = WDUtil.getIcon("gantt.jpg");
            ((JButton)this.getContentPane().getComponent(0)).setIcon(imageIcon2);
        }
        catch (Exception exception) {
            System.out.println("Error during ProjExec Mobile Gantt Initialization");
            exception.printStackTrace();
            this.showErrorDialog();
        }
    }

    private synchronized void hideGantt() {
        boolean bl;
        if (!this.ganttShowing) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(){

                public void run() {
                    PEMobileGanttApplet.this.hideGantt();
                }
            }.start();
            return;
        }
        AppGanttChart appGanttChart = this.getGanttChart();
        if (this.ganttShowing && appGanttChart.getModel().getChangeManager().canUndo() && (bl = WDDialog.showYesNoDialog(appGanttChart.getView(), AppGanttChart.NLS_BUNDLE.getString("saveBeforeQuitQuestion")))) {
            AsyncActionRunner asyncActionRunner = appGanttChart.saveChanges();
            asyncActionRunner.waitUntilDone();
        }
        appGanttChart.unload();
        this.frame.dispose();
        this.setGanttChart(null);
        this.ganttShowing = false;
        ((JButton)this.getContentPane().getComponent(0)).setIcon(WDUtil.getIcon("gantt.jpg"));
    }

    protected void showErrorDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEMobileGanttApplet.this.showErrorDialog();
                }
            });
            return;
        }
        String string = AppGanttChart.NLS_BUNDLE != null ? AppGanttChart.NLS_BUNDLE.getString("gantt_error") : "<html>An unexpected error occured.<br>Please try again later or contact ProjExec support.</html>";
        JOptionPane.showMessageDialog(this.getContentPane(), string, "Gantt", 0);
    }

    protected void internalBeforeUnload() {
        try {
            this.hideGantt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

