/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.flowbuilder.util.xml.JDOMUtil;
import com.flowbuilder.util.xml.XMLException;
import com.triloggroup.gantt.GanttChartException;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.GlobalContext;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.FieldModification;
import com.triloggroup.gantt.pe.app.AppBackwardScheduler;
import com.triloggroup.gantt.pe.app.AppFinancialComputation;
import com.triloggroup.gantt.pe.app.AppScheduleComputation;
import com.triloggroup.gantt.pe.app.CalendarAccessor;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.gantt.pe.app.PEAppGlobalContext;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.project.Role;
import com.triloggroup.project.components.IProjectResourceModel;
import com.triloggroup.project.components.resourceeditor.CostRate;
import com.triloggroup.project.components.resourceeditor.CostRateUnit;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.components.resourceeditor.ProjectRole;
import com.triloggroup.project.components.resourceeditor.ProjectTeam;
import com.triloggroup.project.components.resourceeditor.change.DeleteResourceChange;
import com.triloggroup.project.components.resourceeditor.change.ReplaceOptions;
import com.triloggroup.project.components.resourceeditor.change.ReplaceResourceChange;
import com.triloggroup.project.financial.CostRates;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.financial.VariableCost;
import com.triloggroup.project.schedule.CalendarUtil;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.UString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdom.Element;

public class PEAppProjectModel
extends AppProjectModel
implements IProjectResourceModel {
    private CalendarAccessor calendarAccessor;
    private AppScheduleComputation scheduleComputation;
    private AppBackwardScheduler backwardScheduler;
    private boolean scheduleEditable;
    private boolean resourcesEditable;
    private int timesheetLevel;
    private HashMap<String, ProjectResource> resources = new HashMap();
    private HashMap<String, Resource> nonePrjResources = new HashMap();
    private HashMap<String, ProjectRole> roles = new HashMap();
    private HashMap<String, ProjectTeam> teams = new HashMap();
    private PEAppGanttChartModel chartModel;
    private static String[] TASK_FIELDS_IMPACTED_BACKWARD_SCHEDULE = new String[]{"startDate", "endDate", "actualstart", "actualfinish", "schedulingmode", "status", "taskPredecessors", "taskResources", "work", "durationInHours"};

    public PEAppProjectModel(GlobalContext globalContext, String string, PEAppGanttChartModel pEAppGanttChartModel) {
        super(globalContext, string);
        this.scheduleComputation = new AppScheduleComputation(this);
        this.chartModel = pEAppGanttChartModel;
    }

    public PEAppGlobalContext getGlobalContext() {
        return (PEAppGlobalContext)this.globalContext;
    }

    protected ProjectContext createProjectContext(String string) {
        PEAppProjectContext pEAppProjectContext = new PEAppProjectContext(this.globalContext, string);
        pEAppProjectContext.setModel(this);
        return pEAppProjectContext;
    }

    public PEAppProjectContext getProjectContext() {
        return (PEAppProjectContext)this.prjContext;
    }

    public String getProjectName() {
        return this.getProjectContext().getProjectName();
    }

    public int getProjectSchedulingMode() {
        return this.getProjectContext().getSchedulingMode();
    }

    public int getProjectHandlePredConstraint() {
        return this.getProjectContext().getHandlePredConstraint();
    }

    public boolean isWorkDistributionModeShortest() {
        return this.getProjectContext().isWorkDistributionModeShortest();
    }

    public double getDurationInHours(double d, TimeUnit timeUnit) throws Exception {
        return this.getScheduleComputation().getDurationInHours(d, timeUnit.getCode());
    }

    public double getDurationBetweenDates(Date date, Date date2, ScheduleCalendar scheduleCalendar, int n) throws Exception {
        long l = CalendarUtil.getDurationInMs(date, date2, scheduleCalendar);
        return this.getScheduleComputation().getDurationInDurationFormat(l, n);
    }

    public CalendarAccessor getCalendarAccessor() {
        return this.calendarAccessor;
    }

    public boolean isResourceEditable() {
        return this.resourcesEditable;
    }

    public ScheduleCalendar getProjectCalendar() {
        return this.calendarAccessor.getProjectCalendar();
    }

    public AppScheduleComputation getScheduleComputation() {
        return this.scheduleComputation;
    }

    public String getProjectStatus() {
        return this.getProjectContext().getProjectStatus();
    }

    public double getProjectHoursPerDay() {
        return this.getProjectContext().getHoursPerDay();
    }

    public double getProjectHoursPerWeek() {
        return this.getProjectContext().getHoursPerWeek();
    }

    public double getProjectHoursPerMonth() {
        return this.getProjectContext().getHoursPerMonth();
    }

    public int getTimesheetLevel() {
        return this.timesheetLevel;
    }

    public boolean isDefaultDurationDriven() {
        return this.getProjectSchedulingMode() == 1;
    }

    public boolean updateFinancial() {
        if (!this.getGlobalContext().hasFinancialModule()) {
            return false;
        }
        new AppFinancialComputation(this).process();
        AppProjectModel appProjectModel = this.getParentProjectModel();
        if (appProjectModel != null) {
            appProjectModel.updateFinancial();
        }
        return true;
    }

    public void init(Element element) throws GanttChartException {
        this.resetTaskSeriesForInit();
        try {
            Element element2;
            FinancialSettings financialSettings;
            Element element3;
            Element element4 = element.getChild("Thresold");
            double d = 0.1;
            double d2 = 0.2;
            if (element4 != null) {
                d = JDOMUtil.getDouble(element4, "Warning");
                if (d <= 0.0) {
                    d = 0.1;
                }
                if ((d2 = JDOMUtil.getDouble(element4, "Critical")) <= 0.0) {
                    d2 = 0.2;
                }
            }
            this.prjContext.init(d, d2);
            this.getProjectContext().setIsCurrentUserPM(JDOMUtil.getBoolean(element, "isPM"));
            boolean bl = JDOMUtil.getBoolean(element, "FinancialsModule");
            boolean bl2 = false;
            if (bl) {
                bl2 = this.getGlobalContext().isEditable() && JDOMUtil.getBoolean(element, "FinancialsEditAccess");
                element3 = element.getChild("financial");
                financialSettings = new FinancialSettings(this.getSiteId(), this.getProjectId());
                financialSettings.initFromFinancialNode(element3);
                this.getGlobalContext().clearFinancialData(this.getProjectId());
            } else {
                financialSettings = null;
                bl2 = false;
            }
            this.getProjectContext().setFinancialSettings(financialSettings);
            this.getProjectContext().setFinancialEditable(bl2);
            this.timesheetLevel = JDOMUtil.getInteger(element, "TimesheetLevel");
            this.scheduleEditable = this.getGlobalContext().isEditable() && JDOMUtil.getBoolean(element, "EditAccess");
            this.resourcesEditable = this.scheduleEditable && JDOMUtil.getBoolean(element, "ResourcesEditAccess");
            this.isAutomaticReschedule = JDOMUtil.getBoolean(element, "AutomaticReschedule");
            this.getProjectContext().setSchedulingMode(JDOMUtil.getInteger(element, "ProjectSchedulingMode"));
            this.getProjectContext().setHandlePredConstraint(JDOMUtil.getInteger(element, "ProjectHandlePredConstraint"));
            this.getProjectContext().setWorkDistributionModeShortest(JDOMUtil.getBoolean(element, "WorkDistributionModeShortest", false));
            this.getProjectContext().setProjectStatus(element.getChildText("ProjectStatus"));
            this.getProjectContext().setProjectName(element.getChildText("ProjectName"));
            element3 = element.getChild("ProjectHours");
            if (element3 != null) {
                this.getProjectContext().setHoursPerDay(JDOMUtil.getDouble(element3, "PerDay"));
                this.getProjectContext().setHoursPerWeek(JDOMUtil.getDouble(element3, "PerWeek"));
                this.getProjectContext().setHoursPerMonth(JDOMUtil.getDouble(element3, "PerMonth"));
            }
            if ((element2 = element.getChild("Resources")) != null) {
                this.initResources(element2);
            }
            this.initData(element);
            if (this.allNodes.isEmpty()) {
                this.getGlobalContext().setEditable(false);
            }
            String string = element.getChildText("ActualWorkComputationMode");
            this.prjContext.setActualWorkComputationModeTimesheet("timesheet".equalsIgnoreCase(string));
            this.prjContext.setShowPercentComplete(JDOMUtil.getBoolean(element, "ShowPercentComplete"));
            this.prjContext.setIsTemplate(JDOMUtil.getBoolean(element, "istemplate"));
            this.calendarAccessor = new CalendarAccessor(this.getProjectContext().getWSHelper());
            this.prjContext.setProjectCalendar(this.calendarAccessor.getProjectCalendar());
            this.scheduleComputation.computeAllWBSProgress();
            element2 = element.getChild("Teams");
            if (element2 != null) {
                this.initTeams(element2);
            }
            if ((element2 = element.getChild("Roles")) != null) {
                this.initRoles(element2);
            }
            this.updateFinancial();
            this.runFullBackwardSchedule();
        }
        catch (Exception exception) {
            if (exception instanceof GanttChartException) {
                throw (GanttChartException)exception;
            }
            throw new GanttChartException("Error during initialization of the Gantt chart model", exception);
        }
    }

    protected void runFullBackwardSchedule() throws ChangeException {
        if (this.backwardScheduler == null) {
            this.backwardScheduler = new AppBackwardScheduler(this);
        }
        try {
            this.backwardScheduler.runBackwardPass();
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    protected void updateBackwardSchedule(Change change) throws ChangeException {
        boolean bl = false;
        int n = change.getOperation();
        if (change.getTarget() instanceof GanttTask) {
            if (n == 0) {
                List<FieldModification> list = change.getFieldModifications();
                for (int i = 0; i < list.size(); ++i) {
                    FieldModification fieldModification = list.get(i);
                    if (Arrays.binarySearch(TASK_FIELDS_IMPACTED_BACKWARD_SCHEDULE, fieldModification.field) < 0) continue;
                    bl = true;
                    break;
                }
            } else if (n != 4) {
                bl = true;
            }
        } else if (change.getTarget() instanceof GanttWBS) {
            if (n == 3 || n == 2) {
                ArrayList<TGNode> arrayList = ((GanttWBS)change.getTarget()).getAllChildrenAndSubChildren(true);
                if (arrayList != null && !arrayList.isEmpty()) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!(arrayList.get(i) instanceof GanttTask)) continue;
                        bl = true;
                        break;
                    }
                }
            } else if (n == 7) {
                bl = true;
            }
        }
        if (bl) {
            this.runFullBackwardSchedule(true);
        }
    }

    public void runFullReschedule() throws ChangeException {
        this.getScheduleComputation().runFullReschedule();
        try {
            this.runFullBackwardSchedule(true);
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    protected void rescheduleWBSAndParents(GanttWBS ganttWBS) throws ChangeException {
        try {
            this.getScheduleComputation().rescheduleWBSAndParents(ganttWBS);
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    protected void rescheduleAllWBS() throws ChangeException {
        try {
            ScheduleCalendar scheduleCalendar = this.getCalendarAccessor().getProjectCalendar();
            this.getScheduleComputation().rescheduleAllProjectWBS(scheduleCalendar);
        }
        catch (Exception exception) {
            throw new UnexpectedChangeException(exception);
        }
    }

    void rescheduleParentProject() {
        if (this.getRootNode().getParent() != null) {
            GanttWBS ganttWBS = (GanttWBS)this.getRootNode().getParent();
            PEAppProjectModel pEAppProjectModel = (PEAppProjectModel)((PEAppProjectContext)ganttWBS.getProjectContext()).getModel();
            pEAppProjectModel.getScheduleComputation().rescheduleWBSAndParents(ganttWBS);
        }
    }

    public void refreshResourcesFromServer(String[] stringArray) throws GanttChartException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        try {
            Element element = this.getProjectContext().getWSHelper().getResourcesDataFromWS(stringArray);
            List list = element.getChildren("Resource");
            if (list == null || list.size() != stringArray.length) {
                int n = list == null ? 0 : list.size();
                throw new GanttChartException("Refresh resources uncomplete (" + n + '/' + stringArray.length + "). Full resfresh is needed");
            }
            for (Element element2 : list) {
                ProjectResource projectResource = this.readResource(element2);
                ProjectResource projectResource2 = this.getProjectResource(projectResource.getDn());
                if (!UString.equals(projectResource2.getCn(), projectResource.getCn())) {
                    projectResource2.setCn(projectResource.getCalendarId());
                }
                if (!UString.equals(projectResource2.getEmail(), projectResource.getEmail())) {
                    projectResource2.setEmail(projectResource.getEmail());
                }
                if (!UString.equals(projectResource2.getRoleId(), projectResource.getRoleId())) {
                    projectResource2.setRoleId(projectResource.getRoleId());
                }
                if (!UString.equals(projectResource2.getTeamId(), projectResource.getTeamId())) {
                    projectResource2.setTeamId(projectResource.getTeamId());
                }
                if (projectResource2.isRegistered() != projectResource.isRegistered()) {
                    projectResource2.setRegistered(projectResource.isRegistered());
                }
                if (projectResource2.isEnabled() != projectResource.isEnabled()) {
                    projectResource2.setEnabled(projectResource.isEnabled());
                }
                if (!ProjectResource.costRatesEquals(projectResource2.getCostRates(), projectResource.getCostRates())) {
                    projectResource2.setCostRates(projectResource.getCostRates());
                }
                if (projectResource2.getInvitationDate() == null || !projectResource2.getInvitationDate().equals(projectResource.getInvitationDate())) {
                    projectResource2.setInvitationDate(projectResource.getInvitationDate());
                }
                if (!UString.equals(projectResource2.getInvitedBy(), projectResource.getInvitedBy())) {
                    projectResource2.setInvitedBy(projectResource.getInvitedBy());
                }
                if (UString.equals(projectResource2.getCalendarId(), projectResource.getCalendarId())) continue;
                throw new IllegalStateException("Calendar updated for " + projectResource2.getCn());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PEAppProjectModel.this.fireResourcesUpdated(65535);
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof GanttChartException) {
                throw (GanttChartException)exception;
            }
            throw new GanttChartException(2, "Error in refreshResourcesFromServer", exception);
        }
    }

    public GanttWBS loadSubprojectRoot(String string) throws Exception {
        Element element = this.getProjectContext().getWSHelper().getSubprojectData(string);
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild("e");
        if (element2 == null) {
            return null;
        }
        return (GanttWBS)this.createNode(element2);
    }

    private void initResources(Element element) throws XMLException {
        List list;
        this.resources.clear();
        if (element != null && (list = element.getChildren("Resource")) != null) {
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                ProjectResource projectResource = this.readResource(element2);
                if (projectResource == null) continue;
                this.resources.put(projectResource.getDn(), projectResource);
            }
        }
    }

    private void initRoles(Element element) throws XMLException {
        this.roles.clear();
        if (element == null) {
            return;
        }
        List list = element.getChildren("Role");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            String string = JDOMUtil.getString(element2, "id");
            String string2 = JDOMUtil.getString(element2, "label");
            boolean bl = JDOMUtil.getBoolean(element2, "hidden");
            this.roles.put(string, new ProjectRole(string, string2, bl, this.getProjectContext()));
        }
    }

    private void initTeams(Element element) throws XMLException {
        this.teams.clear();
        if (element == null) {
            return;
        }
        List list = element.getChildren("Team");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            String string = JDOMUtil.getString(element2, "id");
            String string2 = JDOMUtil.getString(element2, "label");
            this.teams.put(string, new ProjectTeam(string, string2, this.getProjectContext()));
        }
    }

    protected ProjectResource readResource(Element element) {
        Object object;
        String string = JDOMUtil.getString(element, "dn");
        if (UString.isEmpty(string)) {
            return null;
        }
        ProjectResource projectResource = new ProjectResource(JDOMUtil.getString(element, "cn"), string, JDOMUtil.getString(element, "calendarId"), this.getProjectContext());
        projectResource.setEmail(JDOMUtil.getString(element, "email"));
        projectResource.setRoleId(JDOMUtil.getString(element, "role"));
        projectResource.setTeamId(JDOMUtil.getString(element, "team"));
        projectResource.setRegistered(JDOMUtil.getBoolean(element, "registered"));
        projectResource.setEnabled(JDOMUtil.getBoolean(element, "enabled"));
        projectResource.setProfileUrl(JDOMUtil.getString(element, "profileUrl"));
        double d = JDOMUtil.getDouble(element, "costRate");
        CostRateUnit costRateUnit = CostRateUnit.fromCode(JDOMUtil.getString(element, "costRateUnit"));
        CostRate costRate = new CostRate(d, costRateUnit);
        Object[] objectArray = VariableCost.NO_VARIABLE_COSTS;
        Element element2 = element.getChild("variablecosts");
        if (element2 != null) {
            object = element2.getChildren("variablecost");
            ArrayList<VariableCost> arrayList = new ArrayList<VariableCost>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Element element3 = (Element)e;
                d = JDOMUtil.getDouble(element3, "costrate");
                costRateUnit = CostRateUnit.fromCode(element3.getChildText("costrateunit"));
                CostRate costRate2 = new CostRate(d, costRateUnit);
                Date date = new Date(JDOMUtil.readXMIDate(element3.getChildText("from")));
                arrayList.add(new VariableCost(date, costRate2));
            }
            objectArray = arrayList.toArray(VariableCost.NO_VARIABLE_COSTS);
            Arrays.sort(objectArray);
        }
        projectResource.setCostRates(new CostRates(costRate, (VariableCost[])objectArray));
        object = JDOMUtil.getString(element, "invitationDate");
        if (!UString.isEmpty((String)object)) {
            projectResource.setInvitationDate(new Date(JDOMUtil.readXMIDate((String)object)));
            projectResource.setInvitedBy(JDOMUtil.getString(element, "invitedBy"));
        }
        return projectResource;
    }

    protected Resource getNoneProjectResourceByDn(String string) {
        Resource resource = this.nonePrjResources.get(string);
        if (resource == null) {
            String string2 = string;
            try {
                string2 = this.getProjectContext().getWSHelper().getResourceCnByDn(string);
            }
            catch (Exception exception) {
                System.out.println("Unable to get Common Name of " + string);
                exception.printStackTrace();
            }
            resource = new Resource(string2, string);
            this.nonePrjResources.put(string, resource);
        }
        return resource;
    }

    public void addResource(ProjectResource projectResource) {
        if (!this.getProjectId().equals(projectResource.getProjectId())) {
            throw new IllegalArgumentException("Resource belongs to another porject: " + projectResource.getDn());
        }
        this.resources.put(projectResource.getDn(), projectResource);
    }

    public Change addResourceForChange(ProjectResource projectResource) {
        Object object;
        if (this.getProjectResource(projectResource.getDn()) != null) {
            return null;
        }
        String string = projectResource.getRoleId();
        if (string == null) {
            string = "pe_teammember";
            object = this.getProjectRoleById(string);
            if (object == null || ((Role)object).isHidden()) {
                ProjectRole[] projectRoleArray;
                for (ProjectRole projectRole : projectRoleArray = this.getProjectRoles()) {
                    if (projectRole.isHidden()) continue;
                    string = projectRole.getId();
                    break;
                }
            }
            projectResource.setRoleId(string);
        }
        this.addResource(projectResource);
        object = Change.newCreateChange(projectResource);
        ((Change)object).addModification("Name", null, projectResource.getCn());
        if (projectResource.getEmail() != null) {
            ((Change)object).addModification("Email", null, projectResource.getEmail());
        }
        if (projectResource.getTeamId() != null) {
            ((Change)object).addModification("Team", null, projectResource.getTeamId());
        }
        if (projectResource.getRoleId() != null) {
            ((Change)object).addModification("Role", null, projectResource.getRoleId());
        }
        if (!projectResource.isEnabled()) {
            ((Change)object).addModification("Enabled", null, Boolean.FALSE);
        }
        this.fireResourcesUpdated(1);
        return object;
    }

    public DeleteResourceChange deleteResource(ProjectResource projectResource) throws ChangeException {
        return this.deleteResources(new ProjectResource[]{projectResource})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteResourceChange[] deleteResources(ProjectResource[] projectResourceArray) throws ChangeException {
        boolean bl = false;
        try {
            this.setUpdatingResources(true);
            DeleteResourceChange[] deleteResourceChangeArray = new DeleteResourceChange[projectResourceArray.length];
            for (int i = 0; i < projectResourceArray.length; ++i) {
                ProjectResource projectResource = projectResourceArray[i];
                deleteResourceChangeArray[i] = new DeleteResourceChange(projectResource);
                deleteResourceChangeArray[i].removals = new DeleteResourceChange.Removals();
                bl |= this.deleteResource(projectResource.getDn(), this.getRootNode(), deleteResourceChangeArray[i].removals);
                this.resources.remove(projectResource.getDn());
            }
            if (bl) {
                this.runFullReschedule();
                this.updateResourcesCost();
            }
            DeleteResourceChange[] deleteResourceChangeArray2 = deleteResourceChangeArray;
            return deleteResourceChangeArray2;
        }
        finally {
            this.setUpdatingResources(false);
            if (bl) {
                this.refresh();
            }
            this.fireResourcesUpdated(1);
        }
    }

    private boolean deleteResource(String string, GanttNode ganttNode, DeleteResourceChange.Removals removals) {
        if (ganttNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            TaskResource[] taskResourceArray = ganttTask.getResources();
            if (taskResourceArray != null) {
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    if (!string.equals(taskResourceArray[i].getDn())) continue;
                    removals.tasks.put(ganttTask.getUid(), new Integer(taskResourceArray[i].getUnit()));
                    TaskResource[] taskResourceArray2 = new TaskResource[taskResourceArray.length - 1];
                    if (i > 0) {
                        System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, i);
                    }
                    if (i < taskResourceArray.length - 1) {
                        System.arraycopy(taskResourceArray, i + 1, taskResourceArray2, i, taskResourceArray2.length - i);
                    }
                    ganttTask.setResources(taskResourceArray2);
                    return true;
                }
            }
        } else if (ganttNode instanceof GanttWBS) {
            int n;
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            if (ganttWBS.isSubProject()) {
                return false;
            }
            boolean bl = false;
            Resource[] resourceArray = ganttWBS.getResources();
            if (resourceArray != null) {
                for (n = 0; n < resourceArray.length; ++n) {
                    if (!string.equals(resourceArray[n].getDn())) continue;
                    Resource[] resourceArray2 = new Resource[resourceArray.length - 1];
                    if (n > 0) {
                        System.arraycopy(resourceArray, 0, resourceArray2, 0, n);
                    }
                    if (n < resourceArray.length - 1) {
                        System.arraycopy(resourceArray, n + 1, resourceArray2, n, resourceArray2.length - n);
                    }
                    removals.wbs.add(ganttWBS.getUid());
                    ganttWBS.setResources(resourceArray2);
                    bl = true;
                    break;
                }
            }
            n = ganttNode.getAllSubTaskCount();
            for (int i = 0; i < n; ++i) {
                GanttNode ganttNode2 = ganttNode.getSubtaskInAll(i);
                bl |= this.deleteResource(string, ganttNode2, removals);
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplaceResourceChange replaceResource(ProjectResource projectResource, ProjectResource projectResource2, ReplaceOptions replaceOptions) throws ChangeException {
        Object object;
        boolean bl;
        ProjectResource projectResource3 = this.getProjectResource(projectResource2.getDn());
        if (projectResource3 == null) {
            bl = false;
            this.addResource(projectResource2);
        } else {
            bl = true;
            projectResource2 = projectResource3;
        }
        ReplaceResourceChange.Replacements replacements = null;
        try {
            this.setUpdatingResources(true);
            replacements = new ReplaceResourceChange.Replacements();
            object = this.getRootNode();
            this.replaceResource(projectResource, projectResource2, (GanttNode)object, replaceOptions.includeHistory, replacements);
            this.runFullReschedule();
        }
        finally {
            this.setUpdatingResources(false);
            this.refresh();
        }
        this.deleteResource(projectResource);
        this.updateResourcesCost();
        object = new ReplaceResourceChange(projectResource, projectResource2, bl);
        ((ReplaceResourceChange)object).setReplaceOptions(replaceOptions);
        ((ReplaceResourceChange)object).setReplacements(replacements);
        return object;
    }

    private void replaceResource(ProjectResource projectResource, ProjectResource projectResource2, GanttNode ganttNode, boolean bl, ReplaceResourceChange.Replacements replacements) {
        block16: {
            String string;
            String string2;
            block17: {
                string2 = projectResource.getDn();
                string = projectResource2.getDn();
                if (!(ganttNode instanceof GanttTask)) break block17;
                GanttTask ganttTask = (GanttTask)ganttNode;
                if (!bl && ganttTask.isDone()) {
                    return;
                }
                TaskResource[] taskResourceArray = ganttTask.getResources();
                if (taskResourceArray == null) break block16;
                for (int i = 0; i < taskResourceArray.length; ++i) {
                    TaskResource[] taskResourceArray2;
                    if (!string2.equals(taskResourceArray[i].getDn())) continue;
                    int n = -1;
                    for (int j = 0; j < taskResourceArray.length; ++j) {
                        if (!string.equals(taskResourceArray[j].getDn())) continue;
                        n = j;
                        break;
                    }
                    replacements.tasksOldRes.put(ganttTask.getUid(), new Integer(taskResourceArray[i].getUnit()));
                    if (n >= 0) {
                        taskResourceArray2 = new TaskResource[taskResourceArray.length - 1];
                        if (i > 0) {
                            System.arraycopy(taskResourceArray, 0, taskResourceArray2, 0, i);
                        }
                        if (i < taskResourceArray.length - 1) {
                            System.arraycopy(taskResourceArray, i + 1, taskResourceArray2, i, taskResourceArray2.length - i);
                        }
                        replacements.tasksNewRes.put(ganttTask.getUid(), new Integer(taskResourceArray[n].getUnit()));
                    } else {
                        taskResourceArray2 = (TaskResource[])taskResourceArray.clone();
                        taskResourceArray2[i] = new TaskResource(projectResource2, taskResourceArray[i].getUnit());
                    }
                    ganttTask.setResources(taskResourceArray2);
                    break block16;
                }
                break block16;
            }
            if (ganttNode instanceof GanttWBS) {
                Resource[] resourceArray;
                int n;
                int n2;
                GanttWBS ganttWBS = (GanttWBS)ganttNode;
                Resource[] resourceArray2 = ganttWBS.getResources();
                if (resourceArray2 != null) {
                    for (n2 = 0; n2 < resourceArray2.length; ++n2) {
                        if (!string2.equals(resourceArray2[n2].getDn())) continue;
                        n = -1;
                        for (int i = 0; i < resourceArray2.length; ++i) {
                            if (!string.equals(resourceArray2[i].getDn())) continue;
                            n = i;
                            break;
                        }
                        if (n >= 0) {
                            resourceArray = new Resource[resourceArray2.length - 1];
                            if (n2 > 0) {
                                System.arraycopy(resourceArray2, 0, resourceArray, 0, n2);
                            }
                            if (n2 < resourceArray2.length - 1) {
                                System.arraycopy(resourceArray2, n2 + 1, resourceArray, n2, resourceArray.length - n2);
                            }
                            replacements.wbs.put(ganttWBS.getUid(), Boolean.TRUE);
                        } else {
                            resourceArray = (Resource[])resourceArray2.clone();
                            resourceArray[n2] = projectResource2;
                            replacements.wbs.put(ganttWBS.getUid(), Boolean.FALSE);
                        }
                        ganttWBS.setResources(resourceArray);
                        break;
                    }
                }
                n2 = ganttNode.getAllSubTaskCount();
                for (n = 0; n < n2; ++n) {
                    resourceArray = ganttNode.getSubtaskInAll(n);
                    this.replaceResource(projectResource, projectResource2, (GanttNode)resourceArray, bl, replacements);
                }
            }
        }
    }

    public Resource[] getResources(String[] stringArray) {
        Resource[] resourceArray;
        if (stringArray != null) {
            resourceArray = new Resource[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                resourceArray[i] = this.resources.get(stringArray[i]);
                if (resourceArray[i] != null) continue;
                resourceArray[i] = this.getNoneProjectResourceByDn(stringArray[i]);
            }
        } else {
            resourceArray = new Resource[]{};
        }
        return resourceArray;
    }

    public ProjectResource[] getProjectResources() {
        return this.resources.values().toArray(new ProjectResource[0]);
    }

    public ProjectResource getProjectResource(String string) {
        return this.resources.get(string);
    }

    public ProjectRole[] getProjectRoles() {
        return this.roles.values().toArray(new ProjectRole[this.roles.size()]);
    }

    public ProjectRole getProjectRoleById(String string) {
        return this.roles.get(string);
    }

    public Change addProjectRole(ProjectRole projectRole) {
        this.roles.put(projectRole.getId(), projectRole);
        Change change = Change.newCreateChange(projectRole);
        change.addModification("id", null, projectRole.getId());
        change.addModification("name", null, projectRole.getLabel());
        change.addModification("securityprofile", null, projectRole.getSecurityProfileId());
        return change;
    }

    public void removeProjectRole(ProjectRole projectRole) {
        this.roles.remove(projectRole.getId());
    }

    public ProjectTeam[] getProjectTeams() {
        return this.teams.values().toArray(new ProjectTeam[this.teams.size()]);
    }

    public ProjectTeam getProjectTeamById(String string) {
        return this.teams.get(string);
    }

    public Change addProjectTeam(ProjectTeam projectTeam) {
        this.teams.put(projectTeam.getId(), projectTeam);
        Change change = Change.newCreateChange(projectTeam);
        change.addModification("id", null, projectTeam.getId());
        change.addModification("name", null, projectTeam.getLabel());
        return change;
    }

    public void removeProjectTeam(ProjectTeam projectTeam) {
        this.teams.remove(projectTeam.getId());
    }

    public void refresh() {
        this.chartModel.refresh();
    }

    public void updateResourcesCost() {
        if (this.updateFinancial()) {
            this.chartModel.refresh();
        }
    }

    public boolean isScheduleEditable() {
        return this.scheduleEditable;
    }

    public boolean isFinancialModuleAvailable() {
        return this.getGlobalContext().hasFinancialModule();
    }

    public boolean isFinancialEditable() {
        return this.getProjectContext().isFinancialEditable();
    }

    public boolean isTimesheetModuleAvailable() {
        return this.getGlobalContext().hasTimesheetModule();
    }

    public ScheduleCalendar getScheduleCalendar(String string) {
        return this.getCalendarAccessor().getCalendar(string);
    }

    public FinancialSettings getFinancialSettings() {
        return this.getProjectContext().getFinancialSettings();
    }

    static {
        Arrays.sort(TASK_FIELDS_IMPACTED_BACKWARD_SCHEDULE);
    }
}

