/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.CriticalPathRuntimeConf;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.ProjectContext;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskPredecessor;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.IActionCallback;
import com.triloggroup.gantt.app.SaveResult;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.social.ISocialDataProvider;
import com.triloggroup.gantt.app.ui.AsyncActionRunner;
import com.triloggroup.gantt.app.ui.CancelAsyncActionException;
import com.triloggroup.gantt.app.ui.IAsyncAction;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.app.xsp.XSPActions;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.gantt.pe.app.PEAppProjectContext;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.gantt.pe.app.dialog.TaskDetailDialog;
import com.triloggroup.gantt.pe.app.dialog.WBSDetailDialog;
import com.triloggroup.gantt.pe.app.social.SocialWSHelper;
import com.triloggroup.gantt.pe.app.treetable.PEAppGanttTreeTableModel;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.project.components.IdentifiableObject;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.ui.ErrorDialog;
import com.triloggroup.util.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEAppGanttChart
extends AppGanttChart {
    @Override
    protected TGTreeTableModel createTreeTableModel() {
        String[] stringArray = null;
        try {
            stringArray = this.getUserPreferences().getTableColumns();
        }
        catch (Exception exception) {
            System.out.println("Unable to load default visible columns");
            exception.printStackTrace();
        }
        return new PEAppGanttTreeTableModel(this.getModel(), this.locale, stringArray);
    }

    @Override
    protected void loadUserPreferences() {
        try {
            this.userPreferences = this.getModel().getMainProjectModel().getProjectContext().getWSHelper().getUserPreferences(this.getModel().getMainProjectModel());
            if (this.userPreferences.getFontSize() != 11) {
                this.updateFonts();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.userPreferences = new UserPreferences();
            this.userPreferences.setCriticalPathConf(new CriticalPathRuntimeConf());
        }
    }

    @Override
    public ISocialDataProvider getSocialDataProvider(ProjectContext projectContext) {
        return new SocialWSHelper((PEAppProjectContext)projectContext);
    }

    @Override
    public AsyncActionRunner loadSubproject(final GanttWBS ganttWBS, final int n) {
        if (ganttWBS.isBrokenSubprojectLink()) {
            return new AsyncActionRunner(null);
        }
        IAsyncAction iAsyncAction = new IAsyncAction(){

            public Object awtBeforeRun() throws CancelAsyncActionException {
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                return PEAppGanttChart.this.getModel().loadSubproject(ganttWBS);
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(PEAppGanttChart.this.getView(), throwable);
                    return;
                }
                GanttWBS ganttWBS2 = (GanttWBS)object;
                if (ganttWBS2.getAllSubTaskCount() == 0) {
                    PEAppGanttChart.this.expandNode(ganttWBS);
                } else {
                    ganttWBS.setExpanded(true);
                    PEAppGanttChart.this.expandNodeToLevel(ganttWBS2, n, true);
                }
                PEAppGanttChart.this.setSelectedNode(ganttWBS2);
            }
        };
        int n2 = this.getIndexOfNodeInTaskSeries(ganttWBS);
        Rectangle rectangle = this.getTreeTable().getCellRect(n2, 0, true);
        Point point = new Point(0, PEAppGanttChart.getRowHeight());
        SwingUtilities.convertPointToScreen(point, this.getTreeTable());
        rectangle.x += point.x;
        rectangle.y += point.y;
        rectangle.width = this.getView().getWidth();
        rectangle.height *= 2;
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this.getView(), this.nlsBundle.getString("loading"));
        asyncActionRunner.setWaitUIBounds(rectangle);
        asyncActionRunner.runAction();
        return asyncActionRunner;
    }

    @Override
    public void showNodeDetail(GanttNode ganttNode, Point point, IActionCallback iActionCallback) {
        point = this.adjustPointOnScreen(point);
        if (ganttNode instanceof GanttWBS) {
            WBSDetailDialog.showDetail((GanttWBS)ganttNode, this, point, iActionCallback);
        } else {
            TaskDetailDialog.showDetail((GanttTask)ganttNode, this, point, iActionCallback);
        }
    }

    @Override
    public void showNewTaskDetail(GanttWBS ganttWBS, Point point, GanttNode ganttNode) {
        point = this.adjustPointOnScreen(point);
        TaskDetailDialog.showNewTaskDetail(ganttWBS, this, point, ganttNode, false);
    }

    @Override
    public void createNewTask(GanttWBS ganttWBS, GanttNode ganttNode) {
        try {
            GanttTask ganttTask = this.getModel().newGanttTask(ganttWBS, null);
            this.getModel().checkComputeAndUpdateTaskValues(null, ganttTask, null, 100);
            if (ganttNode != null) {
                int n = ganttNode.getSubId() + 1;
                this.getModel().reorderNodeToPosition(ganttTask, n, true);
            }
            this.selectAndEditNodeInline(ganttTask);
        }
        catch (ChangeException changeException) {
            changeException.printStackTrace();
            ErrorDialog.showError(this.getView(), changeException);
        }
    }

    @Override
    public void showNewMilestoneDetail(GanttWBS ganttWBS, Point point, GanttNode ganttNode) {
        point = this.adjustPointOnScreen(point);
        TaskDetailDialog.showNewTaskDetail(ganttWBS, this, point, ganttNode, true);
    }

    @Override
    public void createNewMilestone(GanttWBS ganttWBS, GanttNode ganttNode) {
        try {
            GanttTask ganttTask = this.getModel().newMilestone(ganttWBS, null);
            this.getModel().checkComputeAndUpdateTaskValues(null, ganttTask, null, 100);
            if (ganttNode != null) {
                int n = ganttNode.getSubId() + 1;
                this.getModel().reorderNodeToPosition(ganttTask, n, true);
            }
            this.selectAndEditNodeInline(ganttTask);
        }
        catch (ChangeException changeException) {
            changeException.printStackTrace();
            ErrorDialog.showError(this.getView(), changeException);
        }
    }

    @Override
    public void showNewWBSDetail(GanttWBS ganttWBS, Point point, GanttNode ganttNode) {
        point = this.adjustPointOnScreen(point);
        WBSDetailDialog.showNewWBSDetail(ganttWBS, false, this, point, ganttNode);
    }

    @Override
    public void createNewWBS(GanttWBS ganttWBS, GanttNode ganttNode) {
        try {
            GanttWBS ganttWBS2 = this.getModel().newGantWBS(ganttWBS, null);
            this.getModel().checkComputeAndUpdateWBSValues(null, ganttWBS2, null);
            if (ganttNode != null) {
                int n = ganttNode.getSubId() + 1;
                this.getModel().reorderNodeToPosition(ganttWBS2, n, true);
            }
            this.selectAndEditNodeInline(ganttWBS2);
        }
        catch (ChangeException changeException) {
            changeException.printStackTrace();
            ErrorDialog.showError(this.getView(), changeException);
        }
    }

    @Override
    public void showNewSubprojectDetail(GanttWBS ganttWBS, Point point, GanttNode ganttNode) {
        point = this.adjustPointOnScreen(point);
        WBSDetailDialog.showNewWBSDetail(ganttWBS, true, this, point, ganttNode);
    }

    protected Point adjustPointOnScreen(Point point) {
        if (point == null) {
            point = new Point(10, 10);
            Container container = this.getView();
            if (container.getParent() instanceof JViewport) {
                container = container.getParent();
            }
            SwingUtilities.convertPointToScreen(point, container);
        } else {
            Rectangle rectangle = WDUtil.getDisplayBounds(point);
            point.x = Math.max(point.x - 20, rectangle.x);
            point.y = Math.max(point.y - 20, rectangle.y);
        }
        return point;
    }

    @Override
    public PEAppGanttChartModel getModel() {
        return (PEAppGanttChartModel)this.model;
    }

    @Override
    public AsyncActionRunner saveChanges() {
        IAsyncAction iAsyncAction = new IAsyncAction(){
            ChartState state;

            public Object awtBeforeRun() throws CancelAsyncActionException {
                PEAppGanttChart.this.setClipboardData(null);
                this.state = PEAppGanttChart.this.getChartState();
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                return PEAppGanttChart.this.getModel().saveChanges();
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(PEAppGanttChart.this.getView(), throwable);
                    return;
                }
                PEAppGanttChart.this.restoreChartState(this.state);
                PEAppGanttChart.this.ensureVisibleNode();
                SaveResult saveResult = (SaveResult)object;
                PEAppGanttChart.this.showSaveResultDialog(saveResult);
                if (saveResult.getStatus() == 0) {
                    GanttWorkbenchPage ganttWorkbenchPage = PEAppGanttChart.this.getWorkbenchPage();
                    XSPActions xSPActions = new XSPActions(PEAppGanttChart.this.getView(), ganttWorkbenchPage.getApplet());
                    PEAppProjectModel pEAppProjectModel = PEAppGanttChart.this.getModel().getMainProjectModel();
                    xSPActions.ganttSaveCompleted(PEAppGanttChart.this.getModel().getSiteId(), pEAppProjectModel.getProjectContext().getProjectId());
                    String string = pEAppProjectModel.getProjectContext().getProjectStatus();
                    if (pEAppProjectModel.getProjectEndDate().after(this.state.prjEnd) && ("In Progress".equals(string) || "Done".equals(string))) {
                        WDDialog.showMsgDialog(PEAppGanttChart.this.getView(), PEAppGanttChart.this.nlsBundle.getString("projectEndDelayed"));
                    }
                }
                if (saveResult.isIntegrityError()) {
                    WDDialog.showMsgDialog(PEAppGanttChart.this.getView(), PEAppGanttChart.this.nlsBundle.getString("integrityErrorDetected"));
                }
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this.getView(), this.nlsBundle.getString("saving"));
        asyncActionRunner.runAction();
        return asyncActionRunner;
    }

    @Override
    public AsyncActionRunner reloadData() {
        IAsyncAction iAsyncAction = new IAsyncAction(){
            ChangeManager changeManager;
            List<Change> changesToReapply;
            ChartState state;
            {
                this.changeManager = PEAppGanttChart.this.getModel().getChangeManager();
                this.changesToReapply = null;
            }

            public Object awtBeforeRun() throws CancelAsyncActionException {
                PEAppGanttChart.this.stopCellEditing(true);
                if (this.changeManager.canUndo() && WDDialog.showYesNoDialog(PEAppGanttChart.this.getView(), AppGanttChart.NLS_BUNDLE.getString("reapply_changes_question"))) {
                    this.changesToReapply = this.changeManager.getAllChanges();
                }
                PEAppGanttChart.this.setClipboardData(null);
                this.state = PEAppGanttChart.this.getChartState();
                return null;
            }

            public Object asyncRun(Object object) throws Throwable {
                PEAppGanttChart.this.getModel().rebuildAllFromServer();
                return null;
            }

            public void awtAfterRun(Object object, Throwable throwable) {
                if (throwable != null) {
                    WDDialog.showErrorMsgDialog(PEAppGanttChart.this.getView(), throwable);
                    return;
                }
                if (this.changesToReapply != null) {
                    ArrayList<Change> arrayList = new ArrayList<Change>();
                    ArrayList<Change> arrayList2 = new ArrayList<Change>();
                    for (int i = 0; i < this.changesToReapply.size(); ++i) {
                        Change change = this.changesToReapply.get(i);
                        try {
                            PEAppGanttChart.this.getModel().getChangeManager().applyChange(change, false, true, arrayList2);
                            continue;
                        }
                        catch (ChangeException changeException) {
                            changeException.printStackTrace();
                            arrayList.add(change);
                        }
                    }
                    this.changeManager.setAllChanges(arrayList2);
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = new String[arrayList.size() + 1];
                        stringArray[0] = PEAppGanttChart.this.nlsBundle.getString("error_reapply_changes");
                        for (int i = 0; i < arrayList.size(); ++i) {
                            stringArray[i + 1] = " - " + ((Change)arrayList.get(i)).getText();
                        }
                        WDDialog.showMultilineMsgDialog(PEAppGanttChart.this.getView(), stringArray);
                    }
                }
                PEAppGanttChart.this.restoreChartState(this.state);
                PEAppGanttChart.this.ensureVisibleNode();
            }
        };
        AsyncActionRunner asyncActionRunner = new AsyncActionRunner(iAsyncAction, this.getView(), this.nlsBundle.getString("loading"));
        asyncActionRunner.runAction();
        return asyncActionRunner;
    }

    public void showSaveResultDialog(SaveResult saveResult) {
        Object object;
        JComponent jComponent;
        boolean bl;
        boolean bl2 = bl = saveResult.getStatus() == 0;
        if (bl && !saveResult.getMessages().hasMessage()) {
            return;
        }
        WDDialog wDDialog = WDDialog.createWDDialog(this.getView(), true, !bl);
        wDDialog.setTitle(NLS_BUNDLE.getString("save_button"));
        wDDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        wDDialog.getContentPane().add((Component)new JScrollPane(jPanel), "Center");
        List<Message> list = saveResult.getMessages().getAllMessages();
        if (!list.isEmpty()) {
            jComponent = Box.createVerticalBox();
            jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            for (Message object2 : list) {
                JLabel i = new JLabel();
                String i2 = (object2.data == null ? "" : object2.data.toString() + ": ") + object2.text;
                i.setText(i2);
                ImageIcon imageIcon = object2.isError() ? WDUtil.getIcon("msg_error.gif") : (object2.isWarning() ? WDUtil.getIcon("msg_warning.gif") : null);
                i.setIcon(imageIcon);
                jComponent.add(i);
            }
            jPanel.add((Component)jComponent, "North");
        }
        if (saveResult.getNotSavedNodes() != null) {
            jComponent = new JTextArea();
            ((JTextComponent)jComponent).setEditable(false);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            ((JTextArea)jComponent).setLineWrap(false);
            jComponent.setBackground(wDDialog.getContentPane().getBackground());
            ((JTextArea)jComponent).setFont((Font)UIManager.get("Label.font"));
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            object = new StringBuilder();
            ((StringBuilder)object).append(this.nlsBundle.getString("error_save_node_list"));
            List<IdentifiableObject> list2 = saveResult.getNotSavedNodes();
            for (int list22 = 0; list22 < list2.size(); ++list22) {
                ((StringBuilder)object).append(" \n - ");
                ((StringBuilder)object).append(list2.get(list22));
            }
            List<Change> list3 = saveResult.getChangesNotReaplied();
            if (list3 != null && !list3.isEmpty()) {
                ((StringBuilder)object).append("\n\n");
                ((StringBuilder)object).append(this.nlsBundle.getString("error_reapply_changes"));
                for (int i = 0; i < list3.size(); ++i) {
                    ((StringBuilder)object).append("\n - ");
                    ((StringBuilder)object).append(list3.get(i).getText());
                }
            }
            ((JTextComponent)jComponent).setText(((StringBuilder)object).toString());
            jPanel.add((Component)jComponent, "Center");
        }
        jComponent = WDUtil.createOkButton();
        ((AbstractButton)jComponent).addActionListener(wDDialog.new WDDialog.DisposeActionListener());
        object = WDDialog.createButtonPanel(new WDButton[]{jComponent});
        wDDialog.getContentPane().add((Component)object, "South");
        wDDialog.setVisible(300, 120, 1000, 800, this.getView());
        wDDialog.dispose();
    }

    protected ChartState getChartState() {
        ChartState chartState = new ChartState();
        TGNode[] tGNodeArray = this.getSelectedNodes();
        if (tGNodeArray != null) {
            chartState.selectedNodeDescriptions = new ArrayList();
            for (int i = 0; i < tGNodeArray.length; ++i) {
                chartState.selectedNodeDescriptions.add(tGNodeArray[i].getDescription());
            }
        } else {
            chartState.selectedPredecessor = this.getSelectedPredecessor();
        }
        chartState.prjStart = this.getModel().getMainProjectModel().getProjectStartDate();
        chartState.prjEnd = this.getModel().getMainProjectModel().getProjectEndDate();
        chartState.collpasedNodeDescriptions = new HashSet();
        if (this.model.getRootNode() != null) {
            this.getCollapsedNodes(chartState.collpasedNodeDescriptions, this.model.getRootNode());
        }
        chartState.filter = this.getFilter();
        return chartState;
    }

    private void getCollapsedNodes(HashSet<String> hashSet, TGNode tGNode) {
        int n = tGNode.getAllSubTaskCount();
        for (int i = 0; i < n; ++i) {
            TGNode tGNode2 = tGNode.getSubtaskInAll(i);
            if (tGNode2.isLeaf()) continue;
            this.getCollapsedNodes(hashSet, tGNode2);
        }
        if (!tGNode.isExpanded()) {
            hashSet.add(tGNode.getDescription());
        }
    }

    protected void restoreChartState(ChartState chartState) {
        if (chartState == null) {
            return;
        }
        try {
            if (chartState.filter != null) {
                this.applyFilter(chartState.filter);
            }
            PEAppGanttChartModel pEAppGanttChartModel = this.getModel();
            Date date = this.getDisplayStartDate();
            Date date2 = this.getDisplayEndDate();
            if (!date.after(chartState.prjStart) && !date2.before(chartState.prjEnd)) {
                boolean bl = false;
                if (pEAppGanttChartModel.getMainProjectModel().getProjectStartDate().before(date)) {
                    date = pEAppGanttChartModel.getMainProjectModel().getProjectStartDate();
                    bl = true;
                }
                if (pEAppGanttChartModel.getMainProjectModel().getProjectEndDate().after(date2)) {
                    date2 = pEAppGanttChartModel.getMainProjectModel().getProjectEndDate();
                    bl = true;
                }
                if (bl) {
                    this.setGraphDates(date.getTime(), date2.getTime());
                }
            }
            this.restoreCollapsedNodes(pEAppGanttChartModel.getRootNode(), chartState.collpasedNodeDescriptions);
            pEAppGanttChartModel.fireNodeExpanded(pEAppGanttChartModel.getRootNode());
            if (chartState.selectedNodeDescriptions != null) {
                ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
                for (int i = 0; i < chartState.selectedNodeDescriptions.size(); ++i) {
                    String string = chartState.selectedNodeDescriptions.get(i);
                    TGNode tGNode = (TGNode)this.getTaskSeries().get(string);
                    if (tGNode == null) continue;
                    arrayList.add(tGNode);
                }
                final TGNode[] tGNodeArray = arrayList.toArray(new TGNode[0]);
                if (tGNodeArray != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PEAppGanttChart.this.setSelectedNodes(tGNodeArray);
                        }
                    });
                }
            } else if (chartState.selectedPredecessor != null) {
                GanttTask ganttTask = (GanttTask)this.getTaskSeries().get(chartState.selectedPredecessor.task.getDescription());
                Predecessor predecessor = (Predecessor)ganttTask.getPredecessor(chartState.selectedPredecessor.predecessor.getId());
                if (ganttTask != null && predecessor != null) {
                    TaskPredecessor taskPredecessor = new TaskPredecessor(ganttTask, predecessor);
                    this.setSelectedPredecessor(taskPredecessor);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void restoreCollapsedNodes(TGNode tGNode, HashSet<String> hashSet) {
        tGNode.setExpanded(!hashSet.contains(tGNode.getDescription()));
        int n = tGNode.getAllSubTaskCount();
        for (int i = 0; i < n; ++i) {
            TGNode tGNode2 = tGNode.getSubtaskInAll(i);
            this.restoreCollapsedNodes(tGNode2, hashSet);
        }
    }

    protected static class ChartState {
        Date prjStart;
        Date prjEnd;
        ArrayList<String> selectedNodeDescriptions;
        TaskPredecessor selectedPredecessor;
        HashSet<String> collpasedNodeDescriptions;
        INodeFilter filter;

        protected ChartState() {
        }
    }
}

