/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.pe.app;

import com.triloggroup.gantt.Debug;
import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.CloneChange;
import com.triloggroup.gantt.app.change.FieldModification;
import com.triloggroup.gantt.app.change.IChangeHandler;
import com.triloggroup.gantt.app.change.ParentFieldValue;
import com.triloggroup.gantt.app.change.ReorderChildrenChange;
import com.triloggroup.gantt.app.change.TransformTaskIntoWBSChange;
import com.triloggroup.gantt.app.change.TransformWBSIntoTaskChange;
import com.triloggroup.gantt.app.social.NodeSocialData;
import com.triloggroup.gantt.pe.app.PEAppGanttChartModel;
import com.triloggroup.gantt.pe.app.PEAppProjectModel;
import com.triloggroup.gantt.pe.app.TaskUpdater;
import com.triloggroup.gantt.pe.app.WBSUpdater;
import com.triloggroup.project.NameId;
import com.triloggroup.project.components.ObjectType;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.schedule.Predecessor;
import com.triloggroup.project.schedule.SubprojectOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.gantt.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GanttChangeHandler
implements IChangeHandler {
    private static final boolean CHECK_CHANGE = true;
    private PEAppGanttChartModel model;

    GanttChangeHandler(PEAppGanttChartModel pEAppGanttChartModel) {
        this.model = pEAppGanttChartModel;
    }

    @Override
    public boolean canHandleChange(Change change) {
        ObjectType objectType = change.getTargetType();
        return objectType == GanttTask.TYPE || objectType == GanttWBS.TYPE;
    }

    @Override
    public void applyChange(Change change, boolean bl, boolean bl2, List<Change> list) throws ChangeException {
        int n = change.getOperation();
        GanttNode ganttNode = (GanttNode)change.getTarget();
        if (bl2 && (bl && n != 2 || !bl && n != 1)) {
            String string = change.getTarget().getUid();
            ganttNode = this.model.getProjectModel(change.getTarget().getProjectId()).getNodeByUid(string);
            if (ganttNode == null) {
                throw new IllegalStateException("Node does not exist: " + string);
            }
        }
        boolean bl3 = Debug.CHECK_UNDO && !bl2;
        switch (n) {
            case 1: {
                this.applyCreateChange(change, bl, ganttNode, list);
                break;
            }
            case 2: {
                this.applyDeleteChange(change, bl, ganttNode, list);
                break;
            }
            case 0: {
                this.applyUpdateChange(change, bl, ganttNode, bl3, list);
                break;
            }
            case 3: {
                this.applyCloneChange((CloneChange)change, bl, ganttNode, list);
                break;
            }
            case 4: {
                this.applyReorderChildrenChange((ReorderChildrenChange)change, bl, ganttNode, bl3, list);
                break;
            }
            case 6: {
                this.applyTransformTaskIntoWBSChange((TransformTaskIntoWBSChange)change, bl, ganttNode, list);
                break;
            }
            case 7: {
                this.applyTransformWBSIntoTaskChange((TransformWBSIntoTaskChange)change, bl, ganttNode, list);
            }
        }
    }

    protected void applyReorderChildrenChange(ReorderChildrenChange reorderChildrenChange, boolean bl, GanttNode ganttNode, boolean bl2, List<Change> list) throws ChangeException {
        int n;
        Object object2;
        String[] stringArray;
        GanttWBS ganttWBS = (GanttWBS)ganttNode;
        int n2 = ganttWBS.getAllSubTaskCount();
        String[] stringArray2 = bl ? reorderChildrenChange.getOldUids() : reorderChildrenChange.getUids();
        String[] stringArray3 = stringArray = bl ? reorderChildrenChange.getUids() : reorderChildrenChange.getOldUids();
        if (bl2 && (n2 != stringArray2.length || n2 != stringArray.length)) {
            throw new IllegalStateException("Invalid number of nodes: childCount=" + n2 + "/old=" + stringArray.length + " /new=" + stringArray2.length);
        }
        String[] stringArray4 = list != null ? new String[n2] : null;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            GanttNode ganttNode2 = ganttWBS.getSubtaskInAll(i);
            object2 = ganttNode2.getUid();
            if (bl2 && !((String)object2).equals(stringArray[i])) {
                throw new IllegalStateException("Invalid node at position " + i + ": " + (String)object2 + " /Expected: " + stringArray[i]);
            }
            if (!((String)object2).equals(stringArray2[i])) {
                n3 = i;
                break;
            }
            if (stringArray4 == null) continue;
            stringArray4[i] = object2;
        }
        if (n3 == -1) {
            return;
        }
        if (n3 == n2 - 1) {
            if (bl2) {
                throw new IllegalStateException("the last node is unexpected");
            }
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (n = n3; n < n2; ++n) {
            object2 = ganttWBS.getSubtaskInAll(n3);
            String string = ((GanttNode)object2).getUid();
            if (bl2 && !string.equals(stringArray[n])) {
                throw new IllegalStateException("Invalid node at position " + n + ": " + string + " /Expected: " + stringArray[n]);
            }
            if (stringArray4 != null) {
                stringArray4[n] = string;
            }
            hashMap.put(string, object2);
            ganttWBS.removeSubtask((Task)object2);
        }
        for (n = n3; n < stringArray2.length; ++n) {
            object2 = (TGNode)hashMap.get(stringArray2[n]);
            if (object2 == null) {
                if (!bl2) continue;
                throw new IllegalStateException("Node not found: " + stringArray2[n]);
            }
            hashMap.remove(stringArray2[n]);
            ganttWBS.addSubtaskWithoutReorder((TGNode)object2);
        }
        if (!hashMap.isEmpty()) {
            if (bl2) {
                throw new IllegalStateException("Some nodes ar enot listed (" + hashMap.size() + ')');
            }
            for (Object object2 : hashMap.values()) {
                ganttWBS.addSubtaskWithoutReorder((TGNode)object2);
            }
        }
        this.model.recomputeIdsForWbsIfChanged(ganttWBS);
        this.model.fireStructureChanged();
        if (list != null) {
            ReorderChildrenChange reorderChildrenChange2 = new ReorderChildrenChange(ganttWBS, stringArray4);
            reorderChildrenChange2.copyLinkedToPreviousAndTextFromOtherChange(reorderChildrenChange);
            list.add(reorderChildrenChange2);
        }
    }

    protected void applyCreateChange(Change change, boolean bl, GanttNode ganttNode, List<Change> list) throws ChangeException {
        GanttNode ganttNode2;
        if (change.getOperation() != 1) {
            throw new IllegalStateException();
        }
        if (bl) {
            this.applyDeleteChange(Change.newDeleteChange(ganttNode), false, ganttNode, list);
            return;
        }
        if (ganttNode instanceof GanttTask) {
            ganttNode2 = new GanttTask(ganttNode.getDocId(), ganttNode.getHierarchicalId(), ganttNode.getName(), ganttNode.getUid(), ganttNode.getStartDate(), ganttNode.getFinishDate());
        } else if (ganttNode instanceof GanttWBS) {
            ganttNode2 = new GanttWBS(ganttNode.getDocId(), ganttNode.getHierarchicalId(), ganttNode.getName(), ganttNode.getUid(), ganttNode.getStartDate(), ganttNode.getFinishDate());
        } else {
            ObjectType objectType = ganttNode == null ? null : ganttNode.getType();
            throw new IllegalArgumentException("Invalid node type: " + objectType + " (" + ganttNode + ')');
        }
        ganttNode2.setNodeContext(this.model.getRootNode().getNodeContext());
        Change change2 = null;
        if (list != null) {
            change2 = Change.newCreateChange(ganttNode2);
            change2.copyLinkedToPreviousAndTextFromOtherChange(change);
        }
        List<FieldModification> list2 = change.getFieldModifications();
        for (int i = 0; i < list2.size(); ++i) {
            FieldModification fieldModification = list2.get(i);
            this.addNewChangeModification(ganttNode2, fieldModification.field, false, change2, null, fieldModification.newValue, null);
        }
        if (ganttNode2 instanceof GanttTask) {
            this.model.checkComputeAndUpdateTaskValues(null, (GanttTask)ganttNode2, null, 0, false, true);
        } else if (ganttNode2 instanceof GanttWBS) {
            this.model.checkComputeAndUpdateWBSValues(null, (GanttWBS)ganttNode2, null, false, true);
        }
        if (list != null) {
            list.add(change2);
        }
    }

    protected void applyDeleteChange(Change change, boolean bl, GanttNode ganttNode, List<Change> list) throws ChangeException {
        Object object;
        if (change.getOperation() != 2) {
            throw new IllegalStateException();
        }
        PEAppProjectModel pEAppProjectModel = this.model.getProjectModel(ganttNode.getProjectId());
        if (bl) {
            Cloneable cloneable;
            GanttWBS ganttWBS = pEAppProjectModel.getWBSByHierarchicalId(ganttNode.getParentHierarchicalId());
            ganttWBS.addSubtask(ganttNode);
            pEAppProjectModel.addNodeToInternalLists(ganttNode);
            if (ganttNode instanceof GanttWBS) {
                cloneable = ((GanttWBS)ganttNode).getAllChildrenAndSubChildren(false);
                for (int i = 0; i < cloneable.size(); ++i) {
                    GanttNode ganttNode2 = (GanttNode)cloneable.get(i);
                    pEAppProjectModel.addNodeToInternalLists(ganttNode2);
                }
            }
            this.model.recomputeIdsForWbsIfChanged(ganttWBS);
            pEAppProjectModel.rescheduleWBSAndParents(ganttWBS);
            pEAppProjectModel.updateBackwardSchedule(change);
            pEAppProjectModel.updateFinancial();
            this.model.fireStructureChanged();
            if (list != null) {
                cloneable = null;
                if (ganttNode instanceof GanttTask) {
                    TaskUpdater taskUpdater = new TaskUpdater(null, (GanttTask)ganttNode, this.model, null, 0);
                    cloneable = taskUpdater.updateTask();
                } else if (ganttNode instanceof GanttWBS) {
                    WBSUpdater wBSUpdater = new WBSUpdater(null, (GanttWBS)ganttNode, this.model, null);
                    cloneable = wBSUpdater.updateWBS();
                } else {
                    ObjectType objectType = ganttNode == null ? null : ganttNode.getType();
                    throw new IllegalArgumentException("Invalid node type: " + objectType + " (" + ganttNode + ')');
                }
                ((Change)cloneable).copyLinkedToPreviousAndTextFromOtherChange(change);
                list.add((Change)cloneable);
            }
            return;
        }
        GanttWBS ganttWBS = (GanttWBS)ganttNode.getParent();
        ganttWBS.removeSubtask(ganttNode);
        pEAppProjectModel.removeNodeOfInternalLists(ganttNode);
        ArrayList<TGNode> arrayList = null;
        HashMap<String, GanttNode> hashMap = new HashMap<String, GanttNode>();
        if (ganttNode instanceof GanttWBS) {
            arrayList = ((GanttWBS)ganttNode).getAllChildrenAndSubChildren(false);
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (GanttNode)arrayList.get(i);
                pEAppProjectModel.removeNodeOfInternalLists((GanttNode)object);
                if (!(object instanceof GanttTask)) continue;
                hashMap.put(((GanttNode)object).getUid(), (GanttNode)object);
            }
        } else {
            hashMap.put(ganttNode.getUid(), ganttNode);
        }
        this.model.recomputeIdsForWbsIfChanged(ganttWBS);
        Object object2 = change;
        if (list != null) {
            object = Change.newDeleteChange(ganttNode);
            ((Change)object).copyLinkedToPreviousAndTextFromOtherChange(change);
            list.add((Change)object);
            object2 = object;
        }
        this.model.updateSuccessorsOfDeletedTasksAndSchedule(hashMap, ganttWBS, (Change)object2);
        pEAppProjectModel.updateFinancial();
        this.model.fireStructureChanged();
    }

    protected void applyCloneChange(CloneChange cloneChange, boolean bl, GanttNode ganttNode, List<Change> list) throws ChangeException {
        GanttNode ganttNode2;
        Object object;
        if (bl) {
            GanttNode ganttNode3 = cloneChange.getClonedNode();
            this.applyDeleteChange(Change.newDeleteChange(ganttNode3), false, ganttNode3, list);
            return;
        }
        GanttWBS ganttWBS = cloneChange.getNewParent();
        if (!this.model.canCloneNode(ganttNode, ganttWBS = (GanttWBS)this.model.getProjectModel(ganttWBS.getProjectId()).getNodeByUid(ganttWBS.getUid()))) {
            throw new IllegalStateException("Node can not be cloned");
        }
        String[][] stringArray = cloneChange.getUids();
        if (ganttNode instanceof GanttTask) {
            if (!ganttNode.getUid().equals(stringArray[0][0])) {
                throw new IllegalStateException("Invalid id: " + stringArray[0][0] + "/ " + ganttNode.getUid());
            }
            object = stringArray[0][1];
            ganttNode2 = this.model.cloneTaskInternal((GanttTask)ganttNode, ganttWBS, (String)object);
        } else {
            object = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                ((HashMap)object).put(stringArray[i][0], stringArray[i][1]);
            }
            ganttNode2 = this.model.cloneWBS((GanttWBS)ganttNode, ganttWBS, (Map<String, String>)object);
        }
        if (cloneChange.getNewName() != null) {
            ganttNode2.setName(cloneChange.getNewName());
        }
        this.model.fireStructureChanged();
        if (list != null) {
            object = new CloneChange(ganttNode, ganttWBS, ganttNode2, cloneChange.getNewName(), cloneChange.getUids());
            ((Change)object).copyLinkedToPreviousAndTextFromOtherChange(cloneChange);
            list.add((Change)object);
        }
    }

    protected void applyTransformTaskIntoWBSChange(TransformTaskIntoWBSChange transformTaskIntoWBSChange, boolean bl, GanttNode ganttNode, List<Change> list) throws ChangeException {
        GanttTask ganttTask = (GanttTask)ganttNode;
        if (bl) {
            GanttWBS ganttWBS = transformTaskIntoWBSChange.getWBS();
            if (ganttWBS.getAllSubTaskCount() > 0) {
                throw new IllegalStateException("WBS " + ganttWBS + " has a least one child: " + ganttWBS.getAllSubTaskCount());
            }
            PEAppProjectModel pEAppProjectModel = this.model.getProjectModel(ganttNode.getProjectId());
            pEAppProjectModel.addNodeToInternalLists(ganttTask);
            pEAppProjectModel.removeNodeOfInternalLists(ganttWBS);
            GanttWBS ganttWBS2 = (GanttWBS)ganttWBS.getParent();
            ganttWBS2.removeSubtask(ganttWBS);
            ganttWBS2.addSubtask(ganttTask);
            pEAppProjectModel.rescheduleWBSAndParents((GanttWBS)ganttTask.getParent());
            pEAppProjectModel.updateFinancial();
            pEAppProjectModel.updateBackwardSchedule(transformTaskIntoWBSChange);
            if (this.model.isSelectedNode(ganttWBS)) {
                TGNode[] tGNodeArray = this.model.getSelectedNodes();
                if (tGNodeArray.length > 1) {
                    for (int i = 0; i < tGNodeArray.length; ++i) {
                        if (ganttWBS != tGNodeArray[i]) continue;
                        tGNodeArray[i] = ganttTask;
                        break;
                    }
                    this.model.setSelectedNodes(tGNodeArray);
                } else {
                    this.model.setSelectedNodes(ganttTask);
                }
            }
            this.model.fireStructureChanged();
            return;
        }
        if (!this.model.canTransformTaskIntoWbs(ganttTask)) {
            throw new ChangeException("Task can not be transformed into WBS");
        }
        TransformTaskIntoWBSChange transformTaskIntoWBSChange2 = this.model.transformTaskIntoWBS(ganttTask);
        if (list != null) {
            transformTaskIntoWBSChange2.copyLinkedToPreviousAndTextFromOtherChange(transformTaskIntoWBSChange);
            list.add(transformTaskIntoWBSChange2);
        }
    }

    protected void applyTransformWBSIntoTaskChange(TransformWBSIntoTaskChange transformWBSIntoTaskChange, boolean bl, GanttNode ganttNode, List<Change> list) throws ChangeException {
        GanttWBS ganttWBS = (GanttWBS)ganttNode;
        PEAppProjectModel pEAppProjectModel = this.model.getProjectModel(ganttNode.getProjectId());
        if (bl) {
            GanttTask ganttTask = transformWBSIntoTaskChange.getTask();
            pEAppProjectModel.addNodeToInternalLists(ganttWBS);
            pEAppProjectModel.removeNodeOfInternalLists(ganttTask);
            GanttWBS ganttWBS2 = (GanttWBS)ganttTask.getParent();
            ganttWBS2.removeSubtask(ganttTask);
            ganttWBS2.addSubtask(ganttWBS);
            pEAppProjectModel.rescheduleWBSAndParents((GanttWBS)ganttWBS.getParent());
            pEAppProjectModel.updateFinancial();
            pEAppProjectModel.updateBackwardSchedule(transformWBSIntoTaskChange);
            if (this.model.isSelectedNode(ganttTask)) {
                TGNode[] tGNodeArray = this.model.getSelectedNodes();
                if (tGNodeArray.length > 1) {
                    for (int i = 0; i < tGNodeArray.length; ++i) {
                        if (ganttTask != tGNodeArray[i]) continue;
                        tGNodeArray[i] = ganttWBS;
                        break;
                    }
                    this.model.setSelectedNodes(tGNodeArray);
                } else {
                    this.model.setSelectedNodes(ganttWBS);
                }
            }
            this.model.fireStructureChanged();
            return;
        }
        if (!this.model.canTransformWbsIntoTask(ganttWBS)) {
            throw new ChangeException("WBS can not be transformed into a task");
        }
        TransformWBSIntoTaskChange transformWBSIntoTaskChange2 = this.model.transformWBSIntoTask(ganttWBS);
        if (list != null) {
            transformWBSIntoTaskChange2.copyLinkedToPreviousAndTextFromOtherChange(transformWBSIntoTaskChange);
            list.add(transformWBSIntoTaskChange2);
        }
    }

    protected void applyUpdateChange(Change change, boolean bl, GanttNode ganttNode, boolean bl2, List<Change> list) throws ChangeException {
        int n;
        if (change.getOperation() != 0) {
            throw new IllegalStateException();
        }
        Change change2 = null;
        if (list != null) {
            change2 = Change.newUpdateChange(ganttNode);
            change2.copyLinkedToPreviousAndTextFromOtherChange(change);
        }
        if (GanttNode.isSubprojectLink(ganttNode)) {
            bl2 = false;
        }
        List<FieldModification> list2 = change.getFieldModifications();
        GanttNode ganttNode2 = ganttNode.clone();
        for (n = 0; n < list2.size(); ++n) {
            FieldModification fieldModification = list2.get(n);
            String string = bl2 ? change.getText() + ' ' + fieldModification.field : null;
            Object object = bl ? fieldModification.oldValue : fieldModification.newValue;
            Object object2 = bl ? fieldModification.newValue : fieldModification.oldValue;
            this.addNewChangeModification(ganttNode2, fieldModification.field, bl2, change2, object2, object, string);
        }
        if (ganttNode2 instanceof GanttTask) {
            this.model.checkComputeAndUpdateTaskValues((GanttTask)ganttNode, (GanttTask)ganttNode2, null, 0, false, true);
        } else if (ganttNode2 instanceof GanttWBS) {
            n = ganttNode.getAllSubTaskCount();
            this.model.checkComputeAndUpdateWBSValues((GanttWBS)ganttNode, (GanttWBS)ganttNode2, null, false, true);
            if (n != ganttNode.getAllSubTaskCount()) {
                this.model.fireStructureChanged();
            }
        }
        if (list != null) {
            list.add(change2);
        }
    }

    private void addNewChangeModification(GanttNode ganttNode, String string, boolean bl, Change change, Object object, Object object2, String string2) throws ChangeException {
        PEAppProjectModel pEAppProjectModel = this.model.getProjectModel(ganttNode.getProjectId());
        if (string.equals("name")) {
            String string3 = ganttNode.getName();
            if (bl) {
                this.checkChange(string3, object, string2);
            }
            if (change != null) {
                change.addModification("name", string3, object2);
            }
            ganttNode.setName((String)object2);
            return;
        }
        if (string.equals("percentComplete")) {
            Double d = ganttNode.getPercentComplete();
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("percentComplete", d, object2);
            }
            ganttNode.setPercentComplete((Double)object2);
            return;
        }
        if (string.equals("status")) {
            String string4 = ganttNode.getStatus();
            if (bl) {
                this.checkChange(string4, object, string2);
            }
            if (change != null) {
                change.addModification("status", string4, object2);
            }
            ganttNode.setStatus((String)object2);
            return;
        }
        if (string.equals("startDate")) {
            Date date = ganttNode.getDuration().getStart();
            if (bl) {
                this.checkChange(date, object, string2);
            }
            if (change != null) {
                change.addModification("startDate", date, object2);
            }
            date.setTime(((Date)object2).getTime());
            return;
        }
        if (string.equals("endDate")) {
            Date date = ganttNode.getDuration().getEnd();
            if (bl) {
                this.checkChange(date, object, string2);
            }
            if (change != null) {
                change.addModification("endDate", date, object2);
            }
            date.setTime(((Date)object2).getTime());
            return;
        }
        if (string.equals("taskPredecessors")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            ArrayList<Predecessor> arrayList = ganttTask.getPredecessorsCopy();
            if (bl) {
                this.checkChangeForList(arrayList, (List)object, string2);
            }
            if (change != null) {
                change.addModification("taskPredecessors", arrayList, object2);
            }
            ArrayList arrayList2 = object2 == null ? null : (ArrayList)((ArrayList)object2).clone();
            ganttTask.setPredecessors(arrayList2);
            return;
        }
        if (string.equals("taskResources")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Object[] objectArray = ganttTask.getResourcesCopy();
            if (bl) {
                this.checkChangeForArray(objectArray, (Object[])object, string2);
            }
            if (change != null) {
                change.addModification("taskResources", objectArray, object2);
            }
            TaskResource[] taskResourceArray = null;
            if (object2 != null) {
                taskResourceArray = new TaskResource[((TaskResource[])object2).length];
                for (int i = 0; i < ((TaskResource[])object2).length; ++i) {
                    ProjectResource projectResource;
                    taskResourceArray[i] = ((TaskResource[])object2)[i].clone();
                    Resource resource = taskResourceArray[i].getResource();
                    if (resource == (projectResource = pEAppProjectModel.getProjectResource(resource.getDn()))) continue;
                    if (projectResource == null) {
                        throw new ChangeException("Resource does not exist anymore: " + resource.getCn());
                    }
                    taskResourceArray[i].setResource(projectResource);
                }
            }
            ganttTask.setResources(taskResourceArray);
            return;
        }
        if (string.equals("wbsSupervisors")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Object[] objectArray = ganttWBS.getResourcesCopy();
            if (bl) {
                this.checkChangeForArray(objectArray, (Object[])object, string2);
            }
            if (change != null) {
                change.addModification("wbsSupervisors", objectArray, object2);
            }
            if (ganttWBS.isSubProject()) {
                ganttWBS.setResources((Resource[])object2);
            } else {
                Resource[] resourceArray = null;
                if (object2 != null) {
                    resourceArray = new Resource[((Resource[])object2).length];
                    for (int i = 0; i < ((Resource[])object2).length; ++i) {
                        Resource resource = ((Resource[])object2)[i];
                        ProjectResource projectResource = pEAppProjectModel.getProjectResource(resource.getDn());
                        if (resource != projectResource) {
                            if (projectResource == null) {
                                throw new ChangeException("Resource does not exist anymore: " + resource.getCn());
                            }
                            resource = projectResource;
                        }
                        resourceArray[i] = resource;
                    }
                }
                ganttWBS.setResources(resourceArray);
            }
            return;
        }
        if (string.equals("durationInHours")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Double d = new Double(ganttTask.getDurationInHours());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("durationInHours", d, object2);
            }
            ganttTask.setDurationInHours(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("durationdisplay")) {
            Double d = new Double(ganttNode.getDurationDisplay());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("durationdisplay", d, object2);
            }
            ganttNode.setDurationDisplay(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("durationformat")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Integer n = new Integer(ganttTask.getDurationFormat());
            if (bl) {
                this.checkChange(n, object, string2);
            }
            if (change != null) {
                change.addModification("durationformat", n, object2);
            }
            ganttTask.setDurationFormat(this.getIntValue((Integer)object2));
            return;
        }
        if (string.equals("work")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Double d = new Double(ganttTask.getWorkInHours());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("work", d, object2);
            }
            ganttTask.setWorkInHours(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("workdisplay")) {
            Double d = new Double(ganttNode.getWorkDisplay());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("workdisplay", d, object2);
            }
            ganttNode.setWorkDisplay(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("workformat")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Integer n = new Integer(ganttTask.getWorkFormat());
            if (bl) {
                this.checkChange(n, object, string2);
            }
            if (change != null) {
                change.addModification("workformat", n, object2);
            }
            ganttTask.setWorkFormat(this.getIntValue((Integer)object2));
            return;
        }
        if (string.equals("description")) {
            String string5 = ganttNode.getNodeDescription();
            if (bl) {
                this.checkChange(string5, object, string2);
            }
            if (change != null) {
                change.addModification("description", string5, object2);
            }
            ganttNode.setNodeDescription((String)object2);
            return;
        }
        if (string.equals("actualstart")) {
            Date date;
            GanttTask ganttTask = (GanttTask)ganttNode;
            Date date2 = ganttTask.getActualStartDate();
            if (bl) {
                this.checkChange(date2, object, string2);
            }
            if (change != null) {
                change.addModification("actualstart", date2, object2);
            }
            if ((date = (Date)object2) != null) {
                date = (Date)date.clone();
            }
            ganttTask.setActualStartDate(date);
            return;
        }
        if (string.equals("actualfinish")) {
            Date date;
            GanttTask ganttTask = (GanttTask)ganttNode;
            Date date3 = ganttTask.getActualFinishDate();
            if (bl) {
                this.checkChange(date3, object, string2);
            }
            if (change != null) {
                change.addModification("actualfinish", date3, object2);
            }
            if ((date = (Date)object2) != null) {
                date = (Date)date.clone();
            }
            ganttTask.setActualFinishDate(date);
            return;
        }
        if (string.equals("skipautoreschedule")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Boolean bl2 = ganttTask.isSkipAutoReschedule();
            if (bl) {
                this.checkChange(bl2, object, string2);
            }
            if (change != null) {
                change.addModification("skipautoreschedule", bl2, object2);
            }
            ganttTask.setSkipAutoReschedule((Boolean)object2);
            return;
        }
        if (string.equals("schedulingmode")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Integer n = new Integer(ganttTask.getSchedulingMode());
            if (bl) {
                this.checkChange(n, object, string2);
            }
            if (change != null) {
                change.addModification("schedulingmode", n, object2);
            }
            ganttTask.setSchedulingMode(this.getIntValue((Integer)object2));
            return;
        }
        if (string.equals("deadline")) {
            Date date;
            GanttTask ganttTask = (GanttTask)ganttNode;
            Date date4 = ganttTask.getDeadlineDate();
            if (bl) {
                this.checkChange(date4, object, string2);
            }
            if (change != null) {
                change.addModification("deadline", date4, object2);
            }
            if ((date = (Date)object2) != null) {
                date = (Date)date.clone();
            }
            ganttTask.setDeadlineDate(date);
            return;
        }
        if (string.equals("calendarid")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            String string6 = ganttTask.getCalendarId();
            if (bl) {
                this.checkChange(string6, object, string2);
            }
            if (change != null) {
                change.addModification("calendarid", string6, object2);
            }
            ganttTask.setCalendarId((String)object2);
            return;
        }
        if (string.equals("ignoreresourcecalendar")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Boolean bl3 = ganttTask.isIgnoreResourcesCalendar();
            if (bl) {
                this.checkChange(bl3, object, string2);
            }
            if (change != null) {
                change.addModification("ignoreresourcecalendar", bl3, object2);
            }
            ganttTask.setIgnoreResourcesCalendar((Boolean)object2);
            return;
        }
        if (string.equals("priority")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Integer n = new Integer(ganttTask.getPriority());
            if (bl) {
                this.checkChange(n, object, string2);
            }
            if (change != null) {
                change.addModification("priority", n, object2);
            }
            ganttTask.setPriority(this.getIntValue((Integer)object2));
            return;
        }
        if (string.equals("remainWork")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Double d = new Double(ganttTask.getSpecifiedRemainingWork());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("remainWork", d, object2);
            }
            ganttTask.setSpecifiedRemainingWork(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("actualWork")) {
            GanttTask ganttTask = (GanttTask)ganttNode;
            Double d = new Double(ganttTask.getSpecifiedActualWork());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("actualWork", d, object2);
            }
            ganttTask.setSpecifiedActualWork(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("parentInternalId")) {
            ParentFieldValue parentFieldValue = (ParentFieldValue)object;
            ParentFieldValue parentFieldValue2 = (ParentFieldValue)object2;
            GanttWBS ganttWBS = (GanttWBS)pEAppProjectModel.getNodeByUid(parentFieldValue2.parentUid);
            if (ganttWBS == null) {
                throw new ChangeException("wbs_empty", "parentInternalId");
            }
            GanttWBS ganttWBS2 = (GanttWBS)ganttNode.getParent();
            if (bl && ganttWBS2 != null) {
                this.checkChange(ganttWBS2.getUid(), parentFieldValue.parentUid, string2);
            }
            if (change != null) {
                String string7;
                String string8 = ganttWBS2 != null ? ganttWBS2.getUid() : null;
                string7 = parentFieldValue != null && parentFieldValue.childHierarchicalId != null ? (string7 = ganttNode.getHierarchicalId()) : null;
                ParentFieldValue parentFieldValue3 = new ParentFieldValue(string8, string7);
                change.addModification("parentInternalId", parentFieldValue3, parentFieldValue2);
            }
            if (parentFieldValue2.childHierarchicalId != null) {
                ganttNode.setHierarchicalId(parentFieldValue2.childHierarchicalId);
            } else {
                int n = this.model.getNextTaskSubId(ganttWBS);
                ganttNode.setHierarchicalId(ganttWBS.getHierarchicalId() + '.' + n);
            }
            ganttNode.setParent(ganttWBS);
            return;
        }
        if (string.equals("additionalcost")) {
            Double d = new Double(ganttNode.getAdditionalCost());
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("additionalcost", d, object2);
            }
            ganttNode.setAdditionalCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("actualadditionalcost")) {
            Double d = ganttNode.getSpecifiedActualAdditionalCost();
            if (bl) {
                this.checkChange(d, object, string2);
            }
            if (change != null) {
                change.addModification("actualadditionalcost", d, object2);
            }
            ganttNode.setSpecifiedActualAdditionalCost((Double)object2);
            return;
        }
        if (string.equals("additionalcostdescription")) {
            String string9 = ganttNode.getAdditionalCostDescription();
            if (bl) {
                this.checkChange(string9, object, string2);
            }
            if (change != null) {
                change.addModification("additionalcostdescription", string9, object2);
            }
            ganttNode.setAdditionalCostDescription((String)object2);
            return;
        }
        if (string.equals("subproject")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            NameId nameId = ganttWBS.getSubProject();
            if (bl) {
                String string10 = object == null ? null : ((NameId)object).getId();
                String string11 = nameId == null ? null : nameId.getId();
                this.checkChange(string11, string10, string2);
            }
            if (change != null) {
                change.addModification("subproject", nameId, object2);
            }
            ganttWBS.setSubProject((NameId)object2);
            return;
        }
        if (string.equals("subprojectOptions")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            String string12 = ganttWBS.getSubprojectOptionsAsString();
            if (bl) {
                this.checkChange(string12, object, string2);
            }
            if (change != null) {
                change.addModification("subprojectOptions", string12, object2);
            }
            ganttWBS.setSubprojectOptions(new SubprojectOptions((String)object2));
            return;
        }
        if (string.equals("subPrjFinPAC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getProjectedAdditionalCost();
            if (change != null) {
                change.addModification("subPrjFinPAC", d, object2);
            }
            ganttWBS.setProjectedAdditionalCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("subPrjFinAAC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getActualAdditionalCost();
            if (change != null) {
                change.addModification("subPrjFinAAC", d, object2);
            }
            ganttWBS.setActualAdditionalCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("subPrjFinPRC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getProjectedResourceCost();
            if (change != null) {
                change.addModification("subPrjFinPRC", d, object2);
            }
            ganttWBS.setProjectedResourceCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("subPrjFinARC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getActualResourceCost();
            if (change != null) {
                change.addModification("subPrjFinARC", d, object2);
            }
            ganttWBS.setActualResourceCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("subPrjFinIPAC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getInitiallyPlannedAdditionalCost();
            if (change != null) {
                change.addModification("subPrjFinIPAC", d, object2);
            }
            ganttWBS.setInitiallyPlannedAdditionalCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("subPrjFinIPRC")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getInitiallyPlannedResourceCost();
            if (change != null) {
                change.addModification("subPrjFinIPRC", d, object2);
            }
            ganttWBS.setInitiallyPlannedResourceCost(this.getDoubleValue((Double)object2));
            return;
        }
        if (string.equals("plW")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getPlannedWorkedHours();
            if (change != null) {
                change.addModification("plW", d, object2);
            }
            ganttWBS.setPlannedWorkedHours((Double)object2);
            ganttWBS.setPlannedProgress(ganttWBS.getWorkInHours() > 0.0 ? ganttWBS.getPlannedWorkedHours() / ganttWBS.getWorkInHours() : 1.0);
            return;
        }
        if (string.equals("cpW")) {
            GanttWBS ganttWBS = (GanttWBS)ganttNode;
            Double d = ganttWBS.getComputedWorkedHours();
            if (change != null) {
                change.addModification("cpW", d, object2);
            }
            ganttWBS.setComputedWorkedHours((Double)object2);
            return;
        }
        if (string.equals("Social")) {
            NodeSocialData nodeSocialData = ganttNode.getSocialData();
            if (change != null) {
                change.addModification("Social", nodeSocialData, object2);
            }
            ganttNode.getSocialData().updateSummary((NodeSocialData)object2);
            return;
        }
        throw new IllegalStateException("Unknown field: " + string + " -oldValue=" + object + " /newValue=" + object2);
    }

    private double getDoubleValue(Double d) {
        return d == null ? 0.0 : d;
    }

    private int getIntValue(Integer n) {
        return n == null ? 0 : n;
    }

    private void checkChange(Object object, Object object2, String string) throws RuntimeException {
        if (object == null && object2 == null || object != null && object.equals(object2)) {
            return;
        }
        if (object == null && this.isEquivalentToNull(object2)) {
            return;
        }
        if (object2 == null && this.isEquivalentToNull(object)) {
            return;
        }
        throw new IllegalStateException("Source: " + string + " /Expected: " + object2 + " /Actual: " + object);
    }

    private void checkChangeForList(List<?> list, List<?> list2, String string) throws RuntimeException {
        int n;
        if (list == null && list2 == null) {
            return;
        }
        int n2 = list == null ? 0 : list.size();
        int n3 = n = list2 == null ? 0 : list2.size();
        if (n2 != n) {
            throw new IllegalStateException("Source: " + string + " /Expected: " + list2 + " /Actual: " + list);
        }
        for (int i = 0; i < n2; ++i) {
            this.checkChange(list.get(i), list2.get(i), string);
        }
    }

    private void checkChangeForArray(Object[] objectArray, Object[] objectArray2, String string) throws RuntimeException {
        int n;
        if (objectArray == null && objectArray2 == null) {
            return;
        }
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = n = objectArray2 == null ? 0 : objectArray2.length;
        if (n2 != n) {
            throw new IllegalStateException("Source: " + string + " /Expected: " + objectArray2 + " /Actual: " + objectArray);
        }
        for (int i = 0; i < n2; ++i) {
            this.checkChange(objectArray[i], objectArray2[i], string);
        }
    }

    private boolean isEquivalentToNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() == 0.0;
        }
        return false;
    }
}

