/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.GanttExceptionWS;
import com.triloggroup.gantt.app.UnexpectedChangeException;
import com.triloggroup.gantt.app.applet.GanttAppletBase;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.ui.ULabel;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.ConnectException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class WDDialog
extends JDialog
implements MouseListener,
MouseMotionListener {
    private DialogBorder dlgBorder;
    private boolean dragHeader = false;
    private DragHeaderInfo dragInfo;
    private boolean hasDialogDecoration = false;
    private Rectangle restoreRect = null;
    private boolean isClosable = true;
    private boolean isMaximizable = true;
    private boolean isPacked = false;
    protected int scrollWidth = UIManager.getInt("ScrollBar.width");
    private ModalityGlassPane modalityGlassPane;
    private static Icon barIcon = WDUtil.getIcon("windowbar.gif");
    private static Icon leftBarIcon = WDUtil.getIcon("windowbarleft.gif");
    private static Icon rightBarIcon = WDUtil.getIcon("windowbarright.gif");
    private static Color borderColor = new Color(203, 218, 241);
    private static Icon barIcon_highlight = WDUtil.getIcon("windowbar_highlight.gif");
    private static Icon leftBarIcon_highlight = WDUtil.getIcon("windowbarleft_highlight.gif");
    private static Icon rightBarIcon_highlight = WDUtil.getIcon("windowbarright_highlight.gif");
    private static Color borderColor_highlight = new Color(254, 205, 6);
    private static Icon barIcon_close = WDUtil.getIcon("window_close.gif");
    private static Icon barIcon_maximize = WDUtil.getIcon("window_maximize.gif");
    private static Icon barIcon_restore = WDUtil.getIcon("window_restore.gif");
    private static Icon barIcon_close_highlight = WDUtil.getIcon("window_close_highlight.gif");
    private static Icon barIcon_maximize_highlight = WDUtil.getIcon("window_maximize_highlight.gif");
    private static Icon barIcon_restore_highlight = WDUtil.getIcon("window_restore_highlight.gif");
    private static int DECORATION_WIDTH_GAP = 5;
    private static int DECORATION_HEIGHT_GAP = 3;
    private static final int RESIZE_N = 1;
    private static final int RESIZE_S = 2;
    private static final int RESIZE_W = 4;
    private static final int RESIZE_E = 8;
    private static final int RESIZE_NW = 5;
    private static final int RESIZE_SW = 6;
    private static final int RESIZE_NE = 9;
    private static final int RESIZE_SE = 10;

    protected WDDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, null, DEFAULT_MODALITY_TYPE, graphicsConfiguration);
        this.initLook();
    }

    protected void initLook() {
        super.setUndecorated(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.dlgBorder = new DialogBorder();
        this.getRootPane().setBorder(this.dlgBorder);
        this.getRootPane().addMouseListener(this);
        this.getRootPane().addMouseMotionListener(this);
    }

    public void setModalityGlassPane(boolean bl) {
        if (bl) {
            this.setModal(false);
            if (this.modalityGlassPane == null) {
                this.modalityGlassPane = new ModalityGlassPane(this.getParent());
            }
        } else if (this.modalityGlassPane != null) {
            this.modalityGlassPane.removeGlassPane();
            this.modalityGlassPane = null;
        }
    }

    public boolean canDisposeByClickingOutside() {
        return true;
    }

    public void setDragHeader(boolean bl) {
        this.dragHeader = bl;
        if (this.dragHeader) {
            this.hasDialogDecoration = true;
        }
    }

    public void setHighlightBorder(boolean bl) {
        this.dlgBorder.setHighlightBorder(bl);
        if (this.dragHeader && bl) {
            this.isMaximizable = false;
        }
    }

    private boolean isInDragHeader(Point point) {
        return this.dragHeader && point.y < this.dlgBorder.getHeaderHeight() && point.x > 5 && !this.isInCloseIcon(point);
    }

    public void setDialogDecoration(boolean bl) {
        this.hasDialogDecoration = bl;
    }

    public void setClosable(boolean bl) {
        this.isClosable = bl;
    }

    public boolean isClosable() {
        return this.isClosable;
    }

    public void setMaximizable(boolean bl) {
        this.isMaximizable = bl;
    }

    public boolean isMaximizable() {
        return this.isMaximizable;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.ensureFullyVisible();
        }
        super.setVisible(bl);
    }

    public void setVisibleDisableMouseEvents(final long l) {
        if (l > 0L) {
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WDDialog.this.glassPaneEnableMouseEvents();
                }
            }.start();
            this.getGlassPane().addMouseListener(new MouseAdapter(){});
            this.getGlassPane().setVisible(true);
        }
        this.setVisible(true);
    }

    private void glassPaneEnableMouseEvents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WDDialog.this.glassPaneEnableMouseEvents();
                }
            });
            return;
        }
        this.getGlassPane().setVisible(false);
    }

    public void setVisible(int n, int n2, int n3, int n4, Component component) {
        this.ensureMinMaxSize(n, n2, n3, n4);
        if (component != null) {
            this.setLocationRelativeTo(component);
        }
        this.setVisible(true);
    }

    public void setVisibleCenteredAtScreenPoint(Point point) {
        if (!this.isPacked) {
            this.pack();
        }
        Dimension dimension = this.getSize();
        point.x -= dimension.width / 2;
        point.y -= dimension.height / 2;
        this.setLocation(point);
        this.setVisible(true);
    }

    public void ensureMinMaxSize(int n, int n2, int n3, int n4) {
        if (!this.isPacked) {
            this.pack();
        }
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (n > 0 && n > dimension.width) {
            dimension.width = n;
            bl = true;
        } else if (n3 > 0 && n3 < dimension.width) {
            dimension.width = n3;
            bl = true;
        }
        if (n2 > 0 && n2 > dimension.height) {
            dimension.height = n2;
            bl = true;
        } else if (n4 > 0 && n4 < dimension.height) {
            dimension.height = n4;
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
        }
    }

    public void ensureFullyVisible() {
        if (!this.isPacked) {
            this.pack();
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getDisplayBounds();
        boolean bl = false;
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
            bl = true;
        } else if (rectangle.x + rectangle.width > rectangle2.width + rectangle2.x) {
            rectangle.x = Math.max(rectangle2.width + rectangle2.x - rectangle.width, rectangle2.x);
            bl = true;
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
            bl = true;
        } else if (rectangle.y + rectangle.height > rectangle2.height + rectangle2.y) {
            rectangle.y = Math.max(rectangle2.height + rectangle2.y - rectangle.height, rectangle2.y);
            bl = true;
        }
        if (bl) {
            this.setBounds(rectangle);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += this.scrollWidth;
        this.ensureDimensionFitsScreen(dimension);
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width += this.scrollWidth;
        this.ensureDimensionFitsScreen(dimension);
        return dimension;
    }

    private void ensureDimensionFitsScreen(Dimension dimension) {
        if (dimension.height <= 500 && dimension.width <= 750) {
            return;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            Rectangle rectangle = WDUtil.getDisplayBounds(graphicsConfiguration);
            if (dimension.height > rectangle.height) {
                dimension.height = rectangle.height;
            }
            if (dimension.width > rectangle.width) {
                dimension.width = rectangle.width;
                dimension.height = Math.min(rectangle.height, dimension.height + this.scrollWidth);
            }
        }
    }

    public void close() {
        switch (this.getDefaultCloseOperation()) {
            case 2: {
                this.dispose();
                break;
            }
            case 1: {
                this.setVisible(false);
                break;
            }
        }
    }

    public void maximize() {
        if (this.isMaximizable()) {
            this.restoreRect = new Rectangle(this.getLocation(), this.getSize());
            Rectangle rectangle = this.getDisplayBounds();
            this.setBounds(rectangle);
            this.validate();
        }
    }

    public void restore() {
        if (this.restoreRect != null) {
            this.setBounds(this.restoreRect);
            this.restoreRect = null;
            this.validate();
        }
    }

    protected Rectangle getDisplayBounds() {
        if (!this.isShowing()) {
            Point point = this.getLocation();
            if (point.x != 0 || point.y != 0) {
                return WDUtil.getDisplayBounds(point);
            }
        }
        return WDUtil.getDisplayBounds(this);
    }

    protected boolean isInCloseIcon(Point point) {
        if (this.hasDialogDecoration && this.isClosable) {
            Dimension dimension = this.getSize();
            if (point.x < dimension.width && point.x > dimension.width - (barIcon_close.getIconWidth() + DECORATION_WIDTH_GAP) && point.y < barIcon_close.getIconHeight() + DECORATION_HEIGHT_GAP) {
                return true;
            }
        }
        return false;
    }

    protected boolean isInMaximizeIcon(Point point) {
        if (this.hasDialogDecoration && this.isMaximizable && this.restoreRect == null) {
            Dimension dimension = this.getSize();
            int n = dimension.width - 2 * DECORATION_WIDTH_GAP - barIcon_close.getIconHeight();
            if (!this.isClosable) {
                n = dimension.width - DECORATION_WIDTH_GAP;
            }
            if (point.x < n && point.x > n - barIcon_maximize.getIconWidth() && point.y > DECORATION_HEIGHT_GAP && point.y < DECORATION_HEIGHT_GAP + barIcon_maximize.getIconHeight()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isInRestoreIcon(Point point) {
        if (this.hasDialogDecoration && this.isMaximizable && this.restoreRect != null) {
            Dimension dimension = this.getSize();
            int n = dimension.width - 2 * DECORATION_WIDTH_GAP - barIcon_close.getIconHeight();
            if (!this.isClosable) {
                n = dimension.width - DECORATION_WIDTH_GAP;
            }
            if (point.x < n && point.x > n - barIcon_restore.getIconWidth() && point.y > DECORATION_HEIGHT_GAP && point.y < DECORATION_HEIGHT_GAP + barIcon_restore.getIconHeight()) {
                return true;
            }
        }
        return false;
    }

    public void pack() {
        this.isPacked = true;
        super.pack();
    }

    protected static Component adjustParentComponent(Component component) {
        if (component == null) {
            return null;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JViewport)) continue;
            return container;
        }
        return component;
    }

    public void setLocationRelativeTo(Component component) {
        Component component2;
        component = WDDialog.adjustParentComponent(component);
        if (!this.isPacked) {
            this.pack();
        }
        Component component3 = component2 = component == null ? null : SwingUtilities.getRoot(component);
        if (component != null && !component.isShowing() || component2 == null || !component2.isShowing()) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = WDUtil.getDisplayBounds(this.getGraphicsConfiguration());
            this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        } else {
            Dimension dimension = component.getSize();
            Point point = component.getLocationOnScreen();
            if (component instanceof JViewport) {
                dimension = ((JViewport)component).getExtentSize();
            }
            Rectangle rectangle = this.getBounds();
            int n = point.x + (dimension.width - rectangle.width >> 1);
            int n2 = point.y + (dimension.height - rectangle.height >> 1);
            this.setLocation(n, n2);
            if (this.isShowing()) {
                this.ensureFullyVisible();
            }
        }
    }

    public static void showMsgDialog(Component component, String string) {
        WDDialog wDDialog = WDDialog.createMsgDialog(component, string);
        wDDialog.setVisible(-1, -1, -1, -1, component);
        wDDialog.dispose();
    }

    public static WDDialog createMsgDialog(Component component, String string) {
        JLabel jLabel = new JLabel(string);
        return WDDialog.createMsgDialog(component, jLabel);
    }

    private static WDDialog createMsgDialog(Component component, JComponent jComponent) {
        WDDialog wDDialog = WDDialog.createWDDialog(component, true, true);
        wDDialog.getContentPane().setLayout(new BorderLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        wDDialog.getContentPane().add((Component)jComponent, "Center");
        WDButton wDButton = WDUtil.createOkButton();
        JPanel jPanel = WDDialog.createButtonPanel(wDButton);
        wDDialog.getContentPane().add((Component)jPanel, "South");
        wDButton.addActionListener(wDDialog.new DisposeActionListener());
        wDDialog.pack();
        return wDDialog;
    }

    public static void showHelpMsgDialog(Component component, String string) {
        WDDialog wDDialog = WDDialog.createHelpMsgDialog(component, string);
        wDDialog.setVisible(-1, -1, -1, -1, component);
        wDDialog.dispose();
    }

    private static WDDialog createHelpMsgDialog(Component component, String string) {
        WDDialog wDDialog = WDDialog.createWDDialog(component, true, false);
        wDDialog.setMaximizable(false);
        wDDialog.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        wDDialog.getContentPane().add((Component)jLabel, "Center");
        WDButton wDButton = WDUtil.createOkButton();
        JPanel jPanel = WDDialog.createButtonPanel(wDButton);
        wDDialog.getContentPane().add((Component)jPanel, "South");
        wDButton.addActionListener(wDDialog.new DisposeActionListener());
        wDDialog.pack();
        return wDDialog;
    }

    public static void showMultilineMsgDialog(Component component, String[] stringArray) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        for (String string : stringArray) {
            jPanel.add(new JLabel(string));
        }
        WDDialog wDDialog = WDDialog.createMsgDialog(component, jPanel);
        wDDialog.setVisible(-1, -1, -1, -1, component);
        wDDialog.dispose();
    }

    public static void showErrorMsgDialog(Component component, Throwable throwable, Point point, boolean bl) {
        WDDialog wDDialog = WDDialog.createErrorMsgDialog(component, throwable);
        if (wDDialog != null) {
            if (point == null) {
                wDDialog.setVisible(-1, -1, -1, -1, component);
            } else if (bl) {
                wDDialog.setVisibleCenteredAtScreenPoint(point);
            } else {
                wDDialog.setLocation(point);
                wDDialog.setVisible(true);
            }
            wDDialog.dispose();
        }
    }

    public static void showErrorMsgDialog(Component component, Throwable throwable) {
        WDDialog.showErrorMsgDialog(component, throwable, null, false);
    }

    private static WDDialog createErrorMsgDialog(Component component, Throwable throwable) {
        Serializable serializable;
        if (!(throwable instanceof ChangeException) || throwable instanceof UnexpectedChangeException) {
            throwable.printStackTrace();
        }
        boolean bl = false;
        if (throwable instanceof GanttExceptionWS) {
            bl = true;
        } else {
            for (serializable = throwable; serializable != null; serializable = serializable.getCause()) {
                if (!(serializable instanceof ConnectException) && !(serializable instanceof GanttExceptionWS)) continue;
                bl = true;
                break;
            }
        }
        String string = throwable instanceof ChangeException || throwable instanceof GanttExceptionWS && ((GanttExceptionWS)throwable).getCode() == 10050 ? throwable.getLocalizedMessage() : (AppGanttChart.NLS_BUNDLE != null ? AppGanttChart.NLS_BUNDLE.getString("unexpected_error", throwable.getLocalizedMessage()) : throwable.getLocalizedMessage());
        if (bl) {
            System.out.println("-----Connection or Server error-----");
            serializable = WDDialog.getParentGanttApplet(component);
            if (serializable != null) {
                JLabel jLabel = ULabel.createLinkJLabel(Workbench.getNLSString("relogin", new Object[0]), false);
                jLabel.addMouseListener(new ULabel.LinkHoverMouseAdapter(true, (GanttAppletBase)serializable){
                    final /* synthetic */ GanttAppletBase val$ganttApplet;
                    {
                        this.val$ganttApplet = ganttAppletBase;
                        super(bl);
                    }

                    public void mouseClicked(MouseEvent mouseEvent) {
                        Component component = (Component)mouseEvent.getSource();
                        SwingUtilities.getWindowAncestor(component).dispose();
                        this.val$ganttApplet.relogin();
                    }
                });
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)new JLabel(string), "Center");
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.add((Component)jLabel, "West");
                jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
                jPanel.add((Component)jPanel2, "South");
                return WDDialog.createMsgDialog(component, jPanel);
            }
        }
        return WDDialog.createMsgDialog(component, string);
    }

    private static GanttAppletBase getParentGanttApplet(Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof GanttAppletBase) {
                    return (GanttAppletBase)container;
                }
                if (container.getParent() != null || !(container instanceof Window)) continue;
                return WDDialog.findGanttAppletInWindow((Window)container);
            }
        }
        return null;
    }

    private static GanttAppletBase findGanttAppletInWindow(Window window) {
        if (window != null) {
            for (int i = 0; i < window.getComponentCount(); ++i) {
                Component component = window.getComponent(i);
                if (!(component instanceof GanttAppletBase)) continue;
                return (GanttAppletBase)component;
            }
        }
        return null;
    }

    public static boolean showYesNoDialog(Component component, String string) {
        return WDDialog.showYesNoDialog(component, string, true);
    }

    public static boolean showYesNoDialog(Component component, String string, String string2) {
        return WDDialog.showYesNoDialog(component, string, string2, true);
    }

    public static boolean showYesNoDialog(Component component, String string, boolean bl) {
        return WDDialog.showYesNoDialog(component, null, string, bl);
    }

    public static boolean showYesNoDialog(Component component, String string, String string2, boolean bl) {
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        WDButton wDButton = new WDButton(nLSBundle.getString("yes_button"), WDUtil.getIcon("ok.gif"));
        WDButton wDButton2 = new WDButton(nLSBundle.getString("no_button"), WDUtil.getIcon("close.gif"));
        return WDDialog.showTrueFalseDialog(component, string, string2, wDButton, wDButton2, null, bl);
    }

    public static boolean showOkCancelDialog(Component component, String string, Point point) {
        WDButton wDButton = WDUtil.createOkButton();
        WDButton wDButton2 = WDUtil.createCancelButton();
        return WDDialog.showTrueFalseDialog(component, null, string, wDButton, wDButton2, point, true);
    }

    private static boolean showTrueFalseDialog(Component component, String string, String string2, WDButton wDButton, WDButton wDButton2, Point point, boolean bl) {
        JComponent jComponent;
        WDDialog wDDialog = WDDialog.createWDDialog(component, true, true);
        wDDialog.getContentPane().setLayout(new BorderLayout());
        wDDialog.setTitle(string);
        if (!(string2 == null || string2.indexOf(10) < 0 || string2.startsWith("<") && string2.toLowerCase().startsWith("<html>"))) {
            string2 = "<html>" + WDUtil.swingHtmlEscape(string2) + "</html>";
        }
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        Dimension dimension = jLabel.getPreferredSize();
        if (dimension.height > 500 || dimension.width > 750) {
            jComponent = new JScrollPane(jLabel);
            jComponent.getViewport().setBackground(wDDialog.getContentPane().getBackground());
            wDDialog.getContentPane().add((Component)jComponent, "Center");
        } else {
            wDDialog.getContentPane().add((Component)jLabel, "Center");
        }
        jComponent = WDDialog.createButtonPanel(wDButton, wDButton2);
        wDDialog.getContentPane().add((Component)jComponent, "South");
        DisposeActionListener disposeActionListener = wDDialog.new DisposeActionListener();
        wDButton.addActionListener(disposeActionListener);
        wDButton2.addActionListener(disposeActionListener);
        wDDialog.pack();
        if (!bl) {
            wDButton2.requestFocus();
        }
        if (point != null) {
            wDDialog.setLocation(point);
        } else {
            wDDialog.setLocationRelativeTo(component);
        }
        wDDialog.setVisible(true);
        wDDialog.dispose();
        return disposeActionListener.source == wDButton;
    }

    public static String showInputDialog(Component component, String string) {
        WDDialog wDDialog = WDDialog.createWDDialog(component, true, false);
        wDDialog.setResizable(true);
        DisposeActionListener disposeActionListener = wDDialog.new DisposeActionListener();
        WDButton wDButton = WDUtil.createOkButton();
        WDButton wDButton2 = WDUtil.createCancelButton();
        wDButton.addActionListener(disposeActionListener);
        wDButton2.addActionListener(disposeActionListener);
        JTextField jTextField = new JTextField(30);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        jPanel.add((Component)new JLabel(string + ": "), "West");
        jPanel.add((Component)jTextField, "Center");
        wDDialog.add((Component)jPanel, "North");
        wDDialog.add((Component)WDDialog.createButtonPanel(wDButton, wDButton2), "South");
        wDDialog.pack();
        wDDialog.setLocationRelativeTo(component);
        wDDialog.setVisible(true);
        wDDialog.dispose();
        if (disposeActionListener.source == wDButton) {
            return jTextField.getText();
        }
        return null;
    }

    public static JPanel createButtonPanel(WDButton ... wDButtonArray) {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 10));
        for (int i = 0; i < wDButtonArray.length; ++i) {
            if (wDButtonArray[i] == null) continue;
            jPanel.add(wDButtonArray[i]);
        }
        return jPanel;
    }

    public static WDDialog createWDDialog(Component component, boolean bl, boolean bl2) {
        Window window = (component = WDDialog.adjustParentComponent(component)) == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        WDDialog wDDialog = new WDDialog(window, graphicsConfiguration);
        wDDialog.setDragHeader(bl);
        wDDialog.setHighlightBorder(bl2);
        return wDDialog;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.hasDialogDecoration) {
            Point point = mouseEvent.getPoint();
            if (this.isInCloseIcon(point)) {
                this.close();
            } else if (this.isInMaximizeIcon(point)) {
                this.maximize();
            } else if (this.isInRestoreIcon(point)) {
                this.restore();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.dragHeader && this.isInDragHeader(point)) {
            this.dragInfo = new DragHeaderInfo(mouseEvent.getX(), mouseEvent.getY());
        } else {
            int n = this.dlgBorder.getResizeHandle(point);
            if (n != 0) {
                this.dragInfo = new DragHeaderInfo(mouseEvent.getX(), mouseEvent.getY());
                this.dragInfo.resize = n;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragInfo != null && this.dragInfo.startDrag) {
            this.setCursor(Cursor.getDefaultCursor());
            if (this.dragInfo.resize != 0) {
                Dimension dimension = this.getSize();
                Dimension dimension2 = this.getMinimumSize();
                int n = dimension.width;
                int n2 = dimension.height;
                if ((this.dragInfo.resize & 8) == 8) {
                    n = Math.max(dimension.width + mouseEvent.getX() - this.dragInfo.x, Math.max(dimension2.width, 50));
                }
                if ((this.dragInfo.resize & 2) == 2) {
                    n2 = Math.max(dimension.height + mouseEvent.getY() - this.dragInfo.y, Math.max(dimension2.height, 50));
                }
                this.setSize(n, n2);
            } else {
                Point point = this.getLocation();
                point.x -= this.dragInfo.x - mouseEvent.getX();
                point.y -= this.dragInfo.y - mouseEvent.getY();
                Rectangle rectangle = WDUtil.getDisplayBounds(point);
                point.x = point.x < rectangle.x ? Math.max(point.x, rectangle.x + 20 - mouseEvent.getComponent().getSize().width) : Math.min(point.x, rectangle.width + rectangle.x - 20);
                point.y = Math.min(point.y, rectangle.height + rectangle.y - 20);
                point.y = Math.max(point.y, rectangle.y);
                this.setLocation(point);
            }
        }
        this.dragInfo = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.dragInfo == null) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragInfo != null && !this.dragInfo.startDrag) {
            if (this.dragInfo.resize == 0) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
            this.dragInfo.startDrag = true;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.dlgBorder.getResizeHandle(point);
        if (n != 0) {
            int n2;
            switch (n) {
                case 10: {
                    n2 = 5;
                    break;
                }
                case 6: {
                    n2 = 4;
                    break;
                }
                case 2: {
                    n2 = 9;
                    break;
                }
                case 1: {
                    n2 = 8;
                    break;
                }
                case 4: {
                    n2 = 10;
                    break;
                }
                case 8: {
                    n2 = 11;
                    break;
                }
                case 5: {
                    n2 = 6;
                    break;
                }
                case 9: {
                    n2 = 7;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(n2));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class DialogBorder
    implements Border {
        private static final int RESIZE_HANDLE_SIZE = 10;
        private static final int BORDER_WIDTH = 2;
        private boolean hightlighted = false;

        public void setHighlightBorder(boolean bl) {
            this.hightlighted = bl;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            String string;
            int n5;
            int n6;
            Icon icon = null;
            Icon icon2 = null;
            Icon icon3 = null;
            Icon icon4 = null;
            Icon icon5 = null;
            Icon icon6 = null;
            if (this.hightlighted) {
                graphics.setColor(borderColor_highlight);
                icon = leftBarIcon_highlight;
                icon2 = barIcon_highlight;
                icon3 = rightBarIcon_highlight;
                icon4 = barIcon_close_highlight;
                icon5 = barIcon_maximize_highlight;
                icon6 = barIcon_restore_highlight;
            } else {
                graphics.setColor(borderColor);
                icon = leftBarIcon;
                icon2 = barIcon;
                icon3 = rightBarIcon;
                icon4 = barIcon_close;
                icon5 = barIcon_maximize;
                icon6 = barIcon_restore;
            }
            if (WDDialog.this.dragHeader) {
                graphics.drawLine(n, n2 + 4, n, n2 + n4 - 3);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + n4 - 2);
                graphics.drawLine(n + n3 - 1, n2 + 5, n + n3 - 1, n2 + n4 - 4);
                graphics.drawLine(n + n3 - 2, n2 + 3, n + n3 - 2, n2 + n4 - 2);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                icon.paintIcon(component, graphics, n + 2, n2);
                n6 = icon.getIconWidth() + n + 2;
                int n7 = icon2.getIconWidth();
                n5 = icon3.getIconWidth();
                while (n6 + n7 + n5 < n3 - 1) {
                    icon2.paintIcon(component, graphics, n6, n2);
                    n6 += n7;
                }
                icon3.paintIcon(component, graphics, n6, n2);
            } else {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
            }
            if (WDDialog.this.hasDialogDecoration) {
                n6 = 0;
                if (WDDialog.this.isClosable) {
                    n6 = n3 - DECORATION_WIDTH_GAP - barIcon_close.getIconWidth();
                    icon4.paintIcon(component, graphics, n6, n2 + DECORATION_HEIGHT_GAP);
                    n6 -= DECORATION_WIDTH_GAP;
                } else {
                    n6 = n3 - DECORATION_WIDTH_GAP;
                }
                if (WDDialog.this.isMaximizable) {
                    if (WDDialog.this.restoreRect == null) {
                        icon5.paintIcon(component, graphics, n6 -= icon5.getIconWidth(), n2 + DECORATION_HEIGHT_GAP);
                    } else {
                        icon6.paintIcon(component, graphics, n6 -= icon6.getIconWidth(), n2 + DECORATION_HEIGHT_GAP);
                    }
                    n6 -= DECORATION_WIDTH_GAP;
                }
            }
            if (WDDialog.this.dragHeader && !UString.isEmpty(string = WDDialog.this.getTitle())) {
                Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
                n5 = n3 - n;
                if (WDDialog.this.hasDialogDecoration) {
                    if (WDDialog.this.isClosable) {
                        n5 -= DECORATION_WIDTH_GAP + barIcon_close.getIconWidth();
                    }
                    if (WDDialog.this.isMaximizable) {
                        n5 -= DECORATION_WIDTH_GAP + icon5.getIconWidth();
                    }
                }
                Color color = graphics.getColor();
                graphics.setColor(color.darker());
                graphics.drawString(string, (int)((double)n + ((double)n5 - rectangle2D.getWidth()) / 2.0), (int)((double)n2 + ((double)(icon2.getIconHeight() + DECORATION_HEIGHT_GAP) - rectangle2D.getHeight() / 2.0)));
                graphics.setColor(color);
            }
            if (WDDialog.this.isResizable()) {
                Color color = graphics.getColor();
                graphics.setColor(WDDialog.this.getContentPane().getBackground());
                graphics.fillRect(n + 2, n2 + n4 - 2 - 10, n3 - 5, 10);
                Polygon polygon = new Polygon(new int[]{n + n3 - 2, n + n3 - 2, n + n3 - 2 - 10}, new int[]{n2 + n4 - 2 - 10, n2 + n4 - 2, n2 + n4 - 2}, 3);
                graphics.setColor(color);
                graphics.fillPolygon(polygon);
            }
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(2, 2, 2, 2);
            if (WDDialog.this.dragHeader) {
                insets.top = barIcon.getIconHeight();
            }
            if (WDDialog.this.isResizable()) {
                insets.bottom += 10;
            }
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public int getHeaderHeight() {
            return barIcon.getIconHeight();
        }

        private int getResizeHandle(Point point) {
            if (!WDDialog.this.isResizable()) {
                return 0;
            }
            Dimension dimension = WDDialog.this.getSize();
            if (point.y > dimension.height - 10 - 2) {
                if (point.x > dimension.width - 10 - 2) {
                    return 10;
                }
                return 2;
            }
            if (point.x > dimension.width - 2) {
                return 8;
            }
            return 0;
        }
    }

    public class DisposeActionListener
    implements ActionListener {
        public Object source;

        public void actionPerformed(ActionEvent actionEvent) {
            this.source = actionEvent.getSource();
            WDDialog.this.dispose();
        }
    }

    private class DragHeaderInfo {
        int resize;
        int x;
        int y;
        boolean startDrag;

        DragHeaderInfo(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }

    private class ModalityGlassPane
    extends JPanel
    implements MouseListener {
        protected WindowAdapter windowAdapter;
        protected Component previousGlassPane;
        protected JRootPane rootPane;

        public ModalityGlassPane(Container container) {
            this.setOpaque(false);
            this.windowAdapter = new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    ModalityGlassPane.this.removeGlassPane();
                }
            };
            WDDialog.this.addWindowListener(this.windowAdapter);
            if (container instanceof JFrame) {
                this.rootPane = ((JFrame)container).getRootPane();
            } else if (container instanceof JDialog) {
                this.rootPane = ((JDialog)container).getRootPane();
            } else if (container instanceof JApplet) {
                this.rootPane = ((JApplet)container).getRootPane();
            } else if (container instanceof Frame && container.getComponentCount() > 0 && container.getComponent(0) instanceof JApplet) {
                this.rootPane = ((JApplet)container.getComponent(0)).getRootPane();
            }
            if (this.rootPane != null) {
                this.previousGlassPane = this.rootPane.getGlassPane();
                this.rootPane.setGlassPane(this);
                this.setVisible(true);
                this.addMouseListener(this);
            }
        }

        void removeGlassPane() {
            if (this.rootPane != null) {
                this.rootPane.getGlassPane().setVisible(false);
                if (this.previousGlassPane != null) {
                    this.rootPane.setGlassPane(this.previousGlassPane);
                }
            }
            this.removeMouseListener(this);
            WDDialog.this.removeWindowListener(this.windowAdapter);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (WDDialog.this.canDisposeByClickingOutside()) {
                WDDialog.this.dispose();
            } else {
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

