/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.ui.WDCalendarDialog;
import com.triloggroup.gantt.app.ui.WDCmdButton;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.util.date.TGTime;
import com.triloggroup.util.date.UDateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class WDDatePicker
extends JPanel
implements WDCalendarDialog.CallBack {
    public static final String DATE_PROPERTY = "Date";
    protected static Border INVALID_BORDER = BorderFactory.createLineBorder(Color.RED);
    private static final int MIN_WIDTH = 75;
    private static final int MIN_WIDTH_SHOW_TIME = 100;
    private JTextField dateTxtField = new JTextField();
    private WDCmdButton button = new WDCmdButton(WDUtil.getIcon("calendar.gif"));
    private WDCalendarDialog dialog;
    private JTextField timeTxtField;
    private JPanel datePanel;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private Locale locale;
    private TimeZone timeZone;
    private Date currentValue;
    private boolean valid;
    private TGTime defaultTime;
    private TGTime currentTime;

    public WDDatePicker() {
        this(null, null);
    }

    public WDDatePicker(Locale locale) {
        this(locale, null);
    }

    public WDDatePicker(Locale locale, TimeZone timeZone) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.locale = locale;
        this.timeZone = timeZone;
        this.valid = true;
        this.dateFormat = UDateFormat.getDateInstance(locale);
        this.dateFormat.setTimeZone(timeZone);
        this.dateTxtField.setInputVerifier(new DateTextFieldVerifier());
        this.initUI();
    }

    protected DateFormat getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = UDateFormat.getTimeInstance(this.locale);
            this.timeFormat.setTimeZone(this.timeZone);
        }
        return this.timeFormat;
    }

    protected void initUI() {
        this.datePanel = new JPanel(new BorderLayout());
        this.datePanel.add((Component)this.dateTxtField, "Center");
        this.datePanel.add((Component)this.button, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.datePanel, "Center");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WDDatePicker.this.showDialogCalendar();
            }
        });
    }

    public void setDefaultTime(TGTime tGTime) {
        this.defaultTime = tGTime;
    }

    public TGTime getDefaultTime() {
        return this.defaultTime;
    }

    public void setFont(Font font) {
        if (this.dateTxtField != null) {
            this.dateTxtField.setFont(font);
        }
        if (this.timeTxtField != null) {
            this.timeTxtField.setFont(font);
        }
        super.setFont(font);
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        int n2 = n = this.isShowTime() ? 100 : 75;
        if (dimension.width < n) {
            dimension.width = n;
        }
        return dimension;
    }

    public void setEditable(boolean bl) {
        this.dateTxtField.setEditable(bl);
        if (this.timeTxtField != null) {
            this.timeTxtField.setEditable(bl);
        }
        this.button.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.dateTxtField.isEditable();
    }

    public boolean isShowTime() {
        return this.timeTxtField != null;
    }

    public void setShowTime(boolean bl) {
        if (bl == this.isShowTime()) {
            return;
        }
        if (bl) {
            this.timeTxtField = new JTextField();
            this.timeTxtField.setInputVerifier(new TimeTextFieldVerifier());
            Date date = new Date();
            date.setHours(22);
            int n = this.getTimeFormat().format(date).length();
            this.timeTxtField.setColumns(n);
            this.timeTxtField.setEditable(this.isEditable());
            this.add((Component)this.timeTxtField, "East");
            this.setDate(this.currentValue);
        } else {
            this.remove(this.timeTxtField);
            this.timeTxtField = null;
            this.currentTime = null;
        }
    }

    public void setDate(Date date) {
        this.currentValue = date;
        this.valid = true;
        if (date == null) {
            this.dateTxtField.setText("");
            this.currentTime = null;
            if (this.timeTxtField != null) {
                this.timeTxtField.setText("");
            }
        } else {
            this.dateTxtField.setText(this.dateFormat.format(date));
            if (this.timeTxtField != null) {
                this.currentTime = new TGTime(date, this.timeZone);
                this.timeTxtField.setText(this.getTimeFormat().format(date));
            }
        }
    }

    public Date getDate() {
        return this.valid ? this.currentValue : null;
    }

    protected void setDateWithEvent(Date date) {
        Date date2 = this.currentValue;
        this.setDate(date);
        if (date == null && date2 == null) {
            return;
        }
        if (date != null && date.equals(date2)) {
            return;
        }
        this.fireDateChange(date2, date);
    }

    protected Date updateTime(Date date) {
        if (date != null) {
            if (this.currentTime != null) {
                date = this.currentTime.applyTime(date, this.timeZone);
            } else if (this.defaultTime != null) {
                date = this.defaultTime.applyTime(date, this.timeZone);
            }
        }
        return date;
    }

    public boolean isEditValid() {
        return this.valid;
    }

    public void requestFocus() {
        this.dateTxtField.requestFocus();
    }

    protected void showDialogCalendar() {
        if (this.dialog == null) {
            this.dialog = WDCalendarDialog.create(this, this.locale, this);
        }
        this.dialog.showDialog(this.currentValue, this);
    }

    public void dateSelected(Date date) {
        if (date != null) {
            date = this.updateTime(date);
            this.setDateWithEvent(date);
        }
    }

    public void addDateChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(DATE_PROPERTY, propertyChangeListener);
    }

    protected void fireDateChange(Date date, Date date2) {
        this.firePropertyChange(DATE_PROPERTY, date, date2);
    }

    class DateTextFieldVerifier
    extends InputVerifier {
        private Date tmpValue;
        private Border okBorder;

        DateTextFieldVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            ParsePosition parsePosition = new ParsePosition(0);
            this.tmpValue = WDDatePicker.this.dateFormat.parse(string, parsePosition);
            return parsePosition.getIndex() == string.length();
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            if (!WDDatePicker.this.isEditable()) {
                return true;
            }
            if (this.verify(jComponent)) {
                if (WDDatePicker.this.dateTxtField.getBorder() == INVALID_BORDER) {
                    WDDatePicker.this.dateTxtField.setBorder(this.okBorder);
                    this.okBorder = null;
                }
                this.tmpValue = WDDatePicker.this.updateTime(this.tmpValue);
                WDDatePicker.this.setDateWithEvent(this.tmpValue);
                return true;
            }
            WDDatePicker.this.valid = false;
            if (WDDatePicker.this.dateTxtField.getBorder() != INVALID_BORDER) {
                this.okBorder = WDDatePicker.this.dateTxtField.getBorder();
                WDDatePicker.this.dateTxtField.setBorder(INVALID_BORDER);
            }
            return false;
        }
    }

    class TimeTextFieldVerifier
    extends InputVerifier {
        private TGTime tmpValue;
        private Border okBorder;

        TimeTextFieldVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            this.tmpValue = null;
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = WDDatePicker.this.getTimeFormat().parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length()) {
                return false;
            }
            if (date != null) {
                this.tmpValue = new TGTime(date, WDDatePicker.this.timeZone);
            }
            return true;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            if (!WDDatePicker.this.isEditable()) {
                return true;
            }
            if (this.verify(jComponent)) {
                if (WDDatePicker.this.timeTxtField.getBorder() == INVALID_BORDER) {
                    WDDatePicker.this.timeTxtField.setBorder(this.okBorder);
                    this.okBorder = null;
                }
                WDDatePicker.this.currentTime = this.tmpValue;
                Date date = WDDatePicker.this.currentValue;
                if (date == null) {
                    return true;
                }
                if (WDDatePicker.this.currentTime == null) {
                    WDDatePicker.this.currentTime = WDDatePicker.this.defaultTime != null ? WDDatePicker.this.defaultTime : new TGTime(0, 0);
                }
                Date date2 = WDDatePicker.this.currentTime.applyTime(date);
                WDDatePicker.this.setDateWithEvent(date2);
                return true;
            }
            WDDatePicker.this.valid = false;
            if (WDDatePicker.this.timeTxtField.getBorder() != INVALID_BORDER) {
                this.okBorder = WDDatePicker.this.timeTxtField.getBorder();
                WDDatePicker.this.timeTxtField.setBorder(INVALID_BORDER);
            }
            return false;
        }
    }
}

