/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ULabel {
    public static final Color LINK_TEXT_COLOR = new Color(68, 119, 187);
    public static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);

    public static JLabel createLinkJLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(string);
        jLabel.setCursor(HAND_CURSOR);
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jLabel.setForeground(LINK_TEXT_COLOR);
        if (bl) {
            ULabel.setUnderlined(jLabel, true);
        }
        return jLabel;
    }

    public static void setUnderlined(Component component, boolean bl) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.UNDERLINE, bl ? TextAttribute.UNDERLINE_ON : null);
        ULabel.updateFont(component, hashMap);
    }

    public static void setStriked(Component component, boolean bl) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.STRIKETHROUGH, bl ? TextAttribute.STRIKETHROUGH_ON : null);
        ULabel.updateFont(component, hashMap);
    }

    private static void updateFont(Component component, Map<TextAttribute, Object> map) {
        component.setFont(component.getFont().deriveFont(map));
    }

    public static abstract class LinkHoverMouseAdapter
    implements MouseListener {
        private boolean underline;
        private Color hoverColor;
        private Color defaultColor;

        public LinkHoverMouseAdapter(Color color) {
            this.hoverColor = color;
        }

        public LinkHoverMouseAdapter(boolean bl) {
            this.underline = bl;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (this.underline) {
                ULabel.setUnderlined(component, false);
            }
            if (this.defaultColor != null) {
                component.setForeground(this.defaultColor);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (this.underline) {
                ULabel.setUnderlined(component, true);
            }
            this.defaultColor = component.getForeground();
            if (this.hoverColor == null) {
                this.hoverColor = this.defaultColor.darker();
            }
            component.setForeground(this.hoverColor);
        }
    }
}

