/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.ui;

import com.triloggroup.gantt.app.ui.WDUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class TGToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer = new Timer(750, new insideTimerAction());
    Timer exitTimer;
    Timer insideTimer;
    String toolTipText;
    Point preferredLocation;
    JComponent insideComponent;
    MouseEvent mouseEvent;
    boolean showImmediately;
    transient Popup tipWindow;
    private Window window;
    JToolTip tip;
    private Rectangle popupRect = null;
    boolean enabled = true;
    private boolean tipShowing = false;
    private KeyStroke postTip;
    private KeyStroke hideTip;
    private Action postTipAction;
    private Action hideTipAction;
    private FocusListener focusChangeListener = null;
    private MouseMotionListener moveBeforeEnterListener = null;
    private static TGToolTipManager instance = null;

    TGToolTipManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.postTip = KeyStroke.getKeyStroke(112, 2);
        this.postTipAction = new Actions(Actions.SHOW);
        this.hideTip = KeyStroke.getKeyStroke(27, 0);
        this.hideTipAction = new Actions(Actions.HIDE);
        this.moveBeforeEnterListener = new MoveBeforeEnterListener();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        Object object;
        if (this.insideComponent == null || !this.insideComponent.isShowing()) {
            return;
        }
        String string = UIManager.getString("ToolTipManager.enableToolTipMode");
        if ("activeApplication".equals(string) && ((KeyboardFocusManager)(object = KeyboardFocusManager.getCurrentKeyboardFocusManager())).getFocusedWindow() == null) {
            return;
        }
        if (this.enabled) {
            object = this.mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen((Point)object, this.mouseEvent.getComponent());
            GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration((Point)object);
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Point point = this.insideComponent.getLocationOnScreen();
            Point point2 = new Point();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            boolean bl = this.insideComponent.getComponentOrientation().isLeftToRight();
            this.hideTipWindow();
            this.tip = this.insideComponent.createToolTip();
            this.tip.setTipText(this.toolTipText);
            Dimension dimension = this.tip.getPreferredSize();
            if (this.preferredLocation != null) {
                point2.x = point.x + this.preferredLocation.x;
                point2.y = point.y + this.preferredLocation.y;
                if (!bl) {
                    point2.x -= dimension.width;
                }
            } else {
                point2.x = point.x + this.mouseEvent.getX();
                point2.y = point.y + this.mouseEvent.getY() + 20;
                if (!bl && point2.x - dimension.width >= 0) {
                    point2.x -= dimension.width;
                }
            }
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point2.x, point2.y, dimension.width, dimension.height);
            if (point2.x < rectangle.x) {
                point2.x = rectangle.x;
            } else if (point2.x - rectangle.x + dimension.width > rectangle.width) {
                point2.x = rectangle.x + Math.max(0, rectangle.width - dimension.width);
            }
            if (point2.y < rectangle.y) {
                point2.y = rectangle.y;
            } else if (point2.y - rectangle.y + dimension.height > rectangle.height) {
                point2.y = rectangle.y + Math.max(0, rectangle.height - dimension.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.insideComponent, this.tip, point2.x, point2.y);
            this.tipWindow.show();
            Window window = SwingUtilities.windowForComponent(this.insideComponent);
            this.window = SwingUtilities.windowForComponent(this.tip);
            if (this.window != null && this.window != window) {
                this.window.addMouseListener(this);
            } else {
                this.window = null;
            }
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            if (this.window != null) {
                this.window.removeMouseListener(this);
                this.window = null;
            }
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static TGToolTipManager sharedInstance() {
        if (instance == null) {
            instance = new TGToolTipManager();
        }
        return instance;
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.addMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        jComponent.addMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.put(this.postTip, "postTip");
                inputMap.put(this.hideTip, "hideTip");
                actionMap.put("postTip", this.postTipAction);
                actionMap.put("hideTip", this.hideTipAction);
            }
        }
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        if (this.shouldRegisterBindings(jComponent)) {
            InputMap inputMap = jComponent.getInputMap(0);
            ActionMap actionMap = jComponent.getActionMap();
            if (inputMap != null && actionMap != null) {
                inputMap.remove(this.postTip);
                inputMap.remove(this.hideTip);
                actionMap.remove("postTip");
                actionMap.remove("hideTip");
            }
        }
    }

    private boolean shouldRegisterBindings(JComponent jComponent) {
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.initiateToolTip(mouseEvent);
    }

    private void initiateToolTip(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.window) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.exitTimer.stop();
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        if (this.insideComponent != null) {
            this.enterTimer.stop();
        }
        jComponent.removeMouseMotionListener(this);
        jComponent.addMouseMotionListener(this);
        boolean bl = this.insideComponent == jComponent;
        this.insideComponent = jComponent;
        if (this.tipWindow != null) {
            this.mouseEvent = mouseEvent;
            if (this.showImmediately) {
                boolean bl2;
                String string = jComponent.getToolTipText(mouseEvent);
                Point point2 = jComponent.getToolTipLocation(mouseEvent);
                boolean bl3 = this.preferredLocation != null ? this.preferredLocation.equals(point2) : (bl2 = point2 == null);
                if (!(bl && this.toolTipText.equals(string) && bl2)) {
                    this.toolTipText = string;
                    this.preferredLocation = point2;
                    this.showTipWindow();
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Window window;
        boolean bl = true;
        if (this.insideComponent == null) {
            // empty if block
        }
        if (this.window != null && mouseEvent.getSource() == this.window) {
            Container container = this.insideComponent.getTopLevelAncestor();
            if (container != null) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this.window);
                point.x -= container.getX();
                point.y -= container.getY();
                point = SwingUtilities.convertPoint(null, point, this.insideComponent);
                bl = point.x < 0 || point.x >= this.insideComponent.getWidth() || point.y < 0 || point.y >= this.insideComponent.getHeight();
            }
        } else if (mouseEvent.getSource() == this.insideComponent && this.tipWindow != null && (window = SwingUtilities.getWindowAncestor(this.insideComponent)) != null) {
            Point point = SwingUtilities.convertPoint(this.insideComponent, mouseEvent.getPoint(), window);
            Rectangle rectangle = this.insideComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this.tip);
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.width = this.tip.getWidth();
            rectangle.height = this.tip.getHeight();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            this.enterTimer.stop();
            if (this.insideComponent != null) {
                this.insideComponent.removeMouseMotionListener(this);
            }
            this.insideComponent = null;
            this.toolTipText = null;
            this.mouseEvent = null;
            this.hideTipWindow();
            this.exitTimer.restart();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.hideTipWindow();
        this.enterTimer.stop();
        this.showImmediately = false;
        this.insideComponent = null;
        this.mouseEvent = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.tipShowing) {
            this.checkForTipChange(mouseEvent);
        } else if (this.showImmediately) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            this.toolTipText = jComponent.getToolTipText(mouseEvent);
            if (this.toolTipText != null) {
                this.preferredLocation = jComponent.getToolTipLocation(mouseEvent);
                this.mouseEvent = mouseEvent;
                this.insideComponent = jComponent;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.insideComponent = (JComponent)mouseEvent.getSource();
            this.mouseEvent = mouseEvent;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(MouseEvent mouseEvent) {
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        String string = jComponent.getToolTipText(mouseEvent);
        Point point = jComponent.getToolTipLocation(mouseEvent);
        if (string != null || point != null) {
            this.mouseEvent = mouseEvent;
            if ((string != null && string.equals(this.toolTipText) || string == null) && (point != null && point.equals(this.preferredLocation) || point == null)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                this.preferredLocation = point;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.preferredLocation = null;
            this.mouseEvent = null;
            this.insideComponent = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    private FocusListener createFocusChangeListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                TGToolTipManager.this.hideTipWindow();
                TGToolTipManager.this.insideComponent = null;
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.removeFocusListener(TGToolTipManager.this.focusChangeListener);
            }
        };
    }

    private void show(JComponent jComponent) {
        if (this.tipWindow != null) {
            this.hideTipWindow();
            this.insideComponent = null;
        } else {
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
            this.insideComponent = jComponent;
            if (this.insideComponent != null) {
                this.toolTipText = this.insideComponent.getToolTipText();
                this.preferredLocation = new Point(10, this.insideComponent.getHeight() + 10);
                this.showTipWindow();
                if (this.focusChangeListener == null) {
                    this.focusChangeListener = this.createFocusChangeListener();
                }
                this.insideComponent.addFocusListener(this.focusChangeListener);
            }
        }
    }

    private void hide(JComponent jComponent) {
        this.hideTipWindow();
        jComponent.removeFocusListener(this.focusChangeListener);
        this.preferredLocation = null;
        this.insideComponent = null;
    }

    private static class Actions
    extends AbstractAction {
        private static String SHOW = "SHOW";
        private static String HIDE = "HIDE";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.getValue("Name");
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (object == SHOW) {
                TGToolTipManager.sharedInstance().show(jComponent);
            } else if (object == HIDE) {
                TGToolTipManager.sharedInstance().hide(jComponent);
            }
        }

        public boolean isEnabled() {
            if (this.getValue("Name") == SHOW) {
                return true;
            }
            return TGToolTipManager.sharedInstance().tipShowing;
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TGToolTipManager.this.initiateToolTip(mouseEvent);
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TGToolTipManager.this.insideComponent != null && TGToolTipManager.this.insideComponent.isShowing()) {
                if (TGToolTipManager.this.toolTipText == null && TGToolTipManager.this.mouseEvent != null) {
                    TGToolTipManager.this.toolTipText = TGToolTipManager.this.insideComponent.getToolTipText(TGToolTipManager.this.mouseEvent);
                    TGToolTipManager.this.preferredLocation = TGToolTipManager.this.insideComponent.getToolTipLocation(TGToolTipManager.this.mouseEvent);
                }
                if (TGToolTipManager.this.toolTipText != null) {
                    TGToolTipManager.this.showImmediately = true;
                    TGToolTipManager.this.showTipWindow();
                } else {
                    TGToolTipManager.this.insideComponent = null;
                    TGToolTipManager.this.toolTipText = null;
                    TGToolTipManager.this.preferredLocation = null;
                    TGToolTipManager.this.mouseEvent = null;
                    TGToolTipManager.this.hideTipWindow();
                }
            }
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TGToolTipManager.this.showImmediately = false;
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TGToolTipManager.this.hideTipWindow();
            TGToolTipManager.this.enterTimer.stop();
            TGToolTipManager.this.showImmediately = false;
            TGToolTipManager.this.insideComponent = null;
            TGToolTipManager.this.mouseEvent = null;
        }
    }
}

