/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable.resource;

import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.treetable.TGTreeTable;
import com.triloggroup.util.UString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

abstract class ResourceEditorDialog
extends WDDialog
implements ActionListener {
    private WDButton okButton;
    protected Object result;
    protected JTable table;
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border FOCUS_BORDER = new LineBorder(TGTreeTable.EDITABLE_CELL_BORDER_COLOR, 1);

    protected ResourceEditorDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    protected boolean isHighlightRow(Resource resource) {
        return false;
    }

    protected void updateTableUI() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new NameRenderer());
        NameEditor nameEditor = new NameEditor();
        tableColumn.setCellEditor(nameEditor);
        int n = this.table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)1).getPreferredSize().width;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            Component component = nameEditor.getTableCellEditorComponent(this.table, Boolean.TRUE, true, i, 0);
            n = Math.max(n, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n + 5);
        this.table.setSelectionMode(0);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setShowGrid(false);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    protected void initUI(JTable jTable) {
        this.table = jTable;
        this.updateTableUI();
        Dimension dimension = new Dimension(jTable.getPreferredSize());
        jTable.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.okButton = WDUtil.createOkButton();
        jPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel.add(wDButton);
        wDButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setDragHeader(true);
        this.setMaximizable(false);
        this.setResizable(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                return;
            }
            this.collectResult();
        }
        this.dispose();
    }

    protected abstract void collectResult();

    protected Object getSelectedValue() {
        return this.result;
    }

    protected abstract Resource getResource(int var1);

    private void prepareCheckBoxForRow(JCheckBox jCheckBox, int n, Object object) {
        Resource resource = this.getResource(n);
        String string = resource.getEmail();
        if (UString.isEmpty(string)) {
            jCheckBox.setToolTipText(null);
        } else {
            jCheckBox.setToolTipText(string);
        }
        jCheckBox.setText(resource.getCn());
        jCheckBox.setSelected((Boolean)object);
        jCheckBox.setForeground(this.isHighlightRow(resource) ? Color.RED : Color.BLACK);
    }

    class NameEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JCheckBox cb = new JCheckBox();

        NameEditor() {
            this.cb.setFont(this.cb.getFont().deriveFont(0));
            this.cb.setOpaque(true);
            this.cb.setBackground(ResourceEditorDialog.this.table.getSelectionBackground());
            this.cb.setBorderPaintedFlat(true);
            this.cb.addActionListener(this);
        }

        public Object getCellEditorValue() {
            return this.cb.isSelected();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ResourceEditorDialog.this.prepareCheckBoxForRow(this.cb, n, object);
            return this.cb;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
        }
    }

    class NameRenderer
    implements TableCellRenderer {
        JCheckBox cb = new JCheckBox();

        NameRenderer() {
            this.cb.setFont(this.cb.getFont().deriveFont(0));
            this.cb.setBorderPainted(true);
            this.cb.setBorderPaintedFlat(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ResourceEditorDialog.this.prepareCheckBoxForRow(this.cb, n, object);
            this.cb.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.cb.setBorder(bl2 ? FOCUS_BORDER : NO_FOCUS_BORDER);
            return this.cb;
        }
    }
}

