/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTable;
import com.triloggroup.gantt.treetable.TGTreeTableCellRenderer;
import com.triloggroup.project.components.ui.table.TextCellEditor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;

class TGTreeTableNameEditor
extends TextCellEditor {
    private AppGanttTreeTable treeTable;

    TGTreeTableNameEditor(AppGanttTreeTable appGanttTreeTable) {
        this.setCheckInvlaidCharacters(true);
        this.treeTable = appGanttTreeTable;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (super.isCellEditable(eventObject)) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                int n = this.treeTable.rowAtPoint(mouseEvent.getPoint());
                TGNode tGNode = this.treeTable.getModel().nodeForRow(n);
                int n2 = this.treeTable.columnAtPoint(mouseEvent.getPoint());
                Rectangle rectangle = this.treeTable.getCellRect(n, n2, true);
                TGTreeTableCellRenderer tGTreeTableCellRenderer = this.treeTable.getTreeCellRenderer();
                if (tGTreeTableCellRenderer.isLocationInExpandControl(tGNode, mouseEvent.getX(), mouseEvent.getY(), rectangle)) {
                    return false;
                }
                if (tGTreeTableCellRenderer.isLocationInRightIcon(tGNode, mouseEvent.getX(), mouseEvent.getY(), rectangle)) {
                    return false;
                }
                int n3 = tGTreeTableCellRenderer.getXTextOffset(tGNode);
                if (n3 > mouseEvent.getX()) {
                    n3 = mouseEvent.getX();
                }
                mouseEvent.translatePoint(-n3, 0);
            }
            return true;
        }
        return false;
    }
}

