/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.treetable;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.ITimeUnits;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.GanttKeyStrokes;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.dialog.ColumnsDialog;
import com.triloggroup.gantt.app.treetable.ActualAdditionalCostRenderer;
import com.triloggroup.gantt.app.treetable.AppGanttTreeTableModel;
import com.triloggroup.gantt.app.treetable.AppResourcesRenderer;
import com.triloggroup.gantt.app.treetable.AppTreeTableCellRenderer;
import com.triloggroup.gantt.app.treetable.CostRenderer;
import com.triloggroup.gantt.app.treetable.DateEditor;
import com.triloggroup.gantt.app.treetable.DescriptionEditor;
import com.triloggroup.gantt.app.treetable.DurationEditor;
import com.triloggroup.gantt.app.treetable.DurationEditor2;
import com.triloggroup.gantt.app.treetable.PredecessorsEditor;
import com.triloggroup.gantt.app.treetable.PredecessorsRenderer;
import com.triloggroup.gantt.app.treetable.StatusEditor;
import com.triloggroup.gantt.app.treetable.TGTreeTableNameEditor;
import com.triloggroup.gantt.app.treetable.TableDnDManager;
import com.triloggroup.gantt.app.treetable.resource.ResourcesEditor;
import com.triloggroup.gantt.app.ui.TGToolTipManager;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.gantt.event.GanttModelEvent;
import com.triloggroup.gantt.event.GanttModelListener;
import com.triloggroup.gantt.pe.app.SchedulingMode;
import com.triloggroup.gantt.treetable.GanttTreeTable;
import com.triloggroup.gantt.treetable.GanttTreeTableModel;
import com.triloggroup.gantt.treetable.TGTreeTableCellRenderer;
import com.triloggroup.gantt.treetable.TGTreeTableModel;
import com.triloggroup.gantt.util.ValueIntervals;
import com.triloggroup.project.components.ui.UIConstants;
import com.triloggroup.project.components.ui.table.ComboEditor;
import com.triloggroup.project.components.ui.table.DoubleCellEditor;
import com.triloggroup.project.components.ui.table.IntegerCellEditor;
import com.triloggroup.project.components.ui.table.IntegerCellEditorWithLabel;
import com.triloggroup.project.components.ui.table.TGTableHeaderRenderer;
import com.triloggroup.project.components.util.format.FormatUtil;
import com.triloggroup.project.financial.FinancialSettings;
import com.triloggroup.project.schedule.ScheduleCalendar;
import com.triloggroup.util.date.TGTime;
import com.triloggroup.util.date.UDateFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AppGanttTreeTable
extends GanttTreeTable {
    protected AppGanttChart ganttCtrl;
    private TableDnDManager dndManager;
    private boolean updatingSelection = false;
    private int lastDeltaColumn = -1;
    private JComponent rowHeader;

    public AppGanttTreeTable(GanttTreeTableModel ganttTreeTableModel, Locale locale, TimeZone timeZone) {
        super(ganttTreeTableModel, locale, timeZone);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    AppGanttTreeTable.this.showHeaderPopupMenu(mouseEvent);
                }
            }
        });
        if (ganttTreeTableModel.isEditable()) {
            this.dndManager = new TableDnDManager(this);
        }
        if (WDUtil.isMultiScreen()) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            TGToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    protected TGTreeTableCellRenderer createTreeTableCellRenderer() {
        return new AppTreeTableCellRenderer();
    }

    protected void initRenderers() {
        if (this.durationRenderer != null) {
            return;
        }
        this.resourcesRenderer = new AppResourcesRenderer(this.getModel().getChartModel(), this.getLocale());
        this.predecessorsRenderer = new PredecessorsRenderer(this);
        this.costRenderer = new CostRenderer();
        this.actualAdditionalCostRenderer = new ActualAdditionalCostRenderer();
        super.initRenderers();
    }

    public void computePreferredWidth() {
        this.computePreferredWidth(false);
    }

    public void computePreferredWidth(boolean bl) {
        if (this.ganttCtrl == null) {
            return;
        }
        TGTreeTableModel tGTreeTableModel = this.getModel();
        int n = tGTreeTableModel.getRowCount();
        if (n == 0) {
            return;
        }
        JTableHeader jTableHeader = this.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        int n2 = this.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6;
            Component component;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n7 = this.getHeaderPreferredWidth(i);
            String string = tGTreeTableModel.getColumnKeyName(i);
            if (string == "StartDate" || string == "EndDate" || string == "ActualStart" || string == "ActualFinish" || string == "Deadline") {
                if (n3 <= 0) {
                    tableCellRenderer = this.getCellRenderer(0, i);
                    Date date = new GregorianCalendar(2000, 11, 30).getTime();
                    component = tableCellRenderer.getTableCellRendererComponent(this, date, true, true, 0, i);
                    ((JComponent)component).setPreferredSize(null);
                    n4 = n3 = component.getPreferredSize().width;
                    if (this.ganttCtrl.isEditable()) {
                        TableCellEditor tableCellEditor = this.getCellEditor(0, i);
                        component = tableCellEditor.getTableCellEditorComponent(this, date, true, 0, i);
                        n4 = Math.max(n4, this.getPreferredWidth(component));
                    }
                    n3 += 5;
                    n4 += 5;
                }
                int n8 = n3;
                n6 = Math.max(n7, n4);
                tableColumn.setPreferredWidth(n6);
                tableColumn.setMinWidth(n8);
                tableColumn.setMaxWidth(n6);
                tableColumn.setWidth(n6);
                continue;
            }
            if (string == "Progress") {
                tableCellRenderer = this.getCellRenderer(0, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, new Integer(100), true, true, 0, i);
                int n9 = this.getPreferredWidth(component);
                n7 = Math.max(n7, n9);
                tableColumn.setPreferredWidth(n7 += 5);
                tableColumn.setMinWidth(n9 + 5);
                tableColumn.setMaxWidth(n7);
                tableColumn.setWidth(n7);
                continue;
            }
            if (string == "Priority") {
                tableCellRenderer = this.getCellRenderer(0, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, new Integer(1000), true, true, 0, i);
                int n10 = this.getPreferredWidth(component);
                n7 = Math.max(n7, n10);
                tableColumn.setPreferredWidth(n7 += 5);
                tableColumn.setMinWidth(n10 + 5);
                tableColumn.setMaxWidth(n7);
                tableColumn.setWidth(n7);
                continue;
            }
            if (string == "Status") {
                tableCellRenderer = this.getCellRenderer(0, i);
                Status[] statusArray = Status.getAllAvailableStatusForTask();
                for (n6 = 0; n6 < statusArray.length; ++n6) {
                    component = tableCellRenderer.getTableCellRendererComponent(this, statusArray[n6], true, true, 0, i);
                    n7 = Math.max(n7, this.getPreferredWidth(component) + 5);
                }
                tableColumn.setPreferredWidth(n7);
                tableColumn.setMaxWidth(n7);
                tableColumn.setWidth(n7);
                continue;
            }
            int n11 = bl ? this.getRowCount() : Math.min(this.getRowCount(), 200);
            n6 = 0;
            int n12 = Integer.MAX_VALUE;
            if (string == "Resources") {
                String string2 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                component = new JLabel(string2);
                n12 = this.getPreferredWidth(component);
            } else if (string == "Description") {
                String string3 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                n12 = this.getPreferredWidth(new JLabel(string3));
            }
            for (n5 = 0; n5 < n11; ++n5) {
                tableCellRenderer = this.getCellRenderer(n5, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(n5, i), true, true, n5, i);
                if ((n6 = Math.max(n6, this.getPreferredWidth(component))) < n12) continue;
                n6 = n12;
                break;
            }
            n7 = Math.max(n7, n6);
            n7 += 5;
            if (string == "Duration" || string == "Work" || string == "WorkedHours" || string == "ActualWork" || string == "RemainingWork") {
                tableColumn.setMinWidth(n6 + 5);
            } else if (string == "Id" || string == "Name") {
                tableCellRenderer = this.getCellRenderer(0, i);
                component = tableCellRenderer.getTableCellRendererComponent(this, "1.1.1..", true, true, 0, i);
                n5 = Math.min(Math.max(tableColumn.getMinWidth(), this.getPreferredWidth(component)), n7);
                tableColumn.setMinWidth(n5);
            }
            tableColumn.setPreferredWidth(n7);
            tableColumn.setWidth(n7);
        }
        this.invalidate();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        AppGanttTreeTableModel appGanttTreeTableModel = (AppGanttTreeTableModel)this.getModel();
        String string = appGanttTreeTableModel.getColumnKeyName(n3);
        TGNode tGNode = this.getModel().nodeForRow(n);
        AppProjectModel appProjectModel = tGNode instanceof GanttNode ? this.ganttCtrl.getModel().getProjectModel((GanttNode)tGNode) : this.ganttCtrl.getModel().getMainProjectModel();
        if (string == "Name") {
            return new TGTreeTableNameEditor(this);
        }
        if (string == "Status") {
            return StatusEditor.getStatusEditor();
        }
        if (string == "Progress") {
            return new IntegerCellEditorWithLabel(this.ganttCtrl.getDateLocale(), 0, 100, "%");
        }
        if (string == "Priority") {
            return new IntegerCellEditor(this.ganttCtrl.getDateLocale(), 0, 1000);
        }
        if (string == "Description") {
            return new DescriptionEditor();
        }
        if (string == "Duration" || string == "Work") {
            ITimeUnits iTimeUnits = this.ganttCtrl.getModel().getGlobalContext().getTimeUnits();
            DurationEditor2 durationEditor2 = new DurationEditor2(iTimeUnits);
            durationEditor2.setDefaultUnit(string == "Duration" ? iTimeUnits.getDayTimeUnit() : iTimeUnits.getHourTimeUnit());
            return durationEditor2;
        }
        if (string == "ActualWork" || string == "RemainingWork") {
            return new DurationEditor();
        }
        if (string == "Deadline" || string == "StartDate" || string == "EndDate" || string == "ActualStart" || string == "ActualFinish") {
            Locale locale = this.ganttCtrl.getDateLocale();
            if (this.getModel().getChartModel().getGlobalContext().isTimePrecision()) {
                Object object;
                TGTime tGTime = null;
                if (string == "Deadline") {
                    tGTime = new TGTime(23, 59, 59);
                } else if (string == "ActualStart" || string == "ActualFinish") {
                    object = appProjectModel.getProjectCalendar();
                    for (int i = 0; i < 7; ++i) {
                        ScheduleCalendar.Weekday weekday = ((ScheduleCalendar)object).getWeekdayAt(i);
                        if (!weekday.isDayWorking || weekday.workingTimes.length <= 0) continue;
                        if (string == "ActualStart") {
                            tGTime = weekday.workingTimes[0].fromTime;
                            break;
                        }
                        tGTime = weekday.workingTimes[weekday.workingTimes.length - 1].toTime;
                        break;
                    }
                }
                if (tGTime == null) {
                    tGTime = new TGTime(0, 0, 0);
                }
                object = UDateFormat.getDateTimeInstance(locale, tGTime);
                return new DateEditor(locale, (DateFormat)object);
            }
            return new DateEditor(locale);
        }
        if (string == "Resources") {
            return new ResourcesEditor(this.ganttCtrl, appProjectModel);
        }
        if (string == "predecessors") {
            return new PredecessorsEditor();
        }
        if (string == "schedulingConstraint") {
            return new ComboEditor(SchedulingMode.getAllSchedulingModes());
        }
        if (string == "AdditionalCost") {
            FinancialSettings financialSettings = appProjectModel.getProjectContext().getFinancialSettings();
            DecimalFormat decimalFormat = FormatUtil.getCostFormat(this.ganttCtrl.getDateLocale(), financialSettings);
            return new DoubleCellEditor(decimalFormat);
        }
        if (string == "ActualAdditionalCost") {
            FinancialSettings financialSettings = appProjectModel.getProjectContext().getFinancialSettings();
            DecimalFormat decimalFormat = FormatUtil.getCostFormat(this.ganttCtrl.getDateLocale(), financialSettings);
            return new DoubleCellEditor(decimalFormat);
        }
        if (string == "AdditionalCostDescription") {
            return new DescriptionEditor();
        }
        return super.getCellEditor(n, n2);
    }

    protected void setResizingAndReorderingPolicy() {
    }

    public void nodeExpanded() {
    }

    public void nodeCollapsed() {
    }

    public void setGanttControler(AppGanttChart appGanttChart) {
        this.ganttCtrl = appGanttChart;
    }

    AppGanttChart getGanttControler() {
        return this.ganttCtrl;
    }

    public boolean isIgnoreSelectionChange() {
        return this.updatingSelection;
    }

    protected void updateSelectionModel(final ListSelectionModel listSelectionModel) {
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!AppGanttTreeTable.this.updatingSelection) {
                    AppGanttTreeTable.this.updatingSelection = true;
                    try {
                        AppGanttChartModel appGanttChartModel = AppGanttTreeTable.this.ganttCtrl.getModel();
                        int n = listSelectionModel.getMinSelectionIndex();
                        int n2 = listSelectionModel.getMaxSelectionIndex();
                        if (n != -1 && n2 != -1) {
                            ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
                            for (int i = n; i <= n2; ++i) {
                                if (!listSelectionModel.isSelectedIndex(i)) continue;
                                TGNode tGNode = appGanttChartModel.getNodeByRowIndex(i);
                                arrayList.add(tGNode);
                            }
                            TGNode[] tGNodeArray = arrayList.toArray(new TGNode[0]);
                            AppGanttTreeTable.this.ganttCtrl.setSelectedNodes(tGNodeArray);
                        } else {
                            AppGanttTreeTable.this.ganttCtrl.setSelectedNode(null);
                        }
                    }
                    finally {
                        AppGanttTreeTable.this.updatingSelection = false;
                    }
                }
            }
        });
    }

    public void setValueAt(Object object, final int n, int n2) {
        int n3;
        super.setValueAt(object, n, n2);
        final TGNode tGNode = ((AppGanttTreeTableModel)this.getModel()).newNode;
        if (tGNode != null && (n3 = this.ganttCtrl.getModel().getRowIndex(tGNode)) > -1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n4 = AppGanttTreeTable.this.getSelectionModel().getLeadSelectionIndex();
                    int n2 = n4 - n;
                    if (n2 < -1 || n2 > 1) {
                        n2 = 0;
                    }
                    AppGanttTreeTable.this.getSelectionModel().setSelectionInterval(n3 + n2, n3 + n2);
                    AppGanttTreeTable.this.ganttCtrl.scrollToNode(tGNode);
                }
            });
        }
    }

    protected void showHeaderPopupMenu(final MouseEvent mouseEvent) {
        final JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        final int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(AppGanttChart.NLS_BUNDLE.getString("add_columns"));
        jMenuItem.setAccelerator(GanttKeyStrokes.COLUMNS);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ColumnsDialog.isDebug(mouseEvent.getModifiers());
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                ColumnsDialog.showDialog(AppGanttTreeTable.this.ganttCtrl, jTableHeader, point, bl);
            }
        });
        jPopupMenu.add(jMenuItem);
        if (n > -1) {
            JMenuItem jMenuItem2 = new JMenuItem(AppGanttChart.NLS_BUNDLE.getString("hide_column"));
            if (this.getModel().getColumnCount() == 1) {
                jMenuItem2.setEnabled(false);
            } else {
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n3;
                        TGTreeTableModel tGTreeTableModel = AppGanttTreeTable.this.getModel();
                        int n2 = tGTreeTableModel.getColumnCount();
                        String[] stringArray = new String[n2 - 1];
                        for (n3 = 0; n3 < n; ++n3) {
                            stringArray[n3] = tGTreeTableModel.getColumnKeyName(AppGanttTreeTable.this.convertColumnIndexToModel(n3));
                        }
                        for (n3 = n + 1; n3 < n2; ++n3) {
                            stringArray[n3 - 1] = tGTreeTableModel.getColumnKeyName(AppGanttTreeTable.this.convertColumnIndexToModel(n3));
                        }
                        AppGanttTreeTable.this.setVisibleColumns(stringArray);
                        AppGanttTreeTable.this.ganttCtrl.getUserPreferences().setTableColumns(stringArray);
                    }
                });
            }
            jPopupMenu.add(jMenuItem2);
        }
        jPopupMenu.show(jTableHeader, mouseEvent.getX(), mouseEvent.getY());
    }

    protected String getToolTipText(int n, int n2, Point point, TableCellRenderer tableCellRenderer, Component component) {
        TGNode tGNode;
        String string;
        int n3 = this.convertColumnIndexToModel(n2);
        String string2 = this.getModel().getColumnKeyName(n3);
        if (string2 == "Resources" && (string = this.getResourcesColumnTooltip(tGNode = this.getModel().nodeForRow(n))) != null) {
            return string;
        }
        return super.getToolTipText(n, n2, point, tableCellRenderer, component);
    }

    protected String getResourcesColumnTooltip(TGNode tGNode) {
        if (tGNode instanceof GanttTask) {
            GanttTask ganttTask = (GanttTask)tGNode;
            AppProjectModel appProjectModel = this.ganttCtrl.getModel().getProjectModel(ganttTask);
            boolean bl = !appProjectModel.includeAllocationsForDoneTasks();
            boolean bl2 = bl && ganttTask.isDone();
            TaskResource[] taskResourceArray = ganttTask.getResources();
            if (taskResourceArray == null || taskResourceArray.length == 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder("<html>");
            for (int i = 0; i < taskResourceArray.length; ++i) {
                boolean bl3;
                if (i > 0) {
                    stringBuilder.append("<br>");
                }
                Resource resource = taskResourceArray[i].getResource();
                if (bl2) {
                    bl3 = false;
                } else {
                    long l;
                    long l2;
                    ValueIntervals valueIntervals = appProjectModel.getResourceAllocations(resource);
                    bl3 = valueIntervals.isValueOver(l2 = ganttTask.getStartDate().getTime(), l = ganttTask.getFinishDate().getTime(), 100);
                    if (bl3) {
                        stringBuilder.append("<font color=red>");
                    }
                }
                int n = stringBuilder.length();
                stringBuilder.append(WDUtil.swingHtmlEscape(taskResourceArray[i].getCn()));
                this.resourcesRenderer.appendResourceUnits(taskResourceArray[i], stringBuilder);
                if (!bl3) continue;
                Set<GanttTask> set = appProjectModel.getTasksForResource(taskResourceArray[i].getResource(), ganttTask.getStartDate().getTime(), ganttTask.getFinishDate().getTime());
                boolean bl4 = true;
                block1: for (GanttTask ganttTask2 : set) {
                    String string;
                    if (ganttTask == ganttTask2 || bl && ganttTask2.isDone()) continue;
                    if (bl4) {
                        stringBuilder.append(" - ");
                        string = AppGanttChart.NLS_BUNDLE.getString("tasksInConflict");
                        stringBuilder.append(string);
                        stringBuilder.append(": ");
                    } else {
                        stringBuilder.append(", ");
                    }
                    bl4 = false;
                    string = ganttTask2.getName();
                    int n2 = stringBuilder.length() - n;
                    int n3 = -1;
                    if (n2 + string.length() > 136) {
                        if (n2 > 116) {
                            stringBuilder.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                            n = stringBuilder.length() - 2;
                        } else {
                            int n4 = 136 - n2;
                            n3 = this.getBestBreakLocation(string, n4 - 20, n4);
                        }
                    }
                    if (n3 >= 0) {
                        stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(0, n3)));
                        stringBuilder.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                        n = stringBuilder.length() - 2;
                        stringBuilder.append(WDUtil.swingHtmlEscape(string.substring(n3)));
                    } else {
                        stringBuilder.append(WDUtil.swingHtmlEscape(string));
                    }
                    TaskResource[] taskResourceArray2 = ganttTask2.getResources();
                    for (int j = 0; j < taskResourceArray2.length; ++j) {
                        if (taskResourceArray2[j].getResource() != resource) continue;
                        this.resourcesRenderer.appendResourceUnits(taskResourceArray2[j], stringBuilder);
                        continue block1;
                    }
                }
                stringBuilder.append("</font>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        if (tGNode instanceof GanttWBS) {
            Resource[] resourceArray = ((GanttWBS)tGNode).getResources();
            if (resourceArray == null || resourceArray.length == 0) {
                return null;
            }
            if (resourceArray.length == 1) {
                return resourceArray[0].getCn();
            }
            StringBuilder stringBuilder = new StringBuilder("<html>");
            for (int i = 0; i < resourceArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append("<br>");
                }
                stringBuilder.append(WDUtil.swingHtmlEscape(resourceArray[i].getCn()));
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        TGNode tGNode = this.getNodeAtPoint(point);
        if (tGNode instanceof GanttNode) {
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            if (!this.ganttCtrl.stopCellEditing(false)) {
                return;
            }
            this.ganttCtrl.showNodeDetail((GanttNode)tGNode, point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.getView().hasFocus() && mouseEvent.getSource() == this.getRowHeaderComponent()) {
            this.requestFocusInWindow();
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getComponent() == this) {
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            TableColumn tableColumn = this.getTableHeader().getColumnModel().getColumn(n);
            if (tableColumn.getCellRenderer() instanceof TGTreeTableCellRenderer) {
                int n2 = this.rowAtPoint(point);
                TGNode tGNode = this.getModel().nodeForRow(n2);
                if (tGNode instanceof GanttNode) {
                    Rectangle rectangle = this.getCellRect(n2, n, true);
                    if (this.getTreeCellRenderer().isLocationInRightIcon(tGNode, point.x, point.y, rectangle)) {
                        mouseEvent.consume();
                        this.ganttCtrl.getActions().showSocialData((GanttNode)tGNode, false);
                        this.getSelectionModel().setValueIsAdjusting(false);
                    } else if (tGNode instanceof GanttWBS && this.getTreeCellRenderer().isLocationInExpandControl(tGNode, point.x, point.y, rectangle)) {
                        mouseEvent.consume();
                        GanttWBS ganttWBS = (GanttWBS)tGNode;
                        if (!this.ganttCtrl.expandCollapseNode(ganttWBS)) {
                            if (!ganttWBS.isExpanded() && ganttWBS.isSubProject() && !ganttWBS.hasVisibleSubtask()) {
                                this.ganttCtrl.loadSubproject(ganttWBS);
                            } else {
                                System.out.println("expand/collapsed failed");
                            }
                        }
                    }
                }
            }
        }
    }

    public JPopupMenu getPopupMenuForCurrentSelection(Point point) {
        return this.ganttCtrl.getPopupMenuForSelectedNodes(point);
    }

    public void doLayout() {
        LayoutManager layoutManager;
        TableColumn tableColumn = this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
        int n = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
        if (n != 0) {
            this.accommodateDelta(tableColumn, n);
            n = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            if (n != 0 && tableColumn != null) {
                tableColumn.setWidth(tableColumn.getWidth() + n);
            }
        }
        if ((layoutManager = this.getLayout()) != null) {
            layoutManager.layoutContainer(this);
        }
    }

    private void accommodateDelta(TableColumn tableColumn, int n) {
        int n2;
        int n3;
        TableColumn tableColumn2;
        int n4;
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8;
        int n9 = this.getColumnCount();
        int[] nArray = new int[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            nArray[n8] = this.columnModel.getColumn(n8).getWidth();
        }
        int n10 = n8 = tableColumn != null ? n9 - 1 : n9;
        while (n8 > 0 && n != 0) {
            n7 = n / n8;
            bl = n7 == 0;
            n6 = 0;
            if (bl) {
                int n11 = n7 = n > 0 ? 1 : -1;
                if (this.lastDeltaColumn >= 0 && this.lastDeltaColumn < n9 - 2) {
                    n6 = this.lastDeltaColumn + 1;
                }
            }
            n8 = 0;
            for (n5 = 0; n != 0 && n5 < n9; ++n5) {
                n4 = (n5 + n6) % n9;
                tableColumn2 = this.columnModel.getColumn(n4);
                if (tableColumn2 == tableColumn) continue;
                n3 = tableColumn2.getPreferredWidth();
                n2 = n3 - nArray[n4];
                if ((n <= 0 || n2 <= 0) && (n >= 0 || n2 >= 0)) continue;
                if (Math.abs(n2) <= Math.abs(n7)) {
                    nArray[n4] = n3;
                    this.lastDeltaColumn = n4;
                    n -= n2;
                    continue;
                }
                int n12 = n4;
                nArray[n12] = nArray[n12] + n7;
                this.lastDeltaColumn = n4;
                n -= n7;
                ++n8;
            }
        }
        int n13 = n8 = tableColumn != null ? n9 - 1 : n9;
        while (n8 > 0 && n != 0) {
            n7 = n / n8;
            bl = n7 == 0;
            n6 = 0;
            if (bl) {
                int n14 = n7 = n > 0 ? 1 : -1;
                if (this.lastDeltaColumn >= 0 && this.lastDeltaColumn < n9 - 2) {
                    n6 = this.lastDeltaColumn + 1;
                }
            }
            n8 = 0;
            for (n5 = 0; n != 0 && n5 < n9; ++n5) {
                n4 = (n5 + n6) % n9;
                tableColumn2 = this.columnModel.getColumn(n4);
                if (tableColumn2 == tableColumn) continue;
                n3 = n > 0 ? tableColumn2.getMaxWidth() : tableColumn2.getMinWidth();
                n2 = n3 - nArray[n4];
                if (Math.abs(n2) <= Math.abs(n7)) {
                    if (n2 == 0) continue;
                    nArray[n4] = n3;
                    this.lastDeltaColumn = n4;
                    n -= n2;
                    continue;
                }
                int n15 = n4;
                nArray[n15] = nArray[n15] + n7;
                this.lastDeltaColumn = n4;
                n -= n7;
                ++n8;
            }
        }
        for (n7 = 0; n7 < n9; ++n7) {
            TableColumn tableColumn3 = this.columnModel.getColumn(n7);
            if (tableColumn3.getWidth() == nArray[n7]) continue;
            tableColumn3.setWidth(nArray[n7]);
        }
    }

    public JComponent getRowHeaderComponent() {
        if (this.rowHeader == null) {
            RowHeaderListModel rowHeaderListModel = new RowHeaderListModel();
            JList jList = new JList(rowHeaderListModel);
            jList.setFixedCellWidth(40);
            jList.setFixedCellHeight(this.getRowHeight());
            jList.setCellRenderer(new RowHeaderRenderer());
            jList.setSelectionModel(this.getSelectionModel());
            jList.addMouseListener(this);
            jList.setFocusable(false);
            if (this.dndManager != null) {
                this.dndManager.setRowHeader(jList);
            }
            this.rowHeader = jList;
        }
        return this.rowHeader;
    }

    class RowHeaderListModel
    extends AbstractListModel
    implements GanttModelListener,
    TableModelListener {
        RowHeaderListModel() {
            AppGanttTreeTable.this.ganttCtrl.getModel().addGanttModelListener(this);
        }

        public Object getElementAt(int n) {
            return AppGanttTreeTable.this.getModel().nodeForRow(n);
        }

        public int getSize() {
            return AppGanttTreeTable.this.getRowCount();
        }

        private void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.update();
        }

        public void nodeCollapsed(GanttModelEvent ganttModelEvent) {
            this.update();
        }

        public void nodeExpanded(GanttModelEvent ganttModelEvent) {
            this.update();
        }

        public void nodesChanged(GanttModelEvent ganttModelEvent) {
        }

        public void structureChanged(GanttModelEvent ganttModelEvent) {
            this.update();
        }
    }

    public static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        public RowHeaderRenderer() {
            this.setOpaque(true);
            this.setBorder(new TGTableHeaderRenderer.TGHeaderBorder(false));
            this.setHorizontalAlignment(0);
            this.setForeground(Color.BLACK);
        }

        public void updateUI() {
            this.setFont(UIConstants.DEFAULT_FONT);
            super.updateUI();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Color color = null;
            if (object instanceof GanttNode) {
                GanttNode ganttNode = (GanttNode)object;
                boolean bl3 = false;
                if (ganttNode.isProjectRoot() && ganttNode.getParent() != null && !ganttNode.isExpanded()) {
                    ganttNode = (GanttNode)ganttNode.getParent();
                    bl3 = true;
                }
                if (!bl3 && GanttNode.isSubprojectLink(ganttNode) && !ganttNode.isExpanded()) {
                    bl3 = true;
                }
                if (bl3) {
                    this.setFont(UIConstants.BOLD_FONT);
                } else {
                    this.setFont(UIConstants.DEFAULT_FONT);
                }
                this.setText(ganttNode.getFullLineId());
                color = ganttNode.getProjectContext().getHeaderColor();
            } else {
                this.setText("");
            }
            if (color == null) {
                color = UIConstants.BACKGROUND_HEADER_COLOR;
            }
            this.setBackground(bl ? UIConstants.BACKGROUND_SELECTION_COLOR : color);
            return this;
        }
    }
}

