/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.social;

import com.triloggroup.gantt.app.AppGanttChartModel;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.GanttWorkbenchPage;
import com.triloggroup.gantt.app.social.BookmarkPanel;
import com.triloggroup.gantt.app.social.BookmarksAndCommentsDialog;
import com.triloggroup.gantt.app.social.CommentBorder;
import com.triloggroup.gantt.app.social.NotificationsPanel;
import com.triloggroup.gantt.app.social.XSPSocialActions;
import com.triloggroup.gantt.app.ui.LineWrapTextArea;
import com.triloggroup.gantt.app.ui.ULabel;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.project.Role;
import com.triloggroup.project.components.resourceeditor.ProjectResource;
import com.triloggroup.project.social.Bookmark;
import com.triloggroup.project.social.CommentEntry;
import com.triloggroup.project.social.NotificationConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URLEncoder;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

class CommentPanel
extends BookmarksAndCommentsDialog.PanelForComment
implements MouseListener,
BookmarkPanel.IDeleteBookmark {
    private static final boolean SHOW_FULL_COMMENTS = false;
    private static final Color NEW_COMMENT_HINT_TEXT_COLOR = new Color(153, 153, 153);
    private static final GridBagConstraints pictureCst;
    private static final GridBagConstraints authorCst;
    private static final GridBagConstraints dateCst;
    private static final GridBagConstraints bodyCst;
    private static final GridBagConstraints moreBodyCst;
    private static final GridBagConstraints attachmentsCst;
    private static final GridBagConstraints editBodyCst;
    private static final GridBagConstraints editAttachmentsCst;
    private static final GridBagConstraints notifsCst;
    private static final GridBagConstraints postWallCst;
    private static final GridBagConstraints actionsPanelCst;
    private final BookmarksAndCommentsDialog dialog;
    final CommentEntry comment;
    private CommentEntry editedComment;
    private JTextArea body;
    private JLabel moreLabel;
    private Container attachmentsPanel;
    JTextArea editTextArea;
    private Container editAttachmentsPanel;
    private JLabel lbReply;
    private JLabel lbEdit;
    private JLabel lbDelete;
    private JLabel lbSubmit;
    private JLabel lbCancel;
    private JLabel lbNotif;
    private JLabel lbAttachFile;
    private JPanel actionsPanel;
    private JCheckBox cbPostOnWall;
    NotificationsPanel notificationPanel;

    CommentPanel(BookmarksAndCommentsDialog bookmarksAndCommentsDialog, CommentEntry commentEntry) {
        super(commentEntry != null ? commentEntry.parentId : null);
        this.dialog = bookmarksAndCommentsDialog;
        this.comment = commentEntry;
    }

    public boolean isEditInProgress() {
        if (this.editTextArea == null) {
            return false;
        }
        if (!this.editTextArea.isEditable() || !this.editTextArea.isVisible()) {
            return false;
        }
        return this.editTextArea.getForeground() != NEW_COMMENT_HINT_TEXT_COLOR;
    }

    void init(boolean bl) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
        this.setBorder(CommentBorder.create(bl, this.comment != null && this.comment.parentId != null));
        AppGanttChartModel appGanttChartModel = this.dialog.gantt.getModel();
        String string = this.comment != null ? this.comment.authorDn : appGanttChartModel.getGlobalContext().getCurrentUserDn();
        ImageIcon imageIcon = this.dialog.gantt.getSocialManager().getUserIcon(string);
        JLabel jLabel = new JLabel(imageIcon);
        gridBagLayout.setConstraints(jLabel, pictureCst);
        this.add(jLabel);
        this.editTextArea = new LineWrapTextArea();
        this.editTextArea.setRows(3);
        this.editTextArea.setBorder(new LineBorder(BookmarksAndCommentsDialog.GRAY_TEXT_COLOR));
        gridBagLayout.setConstraints(this.editTextArea, editBodyCst);
        this.add(this.editTextArea);
        this.editAttachmentsPanel = Box.createVerticalBox();
        gridBagLayout.setConstraints(this.editAttachmentsPanel, editAttachmentsCst);
        this.add(this.editAttachmentsPanel);
        if (this.comment != null) {
            Object object;
            String string2;
            AppProjectModel appProjectModel = appGanttChartModel.getProjectModel(this.dialog.getNode().getProjectId());
            ProjectResource projectResource = appProjectModel.getProjectResource(this.comment.authorDn);
            if (projectResource == null) {
                string2 = this.comment.authorCn;
            } else {
                string2 = projectResource.getCn();
                object = appProjectModel.getProjectRoleById(projectResource.getRoleId());
                if (object != null) {
                    string2 = string2 + ", " + ((Role)object).getLabel();
                }
            }
            object = new JLabel(string2);
            gridBagLayout.setConstraints((Component)object, authorCst);
            this.add((Component)object);
            if (this.comment.date != null) {
                JLabel jLabel2 = this.dialog.createSubtitleJLabel(this.dialog.messageDateFormat.format(this.comment.date));
                gridBagLayout.setConstraints(jLabel2, dateCst);
                this.add(jLabel2);
            }
            this.body = new LineWrapTextArea();
            this.body.setEditable(false);
            this.body.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
            this.body.setBorder(null);
            gridBagLayout.setConstraints(this.body, bodyCst);
            this.add(this.body);
            if (this.comment.body.length() > 512) {
                this.body.setText(this.comment.body.substring(0, 509) + "...");
                this.moreLabel = ULabel.createLinkJLabel(this.dialog.nls().getString("more") + " >>", false);
                gridBagLayout.setConstraints(this.moreLabel, moreBodyCst);
                this.add(this.moreLabel);
                this.moreLabel.addMouseListener(new ULabel.LinkHoverMouseAdapter(true){
                    boolean isFullComment;
                    {
                        this.isFullComment = false;
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        this.isFullComment = !this.isFullComment;
                        CommentPanel.this.body.setText(this.isFullComment ? CommentPanel.this.comment.body : CommentPanel.this.comment.body.substring(0, 509) + "...");
                        String string = this.isFullComment ? CommentPanel.this.dialog.nls().getString("less") + " <<" : CommentPanel.this.dialog.nls().getString("more") + " >>";
                        ((JLabel)mouseEvent.getComponent()).setText(string);
                    }
                });
            } else {
                this.body.setText(this.comment.body);
            }
            this.attachmentsPanel = Box.createVerticalBox();
            gridBagLayout.setConstraints(this.attachmentsPanel, attachmentsCst);
            this.add(this.attachmentsPanel);
            this.addBookmarksAndAttachments(this.comment, this.attachmentsPanel);
            this.showActionBar(false);
            this.editTextArea.setVisible(false);
            this.editAttachmentsPanel.setVisible(false);
        } else if (!this.dialog.gantt.getSocialManager().isOnServer(this.dialog.getNode())) {
            this.editTextArea.setEditable(false);
            this.editTextArea.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
            this.editTextArea.setForeground(NEW_COMMENT_HINT_TEXT_COLOR);
            this.editTextArea.setBorder(null);
            this.editTextArea.setText(this.dialog.nls().getString("socialNeedSavingPendingChanges"));
        } else {
            this.editedComment = new CommentEntry();
            this.updateBodyForNewComment(false);
            this.editTextArea.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent focusEvent) {
                    CommentPanel.this.updateBodyForNewComment(false);
                }

                public void focusGained(FocusEvent focusEvent) {
                    CommentPanel.this.updateBodyForNewComment(true);
                }
            });
            this.showPostOnWall(true);
            this.showActionBar(true);
        }
    }

    private void updateBodyForNewComment(boolean bl) {
        if (bl) {
            if (this.editTextArea.getForeground() == NEW_COMMENT_HINT_TEXT_COLOR) {
                this.editTextArea.setText("");
                this.editTextArea.setForeground(Color.BLACK);
            }
        } else if (this.editTextArea.getText().length() == 0) {
            this.editTextArea.setText(this.dialog.nls().getString("addCommentHere"));
            this.editTextArea.setForeground(NEW_COMMENT_HINT_TEXT_COLOR);
        }
    }

    private JPanel createActionsPanel() {
        boolean bl = this.dialog.canAddComment() && this.comment.parentId == null;
        boolean bl2 = this.dialog.canEdit(this.comment);
        if (!bl && !bl2) {
            return null;
        }
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        if (bl) {
            this.lbReply = ULabel.createLinkJLabel(this.dialog.nls().getString("addComment"), true);
            this.lbReply.addMouseListener(this);
            jPanel.add(this.lbReply);
        }
        if (bl2) {
            if (bl) {
                jPanel.add(this.createLabelSeparator());
            }
            this.lbEdit = ULabel.createLinkJLabel(this.dialog.nls().getString("edit"), true);
            this.lbEdit.addMouseListener(this);
            jPanel.add(this.lbEdit);
            jPanel.add(this.createLabelSeparator());
            this.lbDelete = ULabel.createLinkJLabel(this.dialog.nls().getString("delete_button"), true);
            this.lbDelete.addMouseListener(this);
            jPanel.add(this.lbDelete);
        }
        return jPanel;
    }

    private JPanel createEditActionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.lbSubmit = ULabel.createLinkJLabel(this.dialog.nls().getString("submit"), true);
        this.lbSubmit.addMouseListener(this);
        jPanel.add(this.lbSubmit);
        jPanel.add(this.createLabelSeparator());
        String string = this.dialog.nls().getString(this.comment != null ? "cancel_button" : "clear");
        this.lbCancel = ULabel.createLinkJLabel(string, true);
        this.lbCancel.addMouseListener(this);
        jPanel.add(this.lbCancel);
        jPanel.add(Box.createHorizontalGlue());
        this.lbNotif = ULabel.createLinkJLabel(this.dialog.nls().getString("notificationList"), true);
        this.lbNotif.addMouseListener(this);
        jPanel.add(this.lbNotif);
        boolean bl = this.dialog.gantt.getWorkbenchPage().isApplet();
        if (bl) {
            jPanel.add(this.createLabelSeparator());
            this.lbAttachFile = ULabel.createLinkJLabel(this.dialog.nls().getString("attachFile"), true);
            this.lbAttachFile.addMouseListener(this);
            jPanel.add(this.lbAttachFile);
        }
        return jPanel;
    }

    private JComponent createLabelSeparator() {
        JLabel jLabel = new JLabel("    |    ");
        jLabel.setForeground(BookmarksAndCommentsDialog.GRAY_TEXT_COLOR);
        return jLabel;
    }

    private void addBookmarksAndAttachments(final CommentEntry commentEntry, Container container) {
        JComponent jComponent;
        boolean bl;
        container.removeAll();
        boolean bl2 = bl = container == this.editAttachmentsPanel;
        if (commentEntry != null && commentEntry.attachments != null && commentEntry.attachments.length > 0) {
            for (final String object : commentEntry.attachments) {
                jComponent = ULabel.createLinkJLabel(object, false);
                jComponent.addMouseListener(new ULabel.LinkHoverMouseAdapter(true){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        try {
                            String string = ((CommentPanel)CommentPanel.this).dialog.gantt.getModel().getGlobalContext().getServerBaseUrl() + "/$$download.xsp/tg_pe_schedule/" + commentEntry.id + '/' + URLEncoder.encode(object, "UTF-8");
                            CommentPanel.this.dialog.getXSPSocialActions().downloadDocument(string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                final JPanel jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(jComponent);
                jPanel.setOpaque(false);
                if (bl) {
                    JLabel jLabel = new JLabel(BookmarkPanel.getDeleteBookmarkIcon());
                    jLabel.setToolTipText(this.dialog.nls().getString("delete_button"));
                    jLabel.setCursor(ULabel.HAND_CURSOR);
                    ULabel.LinkHoverMouseAdapter linkHoverMouseAdapter = new ULabel.LinkHoverMouseAdapter(true){

                        public void mouseClicked(MouseEvent mouseEvent) {
                            CommentPanel.this.deleteXspAttachment(object, jPanel);
                        }
                    };
                    jLabel.addMouseListener(linkHoverMouseAdapter);
                    jPanel.add(jLabel);
                }
                container.add(jPanel);
            }
        }
        if (commentEntry != null && commentEntry.bookmarks != null && commentEntry.bookmarks.length > 0) {
            for (Bookmark bookmark : commentEntry.bookmarks) {
                jComponent = new BookmarkPanel(this.dialog, bookmark, bl ? this : null);
                container.add(jComponent);
            }
        }
    }

    private void prepareEdit() {
        this.editTextArea.setText(this.editedComment.body);
        this.addBookmarksAndAttachments(this.editedComment, this.editAttachmentsPanel);
        this.editTextArea.setVisible(true);
        this.editAttachmentsPanel.setVisible(true);
        this.showActionBar(true);
        this.getRootPane().validate();
        this.editTextArea.requestFocusInWindow();
    }

    private void hideEdit() {
        this.body.setVisible(true);
        this.attachmentsPanel.setVisible(true);
        if (this.moreLabel != null) {
            this.moreLabel.setVisible(true);
        }
        this.editTextArea.setText("");
        this.editTextArea.setVisible(false);
        this.editAttachmentsPanel.setVisible(false);
        this.editAttachmentsPanel.removeAll();
        this.showActionBar(false);
        this.showNotificationPanel(false);
    }

    private boolean checkCommentValid() {
        if (this.editedComment.body.trim().length() == 0) {
            WDDialog.showMsgDialog(this, this.dialog.nls().getString("messageEmpty"));
            return false;
        }
        return true;
    }

    private void updateEditedComment() {
        this.editedComment.body = this.editTextArea.getForeground() == NEW_COMMENT_HINT_TEXT_COLOR ? "" : this.editTextArea.getText();
    }

    void showPostOnWall(boolean bl) {
        if (this.cbPostOnWall == null && !bl) {
            return;
        }
        if (bl) {
            if (this.cbPostOnWall == null) {
                this.cbPostOnWall = new JCheckBox(this.dialog.nls().getString("postOnPrjWall"));
                this.cbPostOnWall.setFont(this.cbPostOnWall.getFont().deriveFont(0));
                this.cbPostOnWall.setBackground(BookmarksAndCommentsDialog.COMMENT_BACKGROUND_COLOR);
                this.cbPostOnWall.setSelected(true);
                ((GridBagLayout)this.getLayout()).setConstraints(this.cbPostOnWall, postWallCst);
            }
            this.add(this.cbPostOnWall);
        } else {
            this.remove(this.cbPostOnWall);
        }
    }

    boolean isPostCommentOnWall() {
        return this.cbPostOnWall != null && this.cbPostOnWall.isSelected();
    }

    private void showActionBar(boolean bl) {
        if (this.actionsPanel != null) {
            this.actionsPanel.getParent().remove(this.actionsPanel);
        }
        this.actionsPanel = bl ? this.createEditActionsPanel() : this.createActionsPanel();
        if (this.actionsPanel != null) {
            ((GridBagLayout)this.getLayout()).setConstraints(this.actionsPanel, actionsPanelCst);
            this.add(this.actionsPanel);
        }
    }

    private void showNotificationPanel(boolean bl) {
        if (this.notificationPanel == null) {
            if (!bl) {
                return;
            }
            this.dialog.loadCommentNotificationConfig(this, new Runnable(){

                public void run() {
                    ((GridBagLayout)CommentPanel.this.getLayout()).setConstraints(CommentPanel.this.notificationPanel, notifsCst);
                    CommentPanel.this.add(CommentPanel.this.notificationPanel);
                    CommentPanel.this.updateDialogHeight();
                }
            });
        } else {
            this.notificationPanel.setVisible(bl);
            this.updateDialogHeight();
        }
        if (this.notificationPanel.isVisible()) {
            this.lbNotif.setText(this.dialog.nls().getString("hideNotificationList"));
        } else {
            this.lbNotif.setText(this.dialog.nls().getString("notificationList"));
        }
        this.lbNotif.repaint();
    }

    public void deleteBookmark(BookmarkPanel bookmarkPanel) {
        Bookmark bookmark = bookmarkPanel.bookmark;
        int n = this.editedComment.bookmarks.length;
        for (int i = 0; i < n; ++i) {
            if (this.editedComment.bookmarks[i] != bookmark) continue;
            Bookmark[] bookmarkArray = new Bookmark[n - 1];
            if (i > 0) {
                System.arraycopy(this.editedComment.bookmarks, 0, bookmarkArray, 0, i);
            }
            if (i < bookmarkArray.length) {
                System.arraycopy(this.editedComment.bookmarks, i + 1, bookmarkArray, i, bookmarkArray.length - i);
            }
            this.editedComment.bookmarks = bookmarkArray;
            this.editAttachmentsPanel.remove(bookmarkPanel);
            this.updateDialogHeight();
            return;
        }
    }

    private void deleteXspAttachment(String string, Component component) {
        int n = this.editedComment.attachments.length;
        for (int i = 0; i < n; ++i) {
            if (this.editedComment.attachments[i] != string) continue;
            String[] stringArray = new String[n - 1];
            if (i > 0) {
                System.arraycopy(this.editedComment.attachments, 0, stringArray, 0, i);
            }
            if (i < stringArray.length) {
                System.arraycopy(this.editedComment.attachments, i + 1, stringArray, i, stringArray.length - i);
            }
            this.editedComment.attachments = stringArray;
            this.editAttachmentsPanel.remove(component);
            this.updateDialogHeight();
            return;
        }
    }

    private void updateDialogHeight() {
        this.dialog.invalidate();
        this.dialog.validate();
        this.dialog.fixHeight();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block27: {
            Object object = mouseEvent.getSource();
            if (object == null) {
                return;
            }
            if (object == this.lbDelete) {
                if (WDDialog.showYesNoDialog(this, this.dialog.nls().getString("deleteItemQuestion"))) {
                    try {
                        this.dialog.deleteComment(this, null);
                    }
                    catch (Exception exception) {
                        WDDialog.showErrorMsgDialog(this, exception);
                        return;
                    }
                }
            } else if (object == this.lbEdit) {
                this.editedComment = this.cloneComment(this.comment);
                this.body.setVisible(false);
                this.attachmentsPanel.setVisible(false);
                if (this.moreLabel != null) {
                    this.moreLabel.setVisible(false);
                }
                this.prepareEdit();
            } else if (object == this.lbReply) {
                this.editedComment = new CommentEntry();
                this.editedComment.parentId = this.comment.id;
                this.prepareEdit();
            } else if (object == this.lbSubmit) {
                try {
                    this.updateEditedComment();
                    if (!this.checkCommentValid()) {
                        return;
                    }
                    if (this.comment == null) {
                        NotificationConfig notificationConfig = null;
                        if (this.notificationPanel != null) {
                            notificationConfig = this.notificationPanel.getNotificationConfig();
                        }
                        this.dialog.postComment(this.editedComment, notificationConfig, this, new Runnable(){

                            public void run() {
                                CommentPanel.this.editedComment = new CommentEntry();
                                CommentPanel.this.editTextArea.setText("");
                                CommentPanel.this.updateBodyForNewComment(CommentPanel.this.editTextArea.hasFocus());
                                CommentPanel.this.editAttachmentsPanel.removeAll();
                                CommentPanel.this.showNotificationPanel(false);
                                CommentPanel.this.updateDialogHeight();
                            }
                        });
                        break block27;
                    }
                    if (this.editedComment.parentId != this.comment.parentId) {
                        NotificationConfig notificationConfig = null;
                        if (this.notificationPanel != null) {
                            notificationConfig = this.notificationPanel.getNotificationConfig();
                        }
                        this.dialog.postComment(this.editedComment, notificationConfig, this, new Runnable(){

                            public void run() {
                                CommentPanel.this.editedComment = null;
                                CommentPanel.this.hideEdit();
                            }
                        });
                        break block27;
                    }
                    this.dialog.updateComment(this.editedComment, this, new Runnable(){

                        public void run() {
                            CommentPanel.this.body.setText(CommentPanel.this.comment.body);
                            CommentPanel.this.addBookmarksAndAttachments(CommentPanel.this.comment, CommentPanel.this.attachmentsPanel);
                            CommentPanel.this.editedComment = null;
                            CommentPanel.this.hideEdit();
                        }
                    });
                }
                catch (Exception exception) {
                    WDDialog.showErrorMsgDialog(this, exception);
                }
            } else if (object == this.lbCancel) {
                if (this.comment == null) {
                    this.editTextArea.setText("");
                    this.updateBodyForNewComment(this.editTextArea.hasFocus());
                    this.editedComment.bookmarks = null;
                    this.editedComment.attachments = null;
                    this.editAttachmentsPanel.removeAll();
                } else {
                    this.editedComment = null;
                    this.hideEdit();
                }
                this.getRootPane().validate();
            } else if (object == this.lbNotif) {
                this.showNotificationPanel(this.notificationPanel == null ? true : !this.notificationPanel.isVisible());
            } else if (object == this.lbAttachFile) {
                this.dialog.setVisible(false);
                XSPSocialActions.DocPickerCallback docPickerCallback = new XSPSocialActions.DocPickerCallback(){

                    public void documentSelected(Bookmark[] bookmarkArray) throws Exception {
                        int n;
                        int n2 = n = ((CommentPanel)CommentPanel.this).editedComment.bookmarks == null ? 0 : ((CommentPanel)CommentPanel.this).editedComment.bookmarks.length;
                        if (n == 0) {
                            ((CommentPanel)CommentPanel.this).editedComment.bookmarks = bookmarkArray;
                        } else {
                            Bookmark[] bookmarkArray2 = new Bookmark[n + bookmarkArray.length];
                            System.arraycopy(((CommentPanel)CommentPanel.this).editedComment.bookmarks, 0, bookmarkArray2, 0, n);
                            System.arraycopy(bookmarkArray, 0, bookmarkArray2, n, bookmarkArray.length);
                            ((CommentPanel)CommentPanel.this).editedComment.bookmarks = bookmarkArray2;
                        }
                        for (Bookmark bookmark : bookmarkArray) {
                            BookmarkPanel bookmarkPanel = new BookmarkPanel(CommentPanel.this.dialog, bookmark, CommentPanel.this);
                            CommentPanel.this.editAttachmentsPanel.add(bookmarkPanel);
                        }
                        CommentPanel.this.dialog.setVisible(true);
                    }
                };
                this.createXSPSociaActions().selectDocument(this.dialog.getNode(), docPickerCallback, this.dialog);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private XSPSocialActions createXSPSociaActions() {
        GanttWorkbenchPage ganttWorkbenchPage = this.dialog.gantt.getWorkbenchPage();
        return new XSPSocialActions(this.dialog.gantt.getView(), ganttWorkbenchPage.getApplet());
    }

    private CommentEntry cloneComment(CommentEntry commentEntry) {
        CommentEntry commentEntry2 = new CommentEntry();
        commentEntry2.id = commentEntry.id;
        commentEntry2.parentId = commentEntry.parentId;
        commentEntry2.date = commentEntry.date;
        commentEntry2.authorCn = commentEntry.authorCn;
        commentEntry2.authorDn = commentEntry.authorDn;
        commentEntry2.body = commentEntry.body;
        commentEntry2.attachments = commentEntry.attachments;
        commentEntry2.bookmarks = commentEntry.bookmarks;
        return commentEntry2;
    }

    static {
        Insets insets = new Insets(2, 2, 2, 2);
        int n = 0;
        pictureCst = new GridBagConstraints(0, n, 1, 8, 0.0, 0.0, 18, 0, insets, 0, 0);
        authorCst = new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 16, 0, insets, 0, 0);
        dateCst = new GridBagConstraints(3, n, 1, 1, 1.0, 0.0, 14, 0, insets, 0, 0);
        bodyCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 1, insets, 0, 0);
        moreBodyCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 2, 2, 2), 0, 0);
        attachmentsCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 10, 2, 2), 0, 0);
        editBodyCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 1, insets, 0, 0);
        editAttachmentsCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 1, new Insets(2, 10, 2, 2), 0, 0);
        notifsCst = new GridBagConstraints(1, ++n, 4, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        postWallCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        actionsPanelCst = new GridBagConstraints(1, ++n, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 2, 2, 2), 0, 0);
    }
}

