/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.search;

import com.triloggroup.gantt.GanttNode;
import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.GanttWBS;
import com.triloggroup.gantt.TGNode;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.ChangeManager;
import com.triloggroup.gantt.app.search.SearchOptions;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.util.UString;
import java.util.ArrayList;

public class SearchEngine {
    private static SearchEngine instance;
    private SearchOptions options;

    public static SearchEngine get() {
        if (instance == null) {
            instance = new SearchEngine();
        }
        return instance;
    }

    private SearchEngine() {
    }

    public SearchOptions getOptions() {
        return this.options;
    }

    public void setOptions(SearchOptions searchOptions) {
        this.options = searchOptions;
    }

    public boolean runSearch(AppGanttChart appGanttChart) {
        if (this.options == null) {
            return false;
        }
        TGNode tGNode = this.firstNode(appGanttChart);
        while (tGNode != null) {
            if (this.match(tGNode.getName())) {
                appGanttChart.setSelectedNode(tGNode);
                appGanttChart.scrollToNode(tGNode);
                return true;
            }
            tGNode = this.nextNode(tGNode);
        }
        return false;
    }

    public int runSearchAll(AppGanttChart appGanttChart) {
        ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
        TGNode tGNode = appGanttChart.getModel().getRootNode();
        while (tGNode != null) {
            if (this.match(tGNode.getName())) {
                arrayList.add(tGNode);
            }
            tGNode = this.nextNode(tGNode);
        }
        appGanttChart.setSelectedNodes(arrayList.toArray(new TGNode[arrayList.size()]));
        return arrayList.size();
    }

    public boolean runReplace(AppGanttChart appGanttChart) throws ChangeException {
        if (this.options == null) {
            return false;
        }
        TGNode[] tGNodeArray = appGanttChart.getSelectedNodes();
        if (tGNodeArray != null && tGNodeArray.length == 1) {
            TGNode tGNode = tGNodeArray[0];
            if (this.canEdit(tGNode, appGanttChart) && this.match(tGNode.getName())) {
                this.updateNodeName(tGNode, appGanttChart);
                this.runSearch(appGanttChart);
                return true;
            }
        } else {
            appGanttChart.setSelectedNodes(new TGNode[0]);
        }
        this.runSearch(appGanttChart);
        return false;
    }

    public int runReplaceAll(AppGanttChart appGanttChart) throws ChangeException {
        if (this.options == null) {
            return 0;
        }
        ArrayList<TGNode> arrayList = new ArrayList<TGNode>();
        ChangeManager changeManager = appGanttChart.getModel().getChangeManager();
        Change change = changeManager.getLastChange();
        TGNode tGNode = appGanttChart.getModel().getRootNode();
        while (tGNode != null) {
            if (this.canEdit(tGNode, appGanttChart) && this.match(tGNode.getName())) {
                this.updateNodeName(tGNode, appGanttChart);
                arrayList.add(tGNode);
            }
            tGNode = this.nextNode(tGNode);
        }
        changeManager.linkChangesAfter(change, Workbench.getNLSString("replace_all", new Object[0]));
        appGanttChart.setSelectedNodes(arrayList.toArray(new TGNode[arrayList.size()]));
        return arrayList.size();
    }

    private boolean canEdit(TGNode tGNode, AppGanttChart appGanttChart) {
        if (!(tGNode instanceof GanttNode)) {
            return false;
        }
        if (appGanttChart.getModel().isProjectScheduleEditable((GanttNode)tGNode)) {
            return !GanttNode.isSubprojectLink(tGNode);
        }
        return false;
    }

    private void updateNodeName(TGNode tGNode, AppGanttChart appGanttChart) throws ChangeException {
        TGNode tGNode2 = tGNode.clone();
        tGNode2.setName(this.replace(tGNode.getName()));
        if (tGNode instanceof GanttTask) {
            appGanttChart.getModel().checkComputeAndUpdateTaskValues((GanttTask)tGNode, (GanttTask)tGNode2, null, 0);
        } else if (tGNode instanceof GanttWBS) {
            appGanttChart.getModel().checkComputeAndUpdateWBSValues((GanttWBS)tGNode, (GanttWBS)tGNode2, null);
        }
    }

    private TGNode firstNode(AppGanttChart appGanttChart) {
        TGNode[] tGNodeArray = appGanttChart.getSelectedNodes();
        if (tGNodeArray != null && tGNodeArray.length > 0) {
            TGNode tGNode;
            if (tGNodeArray.length == 1) {
                tGNode = tGNodeArray[0];
            } else {
                int n = appGanttChart.getTreeTable().getSelectedRow();
                tGNode = appGanttChart.getModel().getNodeByRowIndex(n);
            }
            appGanttChart.setSelectedNodes(new TGNode[0]);
            return this.nextNode(tGNode);
        }
        return appGanttChart.getModel().getRootNode();
    }

    private TGNode nextNode(TGNode tGNode) {
        if (tGNode == null) {
            return null;
        }
        boolean bl = false;
        if (!bl && tGNode.hasVisibleSubtask()) {
            TGNode tGNode2 = tGNode.getVisibleSubtask(0);
            if (GanttNode.isHiddenSubprojectLink(tGNode2)) {
                return this.nextNode(tGNode2);
            }
            return tGNode2;
        }
        while (tGNode != null) {
            TGNode tGNode3 = this.getNextVisibleBrother(tGNode);
            if (tGNode3 != null) {
                if (GanttNode.isHiddenSubprojectLink(tGNode3)) {
                    return this.nextNode(tGNode3);
                }
                return tGNode3;
            }
            tGNode = tGNode.getParent();
        }
        return null;
    }

    private TGNode getNextVisibleBrother(TGNode tGNode) {
        int n;
        TGNode tGNode2 = tGNode.getParent();
        if (tGNode2 == null) {
            return null;
        }
        int n2 = tGNode2.getAllSubTaskCount();
        for (n = 0; n < n2 && tGNode2.getSubtaskInAll(n) != tGNode; ++n) {
        }
        if (++n == n2) {
            return null;
        }
        while (n < n2) {
            TGNode tGNode3 = tGNode2.getSubtaskInAll(n);
            if (tGNode3.isReadeable()) {
                return tGNode3;
            }
            ++n;
        }
        return null;
    }

    private boolean match(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (true) {
            if ((n = this.options.caseSensitive ? string.indexOf(this.options.text, n) : UString.indexOfIgnoreCase(string, this.options.text, n)) < 0) {
                return false;
            }
            if (!this.options.wholeWord) break;
            if (this.isWordSeparatorAt(string, n - 1) && this.isWordSeparatorAt(string, n + this.options.text.length())) {
                return true;
            }
            ++n;
        }
        return true;
    }

    private String replace(String string) {
        int n = 0;
        while (n < string.length() && (n = this.options.caseSensitive ? string.indexOf(this.options.text, n) : UString.indexOfIgnoreCase(string, this.options.text, n)) >= 0) {
            if (this.options.wholeWord) {
                if (this.isWordSeparatorAt(string, n - 1) && this.isWordSeparatorAt(string, n + this.options.text.length())) {
                    string = this.replaceAtIndex(string, this.options.text.length(), this.options.replace, n);
                    n += this.options.text.length();
                    continue;
                }
                ++n;
                continue;
            }
            string = this.replaceAtIndex(string, this.options.text.length(), this.options.replace, n);
            n += this.options.text.length();
        }
        return string;
    }

    private String replaceAtIndex(String string, int n, String string2, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        stringBuilder.append(string2);
        if (n2 + n < string.length()) {
            stringBuilder.append(string.substring(n2 + n));
        }
        return stringBuilder.toString();
    }

    private boolean isWordSeparatorAt(String string, int n) {
        if (n < 0 || n >= string.length()) {
            return true;
        }
        char c = string.charAt(n);
        return !Character.isLetterOrDigit(c);
    }
}

