/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.flowbuilder.util.TString;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TGDuration;
import com.triloggroup.gantt.TimeUnit;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.AppProjectModel;
import com.triloggroup.gantt.app.NodeRef;
import com.triloggroup.gantt.app.Status;
import com.triloggroup.gantt.app.filter.FinancialHealth;
import com.triloggroup.gantt.app.filter.ProgressHealth;
import com.triloggroup.gantt.pe.PETimeUnits;
import com.triloggroup.project.components.ui.Workbench;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ValueType {
    INT,
    DOUBLE,
    STRING,
    DATE,
    RESOURCE,
    NULLABLE_RESOURCE,
    STATUS,
    PROGRESS_HEALTH,
    FINANCIAL_HEALTH,
    WBS,
    DURATION;

    private static final char ITEM_SEPARATOR = '|';
    static final Resource NO_RESOURCE;

    public static String writeValue(ValueType valueType, Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (object != null) {
                switch (valueType) {
                    case INT: 
                    case DOUBLE: {
                        stringBuilder.append(object);
                        break;
                    }
                    case PROGRESS_HEALTH: {
                        stringBuilder.append(((ProgressHealth)((Object)object)).getCode());
                        break;
                    }
                    case FINANCIAL_HEALTH: {
                        stringBuilder.append(((FinancialHealth)((Object)object)).getCode());
                        break;
                    }
                    case STATUS: {
                        stringBuilder.append(((Status)object).getCode());
                        break;
                    }
                    case DATE: {
                        stringBuilder.append(((Date)object).getTime());
                        break;
                    }
                    case RESOURCE: 
                    case NULLABLE_RESOURCE: {
                        Resource resource = (Resource)object;
                        if (object == NO_RESOURCE) break;
                        stringBuilder.append(ValueType.escapeString(resource.getDn()));
                        break;
                    }
                    case WBS: {
                        NodeRef nodeRef = (NodeRef)object;
                        stringBuilder.append(nodeRef.siteId).append('#');
                        stringBuilder.append(nodeRef.projectId).append('#');
                        stringBuilder.append(nodeRef.id);
                        break;
                    }
                    case DURATION: {
                        TGDuration tGDuration = (TGDuration)object;
                        stringBuilder.append(tGDuration.getValue()).append('#');
                        stringBuilder.append(tGDuration.getUnit().getCode());
                        break;
                    }
                    default: {
                        stringBuilder.append(ValueType.escapeString(object.toString()));
                    }
                }
            }
            stringBuilder.append('|');
        }
        return stringBuilder.toString();
    }

    public static Object[] readValue(AppProjectModel appProjectModel, ValueType valueType, String string) {
        ArrayList<String> arrayList = ValueType.unescapeString(string);
        Object[] objectArray = new Object[arrayList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = arrayList.get(i);
            objectArray[i] = ValueType.readSingleValue(appProjectModel, valueType, string2);
        }
        return objectArray;
    }

    private static Object readSingleValue(AppProjectModel appProjectModel, ValueType valueType, String string) {
        switch (valueType) {
            case INT: {
                return TString.isEmpty(string) ? Integer.valueOf(0) : Integer.valueOf(string);
            }
            case DOUBLE: {
                return TString.isEmpty(string) ? Double.valueOf(0.0) : Double.valueOf(string);
            }
            case STRING: {
                return string;
            }
            case DATE: {
                return new Date(Long.parseLong(string));
            }
            case PROGRESS_HEALTH: {
                return ProgressHealth.fromCode(Integer.parseInt(string));
            }
            case FINANCIAL_HEALTH: {
                return FinancialHealth.fromCode(Integer.parseInt(string));
            }
            case NULLABLE_RESOURCE: {
                if (TString.isEmpty(string)) {
                    return NO_RESOURCE;
                }
            }
            case RESOURCE: {
                Resource resource = appProjectModel.getProjectResource(string);
                if (resource == null) {
                    resource = appProjectModel.getResources(new String[]{string})[0];
                }
                return resource;
            }
            case STATUS: {
                return Status.fromCode(string);
            }
            case WBS: {
                String[] stringArray = TString.splitString(string, '#');
                return new NodeRef(stringArray[0], stringArray[1], stringArray[2]);
            }
            case DURATION: {
                int n = string.indexOf(35);
                if (n > 0) {
                    double d = n == 0 ? 0.0 : Double.valueOf(string.substring(0, n));
                    PETimeUnits pETimeUnits = Workbench.get().getTimeUnits();
                    int n2 = Integer.valueOf(string.substring(n + 1));
                    TimeUnit timeUnit = pETimeUnits.fromCode(n2);
                    return new TGDuration(d, timeUnit);
                }
                return new TGDuration(0.0, Workbench.get().getTimeUnits().HOURS);
            }
        }
        throw new IllegalArgumentException("Unsupported datatype: " + (Object)((Object)valueType));
    }

    private static String escapeString(String string) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '|' || c == '\\') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string.substring(0, i));
                }
                stringBuilder.append('\\').append(c);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    private static ArrayList<String> unescapeString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && !bl) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string.substring(n, i));
                }
                bl = true;
                continue;
            }
            if (c == '|' && !bl) {
                arrayList.add(stringBuilder != null ? stringBuilder.toString() : string.substring(n, i));
                stringBuilder = null;
                n = i + 1;
                continue;
            }
            bl = false;
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return arrayList;
    }

    static {
        NO_RESOURCE = new Resource("<" + AppGanttChart.NLS_BUNDLE.getString("none") + '>', null);
    }
}

