/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.filter;

import com.triloggroup.gantt.INodeFilter;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.UserPreferences;
import com.triloggroup.gantt.app.filter.AdvancedFilter;
import com.triloggroup.gantt.app.filter.Criteria;
import com.triloggroup.gantt.app.filter.CriteriaPanel;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.util.NLSBundle;
import com.triloggroup.util.UString;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AdvancedFilterDialog
extends WDDialog
implements ActionListener {
    private AppGanttChart ganttCtrl;
    private AdvancedFilter filter;
    private INodeFilter previouslyAppliedFilter;
    private boolean reapplyFilter = false;
    private WDButton saveButton;
    private WDButton previewButton;
    private WDButton deleteButton;
    private JTextField tfName;
    private JCheckBox cbSharedAcrossProjects;
    private JCheckBox cbShowEmptyWBS;
    private CriteriaPanel criteriaPanel;

    public static void showFilterDialog(AppGanttChart appGanttChart, Component component) {
        AdvancedFilterDialog.showFilterDialog(null, appGanttChart, component);
    }

    public static void showFilterDialog(AdvancedFilter advancedFilter, AppGanttChart appGanttChart, Component component) {
        Point point = component.getLocationOnScreen();
        point.y += component.getHeight() / 2;
        point.x += component.getWidth() / 2;
        AdvancedFilterDialog.showFilterDialog(advancedFilter, appGanttChart, point);
    }

    private static void showFilterDialog(AdvancedFilter advancedFilter, AppGanttChart appGanttChart, Point point) {
        Window window = SwingUtilities.getWindowAncestor(appGanttChart.getView());
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(point);
        AdvancedFilterDialog advancedFilterDialog = new AdvancedFilterDialog(window, graphicsConfiguration);
        advancedFilterDialog.init(appGanttChart, advancedFilter);
        if (point != null) {
            advancedFilterDialog.setLocation(point);
        }
        advancedFilterDialog.setDragHeader(true);
        advancedFilterDialog.setMaximizable(false);
        advancedFilterDialog.setVisible(true);
    }

    protected AdvancedFilterDialog(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
    }

    protected void init(AppGanttChart appGanttChart, AdvancedFilter advancedFilter) {
        this.ganttCtrl = appGanttChart;
        this.filter = advancedFilter;
        this.previouslyAppliedFilter = appGanttChart.getFilter();
        this.initUI();
    }

    private void initUI() {
        NLSBundle nLSBundle = AppGanttChart.NLS_BUNDLE;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.saveButton = new WDButton(nLSBundle.getString("saveAndApply_button"), WDUtil.getIcon("ok.gif"));
        jPanel.add(this.saveButton);
        this.saveButton.addActionListener(this);
        this.previewButton = new WDButton(nLSBundle.getString("preview_button"));
        jPanel.add(this.previewButton);
        this.previewButton.addActionListener(this);
        if (this.filter != null) {
            this.deleteButton = new WDButton(nLSBundle.getString("delete_button"), WDUtil.getIcon("delete.png"));
            jPanel.add(this.deleteButton);
            this.deleteButton.addActionListener(this);
        }
        WDButton wDButton = WDUtil.createCancelButton();
        jPanel.add(wDButton);
        wDButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Insets insets = new Insets(5, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0);
        JLabel jLabel = new JLabel(nLSBundle.getString("filter_name"));
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.tfName = new JTextField();
        jPanel2.add((Component)this.tfName, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 13, 2, insets, 0, 0));
        this.cbSharedAcrossProjects = new JCheckBox(nLSBundle.getString("filter_sharedAcrossProjects"));
        jPanel2.add((Component)this.cbSharedAcrossProjects, gridBagConstraints);
        this.cbShowEmptyWBS = new JCheckBox(nLSBundle.getString("filter_showEmptyWBS"));
        jPanel2.add((Component)this.cbShowEmptyWBS, gridBagConstraints);
        this.criteriaPanel = new CriteriaPanel(this.ganttCtrl, this.filter == null ? null : this.filter.getCriteria());
        this.criteriaPanel.setFormatLocale(this.ganttCtrl.getDateLocale());
        jPanel2.add((Component)this.criteriaPanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 13, 1, insets, 0, 0));
        this.getContentPane().add((Component)jPanel2, "Center");
        UserPreferences userPreferences = this.ganttCtrl.getUserPreferences();
        if (this.filter != null) {
            this.tfName.setText(this.filter.getName());
            this.cbSharedAcrossProjects.setSelected(this.filter.isSharedAcrossProjects());
            this.cbShowEmptyWBS.setSelected(!this.filter.isHideEmptyWBS());
        } else {
            String string;
            String string2 = string = nLSBundle.getString("filter_defaultName");
            AdvancedFilter[] advancedFilterArray = userPreferences.getAllFilters();
            int n = 0;
            block0: while (true) {
                for (AdvancedFilter advancedFilter : advancedFilterArray) {
                    if (!string2.equals(advancedFilter.getName())) {
                        continue;
                    }
                    string2 = string + ++n;
                    continue block0;
                }
                break;
            }
            this.tfName.setText(string2);
        }
        this.setDragHeader(true);
        this.setMaximizable(false);
        this.setResizable(true);
    }

    private AdvancedFilter getEditedFilter(AdvancedFilter advancedFilter, boolean bl) {
        String string = this.tfName.getText();
        if (UString.isEmpty(string)) {
            WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("name_empty"));
            this.tfName.requestFocus();
            return null;
        }
        boolean bl2 = false;
        ArrayList<Criteria> arrayList = this.criteriaPanel.getCriteria();
        for (Criteria criteria : arrayList) {
            if (criteria.def == null || criteria.operator == null || criteria.value == null) {
                WDDialog.showMsgDialog(this, AppGanttChart.NLS_BUNDLE.getString("filter_criteriaInvalid"));
                return null;
            }
            bl2 |= criteria.def.isProjectSpecific();
        }
        if (bl && this.cbSharedAcrossProjects.isSelected() && bl2 && !WDDialog.showYesNoDialog(this.saveButton, AppGanttChart.NLS_BUNDLE.getString("filter_sharedAcrossProjectsWarning"))) {
            return null;
        }
        if (advancedFilter == null) {
            advancedFilter = new AdvancedFilter();
        }
        advancedFilter.setName(string);
        advancedFilter.setSharedAcrossProjects(this.cbSharedAcrossProjects.isSelected());
        advancedFilter.setHideEmptyWBS(!this.cbShowEmptyWBS.isSelected());
        advancedFilter.setCriteria(this.criteriaPanel.getCriteria());
        return advancedFilter;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveButton) {
            this.filter = this.getEditedFilter(this.filter, true);
            if (this.filter == null) {
                return;
            }
            UserPreferences userPreferences = this.ganttCtrl.getUserPreferences();
            userPreferences.saveFilter(this.filter);
            this.ganttCtrl.applyFilter(this.filter);
            this.reapplyFilter = false;
        } else {
            if (object == this.previewButton) {
                AdvancedFilter advancedFilter = this.getEditedFilter(null, false);
                if (advancedFilter == null) {
                    return;
                }
                this.reapplyFilter = true;
                this.ganttCtrl.applyFilter(advancedFilter);
                return;
            }
            if (this.deleteButton != null && object == this.deleteButton) {
                if (!WDDialog.showYesNoDialog(this, AppGanttChart.NLS_BUNDLE.getString("filter_confirmDelete"))) {
                    return;
                }
                if (this.previouslyAppliedFilter == this.filter) {
                    this.ganttCtrl.applyFilter(null);
                    this.reapplyFilter = false;
                }
                UserPreferences userPreferences = this.ganttCtrl.getUserPreferences();
                userPreferences.deleteFilter(this.filter);
            }
        }
        this.dispose();
    }

    public void dispose() {
        if (this.reapplyFilter) {
            this.ganttCtrl.applyFilter(this.previouslyAppliedFilter);
        }
        super.dispose();
    }
}

