/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.dialog;

import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ui.WDButton;
import com.triloggroup.gantt.app.ui.WDDatePicker;
import com.triloggroup.gantt.app.ui.WDDialog;
import com.triloggroup.gantt.app.ui.WDUtil;
import com.triloggroup.project.components.ui.Workbench;
import com.triloggroup.ui.IntTextField;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MoveDatesDialog
extends WDDialog
implements ActionListener {
    private int numberOfDays = 0;
    private WDButton okButton;
    private IntTextField daysTf;
    private WDDatePicker datePicker;
    private Date refDate;

    public static int showDialog(Component component, Date date) {
        Window window = SwingUtilities.getWindowAncestor(component);
        GraphicsConfiguration graphicsConfiguration = WDUtil.getGraphicsConfiguration(component);
        MoveDatesDialog moveDatesDialog = new MoveDatesDialog(window, graphicsConfiguration, date);
        moveDatesDialog.pack();
        moveDatesDialog.setLocationRelativeTo(component);
        moveDatesDialog.setVisible(true);
        return moveDatesDialog.getNumberOfDays();
    }

    protected MoveDatesDialog(Window window, GraphicsConfiguration graphicsConfiguration, Date date) {
        super(window, graphicsConfiguration);
        this.refDate = date;
        this.setUI();
    }

    protected void setUI() {
        Serializable serializable;
        String string;
        JComponent jComponent;
        this.setModal(true);
        this.setDragHeader(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 10, 0), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        JLabel jLabel = new JLabel(Workbench.getNLSString("moveDates", new Object[0]));
        if (this.refDate == null) {
            jComponent = this.daysTf = new IntTextField();
            this.daysTf.setValue(0);
            string = AppGanttChart.NLS_BUNDLE.getString("recentcomment_numberOfDays");
        } else {
            serializable = Workbench.get().getFormatLocale();
            this.datePicker = new WDDatePicker((Locale)serializable);
            jComponent = this.datePicker;
            this.datePicker.setDate(this.refDate);
            string = AppGanttChart.NLS_BUNDLE.getString("startDate");
        }
        serializable = new JLabel(string);
        this.okButton = WDUtil.createOkButton();
        WDButton wDButton = WDUtil.createCancelButton();
        JPanel jPanel2 = WDDialog.createButtonPanel(this.okButton, wDButton);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel.add((Component)serializable, gridBagConstraints2);
        jPanel.add((Component)jComponent, gridBagConstraints3);
        jPanel.add((Component)jPanel2, gridBagConstraints4);
        this.getContentPane().add(jPanel);
        this.okButton.addActionListener(this);
        wDButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.daysTf != null) {
                if (this.daysTf.isEditValid()) {
                    this.numberOfDays = this.daysTf.getIntValue();
                    this.dispose();
                } else {
                    this.daysTf.grabFocus();
                }
            } else if (this.datePicker.isEditValid()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.datePicker.getDate());
                calendar.set(11, 0);
                long l = calendar.getTimeInMillis();
                calendar.setTime(this.refDate);
                calendar.set(11, 0);
                long l2 = calendar.getTimeInMillis();
                double d = l - l2;
                double d2 = d / 8.64E7;
                this.numberOfDays = (int)Math.round(d2);
                this.dispose();
            } else {
                this.datePicker.grabFocus();
            }
        } else {
            this.dispose();
        }
    }

    public int getNumberOfDays() {
        return this.numberOfDays;
    }
}

