/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app.change;

import com.triloggroup.gantt.app.change.Change;
import com.triloggroup.gantt.app.change.ChangeException;
import com.triloggroup.gantt.app.change.IChangeHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeManager {
    private ArrayList<IChangeHandler> handlers = new ArrayList();
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private ArrayList<Change> changes = new ArrayList();

    public void registerHandler(IChangeHandler iChangeHandler) {
        this.handlers.add(iChangeHandler);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void fireChange() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ChangeManager.this.fireChange();
                }
            });
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public String getUndoText() {
        for (int i = this.changes.size() - 1; i >= 0; --i) {
            Change change = this.changes.get(i);
            if (change.isLinkedToPreviousChange()) continue;
            return change.getUndoText();
        }
        return null;
    }

    public String getRedoText() {
        return null;
    }

    public synchronized void addChange(Change change) {
        if (!Change.isNullOperation(change)) {
            this.changes.add(change);
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undo() throws ChangeException {
        try {
            while (!this.changes.isEmpty()) {
                Change change = this.changes.remove(this.changes.size() - 1);
                if (change.hasSubChange()) {
                    List<Change> list = change.getPostSubChanges();
                    for (int i = list.size() - 1; i > -1; --i) {
                        this.undoChange(list.get(i));
                    }
                    this.undoChange(change);
                    List<Change> list2 = change.getPreSubChanges();
                    for (int i = list2.size() - 1; i > -1; --i) {
                        this.undoChange(list2.get(i));
                    }
                } else {
                    this.undoChange(change);
                }
                if (change.isLinkedToPreviousChange()) continue;
                break;
            }
        }
        finally {
            this.fireChange();
        }
    }

    public synchronized boolean hasChange() {
        return !this.changes.isEmpty();
    }

    public synchronized boolean canUndo() {
        return this.hasChange();
    }

    public synchronized boolean canRedo() {
        return false;
    }

    private void undoChange(Change change) throws ChangeException {
        this.applyChange(change, true, false, null);
    }

    public void applyChange(Change change, boolean bl, boolean bl2, List<Change> list) throws ChangeException {
        for (IChangeHandler iChangeHandler : this.handlers) {
            if (!iChangeHandler.canHandleChange(change)) continue;
            iChangeHandler.applyChange(change, bl, bl2, list);
            return;
        }
        throw new IllegalStateException("No handler found for this change: " + change);
    }

    public synchronized Change getLastChange() {
        int n = this.changes.size();
        return n == 0 ? null : this.changes.get(n - 1);
    }

    public synchronized ArrayList<Change> getAllChanges() {
        return (ArrayList)this.changes.clone();
    }

    public synchronized void setAllChanges(ArrayList<Change> arrayList) {
        this.changes = arrayList;
        this.fireChange();
    }

    public void clear() {
        this.changes.clear();
        this.fireChange();
    }

    public synchronized void linkChangesAfter(Change change, String string) {
        if (this.changes.isEmpty() || change != null && change == this.getLastChange()) {
            return;
        }
        for (int i = this.changes.size() - 1; i > 0; --i) {
            Change change2 = this.changes.get(i);
            if (change != null && change == this.changes.get(i - 1)) {
                if (string != null) {
                    change2.setText(string);
                }
                this.fireChange();
                return;
            }
            change2.setLinkedToPreviousChange(true);
        }
        if (string != null) {
            this.changes.get(0).setText(string);
        }
        this.fireChange();
    }
}

