/*
 * Decompiled with CFR 0.152.
 */
package com.triloggroup.gantt.app;

import com.triloggroup.gantt.GanttTask;
import com.triloggroup.gantt.Resource;
import com.triloggroup.gantt.TaskResource;
import com.triloggroup.gantt.app.AppGanttChart;
import com.triloggroup.gantt.app.ResourcePickerDialog;
import com.triloggroup.gantt.app.TablePanel;
import com.triloggroup.gantt.app.treetable.resource.ResourceUnitsEditor;
import com.triloggroup.gantt.app.treetable.resource.ResourceUnitsRenderer;
import com.triloggroup.gantt.app.treetable.resource.ResourceWorkEditor;
import com.triloggroup.gantt.app.treetable.resource.TaskResourceTableModel;
import com.triloggroup.project.components.ui.table.TGTableCellRenderer;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TaskResourcesPanel
extends TablePanel {
    TaskResourceTableModel.Form tableModel;

    public TaskResourcesPanel(AppGanttChart appGanttChart, GanttTask ganttTask) {
        super(appGanttChart, ganttTask);
    }

    protected void init() {
        super.init();
        this.addButton.setToolTipText(this.nlsBundle.getString("add_resource"));
        this.deleteButton.setToolTipText(this.nlsBundle.getString("remove_resource"));
    }

    protected void initTable() {
        super.initTable();
        this.tableModel = new TaskResourceTableModel.Form(this.ganttChart, (GanttTask)this.node);
        this.table.setModel(this.tableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new TGTableCellRenderer(){

            public JComponent getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Resource resource = ((GanttTask)TaskResourcesPanel.this.node).getResources()[n].getResource();
                jComponent.setForeground(TaskResourcesPanel.this.tableModel.isHighlightedResource(resource) ? Color.RED : Color.BLACK);
                return jComponent;
            }

            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    this.setToolTipText(null);
                } else {
                    String string = ((Resource)object).getEmail();
                    if ("".equals(string)) {
                        string = null;
                    }
                    this.setToolTipText(string);
                    this.setText(object.toString());
                }
            }
        });
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setCellEditor(new ResourceUnitsEditor());
        tableColumn2.setCellRenderer(new ResourceUnitsRenderer());
        tableColumn2.setMaxWidth(100);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        ResourceWorkEditor resourceWorkEditor = new ResourceWorkEditor();
        tableColumn3.setCellEditor(resourceWorkEditor);
        tableColumn3.setMaxWidth(200);
        this.table.validate();
    }

    public void updateHighlightedRows() {
        this.tableModel.updateHighlightedRows();
    }

    protected void doAdd() {
        TaskResourceTableModel.Form form = (TaskResourceTableModel.Form)this.table.getModel();
        ResourcePickerDialog resourcePickerDialog = ResourcePickerDialog.create(this.table);
        TaskResource[] taskResourceArray = ((GanttTask)this.node).getResources();
        Resource[] resourceArray = new Resource[taskResourceArray.length];
        for (int i = 0; i < taskResourceArray.length; ++i) {
            resourceArray[i] = taskResourceArray[i].getResource();
        }
        resourcePickerDialog.setExcludeDisabled(true);
        resourcePickerDialog.init(this.ganttChart.getModel().getProjectModel(this.node.getProjectId()), resourceArray, true);
        resourcePickerDialog.setVisible(-1, -1, -1, 600, this.table);
        Resource[] resourceArray2 = resourcePickerDialog.getSelection();
        if (resourceArray2 != null && resourceArray2.length > 0) {
            int n;
            for (n = 0; n < resourceArray2.length; ++n) {
                TaskResource taskResource = new TaskResource(resourceArray2[n], 100);
                form.addRow(taskResource);
            }
            n = form.getRowCount();
            this.selectRow(n - 1);
            this.deleteButton.setEnabled(true);
        }
    }

    protected void doDelete() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        TaskResourceTableModel.Form form = (TaskResourceTableModel.Form)this.table.getModel();
        for (n = nArray.length - 1; n > -1; --n) {
            form.removeRow(nArray[n]);
        }
        n = form.getRowCount();
        if (n == 0) {
            this.deleteButton.setEnabled(false);
        } else if (nArray.length == 1) {
            int n2 = nArray[0];
            if (n > n2) {
                this.selectRow(n2);
            } else {
                this.selectRow(n2 - 1);
            }
        }
    }
}

